(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["AnyShare"] = factory();
	else
		root["AnyShare"] = factory();
})(typeof self !== 'undefined' ? self : this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 1);
/******/ })
/************************************************************************/
/******/ ({

/***/ "../ShareWebComponents/src/DocSelector/component.base.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
exports.__esModule = true;
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/index.ts");
var entrydoc_1 = __webpack_require__("../ShareWebCore/src/entrydoc/index.ts");
var component_base_1 = __webpack_require__("../ShareWebComponents/src/DocTree/component.base.tsx");
var webcomponent_1 = __webpack_require__("../ShareWebComponents/src/webcomponent.tsx");
var lodash_2 = __webpack_require__("../node_modules/lodash/index.js");
var DocSelectorBase = /** @class */ (function (_super) {
    __extends(DocSelectorBase, _super);
    function DocSelectorBase() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            selection: null || []
        };
        return _this;
    }
    DocSelectorBase.prototype.onSelectionChange = function (doc) {
        this.setState({ selection: doc });
    };
    DocSelectorBase.prototype.confirm = function () {
        this.props.onSelect(this.state.selection);
    };
    /**
     * “确定”按钮是否可用
     * （1）数组，当数组里有元素时，按钮可用
     * （2）一个文件，当文件不是topview，不是文件夹时，按钮可用
     */
    DocSelectorBase.prototype.getBtnDisabled = function (selection) {
        var selectType = this.props.selectType;
        if (selection instanceof Array) {
            // 数组
            return !selection.length;
        }
        else {
            // 对象
            return !selection || entrydoc_1.isTopView(selection) ||
                docs_1.isDir(selection) && !lodash_1.includes(selectType, component_base_1.SelectType.DIR) ||
                !(docs_1.isDir(selection)) && !lodash_1.includes(selectType, component_base_1.SelectType.FILE);
        }
    };
    DocSelectorBase.defaultProps = {
        onSelect: lodash_2.noop,
        selectMode: 'single',
        selectType: [component_base_1.SelectType.FILE],
        onCancel: lodash_2.noop
    };
    return DocSelectorBase;
}(webcomponent_1["default"]));
exports["default"] = DocSelectorBase;


/***/ }),

/***/ "../ShareWebComponents/src/DocSelector/component.mobile.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var component_base_1 = __webpack_require__("../ShareWebComponents/src/DocSelector/component.base.tsx");
var ui_mobile_1 = __webpack_require__("../ShareWebUI/src/Dialog/ui.mobile.tsx");
var ui_mobile_2 = __webpack_require__("../ShareWebUI/src/Button/ui.mobile.tsx");
var component_mobile_1 = __webpack_require__("../ShareWebComponents/src/DocTree/component.mobile.tsx");
var locale_1 = __webpack_require__("../ShareWebComponents/src/DocSelector/locale.ts");
var styles = __webpack_require__("../ShareWebComponents/src/DocSelector/styles.mobile.css");
var DocSelector = /** @class */ (function (_super) {
    __extends(DocSelector, _super);
    function DocSelector() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    DocSelector.prototype.render = function () {
        var _this = this;
        return (React.createElement("div", { className: styles['container'] },
            React.createElement(ui_mobile_1["default"], { width: "20rem" },
                React.createElement(ui_mobile_1["default"].Header, { closable: true, onClose: function () { return _this.props.onCancel(); } }, locale_1["default"]('选择文件')),
                React.createElement(ui_mobile_1["default"].Main, null,
                    React.createElement("div", { className: styles['tree-box'] },
                        React.createElement(component_mobile_1["default"], __assign({}, this.props, { onSelectionChange: this.onSelectionChange.bind(this) })))),
                React.createElement(ui_mobile_1["default"].Footer, null,
                    React.createElement("div", { className: styles['button-wrap'] },
                        React.createElement(ui_mobile_2["default"], { type: "submit", disabled: this.getBtnDisabled(this.state.selection), onClick: this.confirm.bind(this) }, locale_1["default"]('确定'))),
                    React.createElement("div", { className: styles['button-wrap'] },
                        React.createElement(ui_mobile_2["default"], { onClick: function () { return _this.props.onCancel(); } }, locale_1["default"]('取消')))))));
    };
    return DocSelector;
}(component_base_1["default"]));
exports["default"] = DocSelector;


/***/ }),

/***/ "../ShareWebComponents/src/DocSelector/locale.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var i18n_1 = __webpack_require__("../ShareWebComponents/src/i18n.ts");
exports["default"] = i18n_1["default"]([
    [
        '选择文件',
        '選取檔案',
        'Select File'
    ], [
        '确定',
        '確定',
        'OK'
    ], [
        '取消',
        '取消',
        'Cancel'
    ]
]);


/***/ }),

/***/ "../ShareWebComponents/src/DocSelector/styles.mobile.css":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin
module.exports = {"container":"_-ShareWebComponents-src-DocSelector-styles-mobile---container","tree-box":"_-ShareWebComponents-src-DocSelector-styles-mobile---tree-box","button-wrap":"_-ShareWebComponents-src-DocSelector-styles-mobile---button-wrap"};

/***/ }),

/***/ "../ShareWebComponents/src/DocTree/component.base.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
exports.__esModule = true;
var webcomponent_1 = __webpack_require__("../ShareWebComponents/src/webcomponent.tsx");
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/index.ts");
var fs = __webpack_require__("../ShareWebCore/src/filesystem/index.ts");
var config_1 = __webpack_require__("../ShareWebCore/src/apis/eachttp/config/index.ts");
var entrydoc_1 = __webpack_require__("../ShareWebCore/src/entrydoc/index.ts");
var SelectType;
(function (SelectType) {
    SelectType[SelectType["DIR"] = 0] = "DIR";
    SelectType[SelectType["FILE"] = 1] = "FILE";
})(SelectType = exports.SelectType || (exports.SelectType = {}));
var DocTreeBase = /** @class */ (function (_super) {
    __extends(DocTreeBase, _super);
    function DocTreeBase() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            nodes: []
        };
        return _this;
    }
    /**
     * 初始化 加载顶级视图列表
     */
    DocTreeBase.prototype.componentWillMount = function () {
        this.getRoot();
    };
    DocTreeBase.prototype.getRoot = function () {
        return __awaiter(this, void 0, void 0, function () {
            var viewsinfo, dirs, viewDocTypes, viewDocs, OEMlist, webclientTabs, err_1, selectRangeFilter, types, newViewsinfo, nodes;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, entrydoc_1.getTopViews()];
                    case 1:
                        viewsinfo = _a.sent();
                        return [4 /*yield*/, fs.list()];
                    case 2:
                        dirs = (_a.sent()).dirs;
                        viewDocTypes = viewsinfo.map(function (_a) {
                            var view_doctype = _a.view_doctype;
                            return view_doctype;
                        });
                        viewDocs = viewDocTypes.reduce(function (preViewDocs, viewDocType) {
                            var _a;
                            return (__assign({}, preViewDocs, (_a = {}, _a[viewDocType] = dirs.filter(function (doc) { return doc.view_doctype === viewDocType; }), _a)));
                        }, {});
                        _a.label = 3;
                    case 3:
                        _a.trys.push([3, 5, , 6]);
                        return [4 /*yield*/, config_1.getOemConfigBySection({ section: 'anyshare' })];
                    case 4:
                        webclientTabs = (_a.sent()).webclientTabs;
                        OEMlist = webclientTabs ? JSON.parse(webclientTabs) : [];
                        return [3 /*break*/, 6];
                    case 5:
                        err_1 = _a.sent();
                        OEMlist = [];
                        return [3 /*break*/, 6];
                    case 6:
                        if (OEMlist.some(function (item) { return item.name === 'docaccess'; })) {
                            selectRangeFilter = [];
                        }
                        else {
                            types = OEMlist.reduce(function (prev, list) {
                                switch (list.name) {
                                    case 'userdoc':
                                        return __spread(prev, [entrydoc_1.ViewDocType.UserDoc]);
                                    case 'sharedoc':
                                        return __spread(prev, [entrydoc_1.ViewDocType.ShareDoc]);
                                    case 'groupdoc':
                                        return __spread(prev, [entrydoc_1.ViewDocType.GroupDoc, entrydoc_1.ViewDocType.ShareGroup]);
                                    case 'customdoc':
                                        return __spread(prev, [entrydoc_1.ViewDocType.CustomDoc, entrydoc_1.ViewDocType.CustomDoc]);
                                    case 'archivedoc':
                                        return __spread(prev, [entrydoc_1.ViewDocType.ArchiveDoc]);
                                    default:
                                        return prev;
                                }
                            }, []);
                            // 根据OEM配置项和this.props.selectRange得到需要显示的顶级视图
                            selectRangeFilter = lodash_1.difference(this.props.selectRange, types);
                        }
                        newViewsinfo = viewsinfo.filter(function (info) { return lodash_1.includes(selectRangeFilter, info.view_doctype); });
                        nodes = newViewsinfo.map(function (info) {
                            return {
                                data: info,
                                children: viewDocs[info.view_doctype].map(function (item) { return ({
                                    data: item,
                                    loading: false
                                }); }),
                                loading: true,
                                expanded: _this.props.expandTopView
                            };
                        });
                        // 顶级视图，如果children为空数组，则不显示
                        this.setState({
                            nodes: nodes.filter(function (node) { return node.children.length; })
                        });
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * 展开节点
     */
    DocTreeBase.prototype.expand = function (node, doc) {
        if (lodash_1.isArray(node.children)) {
            // 如果children存在 则使用缓存
            this.forceUpdate();
        }
        else if (node.loading === false) {
            node.loading = true;
            if (docs_1.isDir(doc)) {
                // 文档目录
                this.appendChild(node, fs.list(doc, {
                    by: this.props.sort.by,
                    sort: this.props.sort.sort
                }));
            }
        }
    };
    /**
     * 向指定节点添加子节点并重新渲染组件
     */
    DocTreeBase.prototype.appendChild = function (node, loader) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, dirs, files, docinfos;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, loader];
                    case 1:
                        _a = _b.sent(), dirs = _a.dirs, files = _a.files;
                        docinfos = __spread(dirs, files);
                        lodash_1.assign(node, {
                            children: this.props.selectType.find(function (o) { return o === SelectType.FILE; }) ?
                                docinfos.map(function (data) { return ({ data: data, loading: false }); })
                                :
                                    docinfos.filter(function (doc) { return docs_1.isDir(doc); }).map(function (data) { return ({ data: data, loading: false }); })
                        });
                        this.forceUpdate();
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * 多选框是否显示
     * （1）单选模式不显示
     * （2）topView，不显示
     *  (3) selectType包括dir，显示
     *  (4) selectType不包括dir，文件夹不显示，文件显示
     */
    DocTreeBase.prototype.checkBoxVisible = function (node) {
        if (this.props.selectMode === 'single') {
            return false;
        }
        if (entrydoc_1.isTopView(node.data)) {
            return false;
        }
        if (lodash_1.includes(this.props.selectType, SelectType.DIR)) {
            return true;
        }
        return !docs_1.isDir(node.data);
    };
    DocTreeBase.defaultProps = {
        /**
         * 选中事件
         */
        onSelectionChange: lodash_1.noop,
        /**
         * 文件和文件夹的选择控制
         */
        selectType: [SelectType.DIR, SelectType.FILE],
        /**
         * 个人文档，个人群组文档，共享群组文档，共享文档，文档库，归档库的选择控制 视图按传参顺序排序
         */
        selectRange: [entrydoc_1.ViewDocType.UserDoc, entrydoc_1.ViewDocType.GroupDoc, entrydoc_1.ViewDocType.ShareGroup, entrydoc_1.ViewDocType.ShareDoc, entrydoc_1.ViewDocType.CustomDoc, entrydoc_1.ViewDocType.ArchiveDoc],
        /**
         * 选择模式: 'single'--单选, 'multi'--多选, 'cascade'--级联
         */
        selectMode: 'single',
        /**
         * 默认是否展开顶级视图: Boolean
         */
        expandTopView: false,
        /**
         * 默认按文件名升序排序
         */
        sort: {
            by: 'name',
            sort: 'asc'
        }
    };
    return DocTreeBase;
}(webcomponent_1["default"]));
exports["default"] = DocTreeBase;


/***/ }),

/***/ "../ShareWebComponents/src/DocTree/component.mobile.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var component_base_1 = __webpack_require__("../ShareWebComponents/src/DocTree/component.base.tsx");
var ui_mobile_1 = __webpack_require__("../ShareWebUI/src/Tree/ui.mobile.tsx");
var ui_mobile_2 = __webpack_require__("../ShareWebUI/src/Tree.Node/ui.mobile.tsx");
var component_mobile_1 = __webpack_require__("../ShareWebComponents/src/Thumbnail/component.mobile.tsx");
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/index.ts");
var entrydoc_1 = __webpack_require__("../ShareWebCore/src/entrydoc/index.ts");
var classnames = __webpack_require__("../node_modules/classnames/index.js");
var styles = __webpack_require__("../ShareWebComponents/src/DocTree/styles.mobile.css");
var DocTree = /** @class */ (function (_super) {
    __extends(DocTree, _super);
    function DocTree() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * 显示模板
     */
    DocTree.prototype.formatter = function (data) {
        var _a;
        var isTop = entrydoc_1.isTopView(data);
        var name = isTop ? entrydoc_1.getViewTypesName(data.view_doctype) : data.name;
        return (React.createElement("div", { className: classnames(styles['name-box'], (_a = {}, _a[styles['name-view-box']] = isTop, _a)), title: name },
            React.createElement(component_mobile_1["default"], { doc: data, size: isTop ? 40 : 36 }),
            React.createElement("span", { className: styles['name'] }, name)));
    };
    /**
     * 生成节点
     */
    DocTree.prototype.nodesGenerator = function (nodes, isTop) {
        var _this = this;
        if (isTop === void 0) { isTop = false; }
        var selectRange = this.props.selectRange;
        if (isTop) {
            return nodes
                .sort(function (a, b) { return selectRange.indexOf(a.data.view_doctype) - selectRange.indexOf(b.data.view_doctype); })
                .map(function (node) { return (React.createElement(ui_mobile_2["default"], { checkbox: _this.checkBoxVisible(node), key: node.data.docid || node.data.view_doctype, data: node.data, isLeaf: !entrydoc_1.isTopView(node.data) && !docs_1.isDir(node.data), formatter: _this.formatter, onExpand: function (doc) { return _this.expand(node, doc); } }, !!node.children && _this.nodesGenerator(node.children))); });
        }
        return nodes
            .map(function (node) { return (React.createElement(ui_mobile_2["default"], { checkbox: _this.checkBoxVisible(node), key: node.data.docid || node.data.view_doctype, data: node.data, isLeaf: !entrydoc_1.isTopView(node.data) && !docs_1.isDir(node.data), formatter: _this.formatter, onExpand: function (doc) { return _this.expand(node, doc); } }, !!node.children && _this.nodesGenerator(node.children))); });
    };
    DocTree.prototype.render = function () {
        return (React.createElement("div", { className: styles['contianer'] },
            React.createElement(ui_mobile_1["default"], { selectMode: this.props.selectMode, onSelectionChange: this.props.onSelectionChange }, this.nodesGenerator(this.state.nodes, true))));
    };
    return DocTree;
}(component_base_1["default"]));
exports["default"] = DocTree;


/***/ }),

/***/ "../ShareWebComponents/src/DocTree/styles.mobile.css":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin
module.exports = {"contianer":"_-ShareWebComponents-src-DocTree-styles-mobile---contianer","name-box":"_-ShareWebComponents-src-DocTree-styles-mobile---name-box","name":"_-ShareWebComponents-src-DocTree-styles-mobile---name","name-view-box":"_-ShareWebComponents-src-DocTree-styles-mobile---name-view-box"};

/***/ }),

/***/ "../ShareWebComponents/src/DocsGrid/assets/enter.mobile.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAN2SURBVGhD7ZlJaxRRFIUjaByJbsWlS0UFZ0QTxQH8F4KIUTTiPJFsAyEk6cxjZ54TaFpbQ0x3nHHjxoWriNHEJIrxJ5TfKW5J/4Rb4IEHXVV3cc6d3n2vC/4jbqiurt6RTCbvd3Z2ljc2NhYHQbDGPsUDNTU1JYODg0E6nQ4aGho+ss7bp3gAwrva29s/j46OBn19fQFR+NDU1HTOPvtHXV3dekhfgPQXRWJgYCBobm5+z7uzZuIfeL9QIiA+NzQ0FPT390vEW9YZM/GP1tbWdVEkhoeHQxEtLS1vYiUil8utzRdh6fQ6dpGor6+/COmvIyMjoQgi8QpRp83EP1QTEL7EmpcIpRPCXvJ8ykz8Q92JSFzG+wtjY2ORiByRKTET/7AWewUR37RPWHfKIiw+IjKZTBgJ0ue7IqHNTpGIlQhFgh27lEiEIiwSs0Sn2Ez8Q5FIJBJKp8Xx8fF/IojMcTPxD6bWDaTONVJoMYpEW1tbFiHHzMQ/GL834vXrHR0dyxMTE+E+QSqpJo6aiX8QgU2QvskUu6RI2I6t7hQ7EWWk0JJqwkTMcr6IjwilkyJBOq1EIpROCDlkJv6hSFATt0inn1F34jlLtzpgJv5RVVW1Gc/f5Vy9rNmpt7dXx9Np3h00E/8wEaqJeUVB6UR0BrUJmol/QHYnnp8hEuElQVdX16eKiooi++wbdJ9tePwRtfBDEbBNrhMBhWbiFyJP0Vbg8VXtC93d3aqBFMW820z8orKycittsxzSfyYnJ4Oenh610rSua8zEL5TfeP4xOb+qsULdB68/qa2t3WMmfkHBFuH5B6TN74g8zxlqIB7k8fRjyP+KyJM2TxGw10z8gtzeAnldBoee1wmN52e832cmfmGb1b3I8yJPDTxHwH4z8Qsjf5vBLSRv0+dULGaevIFtJe9MPMXyP3Xa3K/DSzgyR2nD5nXYTPwi8jwjQeh5ked3Jhae12GFI+INvB3O+XYfpG7j3/N2mVVG6izn3chN0f+PmIlfaH4nba7i+aWIPGkzjQD/VyciD9Hw8io6WSHmRSKR8H95pbk9unnLJ8/yT16eJ99FfkH/zNhgNhMLz6vb0FlKIbwo8prn+Z3l3Qkz8Q3N7hTpnFqlyJMy8bp1Jn2K9ddqKpXSMfAd5E/ap3iAvN+eTCbvMKQ9xPv++7xvFBT8BWeW4MIjx/0pAAAAAElFTkSuQmCC"

/***/ }),

/***/ "../ShareWebComponents/src/DocsGrid/component.base.tsx":
/***/ (function(module, exports, __webpack_require__) {

/// <reference path="./component.base.d.ts" />
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
exports.__esModule = true;
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var session_1 = __webpack_require__("../ShareWebUtil/src/session/index.ts");
var entrydoc_1 = __webpack_require__("../ShareWebCore/src/entrydoc/index.ts");
var oem_1 = __webpack_require__("../ShareWebCore/src/oem/index.ts");
var path_1 = __webpack_require__("../ShareWebCore/src/path/index.ts");
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/index.ts");
var link_1 = __webpack_require__("../ShareWebCore/src/link/index.ts");
var permission_1 = __webpack_require__("../ShareWebCore/src/permission/index.ts");
var webcomponent_1 = __webpack_require__("../ShareWebComponents/src/webcomponent.tsx");
var Status;
(function (Status) {
    Status[Status["OK"] = 0] = "OK";
    // 无权限访问
    Status[Status["NO_PERMISSION"] = 1] = "NO_PERMISSION";
    // 文件不存在
    Status[Status["FILE_NOT_EXIST"] = 2] = "FILE_NOT_EXIST";
})(Status || (Status = {}));
var DocsGridBase = /** @class */ (function (_super) {
    __extends(DocsGridBase, _super);
    function DocsGridBase(props, context) {
        var _this = _super.call(this, props, context) || this;
        _this.state = {
            /**
             * 当前列举的目录子文档
             */
            docs: [],
            /**
             * 当前列举的目录路径
             */
            path: []
        };
        _this.timeoutId = 0;
        _this.open = _this.open.bind(_this);
        return _this;
    }
    DocsGridBase.prototype.componentWillMount = function () {
        this.watch();
        if (this.props.link) {
            this.load(this.props.doc);
        }
        else {
            if (this.props.doc && this.props.doc.docid) {
                this.load(this.props.doc);
            }
            else if (this.props.doctype) {
                this.loadType(this.props.doctype);
            }
            else {
                this.loadTopViews();
            }
        }
    };
    DocsGridBase.prototype.componentWillReceiveProps = function (nextProps) {
        if (nextProps.docid && nextProps.docid !== this.props.doc) {
            this.load(this.props.doc);
        }
    };
    /**
     * 列举指定类型的入口文档
     * @param doctype
     */
    DocsGridBase.prototype.loadType = function (doctype) {
        var _this = this;
        Promise.all([
            oem_1.getOEMConfByOptions(['product']),
            entrydoc_1.getViewByType(doctype),
            entrydoc_1.getTopEntriesByType(doctype)
        ]).then(function (_a) {
            var _b = __read(_a, 3), product = _b[0].product, view = _b[1], docs = _b[2];
            _this.updatePath([{ name: product }, view]);
            _this.updateDocs(docs);
        });
    };
    /**
     * 加载顶级视图
     */
    DocsGridBase.prototype.loadTopViews = function () {
        var _this = this;
        if (this.props.link) {
            this.load();
        }
        else {
            Promise.all([
                oem_1.getOEMConfByOptions(['product']),
                entrydoc_1.getTopViews()
            ]).then(function (_a) {
                var _b = __read(_a, 2), product = _b[0].product, views = _b[1];
                _this.updateDocs(lodash_1.uniq(views, function (n) { return n.doc_type; }));
                _this.updatePath([{ name: product }]);
            });
        }
    };
    /**
     * 初始化监控函数
     */
    DocsGridBase.prototype.watch = function () {
        this.props.watcher(this.load.bind(this));
    };
    /**
     * 列举文档或外链目录
     * @param doc
     */
    DocsGridBase.prototype.load = function (_a) {
        var docid = (_a === void 0 ? {} : _a).docid;
        if (this.props.link) {
            this.loadLinkDir(this.props.link, docid);
        }
        else {
            this.loadDir(docid);
        }
    };
    /**
     * 更新列举目录
     * @param docid
     */
    DocsGridBase.prototype.loadDir = function (docid) {
        var _this = this;
        return Promise.all([
            entrydoc_1.getViewById(docid),
            path_1.mapGNS(docid),
            docs_1.load(docid)
        ]).then(function (_a) {
            var _b = __read(_a, 3), view = _b[0], path = _b[1], docs = _b[2];
            _this.updatePath(__spread([lodash_1.first(_this.state.path), view], path)); // 第一级为AnyShare顶级路径，第二级view为文档类型视图，需要保留
            _this.updateDocs(docs);
        });
    };
    /**
     * 更新外链目录
     * @param link 外链对象
     */
    DocsGridBase.prototype.loadLinkDir = function (link, docid) {
        var _this = this;
        return Promise.all([
            path_1.mapLinkGNS(link, docid),
            link_1.list(lodash_1.assign({}, link, { docid: docid }))
        ]).then(function (_a) {
            var _b = __read(_a, 2), path = _b[0], docs = _b[1];
            _this.updatePath(path);
            _this.updateDocs(docs);
        });
    };
    DocsGridBase.prototype.updatePath = function (path) {
        this.setState({ path: path });
        this.props.onNavigate(path);
    };
    DocsGridBase.prototype.updateDocs = function (docs) {
        this.setState({ docs: docs });
        this.props.onLoad(docs);
    };
    /**
     * 打开目录
     * @param doc
     */
    DocsGridBase.prototype.open = function (doc) {
        var _this = this;
        if (this.props.link) {
            if (docs_1.isDir(doc)) {
                this.load(doc);
            }
            else {
                this.props.onOpen(doc);
            }
        }
        else {
            if (entrydoc_1.isTopView(doc)) {
                this.loadType(entrydoc_1.DocType[doc.doc_type]);
            }
            else if (docs_1.isDir(doc)) {
                this.load(doc);
            }
            else {
                permission_1.checkPermItem(doc.docid, permission_1.SharePermission.PREVIEW, session_1["default"].get('userid')).then(function (hasPerm) {
                    if (!hasPerm) {
                        _this.setState({
                            status: Status.NO_PERMISSION
                        }, function () { return _this.resetError(3000); });
                    }
                    else {
                        _this.props.onOpen(doc);
                    }
                }, function (_a) {
                    var errcode = _a.errcode;
                    switch (errcode) {
                        case 404006:
                            _this.setState({
                                status: Status.FILE_NOT_EXIST,
                                docs: _this.state.docs.filter(function (item) { return item !== doc; })
                            }, function () { return _this.resetError(3000); });
                        default:
                            return;
                    }
                });
            }
        }
    };
    /**
     * 重置异常
     */
    DocsGridBase.prototype.resetError = function (timeout) {
        var _this = this;
        if (typeof timeout === 'number') {
            this.timeoutId = setTimeout(function () {
                clearTimeout(_this.timeoutId);
                _this.setState({
                    status: Status.OK
                });
            }, timeout);
        }
        else {
            clearTimeout(this.timeoutId);
            this.setState({
                status: Status.OK
            });
        }
    };
    /**
     * 返回上一级目录
     * @param
     */
    DocsGridBase.prototype.back = function (path) {
        if (path.length === 1) {
            this.loadTopViews();
        }
        else {
            this.open(lodash_1.last(path));
        }
    };
    DocsGridBase.Status = Status;
    DocsGridBase.defaultProps = {
        watcher: lodash_1.noop,
        onOpen: lodash_1.noop,
        onNavigate: lodash_1.noop,
        onLoad: lodash_1.noop
    };
    return DocsGridBase;
}(webcomponent_1["default"]));
exports["default"] = DocsGridBase;


/***/ }),

/***/ "../ShareWebComponents/src/DocsGrid/component.mobile.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var classnames = __webpack_require__("../node_modules/classnames/index.js");
var entrydoc_1 = __webpack_require__("../ShareWebCore/src/entrydoc/index.ts");
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/index.ts");
var formatters_1 = __webpack_require__("../ShareWebUtil/src/formatters/index.ts");
var ui_mobile_1 = __webpack_require__("../ShareWebUI/src/Icon/ui.mobile.tsx");
var ui_mobile_2 = __webpack_require__("../ShareWebUI/src/FlexBox/ui.mobile.tsx");
var ui_mobile_3 = __webpack_require__("../ShareWebUI/src/Crumbs/ui.mobile.tsx");
var ui_mobile_4 = __webpack_require__("../ShareWebUI/src/DataGrid/ui.mobile.tsx");
var helper_1 = __webpack_require__("../ShareWebUI/src/helper.tsx");
var ui_mobile_5 = __webpack_require__("../ShareWebUI/src/ErrorDialog/ui.mobile.tsx");
var helper_2 = __webpack_require__("../ShareWebComponents/src/helper.tsx");
var component_base_1 = __webpack_require__("../ShareWebComponents/src/DocsGrid/component.base.tsx");
var styles = __webpack_require__("../ShareWebComponents/src/DocsGrid/styles.mobile.css");
var locale_1 = __webpack_require__("../ShareWebComponents/src/DocsGrid/locale.ts");
var enter = __webpack_require__("../ShareWebComponents/src/DocsGrid/assets/enter.mobile.png");
var DocsGrid = /** @class */ (function (_super) {
    __extends(DocsGrid, _super);
    function DocsGrid() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    DocsGrid.prototype.render = function () {
        var _this = this;
        return (React.createElement("div", { className: styles['container'] },
            React.createElement("div", { className: classnames(styles['navigator'], helper_1.ClassName.BackgroundColor) },
                React.createElement(ui_mobile_3["default"], { crumbs: this.state.path, formatter: function (crumb) { return entrydoc_1.isTopView(crumb) ? entrydoc_1.getViewName(crumb) : docs_1.docname(crumb); }, onChange: function () { return _this.back(_this.state.path.slice(0, _this.state.path.length - 1)); } })),
            React.createElement("div", { className: styles['main'] },
                React.createElement(ui_mobile_4["default"], { className: styles['docsgrid'], data: this.state.docs, onClickRow: this.open, select: false },
                    React.createElement(ui_mobile_4["default"].Field, { field: "name", label: locale_1["default"]('文档名称'), width: "200", formatter: function (name, record) {
                            var _a;
                            return (React.createElement("div", { className: styles['record'] },
                                React.createElement("div", { className: styles['icon'] }, helper_2.getMobileIcon(record)),
                                React.createElement("div", { className: classnames(styles['docinfo'], (_a = {}, _a[styles['dir']] = docs_1.isDir(record), _a)) },
                                    React.createElement("div", { className: styles['name'] }, record.view_type ? entrydoc_1.getViewName(record) : docs_1.docname(record)),
                                    !docs_1.isDir(record) ?
                                        React.createElement("div", null,
                                            React.createElement(ui_mobile_2["default"], null,
                                                React.createElement(ui_mobile_2["default"].Item, { align: "bottom left" }, React.createElement("span", { className: styles['meta'] }, formatters_1.formatTime(record.modified / 1000))),
                                                React.createElement(ui_mobile_2["default"].Item, { align: "bottom right" }, React.createElement("span", { className: styles['meta'] }, docs_1.isDir(record) ? '' : formatters_1.formatSize(record.size)))))
                                        : null),
                                React.createElement("div", { className: styles['action'] }, docs_1.isDir(record) ? React.createElement(ui_mobile_1["default"], { className: styles['enter'], size: ".5rem", url: enter }) : null)));
                        } }))),
            (function (status) {
                switch (status) {
                    case component_base_1["default"].Status.NO_PERMISSION:
                        return (React.createElement(ui_mobile_5["default"], { onConfirm: _this.resetError.bind(_this) }, locale_1["default"]('无法预览该文件,您的访问权限不足')));
                    case component_base_1["default"].Status.FILE_NOT_EXIST:
                        return (React.createElement(ui_mobile_5["default"], { onConfirm: _this.resetError.bind(_this) }, locale_1["default"]('无法预览该文件,该文件已不存在')));
                    default:
                        return null;
                }
            })(this.state.status)));
    };
    return DocsGrid;
}(component_base_1["default"]));
exports["default"] = DocsGrid;


/***/ }),

/***/ "../ShareWebComponents/src/DocsGrid/locale.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var i18n_1 = __webpack_require__("../ShareWebComponents/src/i18n.ts");
exports["default"] = i18n_1["default"]([
    [
        '文档名称',
        '文件名稱',
        'File Name'
    ],
    [
        '类型',
        '類型',
        'Type'
    ],
    [
        '大小',
        '大小',
        'Size'
    ],
    [
        '修改时间',
        '修改時間',
        'Modified On'
    ],
    [
        '无法预览该文件,您的访问权限不足',
        '無法預覽該檔案，您的存取權限不足',
        'Preview failed, insufficient permission'
    ],
    [
        '无法预览该文件,该文件已不存在',
        '無法預覽該檔案，該檔案已不存在',
        'Preview failed, the file does not exist'
    ]
]);


/***/ }),

/***/ "../ShareWebComponents/src/DocsGrid/styles.mobile.css":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin
module.exports = {"container":"_-ShareWebComponents-src-DocsGrid-styles-mobile---container","navigator":"_-ShareWebComponents-src-DocsGrid-styles-mobile---navigator","main":"_-ShareWebComponents-src-DocsGrid-styles-mobile---main","docsgrid":"_-ShareWebComponents-src-DocsGrid-styles-mobile---docsgrid","record":"_-ShareWebComponents-src-DocsGrid-styles-mobile---record","icon":"_-ShareWebComponents-src-DocsGrid-styles-mobile---icon","docinfo":"_-ShareWebComponents-src-DocsGrid-styles-mobile---docinfo","dir":"_-ShareWebComponents-src-DocsGrid-styles-mobile---dir","name":"_-ShareWebComponents-src-DocsGrid-styles-mobile---name","enter":"_-ShareWebComponents-src-DocsGrid-styles-mobile---enter","meta":"_-ShareWebComponents-src-DocsGrid-styles-mobile---meta","action":"_-ShareWebComponents-src-DocsGrid-styles-mobile---action"};

/***/ }),

/***/ "../ShareWebComponents/src/Download/Exceptions/component.base.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var download_1 = __webpack_require__("../ShareWebCore/src/download/index.ts");
var errorcode_1 = __webpack_require__("../ShareWebCore/src/apis/openapi/errorcode.ts");
var locale_1 = __webpack_require__("../ShareWebComponents/src/Download/Exceptions/locale.ts");
var Exceptions = /** @class */ (function (_super) {
    __extends(Exceptions, _super);
    function Exceptions(props, context) {
        var _this = _super.call(this, props, context) || this;
        _this.state = {
            error: null,
            close: lodash_1.noop
        };
        /**
         * 事件处理 Promise
         */
        _this.exceptionPromise = Promise.resolve();
        _this.handleDownloadError = _this.handleDownloadError.bind(_this);
        return _this;
    }
    Exceptions.prototype.componentDidMount = function () {
        this.unsubscribe = download_1.subscribe(download_1.EventType.DOWNLOAD_ERROR, this.handleDownloadError);
    };
    Exceptions.prototype.componentWillUnmount = function () {
        if (typeof this.unsubscribe === 'function') {
            this.unsubscribe();
        }
    };
    /**
     * 下载错误处理
     */
    Exceptions.prototype.handleDownloadError = function (error) {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (error.errcode) {
                    case download_1.ErrorCode.WATERMARK_NOT_SUPPORT:
                        if (typeof this.context.toast === 'function') {
                            this.context.toast(locale_1["default"]('不支持当前格式的文件下载'));
                        }
                        break;
                    case download_1.ErrorCode.MAKING_WATERMARK:
                    case download_1.ErrorCode.WAITING_WATERMARK:
                        if (typeof this.context.toast === 'function') {
                            this.context.toast(locale_1["default"]('正在制作水印，请稍后...'));
                        }
                        break;
                    // 外链关闭，外链密码变更，不处理
                    case errorcode_1.ErrorCode.LinkInaccessable:
                    case errorcode_1.ErrorCode.LinkAuthFailed:
                        break;
                    default:
                        this.exceptionPromise = this.exceptionPromise.then(function () {
                            return new Promise(function (resolve) {
                                _this.setState({
                                    error: error,
                                    close: resolve
                                });
                            }).then(function () {
                                _this.setState({
                                    error: null
                                });
                            });
                        });
                }
                return [2 /*return*/];
            });
        });
    };
    Exceptions.contextTypes = {
        toast: React.PropTypes.func
    };
    return Exceptions;
}(React.Component));
exports["default"] = Exceptions;


/***/ }),

/***/ "../ShareWebComponents/src/Download/Exceptions/component.mobile.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var component_base_1 = __webpack_require__("../ShareWebComponents/src/Download/Exceptions/component.base.tsx");
var ui_mobile_1 = __webpack_require__("../ShareWebUI/src/MessageDialog/ui.mobile.tsx");
var errcode_1 = __webpack_require__("../ShareWebCore/src/errcode/index.ts");
var optype_1 = __webpack_require__("../ShareWebCore/src/optype/index.ts");
var download_1 = __webpack_require__("../ShareWebCore/src/download/index.ts");
var formatters_1 = __webpack_require__("../ShareWebUtil/src/formatters/index.ts");
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/index.ts");
var commonStyles = __webpack_require__("../ShareWebComponents/src/styles.desktop.css");
var locale_1 = __webpack_require__("../ShareWebComponents/src/Download/Exceptions/locale.ts");
var Exceptions = /** @class */ (function (_super) {
    __extends(Exceptions, _super);
    function Exceptions() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Exceptions.prototype.render = function () {
        var _a = this.state, error = _a.error, close = _a.close;
        if (!error) {
            return null;
        }
        var _b = error, errcode = _b.errcode, target = _b.target, nativeEvent = _b.nativeEvent;
        switch (errcode) {
            case download_1.ErrorCode.FILE_NOT_EXISTED:
                return (React.createElement(ui_mobile_1["default"], { onConfirm: close },
                    React.createElement("h1", { className: commonStyles['warningHeader'] }, locale_1["default"]('无法执行下载操作')),
                    React.createElement("p", { className: commonStyles['warningContent'] }, errcode_1.getErrorTemplate(download_1.ErrorCode.FILE_NOT_EXISTED)({ filename: docs_1.docname(target) }))));
            case download_1.ErrorCode.FILE_NO_PERMISSION:
                return (React.createElement(ui_mobile_1["default"], { onConfirm: close },
                    React.createElement("h1", { className: commonStyles['warningHeader'] }, locale_1["default"]('无法执行下载操作')),
                    React.createElement("p", { className: commonStyles['warningContent'] }, errcode_1.getErrorMessage(download_1.ErrorCode.FILE_NO_PERMISSION, optype_1.OpType.DOWNLOAD))));
            case download_1.ErrorCode.No_COPY_PERMISSION:
                return (React.createElement(ui_mobile_1["default"], { onConfirm: close },
                    React.createElement("h1", { className: commonStyles['warningHeader'] }, locale_1["default"]('无法执行下载操作')),
                    React.createElement("p", { className: commonStyles['warningContent'] }, locale_1["default"]('您对文件“${filename}”没有复制权限, 不允许将数据从云盘下载到本地磁盘。', { filename: docs_1.docname(target) }))));
            case download_1.ErrorCode.FILE_SIZE_LIMITED:
                return (React.createElement(ui_mobile_1["default"], { onConfirm: close },
                    React.createElement("h1", { className: commonStyles['warningHeader'] }, locale_1["default"]('无法执行下载操作')),
                    React.createElement("p", { className: commonStyles['warningContent'] }, locale_1["default"]('文件 “${filename}” 已大于${fileSize}文件大小的限制。', {
                        filename: docs_1.docname(target),
                        fileSize: formatters_1.formatSize(nativeEvent.detail.file_limit_size)
                    }))));
            case download_1.ErrorCode.SECURITY_INSUFICIENT:
                return (React.createElement(ui_mobile_1["default"], { onConfirm: close },
                    React.createElement("h1", { className: commonStyles['warningHeader'] }, locale_1["default"]('无法执行下载操作')),
                    React.createElement("p", { className: commonStyles['warningContent'] }, errcode_1.getErrorMessage(download_1.ErrorCode.SECURITY_INSUFICIENT))));
            case download_1.ErrorCode.DOWNLOADS_LIMIT:
                return (React.createElement(ui_mobile_1["default"], { onConfirm: close },
                    React.createElement("h1", { className: commonStyles['warningHeader'] }, locale_1["default"]('无法执行下载操作')),
                    React.createElement("p", { className: commonStyles['warningContent'] }, errcode_1.getErrorMessage(download_1.ErrorCode.DOWNLOADS_LIMIT))));
            case download_1.ErrorCode.WATERMARKING_FAILED:
                return (React.createElement(ui_mobile_1["default"], { onConfirm: close },
                    React.createElement("h1", { className: commonStyles['warningHeader'] }, locale_1["default"]('无法下载文件“${filename}”', { filename: docs_1.docname(target) })),
                    React.createElement("p", { className: commonStyles['warningContent'] }, locale_1["default"]('水印制作失败'))));
            case download_1.ErrorCode.SITE_REMOVED:
                return (React.createElement(ui_mobile_1["default"], { onConfirm: close },
                    React.createElement("h1", { className: commonStyles['warningHeader'] }, locale_1["default"]('无法执行下载操作')),
                    React.createElement("p", { className: commonStyles['warningContent'] }, locale_1["default"]('文件“${filename}”的归属站点已经离线。', {
                        filename: docs_1.docname(target)
                    }))));
            case download_1.ErrorCode.WATERMARK_BATCH_DENIED:
                return (React.createElement(ui_mobile_1["default"], { onConfirm: close },
                    React.createElement("h1", { className: commonStyles['warningHeader'] }, locale_1["default"]('无法执行下载操作')),
                    React.createElement("p", { className: commonStyles['warningContent'] }, locale_1["default"]('水印范围内的文件不支持批量下载'))));
            // iOS不允许下载
            case download_1.ErrorCode.FAIL_IOS:
                return (React.createElement(ui_mobile_1["default"], { onConfirm: close },
                    React.createElement("h1", { className: commonStyles['warningHeader'] }, locale_1["default"]('无法执行下载操作')),
                    React.createElement("p", { className: commonStyles['warningContent'] }, locale_1["default"]('您正在使用苹果设备访问此页面，仅支持文件预览，不支持文件下载。'))));
            // 微信不允许下载
            case download_1.ErrorCode.FAIL_WECHAT:
                return (React.createElement(ui_mobile_1["default"], { onConfirm: close },
                    React.createElement("h1", { className: commonStyles['warningHeader'] }, locale_1["default"]('无法执行下载操作')),
                    React.createElement("p", { className: commonStyles['warningContent'] }, locale_1["default"]('您正在使用微信访问此页面，仅支持文件预览，不支持文件下载。'))));
            default:
                return null;
        }
    };
    return Exceptions;
}(component_base_1["default"]));
exports["default"] = Exceptions;


/***/ }),

/***/ "../ShareWebComponents/src/Download/Exceptions/locale.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var i18n_1 = __webpack_require__("../ShareWebComponents/src/i18n.ts");
exports["default"] = i18n_1["default"]([
    [
        '无法执行下载操作',
        '無法執行下載操作',
        'Failed to download this file'
    ],
    [
        '文件“${filename}”不存在, 可能其所在路径发生变更。',
        '檔案“${filename}”不存在, 可能其所在路徑發生變更。',
        'File "${filename}" does not exist or it’s location has been changed.'
    ],
    [
        '您正在使用苹果设备访问此页面，仅支持文件预览，不支持文件下载。',
        '您正在使用蘋果設備存取此頁面,僅支援檔案預覽,不支援檔案下載。',
        'You are viewing this page on iOS device, and only file preview is available.'
    ],
    [
        '您正在使用微信访问此页面，仅支持文件预览，不支持文件下载。',
        '您正在使用WeChat設備存取此頁面,僅支援檔案預覽,不支援檔案下載。',
        'You are viewing this page on WeChat, and only file preview is available.'
    ],
    [
        '您对文件“${filename}”没有下载权限。',
        '您對檔案“${filename}”沒有下载權限。',
        'You are not authorized to copy the file "${filename}".'
    ],
    [
        '您对文件“${filename}”没有复制权限, 不允许将数据从云盘下载到本地磁盘。',
        '您對檔案“${filename}”沒有複製權限, 不允許將資料從雲盤下載到本地磁碟。',
        'You do not have Copy permission to download file "${filename}" from web disk to local disk.'
    ],
    [
        '您没有下载权限。',
        '您没有下载權限。',
        'You are not authorized to download'
    ],
    [
        '下载',
        '下载',
        'Download'
    ],
    [
        '关闭',
        '關閉',
        'Close'
    ],
    [
        '立即下载',
        '立即下載',
        'Download Immediately'
    ],
    [
        '关闭窗口',
        '關閉窗口',
        'Close'
    ],
    [
        '外链地址不存在，无法下载文件。',
        '外連結位址不存在，無法下載檔案。',
        'External link does not exist, failed to download the file.'
    ],
    [
        '无法下载文件“${filename}”',
        '無法下載檔案“${filename}”',
        'Failed to download file “${filename}”'
    ],
    [
        '水印制作失败',
        '浮水印製作失敗',
        'Watermarking failed. '
    ],
    [
        '文件“${filename}”过大，无法同步，您所在的网络存在限制。',
        '檔案“${filename}”過大，無法同步，您所在的網路存在限制。',
        'File "${filename}" is too large and cannot be synced, your network is limited.'
    ],
    [
        '文件“${filename}”的归属站点已经离线。',
        '檔案“${filename}”的歸屬網站已經離線。',
        'the site of file "${filename}" is offline.'
    ],
    [
        '水印范围内的文件不支持批量下载',
        '水印範圍內的檔案不支持批量下載',
        'Files in the watermark range do not support batch'
    ],
    [
        '不支持当前格式的文件下载',
        '不支持當前格式的檔案下載',
        'File of current format is unsupported for download'
    ],
    [
        '正在制作水印，请稍后...',
        '正在製作浮水印，請稍後…',
        'Water-marking, please wait…'
    ],
    [
        '文件 “${filename}” 已大于${fileSize}文件大小的限制。',
        '檔案 “${filename}” 已大於${fileSize}文件大小的限制。',
        'The file "${filename}" is larger than the limit of ${fileSize}.',
    ]
]);


/***/ }),

/***/ "../ShareWebComponents/src/Download/component.base.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var download_1 = __webpack_require__("../ShareWebCore/src/download/index.ts");
var errorcode_1 = __webpack_require__("../ShareWebCore/src/apis/openapi/errorcode.ts");
var decorators_1 = __webpack_require__("../ShareWebUI/src/decorators.tsx");
var DownloadBase = /** @class */ (function (_super) {
    __extends(DownloadBase, _super);
    function DownloadBase(props, context) {
        var _this = _super.call(this, props, context) || this;
        _this.state = {
            url: ''
        };
        /**
         * unsubscribe 事件处理 handler
         */
        _this.unsubscribe = [];
        _this.handleDownloadSuccess = _this.handleDownloadSuccess.bind(_this);
        _this.handleDownloadError = _this.handleDownloadError.bind(_this);
        return _this;
    }
    DownloadBase.prototype.componentWillMount = function () {
        this.unsubscribe = [
            download_1.subscribe(download_1.EventType.DOWNLOAD_SUCCESS, this.handleDownloadSuccess),
            download_1.subscribe(download_1.EventType.DOWNLOAD_ERROR, this.handleDownloadError)
        ];
    };
    DownloadBase.prototype.componentWillUnmount = function () {
        this.unsubscribe.forEach(function (fn) { return fn(); });
    };
    /**
     * 下载成功
     */
    DownloadBase.prototype.handleDownloadSuccess = function (url) {
        if (typeof this.props.onGetURLSuccess === 'function') {
            this.props.onGetURLSuccess(url);
        }
        else {
            this.setState({
                url: url
            });
        }
    };
    /**
     * 下载失败
     */
    DownloadBase.prototype.handleDownloadError = function (e) {
        if (typeof this.props.onGetURLError === 'function') {
            this.props.onGetURLError(e);
        }
    };
    /**
     * 处理下载过程中的错误
     * @param e
     */
    DownloadBase.prototype.handleError = function (e) {
        try {
            var errObj = JSON.parse(e.target.contentWindow.document.body.innerText);
            var errcode = errObj.errcode;
            switch (errcode) {
                // 没有下载权限
                case errorcode_1.ErrorCode.PermissionRestricted:
                // 外链密码不正确
                case errorcode_1.ErrorCode.LinkAuthFailed:
                // 外链不存在
                case errorcode_1.ErrorCode.LinkInaccessable:
                    download_1.trigger(download_1.EventType.DOWNLOAD_ERROR, null, { errcode: errcode });
                    break;
            }
        }
        catch (err) {
        }
    };
    DownloadBase.defaultProps = {
        doc: [],
        saveName: ''
    };
    DownloadBase = __decorate([
        decorators_1.webcomponent
    ], DownloadBase);
    return DownloadBase;
}(React.Component));
exports["default"] = DownloadBase;


/***/ }),

/***/ "../ShareWebComponents/src/Download/component.mobile.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var component_base_1 = __webpack_require__("../ShareWebComponents/src/Download/component.base.tsx");
var component_mobile_1 = __webpack_require__("../ShareWebComponents/src/Download/Exceptions/component.mobile.tsx");
var styles = __webpack_require__("../ShareWebComponents/src/Download/styles.desktop.css");
var Download = /** @class */ (function (_super) {
    __extends(Download, _super);
    function Download() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Download.prototype.render = function () {
        var _a = this.props, onGetURLSuccess = _a.onGetURLSuccess, onGetURLError = _a.onGetURLError;
        return (React.createElement("div", null,
            typeof onGetURLError === 'function' ?
                null :
                React.createElement(component_mobile_1["default"], null),
            typeof onGetURLSuccess === 'function' ?
                null :
                React.createElement("iframe", { className: styles['iframe'], src: this.state.url })));
    };
    return Download;
}(component_base_1["default"]));
exports["default"] = Download;


/***/ }),

/***/ "../ShareWebComponents/src/Download/styles.desktop.css":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin
module.exports = {"iframe":"_-ShareWebComponents-src-Download-styles-desktop---iframe"};

/***/ }),

/***/ "../ShareWebComponents/src/ErrorOverlay/component.mobile.tsx":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var errcode_1 = __webpack_require__("../ShareWebCore/src/errcode/index.ts");
var ui_mobile_1 = __webpack_require__("../ShareWebUI/src/Overlay/ui.mobile.tsx");
function ErrorOverlay(_a) {
    var error = _a.error;
    return (React.createElement(ui_mobile_1["default"], { position: "top center" }, error.errcode === 500001 ? error.causemsg : errcode_1.getErrorMessage(error.errcode)));
}
exports["default"] = ErrorOverlay;


/***/ }),

/***/ "../ShareWebComponents/src/Image/assets/mobile/broken.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Image/assets/mobile/next.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA0AAAAVCAYAAACdbmSKAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyBpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNSBXaW5kb3dzIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOkEzQkNDNjhFRjIyRTExRTQ4MUYwRjc0QTJFREVDOEM4IiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOkEzQkNDNjhGRjIyRTExRTQ4MUYwRjc0QTJFREVDOEM4Ij4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6QTNCQ0M2OENGMjJFMTFFNDgxRjBGNzRBMkVERUM4QzgiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6QTNCQ0M2OERGMjJFMTFFNDgxRjBGNzRBMkVERUM4QzgiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz7y6x0ZAAABUUlEQVR42oyUPW6DQBCFF4RcG2iSJil8gRRI0PDTUWFcpwK58x3ScIgcITU/FSV0dOmpqOLCsuEExA9lEeC1NyMhgcS3772ZAdL3PcEVBMGHZVlP9PnRJZJr7ff7yLbtyPf9H4CEUwNU1/Xn5XIhsiyT3W7HBQeoLMtjHMfPABVFGUDHcV4eQqiiKI5JkozgdrttrpaZigKCTQvWoATwfD4THIQDmUq0YBUvAgCI5iwVRZY8tQpQVdUbUNQ0bWUYxooFojlUEZZN01SYmZY1zYgm4SCRN0hkzPP8DfeYo67rX1wIWVzX/RYEYVCqqupd4gFoAqydTieSZdkrsko8AJbQjDRNx3lJPICGR7a7c8LOTQHMawrcQAA8z2uQoW3bQWG5QjN7f5aa6c4tFWZKNMN6vR4tsRRm0GazOUCh67q7lmZFv/swDKPrbv3rH/ErwACymwuhwzTUbgAAAABJRU5ErkJggg=="

/***/ }),

/***/ "../ShareWebComponents/src/Image/assets/mobile/prev.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA0AAAAVCAYAAACdbmSKAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyBpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNSBXaW5kb3dzIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOjk2ODU4RTU0RjIyRTExRTQ4QUFFQzJFNEI0QkRDN0QxIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOjk2ODU4RTU1RjIyRTExRTQ4QUFFQzJFNEI0QkRDN0QxIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6OTY4NThFNTJGMjJFMTFFNDhBQUVDMkU0QjRCREM3RDEiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6OTY4NThFNTNGMjJFMTFFNDhBQUVDMkU0QjRCREM3RDEiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz5SFqJaAAABQklEQVR42oyUq26EQBSGB9JUczGsaQUvUAeGi0NxCbIKgus71PAQfYRqkEhwuHrUql1BuHgSumeyQ4ZNmelJEDPDl/P/P2dA67oi3mPbtpYkySdZi4hTAIRheHEcJ8+yLIc9kQdEUXSRZRmN44i6rvtiQq7rvgCgKAoGiqI4NU1zPYRuUrQgCM4EKMvyVNf1lZw//QWABwCGYdh1ICWyAOjwCOwgAqiqugG0JLqwPMuylDiOcUpHkqBM03xelgUJdKwsYCfPMIxvAKCqqnrjARhq2/YdYhUEAXme9wPeuBCYvZl+7fseQWr3kWGCAgwgnR4ZGVZ6W+TwAoQAAICsjruPCyFABxqEGWRCdMdpmrBH3/fPj+DmiTeDtMfDq3FPFUuVJGnnkXkJidR5nrFUXdc/8MF//hG32dTSNM3J+leAAQBATBEWEaFLHQAAAABJRU5ErkJggg=="

/***/ }),

/***/ "../ShareWebComponents/src/Image/component.base.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
exports.__esModule = true;
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var session_1 = __webpack_require__("../ShareWebUtil/src/session/index.ts");
var image_1 = __webpack_require__("../ShareWebCore/src/image/index.ts");
var errorcode_1 = __webpack_require__("../ShareWebCore/src/apis/openapi/errorcode.ts");
var helper_1 = __webpack_require__("../ShareWebComponents/src/Image/helper.ts");
var permission_1 = __webpack_require__("../ShareWebCore/src/permission/index.ts");
var csf_1 = __webpack_require__("../ShareWebCore/src/csf/index.ts");
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/index.ts");
var extension_1 = __webpack_require__("../ShareWebCore/src/extension/index.ts");
var webcomponent_1 = __webpack_require__("../ShareWebComponents/src/webcomponent.tsx");
var ImageBase = /** @class */ (function (_super) {
    __extends(ImageBase, _super);
    function ImageBase() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            /**
             * 图片资源
             */
            src: '',
            /**
             * 状态
             */
            status: -1,
            /**
             * 当前图片文档 移动端切换图片时使用
             */
            currentDoc: null,
            /**
             * 下载地址
             */
            downloadURL: '',
            previewError: false
        };
        return _this;
    }
    ImageBase.prototype.componentDidMount = function () {
        this.load(this.props.doc);
    };
    /**
     * 图片文档对象或者外链对象改变时 重新加载 获取下载地址
     */
    ImageBase.prototype.componentWillReceiveProps = function (nextProps) {
        if (nextProps.doc && nextProps.doc.docid !== this.props.doc.docid) {
            this.load(nextProps.doc);
            // 这里需要清空一下图裂的state，要不然一旦出现图裂，切换其他图片时会一直显示图裂
            this.setState({
                previewError: false
            });
        }
    };
    ImageBase.prototype.load = function (doc) {
        var _this = this;
        if (!doc) {
            // 文件不存在
            this.setState({ status: helper_1.Status.FILE_NOT_EXISTED });
        }
        else if (!extension_1.findPictrueType(docs_1.docname(doc))) {
            // 不支持的图片格式
            this.setState({
                status: helper_1.Status.INVALID_FORMAT
            });
        }
        else {
            if (this.props.link) {
                // 外链预览
                this.setState({
                    status: helper_1.Status.OK,
                    src: image_1.buildLinkImageSrc(lodash_1.merge({}, this.props.link, doc))
                });
            }
            else if (doc) {
                // 不是外链预览 检查预览权限
                this.check(doc).then(function () {
                    _this.setState({
                        status: helper_1.Status.OK,
                        src: image_1.buildImageSrc(doc)
                    });
                });
            }
        }
        if (doc && this.props.list) {
            this.setState({
                currentDoc: doc
            });
        }
    };
    /**
     * 检查预览权限 检查密级
     */
    ImageBase.prototype.check = function (doc) {
        var self = this;
        return new Promise(function (resolve, reject) {
            Promise.all([
                permission_1.checkPermItem(doc.docid, permission_1.SharePermission.PREVIEW, session_1["default"].get('userid')),
                csf_1.checkCsfLevel(doc.docid)
            ]).then(function (_a) {
                var _b = __read(_a, 2), permission = _b[0], csf = _b[1];
                if (permission) {
                    resolve(1);
                }
                else {
                    self.setState({ status: helper_1.Status.NO_PERMISSION });
                    reject(1);
                }
            })["catch"](function (response) {
                if (response.errcode) {
                    switch (response.errcode) {
                        //403002
                        case errorcode_1.ErrorCode.PermissionRestricted:
                            self.setState({ status: helper_1.Status.NO_PERMISSION });
                            break;
                        // 404006
                        case errorcode_1.ErrorCode.GNSInaccessible:
                            self.setState({ status: helper_1.Status.FILE_NOT_EXISTED });
                            break;
                        //403065 密级不足
                        case errorcode_1.ErrorCode.CSFLevelMismatch:
                            self.setState({ status: helper_1.Status.CSFLevelMismatch });
                            break;
                        default:
                            self.setState({ status: helper_1.Status.FAILED });
                            break;
                    }
                }
                reject(1);
            });
        });
    };
    /**
     * gallery切换当前图片
     */
    ImageBase.prototype.switchImage = function (target) {
        var self = this;
        return function () {
            self.props.applyImage(target);
        };
    };
    /**
     * 获取缩略图位置
     */
    ImageBase.prototype.getIndex = function () {
        var _this = this;
        var index = lodash_1.findIndex(this.props.gallery, function (item, i) {
            return item.docid === _this.props.doc.docid;
        });
        return Math.floor(index / this.props.groupSize);
    };
    /**
     * 处理预览图片出错
     */
    ImageBase.prototype.handleError = function (e) {
        this.setState({
            previewError: true
        });
    };
    ImageBase.defaultProps = {
        /**
         * 直接传递图片url
         */
        url: '',
        /**
         * 传递图片文档对象
         */
        doc: null,
        /**
         * 传递外链对象
         */
        link: null,
        /**
         * 图片列表
         */
        list: [],
        /**
         * 缩略图文档列表
         */
        gallery: [],
        /**
         * 权限信息
         */
        perm: 1,
        /**
         * 缩略图分组大小
         */
        groupSize: 8
    };
    return ImageBase;
}(webcomponent_1["default"]));
exports["default"] = ImageBase;


/***/ }),

/***/ "../ShareWebComponents/src/Image/component.mobile.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var locale_1 = __webpack_require__("../ShareWebComponents/src/Image/locale.ts");
var component_base_1 = __webpack_require__("../ShareWebComponents/src/Image/component.base.tsx");
var ui_mobile_1 = __webpack_require__("../ShareWebUI/src/ImageBox/ui.mobile.tsx");
var ui_desktop_1 = __webpack_require__("../ShareWebUI/src/ui.desktop.tsx");
var component_mobile_1 = __webpack_require__("../ShareWebComponents/src/Viewer/component.mobile.tsx");
var errcode_1 = __webpack_require__("../ShareWebCore/src/errcode/index.ts");
var ui_mobile_2 = __webpack_require__("../ShareWebUI/src/LinkIcon/ui.mobile.tsx");
var helper_1 = __webpack_require__("../ShareWebComponents/src/Image/helper.ts");
var styles = __webpack_require__("../ShareWebComponents/src/Image/style.mobile.css");
var prev = __webpack_require__("../ShareWebComponents/src/Image/assets/mobile/prev.png");
var next = __webpack_require__("../ShareWebComponents/src/Image/assets/mobile/next.png");
var brokenImg = __webpack_require__("../ShareWebComponents/src/Image/assets/mobile/broken.png");
var Image = /** @class */ (function (_super) {
    __extends(Image, _super);
    function Image() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * 注册屏幕旋转的事件监听
     */
    Image.prototype.componentDidMount = function () {
        _super.prototype.componentDidMount.call(this);
        window.addEventListener('orientationchange', this.setImageSize.bind(this));
    };
    /**
     * 卸载时移除事件监听
     */
    Image.prototype.componentWillUnmount = function () {
        window.removeEventListener('orientationchange', this.setImageSize);
    };
    Image.prototype.render = function () {
        return (React.createElement(component_mobile_1["default"], { onRequestBack: this.props.onRequestBack, doc: this.state.currentDoc || this.props.doc, link: this.props.link, style: { background: '#000', backgroundImage: 'none' } },
            React.createElement("div", { className: styles['container'] },
                React.createElement("div", { className: styles['body'] }, this.props.list.length > 1 ?
                    (React.createElement("div", null,
                        React.createElement("div", { className: styles['img-wrap'] }, this.getContent()),
                        React.createElement(ui_mobile_2["default"], { className: styles['right-arrow'], url: prev, size: "40px", onClick: this.prevHandler.bind(this) }),
                        React.createElement(ui_mobile_2["default"], { className: styles['left-arrow'], url: next, size: "40px", onClick: this.nextHandler.bind(this) }))) :
                    (React.createElement("div", { className: styles['img-wrap'] }, this.getContent()))))));
    };
    Image.prototype.getContent = function () {
        switch (this.state.status) {
            case helper_1.Status.OK:
                return (this.state.previewError ?
                    React.createElement(ui_desktop_1.Centered, null,
                        React.createElement(ui_desktop_1.Icon, { url: brokenImg, size: 64 }),
                        React.createElement("div", { className: styles['text'] },
                            " ",
                            locale_1["default"]('图片加载失败')))
                    :
                        (React.createElement(ui_mobile_1["default"], { src: this.state.src, fullScreen: this.props.list.length > 1 ? false : true, onError: this.handleError.bind(this) })));
            case helper_1.Status.INVALID_FORMAT:
                return (React.createElement("div", { className: styles.message }, locale_1["default"]('不支持当前格式的文件预览')));
            case helper_1.Status.NO_PERMISSION:
                return (React.createElement("div", { className: styles.message }, locale_1["default"]('无法预览该文件,您的访问权限不足')));
            case helper_1.Status.FILE_NOT_EXISTED:
                return (React.createElement("div", { className: styles.message }, locale_1["default"]('无法预览该文件，该文件已不存在')));
            case helper_1.Status.CSFLevelMismatch:
                return (React.createElement("div", { className: styles.message }, locale_1["default"]('无法预览该文件，您的密级不足')));
            case helper_1.Status.LINK_PWD_ERROR:
                return (React.createElement("div", { className: styles.message }, errcode_1.getErrorMessage(helper_1.Status.LINK_PWD_ERROR)));
        }
    };
    Image.prototype.setImageSize = function () {
        var self = this;
        setTimeout(function () {
            self.forceUpdate();
        }, 100);
    };
    /**
     * 获取当前图片在列表中的顺序
     */
    Image.prototype.getImgIndex = function () {
        var _this = this;
        return lodash_1.findIndex(this.props.list, function (doc) { return doc.docid === _this.state.currentDoc.docid; });
    };
    /**
     * 应用对应列表位置的图片
     */
    Image.prototype.applyImgByIndex = function (index) {
        var newPicture = this.props.list[index];
        this.setState({
            currentDoc: newPicture
        });
        this.props.onChange(newPicture);
    };
    /**
     * 前翻
     */
    Image.prototype.prevHandler = function () {
        var index = this.getImgIndex();
        if (index !== 0) {
            this.applyImgByIndex(index - 1);
        }
    };
    /**
     * 后翻
     */
    Image.prototype.nextHandler = function () {
        var index = this.getImgIndex();
        if (index !== this.props.list.length - 1) {
            this.applyImgByIndex(index + 1);
        }
    };
    return Image;
}(component_base_1["default"]));
exports["default"] = Image;


/***/ }),

/***/ "../ShareWebComponents/src/Image/helper.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var image_1 = __webpack_require__("../ShareWebCore/src/image/index.ts");
var Status;
(function (Status) {
    // 获取成功
    Status[Status["OK"] = 0] = "OK";
    // 格式错误
    Status[Status["INVALID_FORMAT"] = 1] = "INVALID_FORMAT";
    // 预览失败
    Status[Status["FAILED"] = 2] = "FAILED";
    // 外链密码不正确
    Status[Status["LINK_PWD_ERROR"] = 401002] = "LINK_PWD_ERROR";
    // 没有预览权限
    Status[Status["NO_PERMISSION"] = 403002] = "NO_PERMISSION";
    // 文件不存在
    Status[Status["FILE_NOT_EXISTED"] = 404006] = "FILE_NOT_EXISTED";
    // 密级不足
    Status[Status["CSFLevelMismatch"] = 403065] = "CSFLevelMismatch";
})(Status = exports.Status || (exports.Status = {}));
function buildThumb(docid) {
    return image_1.buildSrc(docid, 100, 100, 50);
}
function buildGallery(list) {
    var checkingPerm = [], gallery = [], groupIndex = -1;
    return _.map(list, function (doc) { return ({
        doc: doc,
        img: buildThumb(doc.docid)
    }); });
}
exports.buildGallery = buildGallery;


/***/ }),

/***/ "../ShareWebComponents/src/Image/locale.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var i18n_1 = __webpack_require__("../ShareWebComponents/src/i18n.ts");
exports["default"] = i18n_1["default"]([
    [
        '确定',
        '確定',
        'OK'
    ],
    [
        '下载',
        '下載',
        'Download'
    ],
    [
        '不支持当前格式的文件预览',
        '不支援當前的檔案格式預覽',
        'File of this type is unsupported for previewing'
    ],
    [
        '无法预览该文件,您的访问权限不足',
        '無法預覽該檔案，您的存取權限不足',
        'Preview failed, insufficient permission'
    ],
    [
        '无法预览该文件，该文件已不存在',
        '無法預覽該檔案，該檔案已不存在',
        'Preview failed, the file does not exist'
    ],
    [
        '图片加载失败',
        '圖片加載失敗',
        'Load failed'
    ],
    [
        '无法预览该文件，您的密级不足',
        '無法預覽該檔案，您的密級不足',
        'Preview failed, your security level is lower than that of files.'
    ]
]);


/***/ }),

/***/ "../ShareWebComponents/src/Image/style.mobile.css":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin
module.exports = {"container":"_-ShareWebComponents-src-Image-style-mobile---container","body":"_-ShareWebComponents-src-Image-style-mobile---body","message":"_-ShareWebComponents-src-Image-style-mobile---message","img-wrap":"_-ShareWebComponents-src-Image-style-mobile---img-wrap","right-arrow":"_-ShareWebComponents-src-Image-style-mobile---right-arrow","left-arrow":"_-ShareWebComponents-src-Image-style-mobile---left-arrow","text":"_-ShareWebComponents-src-Image-style-mobile---text"};

/***/ }),

/***/ "../ShareWebComponents/src/Login/Captcha/component.mobile.tsx":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var classnames = __webpack_require__("../node_modules/classnames/index.js");
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var ui_mobile_1 = __webpack_require__("../ShareWebUI/src/TextInput/ui.mobile.tsx");
var helper_1 = __webpack_require__("../ShareWebUI/src/helper.tsx");
var styles = __webpack_require__("../ShareWebComponents/src/Login/Captcha/styles.mobile.css");
var locale_1 = __webpack_require__("../ShareWebComponents/src/Login/Captcha/locale.ts");
function ChangePassword(_a) {
    var captchaPicture = _a.captchaPicture, vcode = _a.vcode, _b = _a.handleChange, handleChange = _b === void 0 ? lodash_1.noop : _b, _c = _a.changeNext, changeNext = _c === void 0 ? lodash_1.noop : _c;
    return (React.createElement("div", { className: styles['captach'] },
        React.createElement("div", { className: styles['captach-input'] },
            React.createElement(ui_mobile_1["default"], { className: classnames(styles['captach-input-size'], helper_1.ClassName.BorderColor__Focus), value: vcode, onChange: function (value) { handleChange(value); }, placeholder: locale_1["default"]('请输入验证码') })),
        React.createElement("div", { className: styles['captach-img'] }, captchaPicture ?
            React.createElement("img", { src: "data:image/jpeg;base64," + captchaPicture, onClick: changeNext, height: 45 }) :
            null)));
}
exports["default"] = ChangePassword;


/***/ }),

/***/ "../ShareWebComponents/src/Login/Captcha/locale.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var i18n_1 = __webpack_require__("../ShareWebComponents/src/i18n.ts");
exports["default"] = i18n_1["default"]([
    [
        '请输入验证码',
        '請輸入驗證碼',
        'Verification Code'
    ]
]);


/***/ }),

/***/ "../ShareWebComponents/src/Login/Captcha/styles.mobile.css":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin
module.exports = {"captach":"_-ShareWebComponents-src-Login-Captcha-styles-mobile---captach","captach-input":"_-ShareWebComponents-src-Login-Captcha-styles-mobile---captach-input","captach-input-size":"_-ShareWebComponents-src-Login-Captcha-styles-mobile---captach-input-size","captach-img":"_-ShareWebComponents-src-Login-Captcha-styles-mobile---captach-img"};

/***/ }),

/***/ "../ShareWebComponents/src/Login/component.base.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var session_1 = __webpack_require__("../ShareWebUtil/src/session/index.ts");
var auth_1 = __webpack_require__("../ShareWebCore/src/auth/index.ts");
var auth1_1 = __webpack_require__("../ShareWebCore/src/apis/eachttp/auth1/index.ts");
var config_1 = __webpack_require__("../ShareWebCore/src/config/index.ts");
var ca_1 = __webpack_require__("../ShareWebCore/src/ca/index.ts");
var webcomponent_1 = __webpack_require__("../ShareWebComponents/src/webcomponent.tsx");
var helper_1 = __webpack_require__("../ShareWebComponents/src/Login/helper.ts");
/**
 * 输入框类型
 */
var InputType;
(function (InputType) {
    InputType[InputType["ACCOUNT"] = 0] = "ACCOUNT";
    InputType[InputType["PASSWORD"] = 1] = "PASSWORD";
})(InputType = exports.InputType || (exports.InputType = {}));
/**
 *  登录状态
 */
var LoadStatus;
(function (LoadStatus) {
    LoadStatus[LoadStatus["READY"] = 0] = "READY";
    LoadStatus[LoadStatus["LOADING"] = 1] = "LOADING";
})(LoadStatus = exports.LoadStatus || (exports.LoadStatus = {}));
var LoginBase = /** @class */ (function (_super) {
    __extends(LoginBase, _super);
    function LoginBase() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            account: '',
            password: '',
            loginStatus: helper_1.Status.NORMAL,
            focusing: null,
            loadStatus: LoadStatus.READY,
            caMessage: '',
            secondAuthId: '',
            needChangePassword: false,
            errorInfo: null,
            captchaStatus: false,
            captchaInfo: {
                uuid: '',
                vcode: ''
            },
            vcode: ''
        };
        _this.userInfo = null;
        return _this;
    }
    LoginBase.prototype.componentWillMount = function () {
        if (session_1["default"].has('kickedOut')) {
            if (session_1["default"].get('kickedOut') === helper_1.Status.ACCOUNT_LOCK) {
                this.setState({
                    loginStatus: session_1["default"].take('kickedOut'),
                    errorInfo: { detail: session_1["default"].take('detail') }
                });
            }
            else {
                this.setState({
                    loginStatus: session_1["default"].take('kickedOut')
                });
            }
        }
        else if (session_1["default"].has('timeout')) {
            this.setState({
                loginStatus: helper_1.Status.CLIENT_LOGOUT
            });
            session_1["default"].remove('timeout');
        }
        this.getCaptchaStatus();
    };
    LoginBase.prototype.login = function (ostype, event) {
        var _this = this;
        if (!this.state.account) {
            this.setState({
                loginStatus: helper_1.Status.NO_ACCOUNT
            });
        }
        else if (!this.state.password) {
            this.setState({
                loginStatus: helper_1.Status.NO_PASSWORD
            });
        }
        else if (!this.state.vcode && session_1["default"].get('captchaStatus')) {
            this.setState({
                loginStatus: helper_1.Status.NO_VCODE,
                vcode: ''
            });
        }
        else {
            this.setState({
                loadStatus: LoadStatus.LOADING
            });
            config_1.getThirdAuth().then(function (thirdauth) {
                // 开启了CA认证
                if (thirdauth.id === 'ideabank') {
                    ca_1.caAuth(_this.state.account, thirdauth.config).then(function () {
                        this.authLogin(ostype);
                    }, function (message) {
                        this.setState({
                            caMessage: message
                        });
                    });
                }
                else {
                    _this.authLogin(ostype);
                }
            });
        }
        event.preventDefault();
    };
    LoginBase.prototype.authLogin = function (ostype) {
        var _this = this;
        auth_1.login(this.state.account, this.state.password, ostype, { uuid: this.state.captchaInfo.uuid, vcode: this.state.vcode, ismodify: false }).then(function (res) {
            session_1["default"].remove('captchaStatus');
            _this.userInfo = res;
            _this.setState({
                loadStatus: LoadStatus.READY
            });
            if (res.needsecondauth) {
                config_1.getThirdAuth('id').then(function (thirdauthid) {
                    if (thirdauthid === 'cjsjy') {
                        _this.setState({
                            secondAuthId: thirdauthid
                        });
                    }
                });
            }
            else {
                _this.props.onSuccess(res);
            }
        }, function (err) {
            if (session_1["default"].get('captchaStatus')) {
                _this.getCaptchaInfo(_this.state.captchaInfo.uuid);
            }
            else if (err.detail && err.detail.isShowStatus) {
                session_1["default"].set('captchaStatus', true);
                _this.getCaptchaInfo(_this.state.captchaInfo.uuid);
            }
            _this.setState({
                loadStatus: LoadStatus.READY,
                vcode: ''
            });
            if (err.errcode) {
                if (err.errcode === helper_1.Status.EXPIRED_PASSWORD || err.errcode === helper_1.Status.LOW_PASSWORD || err.errcode === helper_1.Status.ORGIN_PASSWORD) {
                    _this.setState({
                        loginStatus: err.errcode,
                        errorInfo: err,
                        needChangePassword: true
                    });
                }
                else {
                    _this.setState({
                        loginStatus: err.errcode,
                        errorInfo: err
                    });
                }
            }
            _this.refs.password && _this.refs.password.focus();
            _this.refs.password && _this.refs.password.blur();
        });
    };
    LoginBase.prototype.inputAccount = function (e) {
        this.setState({
            account: e.target.value
        });
    };
    LoginBase.prototype.inputPassword = function (e) {
        this.setState({
            password: e.target.value
        });
    };
    /**
     * 文本聚焦
     * @param value = InputType.ACCOUNT（账户输入）|| InputType.PASSWORD（密码输入）
     */
    LoginBase.prototype.setFocusStatus = function (value) {
        this.setState({
            focusing: value
        });
    };
    /**
     * 文本失去聚焦
     * @param value = InputType.ACCOUNT（账户输入）|| InputType.PASSWORD（密码输入）
     */
    LoginBase.prototype.setBlurStatus = function () {
        this.setState({
            focusing: null
        });
    };
    /**
     * 取消跳转修改密码
     */
    LoginBase.prototype.cancelPassword = function () {
        this.setState({
            loginStatus: helper_1.Status.NORMAL,
            needChangePassword: false
        });
    };
    /**
     * 二次认证成功
     */
    LoginBase.prototype.secondAuthSuccess = function () {
        this.setState({
            secondAuthId: ''
        });
        this.props.onSuccess(this.userInfo);
    };
    /**
     * 取消二次认证
     */
    LoginBase.prototype.onCancelSecondAuth = function () {
        this.setState({
            secondAuthId: ''
        });
    };
    /**
     * 获取是否需要验证码
     */
    LoginBase.prototype.getCaptchaStatus = function () {
        return __awaiter(this, void 0, void 0, function () {
            var vcodeLogin;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, config_1.getConfig('vcode_login_config')];
                    case 1:
                        vcodeLogin = _a.sent();
                        if (session_1["default"].get('captchaStatus')) {
                            this.setState({
                                captchaStatus: session_1["default"].get('captchaStatus')
                            });
                            this.getCaptchaInfo(this.state.captchaInfo.uuid);
                        }
                        else if (vcodeLogin && vcodeLogin.isenable && vcodeLogin.passwderrcnt === 0) {
                            session_1["default"].set('captchaStatus', true);
                            this.setState({
                                captchaStatus: true
                            });
                            this.getCaptchaInfo(this.state.captchaInfo.uuid);
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * 获取输入的验证码
     */
    LoginBase.prototype.getInputVcode = function (vcode) {
        this.setState({
            vcode: vcode
        });
    };
    /**
     * 换下一个验证码
     */
    LoginBase.prototype.changeNext = function () {
        this.getCaptchaInfo(this.state.captchaInfo.uuid);
    };
    /**
     * 获取验证码图片
     */
    LoginBase.prototype.getCaptchaInfo = function (uuid) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _a = this.setState;
                        _b = {};
                        return [4 /*yield*/, auth1_1.getVcode({ uuid: uuid })];
                    case 1:
                        _a.apply(this, [(_b.captchaInfo = _c.sent(),
                                _b.captchaStatus = true,
                                _b)]);
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * 去修改密码
     */
    LoginBase.prototype.requestPasswordChange = function () {
        this.props.onPasswordChange(this.state.account);
        this.setState({
            loginStatus: helper_1.Status.NORMAL,
            needChangePassword: false
        });
    };
    LoginBase.defaultProps = {
        onPasswordChange: lodash_1.noop,
        onSuccess: lodash_1.noop
    };
    return LoginBase;
}(webcomponent_1["default"]));
exports["default"] = LoginBase;


/***/ }),

/***/ "../ShareWebComponents/src/Login/component.mobile.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var classnames = __webpack_require__("../node_modules/classnames/index.js");
var errcode_1 = __webpack_require__("../ShareWebCore/src/errcode/index.ts");
var auth_1 = __webpack_require__("../ShareWebCore/src/auth/index.ts");
var helper_1 = __webpack_require__("../ShareWebUI/src/helper.tsx");
var ui_mobile_1 = __webpack_require__("../ShareWebUI/src/Button/ui.mobile.tsx");
var ui_mobile_2 = __webpack_require__("../ShareWebUI/src/Overlay/ui.mobile.tsx");
var ui_mobile_3 = __webpack_require__("../ShareWebUI/src/UIIcon/ui.mobile.tsx");
var component_mobile_1 = __webpack_require__("../ShareWebComponents/src/Login/Captcha/component.mobile.tsx");
var component_base_1 = __webpack_require__("../ShareWebComponents/src/Login/component.base.tsx");
var component_base_2 = __webpack_require__("../ShareWebComponents/src/Login/component.base.tsx");
var helper_2 = __webpack_require__("../ShareWebComponents/src/Login/helper.ts");
var locale_1 = __webpack_require__("../ShareWebComponents/src/Login/locale.ts");
var styles = __webpack_require__("../ShareWebComponents/src/Login/styles.mobile.css");
var Login = /** @class */ (function (_super) {
    __extends(Login, _super);
    function Login() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        //  计时器id
        _this.timeId = null;
        return _this;
    }
    Login.prototype.render = function () {
        var _this = this;
        return (React.createElement("div", { className: styles['login'] },
            React.createElement("form", { onSubmit: this.login.bind(this, auth_1.OS_TYPE.MOBILEWEB) },
                React.createElement("div", { className: styles['input-user'] },
                    React.createElement(ui_mobile_3["default"], { code: '\uf01f', color: '#c3c3c3', size: 20, className: styles['icon'] }),
                    React.createElement("input", { type: "text", className: classnames(styles['account'], helper_1.ClassName.BorderColor__Focus), value: this.state.account, onChange: function (account) { _this.inputAccount(account); }, placeholder: locale_1["default"]('请输入账号') })),
                React.createElement("div", { className: styles['input-password'] },
                    React.createElement(ui_mobile_3["default"], { code: '\uf020', color: '#c3c3c3', size: 20, className: styles['icon'] }),
                    React.createElement("input", { type: "password", className: classnames(styles['password'], helper_1.ClassName.BorderColor__Focus), value: this.state.password, ref: "password", onChange: function (password) { _this.inputPassword(password); }, placeholder: locale_1["default"]('请输入密码') })),
                this.state.captchaStatus ?
                    (React.createElement(component_mobile_1["default"], { captchaPicture: this.state.captchaInfo.vcode, vcode: this.state.vcode, handleChange: function (value) { _this.getInputVcode(value); }, changeNext: this.changeNext.bind(this) })) :
                    null,
                React.createElement("div", { className: styles['submit-load'] },
                    React.createElement(ui_mobile_1["default"], { type: "submit", disabled: !this.state.account || !this.state.password || (this.state.captchaStatus && !this.state.vcode), className: classnames(styles['input-btn'], helper_1.ClassName.BackgroundColor) }, this.state.loadStatus === component_base_2.LoadStatus.READY ?
                        locale_1["default"]('登 录') :
                        locale_1["default"]('登录中...')))),
            this.state.loginStatus !== helper_2.Status.NORMAL ?
                this.renderError(this.state.loginStatus) :
                null));
    };
    Login.prototype.renderError = function (errorcode) {
        return (React.createElement(ui_mobile_2["default"], { position: "center 80%", className: styles['error-code'] },
            React.createElement("p", null, this.getMessage(errorcode))));
    };
    Login.prototype.getMessage = function (errorcode) {
        var _this = this;
        if (this.timeId) {
            clearTimeout(this.timeId);
            this.timeId = null;
        }
        this.timeId = setTimeout(function () {
            _this.setState({
                loginStatus: helper_2.Status.NORMAL
            });
        }, 3000);
        switch (errorcode) {
            case helper_2.Status.ORGIN_PASSWORD:
                return locale_1["default"]('无法使用初始密码登录，请登录Web客户端修改密码。');
            case helper_2.Status.EXPIRED_PASSWORD:
                return locale_1["default"]('您的登录密码已失效，请登录Web客户端修改密码。');
            case helper_2.Status.LOW_PASSWORD:
                return locale_1["default"]('您的密码安全系数过低，请登录Web客户端修改密码。');
            case helper_2.Status.ACCOUNT_LOCK:
                return locale_1["default"]('您输入错误次数超过限制，账号已被锁定，${time}分钟内无法登录，请稍后重试', { 'time': this.state.errorInfo.detail.remainlockTime });
            case helper_2.Status.NEED_ACTION:
                return locale_1["default"]('用户已被禁用，请登录Web客户端激活');
            default:
                return errcode_1.getErrorMessage(errorcode);
        }
    };
    return Login;
}(component_base_1["default"]));
exports["default"] = Login;


/***/ }),

/***/ "../ShareWebComponents/src/Login/helper.ts":
/***/ (function(module, exports) {

exports.__esModule = true;
/**
 * 登录状态
 */
var Status;
(function (Status) {
    // 无异常
    Status[Status["NORMAL"] = 0] = "NORMAL";
    // 无用户名
    Status[Status["NO_ACCOUNT"] = 1] = "NO_ACCOUNT";
    // 无密码
    Status[Status["NO_PASSWORD"] = 2] = "NO_PASSWORD";
    // 客户端超时退出
    Status[Status["CLIENT_LOGOUT"] = 3] = "CLIENT_LOGOUT";
    // 验证码不存在
    Status[Status["NO_VCODE"] = 4] = "NO_VCODE";
    // 初始密码登录
    Status[Status["ORGIN_PASSWORD"] = 401017] = "ORGIN_PASSWORD";
    // 密码系数过低
    Status[Status["LOW_PASSWORD"] = 401013] = "LOW_PASSWORD";
    // 密码已失效
    Status[Status["EXPIRED_PASSWORD"] = 401012] = "EXPIRED_PASSWORD";
    // 账号已被锁定
    Status[Status["ACCOUNT_LOCK"] = 401020] = "ACCOUNT_LOCK";
    // 账号需要激活
    Status[Status["NEED_ACTION"] = 401040] = "NEED_ACTION";
})(Status = exports.Status || (exports.Status = {}));


/***/ }),

/***/ "../ShareWebComponents/src/Login/locale.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var i18n_1 = __webpack_require__("../ShareWebComponents/src/i18n.ts");
exports["default"] = i18n_1["default"]([
    [
        '登 录',
        '登 入',
        'Log In'
    ], [
        '请输入账号',
        '請輸入帳號',
        'Enter account'
    ], [
        '请输入密码',
        '請輸入密碼',
        'Enter password'
    ], [
        '无法使用初始密码登录，请登录Web客户端修改密码。',
        '無法使用初始密碼登入，請登入Web用戶端修改密碼。',
        'You are not allowed to log in with initial password, please change password in Web Client.'
    ], [
        '您的登录密码已失效，请登录Web客户端修改密码。',
        '您的登入密碼已失效，請登入Web用戶端修改密碼。',
        'Your password has been invalid, please change password in Web Client.'
    ], [
        '您的密码安全系数过低，请登录Web客户端修改密码。',
        '您的密碼安全係數過低，請登入Web用戶端修改密碼。',
        'Weak password, please change password in Web Client. '
    ], [
        '你还没有输入账号',
        '您還沒有輸入帳號',
        'You have not enter account.'
    ],
    [
        '你还没有输入密码',
        '您還沒有輸入密碼',
        'You have not enter password.'
    ],
    [
        '您输入错误次数超过限制，账号已被锁定，${time}分钟内无法登录，请稍后重试',
        '您輸入錯誤次數超過限制，帳號已被鎖定，${time}分鐘內無法登入，請稍後重試',
        'Account has been locked and you cannot log in within ${time} minute(s). Please try later.'
    ],
    [
        '您的登录已超时。',
        '您的登入已超時。',
        'Your login has timed out.'
    ],
    [
        '验证码不能为空，请重新输入',
        '驗證碼不能為空，請重新輸入',
        'Verification code cannot be empty, please enter again'
    ],
    [
        '用户已被禁用，请登录Web客户端激活',
        '用戶已被禁用，請登錄Web客戶端啟動',
        'User has been disabled, Please login web client activation'
    ],
    [
        '登录中...',
        '登入中...',
        'Loading...'
    ]
]);


/***/ }),

/***/ "../ShareWebComponents/src/Login/styles.mobile.css":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin
module.exports = {"login":"_-ShareWebComponents-src-Login-styles-mobile---login","input-user":"_-ShareWebComponents-src-Login-styles-mobile---input-user","account":"_-ShareWebComponents-src-Login-styles-mobile---account","input-password":"_-ShareWebComponents-src-Login-styles-mobile---input-password","password":"_-ShareWebComponents-src-Login-styles-mobile---password","icon":"_-ShareWebComponents-src-Login-styles-mobile---icon","submit-load":"_-ShareWebComponents-src-Login-styles-mobile---submit-load","error-code":"_-ShareWebComponents-src-Login-styles-mobile---error-code"};

/***/ }),

/***/ "../ShareWebComponents/src/Play/assets/loading.gif":
/***/ (function(module, exports) {

module.exports = "data:image/gif;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Play/component.base.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
var webcomponent_1 = __webpack_require__("../ShareWebComponents/src/webcomponent.tsx");
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var timer_1 = __webpack_require__("../ShareWebUtil/src/timer/index.ts");
var extension_1 = __webpack_require__("../ShareWebCore/src/extension/index.ts");
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/index.ts");
var player_1 = __webpack_require__("../ShareWebCore/src/player/index.ts");
var download_1 = __webpack_require__("../ShareWebCore/src/download/index.ts");
var errorcode_1 = __webpack_require__("../ShareWebCore/src/apis/openapi/errorcode.ts");
var helper_1 = __webpack_require__("../ShareWebComponents/src/Play/helper.ts");
var decorators_1 = __webpack_require__("../ShareWebUI/src/decorators.tsx");
var PlayBase = /** @class */ (function (_super) {
    __extends(PlayBase, _super);
    function PlayBase() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            active: false,
            status: undefined,
            fullScreen: false,
            queuepos: undefined,
            remainingTime: undefined,
            transpercent: undefined
        };
        _this.playType = extension_1.findType(docs_1.docname(_this.props.doc)) === 'VIDEO' ? helper_1.PlayType.VIDEO : helper_1.PlayType.AUDIO;
        return _this;
    }
    PlayBase.prototype.componentDidMount = function () {
        this.play();
    };
    /**
     * 更新播放信息
     */
    PlayBase.prototype.updatePlayInfo = function (definition) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, link, password, docid, rev, playInfo;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this.props.doc, link = _a.link, password = _a.password, docid = _a.docid, rev = _a.rev;
                        return [4 /*yield*/, player_1.getPlayInfo({ link: link, password: password, docid: docid, rev: rev, definition: definition })];
                    case 1:
                        playInfo = _b.sent();
                        this.setState({ playInfo: playInfo });
                        // 0表示处于转码队列中，尚未开始转码
                        if (playInfo.status === 0) {
                            this.setState({
                                status: helper_1.Status.UNCONVERT,
                                queuepos: playInfo.queuepos
                            });
                        }
                        // 1表示正在转码的文件
                        else if (playInfo.status === 1) {
                            this.setState({
                                status: helper_1.Status.CONVERTING,
                                remainingTime: playInfo.remainingtime,
                                transpercent: playInfo.transpercent
                            });
                        }
                        else if (playInfo.status === 2) {
                            this.setState({ status: helper_1.Status.PAUSE });
                        }
                        return [2 /*return*/, playInfo];
                }
            });
        });
    };
    /**
     * 轮询当前视频转码状态
     */
    PlayBase.prototype.rollPollStatus = function (definition) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, link, password, stop;
            var _this = this;
            return __generator(this, function (_b) {
                _a = this.props.doc, link = _a.link, password = _a.password;
                stop = timer_1.timer(function () { return __awaiter(_this, void 0, void 0, function () {
                    var _a, status, docid, odstat, sdstat, err_1;
                    return __generator(this, function (_b) {
                        switch (_b.label) {
                            case 0:
                                _b.trys.push([0, 2, , 3]);
                                return [4 /*yield*/, this.updatePlayInfo(definition)];
                            case 1:
                                _a = _b.sent(), status = _a.status, docid = _a.docid, odstat = _a.odstat, sdstat = _a.sdstat;
                                switch (status) {
                                    case 1:
                                        this.setState({ status: helper_1.Status.CONVERTING });
                                        break;
                                    case 2:
                                        stop();
                                        if (typeof this.props.onRequestPlay === 'function') {
                                            this.props.onRequestPlay();
                                        }
                                        else {
                                            this.setState({
                                                status: helper_1.Status.PLAYING,
                                                src: player_1.buildUrl(link ? 'link' : 'file', { docid: docid, link: link, password: password }),
                                                definition: definition ?
                                                    definition :
                                                    odstat ? helper_1.Definition.OD : helper_1.Definition.SD
                                            });
                                        }
                                        break;
                                }
                                return [3 /*break*/, 3];
                            case 2:
                                err_1 = _b.sent();
                                stop();
                                switch (err_1.errcode) {
                                    case 403047:
                                        this.setState({
                                            status: helper_1.Status.FAIL
                                        });
                                        break;
                                    case 403069:
                                        this.setState({
                                            status: helper_1.Status.LOW_DISK
                                        });
                                        break;
                                    // 无权限
                                    case 403002:
                                        this.setState({
                                            status: helper_1.Status.NO_PERMISSION
                                        });
                                        this.props.onError(err_1.errcode);
                                        break;
                                    // 外链关闭
                                    case errorcode_1.ErrorCode.LinkInaccessable:
                                    // 外链密码不正确
                                    case errorcode_1.ErrorCode.LinkAuthFailed:
                                        this.props.onError(err_1.errcode);
                                        break;
                                    case 403065:
                                        // 密级不足
                                        this.setState({
                                            status: helper_1.Status.CSFLevelMismatch
                                        });
                                        this.props.onError(err_1.errcode);
                                        break;
                                }
                                return [3 /*break*/, 3];
                            case 3: return [2 /*return*/];
                        }
                    });
                }); }, 5000);
                return [2 /*return*/];
            });
        });
    };
    /**
     * 播放视频
     */
    PlayBase.prototype.play = function (definition) {
        if (definition) {
            this.setState({
                definition: definition
            });
        }
        this.rollPollStatus(definition);
    };
    /**
     * 切换画质
     */
    PlayBase.prototype.switchDefinition = function (definition) {
        if (definition !== this.state.definition) {
            // this.refs.player.pause();
            this.play(definition);
        }
    };
    /**
     * IE8 获取下载
     */
    PlayBase.prototype.prepareDownload = function () {
        var _this = this;
        var doc = this.props.doc;
        download_1.getDownloadURL(lodash_1.pick(doc, ['link', 'password', 'docid', 'rev']))
            .then(function (url) {
            _this.setState({
                downloadUrl: url
            });
        });
    };
    /**
     * 下载按钮
     * @description 如果是IE8 则弹出提示框 点击确认按钮才开始下载
     */
    PlayBase.prototype.downloadTrigger = function () {
        var doc = this.props.doc;
        if (navigator.userAgent.match(/MSIE 8\.0/)) {
            this.prepareDownload();
        }
        else {
            download_1.download(lodash_1.pick(doc, ['link', 'password', 'docid', 'rev']));
        }
    };
    /**
     * 点击显示侧栏
     */
    PlayBase.prototype.toggleSidebar = function () {
        if (this.state.active) {
            this.setState({ active: false });
        }
        else {
            this.setState({ active: true });
        }
        return true;
    };
    /**
     * 全屏切换
     * @param fullScreen
     */
    PlayBase.prototype.handleFullScreenChange = function (fullScreen) {
        this.setState({
            fullScreen: fullScreen
        });
    };
    PlayBase.defaultProps = {
        type: helper_1.PlayType.VIDEO,
        onError: lodash_1.noop,
        onRequestPlay: undefined
    };
    PlayBase = __decorate([
        decorators_1.getContextWindow
    ], PlayBase);
    return PlayBase;
}(webcomponent_1["default"]));
exports["default"] = PlayBase;


/***/ }),

/***/ "../ShareWebComponents/src/Play/component.mobile.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var classnames = __webpack_require__("../node_modules/classnames/index.js");
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/index.ts");
var browser_1 = __webpack_require__("../ShareWebUtil/src/browser/index.ts");
var formatters_1 = __webpack_require__("../ShareWebUtil/src/formatters/index.ts");
var ui_mobile_1 = __webpack_require__("../ShareWebUI/src/HlsPlayer/ui.mobile.tsx");
var ui_mobile_2 = __webpack_require__("../ShareWebUI/src/Icon/ui.mobile.tsx");
var ui_desktop_1 = __webpack_require__("../ShareWebUI/src/ProgressBar/ui.desktop.tsx");
var component_mobile_1 = __webpack_require__("../ShareWebComponents/src/Viewer/component.mobile.tsx");
var ui_mobile_3 = __webpack_require__("../ShareWebUI/src/Player/ui.mobile.tsx");
var component_base_1 = __webpack_require__("../ShareWebComponents/src/Play/component.base.tsx");
var helper_1 = __webpack_require__("../ShareWebComponents/src/Play/helper.ts");
var locale_1 = __webpack_require__("../ShareWebComponents/src/Play/locale.ts");
var styles = __webpack_require__("../ShareWebComponents/src/Play/styles.mobile.css");
var loadImg = __webpack_require__("../ShareWebComponents/src/Play/assets/loading.gif");
var Play = /** @class */ (function (_super) {
    __extends(Play, _super);
    function Play() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Play.prototype.switchContent = function (type, status, queuepos, remainingTime, transpercent) {
        var _this = this;
        var _a, _b, _c;
        switch (true) {
            case type === helper_1.PlayType.VIDEO && status === helper_1.Status.UNCONVERT:
                return (React.createElement("div", { className: styles['wait-wrapper'] },
                    React.createElement(ui_mobile_2["default"], { url: loadImg, size: 48 }),
                    queuepos === 0
                        ?
                            React.createElement("div", { className: styles['tips'] }, locale_1["default"]('即将开始转码，请稍候...'))
                        :
                            React.createElement("div", { className: styles['tips'] }, locale_1["default"]('前面还有 ${queuepos} 个文件正在等待转码', { queuepos: queuepos }))));
            case type === helper_1.PlayType.VIDEO && status === helper_1.Status.CONVERTING:
                return (React.createElement("div", { className: styles['wait-wrapper'] },
                    React.createElement(ui_desktop_1["default"], { height: 8, containerBackground: '#353535', progressBackground: '#0383fe', border: '0', value: transpercent / 100, renderValue: lodash_1.noop }),
                    React.createElement("div", { className: styles['tips'] }, locale_1["default"]('视频正在转码，预计时间 ${time}', { time: formatters_1.secToHHmmss(remainingTime) }))));
            case type === helper_1.PlayType.AUDIO && status === helper_1.Status.CONVERTING:
                return (React.createElement("div", { className: styles.message }, locale_1["default"]('音频正在转码，请稍候...')));
            case status === helper_1.Status.LOW_DISK:
                return (React.createElement("div", { className: styles.message }, locale_1["default"]('转码失败，服务器缓存空间不足')));
            case status === helper_1.Status.FAIL:
                return (React.createElement("div", { className: styles.message },
                    React.createElement("p", { className: styles.paragraph }, locale_1["default"]('文件转码失败')),
                    this.props.link && this.props.perm & 2 === 2 ?
                        React.createElement("p", { className: styles.paragraph },
                            React.createElement("span", null, locale_1["default"]('您可以：')),
                            React.createElement("a", { className: styles.link, href: "javascript:void(0)", onClick: this.downloadTrigger.bind(this, null) }, locale_1["default"]('下载文件')))
                        :
                            ''));
            case status === helper_1.Status.NO_PERMISSION:
                return (React.createElement("div", { className: classnames(styles.message, styles['tip-message']) }, locale_1["default"]('您对文件“${filename}”没有预览权限', { filename: docs_1.docname(this.props.doc) })));
            case status === helper_1.Status.CSFLevelMismatch:
                return (React.createElement("div", { className: classnames(styles.message, styles['tip-message']) }, locale_1["default"]('您对文件“${filename}”的密级权限不足', { filename: docs_1.docname(this.props.doc) })));
            case type === helper_1.PlayType.AUDIO && status === helper_1.Status.PAUSE:
                return (React.createElement("div", { className: "wave", "ng-className": "'playing': playStatus === PLAY_STATUS.PLAYING, 'pause': playStatus === PLAY_STATUS.PAUSE || playStatus === PLAY_STATUS.STOP}" }));
            case status === helper_1.Status.PLAYING:
                return (React.createElement("div", { className: styles.video },
                    React.createElement("div", { className: styles.player, onTouchEnd: this.toggleSidebar.bind(this), onClick: this.toggleSidebar.bind(this) }, browser_1.isBrowser({ os: browser_1.OSType.IOS }) ?
                        (React.createElement(ui_mobile_3["default"], { ref: "player", src: this.state.src, width: "100%", height: "100%" })) : (React.createElement(ui_mobile_1["default"], { ref: "player", src: this.state.src, type: this.playType, autoPlay: false, controls: true, width: '100%', height: '100%' }))),
                    React.createElement("div", { className: classnames(styles.sidebar, (_a = {}, _a[styles['sidebar-active']] = this.state.active, _a)) },
                        React.createElement("ul", { className: styles.sidebarTools },
                            this.state.playInfo && this.state.playInfo.sdstat ?
                                React.createElement("li", { className: styles.sidebarTool },
                                    React.createElement("a", { href: "javascript:void(0)", className: classnames(styles.sidebarButton, (_b = {}, _b[styles.activeDefinition] = this.state.definition === helper_1.Definition.SD, _b)), onClick: function () { _this.switchDefinition(helper_1.Definition.SD); } }, locale_1["default"]('流畅')))
                                :
                                    null,
                            this.state.playInfo && this.state.playInfo.odstat ?
                                React.createElement("li", { className: styles.sidebarTool },
                                    React.createElement("a", { href: "javascript:void(0)", className: classnames(styles.sidebarButton, (_c = {}, _c[styles.activeDefinition] = this.state.definition === helper_1.Definition.OD, _c)), onClick: function () { _this.switchDefinition(helper_1.Definition.OD); } }, locale_1["default"]('原画质')))
                                :
                                    null))));
        }
    };
    Play.prototype.render = function () {
        var _a = this.state, queuepos = _a.queuepos, remainingTime = _a.remainingTime, transpercent = _a.transpercent;
        return (React.createElement(component_mobile_1["default"], { onRequestBack: this.props.onRequestBack, doc: this.props.doc, link: this.props.link, style: { background: '#000', backgroundImage: 'none' } },
            React.createElement("div", { className: styles.container },
                React.createElement("div", { className: styles.main },
                    React.createElement("div", { className: styles.mainPadding }, this.switchContent(this.playType, this.state.status, queuepos, remainingTime, transpercent))))));
    };
    return Play;
}(component_base_1["default"]));
exports["default"] = Play;


/***/ }),

/***/ "../ShareWebComponents/src/Play/helper.ts":
/***/ (function(module, exports) {

exports.__esModule = true;
/**
 * 播放状态
 */
var Status;
(function (Status) {
    // 正在转码
    Status[Status["CONVERTING"] = 0] = "CONVERTING";
    // 暂停
    Status[Status["PAUSE"] = 1] = "PAUSE";
    // 播放中
    Status[Status["PLAYING"] = 2] = "PLAYING";
    // 播放失败
    Status[Status["FAIL"] = 3] = "FAIL";
    // 空间不足
    Status[Status["LOW_DISK"] = 4] = "LOW_DISK";
    /**
     * 没有权限
     */
    Status[Status["NO_PERMISSION"] = 5] = "NO_PERMISSION";
    // 未开始转码
    Status[Status["UNCONVERT"] = 6] = "UNCONVERT";
    // 密级不足
    Status[Status["CSFLevelMismatch"] = 7] = "CSFLevelMismatch";
})(Status = exports.Status || (exports.Status = {}));
/**
 * 播放类型
 */
var PlayType;
(function (PlayType) {
    // 视频
    PlayType["VIDEO"] = "video";
    // 音频
    PlayType["AUDIO"] = "audio";
})(PlayType = exports.PlayType || (exports.PlayType = {}));
/**
 * 清晰度
 */
exports.Definition = {
    // 原始画质
    OD: 'od',
    // 标清画质
    SD: 'sd'
};


/***/ }),

/***/ "../ShareWebComponents/src/Play/locale.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var i18n_1 = __webpack_require__("../ShareWebComponents/src/i18n.ts");
exports["default"] = i18n_1["default"]([
    [
        '原画质',
        '原畫質',
        'Raw',
    ],
    [
        '流畅',
        '流暢',
        'Fluent',
    ],
    [
        '下载 ${size}',
        '下載 ${size}',
        'Download ${size}',
    ],
    [
        '立即下载',
        '立即下載',
        'Download Immediately',
    ],
    [
        '关闭窗口',
        '關閉窗口',
        'Close',
    ],
    [
        '下载',
        '下載',
        'Download',
    ],
    [
        '视频正在转码，请稍等...',
        '視訊正在轉碼，請稍等...',
        'Video is transcoding, please wait...',
    ],
    [
        '音频正在转码，请稍候...',
        '音訊正在轉碼，請稍候...',
        'Audio is transcoding, please wait...',
    ],
    [
        'MSG_FILE_UNSUPPORT',
        'Audio is transcoding, please wait...',
    ],
    [
        '当前文件无法播放',
        '當前檔案無法播放',
        'This file cannot be played',
    ],
    [
        '您可以：',
        '您可以：',
        'You can: ',
    ],
    [
        '下载文件',
        '下載檔案',
        'download the file',
    ],
    [
        '提示',
        '提示',
        'Tip',
    ],
    [
        '无法执行下载操作',
        '無法執行下載操作',
        'Download failed',
    ],
    [
        '您对文件“${filename}”没有复制权限, 不允许将数据从云盘下载到本地磁盘.',
        '您對檔案“${filename}”沒有複製權限, 不允許將資料從雲盤下載到本地磁碟.',
        'You are not authorized to copy the file "${filename}", and it cannot be downloaded to local disk.',
    ],
    [
        '跳过之后的所有冲突提示',
        '跳過之後的所有衝突提示',
        'Do this for the next conflicts',
    ],
    [
        '文件“${filename}”不存在, 可能其所在路径发生变更。',
        '檔案“${filename}”不存在, 可能其所在路徑發生變更。',
        'File "${filename}" does not exist in this location.',
    ],
    [
        '转码失败，服务器缓存空间不足',
        '轉碼失敗，伺服器快取空間不足',
        'Transcoding failed, there is not enough cache space in server.',
    ],
    [
        '文件“${filename}”过大，无法同步，您所在的网络存在限制。',
        '檔案“${filename}”過大，無法同步，您所在的網路存在限制。',
        'File "${filename}" is too large and cannot be synced, your network is limited.',
    ],
    [
        '文件转码失败',
        '檔案轉碼失敗',
        'Transcoding failed',
    ],
    [
        '无法预览该文件,您的访问权限不足',
        '無法預覽該檔案，您的存取權限不足',
        'Preview failed, insufficient permission',
    ],
    [
        '您对文件“${filename}”没有预览权限',
        '您對檔案“${filename}”沒有預覽權限',
        'You are not authorized to preview the file "${filename}"',
    ],
    [
        '即将开始转码，请稍候...',
        '即將開始轉碼，請稍候...',
        'Ready to start transcoding, please wait...',
    ],
    [
        '前面还有 ${queuepos} 个文件正在等待转码',
        '前面還有 ${queuepos} 個檔案正在等待轉碼',
        'Currently there are ${queuepos} file(s) waiting for transcoding',
    ],
    [
        '视频正在转码，预计时间 ${time}',
        '視頻正在轉碼，預計時間 ${time}',
        'Video is transcoding, estimated time: ${time}',
    ],
    [
        '即将开始转码，请稍候...',
        '即將開始轉碼，請稍候...',
        'Ready to start transcoding, please wait...',
    ],
    [
        '前面还有 ${queuepos} 个文件正在等待转码，请稍候...',
        '前面還有 ${queuepos} 個檔案正在等待轉碼，請稍候...',
        'Currently there are ${queuepos} file(s) waiting for transcoding, please wait...'
    ],
    [
        '视频正在转码，请稍候...（剩余时间 ${time}）',
        '視頻正在轉碼，請稍候...（剩餘時間 ${time}）',
        'Video is transcoding, please wait... (Remaining time: ${time})'
    ],
    [
        '您对文件“${filename}”的密级权限不足',
        '您對檔案“${filename}”的密級權限不足',
        'Your security level is lower than file "${filename}"'
    ],
]);


/***/ }),

/***/ "../ShareWebComponents/src/Play/styles.mobile.css":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin
module.exports = {"container":"_-ShareWebComponents-src-Play-styles-mobile---container","main":"_-ShareWebComponents-src-Play-styles-mobile---main","mainPadding":"_-ShareWebComponents-src-Play-styles-mobile---mainPadding","video":"_-ShareWebComponents-src-Play-styles-mobile---video","player":"_-ShareWebComponents-src-Play-styles-mobile---player","sidebar":"_-ShareWebComponents-src-Play-styles-mobile---sidebar","sidebarTools":"_-ShareWebComponents-src-Play-styles-mobile---sidebarTools","sidebarButton":"_-ShareWebComponents-src-Play-styles-mobile---sidebarButton","activeDefinition":"_-ShareWebComponents-src-Play-styles-mobile---activeDefinition","sidebar-active":"_-ShareWebComponents-src-Play-styles-mobile---sidebar-active","message":"_-ShareWebComponents-src-Play-styles-mobile---message","paragraph":"_-ShareWebComponents-src-Play-styles-mobile---paragraph","link":"_-ShareWebComponents-src-Play-styles-mobile---link","tip-message":"_-ShareWebComponents-src-Play-styles-mobile---tip-message","wait-wrapper":"_-ShareWebComponents-src-Play-styles-mobile---wait-wrapper","tips":"_-ShareWebComponents-src-Play-styles-mobile---tips"};

/***/ }),

/***/ "../ShareWebComponents/src/Preview/component.base.tsx":
/***/ (function(module, exports, __webpack_require__) {

/// <reference path="./component.base.d.ts" />
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
exports.__esModule = true;
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var preview_1 = __webpack_require__("../ShareWebCore/src/preview/index.ts");
var extension_1 = __webpack_require__("../ShareWebCore/src/extension/index.ts");
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/index.ts");
var watermark_1 = __webpack_require__("../ShareWebCore/src/watermark/index.ts");
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/index.ts");
var browser_1 = __webpack_require__("../ShareWebUtil/src/browser/index.ts");
var permission_1 = __webpack_require__("../ShareWebCore/src/permission/index.ts");
var download_1 = __webpack_require__("../ShareWebCore/src/download/index.ts");
var errorcode_1 = __webpack_require__("../ShareWebCore/src/apis/openapi/errorcode.ts");
var config_1 = __webpack_require__("../ShareWebCore/src/config/index.ts");
var webcomponent_1 = __webpack_require__("../ShareWebComponents/src/webcomponent.tsx");
var helper_1 = __webpack_require__("../ShareWebComponents/src/Preview/helper.ts");
var PreviewBase = /** @class */ (function (_super) {
    __extends(PreviewBase, _super);
    function PreviewBase(props, context) {
        var _this = _super.call(this, props, context) || this;
        _this.state = {
            pdf: null,
            width: 0,
            watermark: lodash_1.noop,
            downloadEnabled: false,
            password: '',
            status: helper_1.Status.PENDING,
            showPasswordError: false
        };
        _this.tryPasswordCount = 0;
        _this.orientationChangeHandler = function () {
            setTimeout(function () {
                _this.setState({
                    width: window.innerWidth
                });
            }, 100);
        };
        _this.fetchPDF = _this.fetchPDF.bind(_this);
        return _this;
    }
    PreviewBase.prototype.componentDidMount = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, link, doc, name, _b;
            var _this = this;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _a = this.props, link = _a.link, doc = _a.doc;
                        name = link ? (link.size === -1 ? docs_1.docname(doc) : link.name) : docs_1.docname(doc);
                        _b = extension_1.findType(name) === 'CAD';
                        if (!_b) return [3 /*break*/, 2];
                        return [4 /*yield*/, docs_1.canCADPreview()];
                    case 1:
                        _b = (_c.sent());
                        _c.label = 2;
                    case 2:
                        // cad预览
                        if (_b) {
                            if (this.props.illegalContentQuarantine) {
                                // 隔离区预览，不支持CAD预览
                                this.setState({
                                    status: helper_1.Status.INVALID_FORMAT
                                });
                            }
                            else {
                                // 非隔离区的CAD预览
                                this.previewCAD(link, doc);
                                this.checkEnableDownload();
                            }
                        }
                        else {
                            this.checkCapable();
                            this.checkEnableDownload();
                            watermark_1.watermarkFactory(__assign({}, (link || {}), (doc || {}))).then(function (watermark) {
                                _this.setState({
                                    watermark: watermark,
                                    width: window.innerWidth
                                });
                            });
                            this.checkSupport(link ? (link.size === -1 ? docs_1.docname(doc) : link.name) : docs_1.docname(doc)).then(function () {
                                if (_this.state.status !== helper_1.Status.BROWSER_INCOMPATIABLE && _this.state.status !== helper_1.Status.INVALID_FORMAT) {
                                    _this.fetchPDF();
                                }
                            });
                        }
                        window.addEventListener('orientationchange', this.orientationChangeHandler);
                        return [2 /*return*/];
                }
            });
        });
    };
    PreviewBase.prototype.componentWillUnmount = function () {
        window.removeEventListener('orientationchange', this.orientationChangeHandler);
    };
    /**
     * cad
     */
    PreviewBase.prototype.previewCAD = function (link, doc) {
        return __awaiter(this, void 0, void 0, function () {
            var cadTool, capable, name;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, config_1.getOEMConfig('cadtool')];
                    case 1:
                        cadTool = _a.sent();
                        switch (cadTool) {
                            case 'mx':
                                capable = this.checkCapable();
                                if (capable) {
                                    name = link ? (link.size === -1 ? docs_1.docname(doc) : link.name) : docs_1.docname(doc);
                                    if (extension_1.serializeName(name.toLowerCase()) === '.dwg') {
                                        // .dwg文件
                                        watermark_1.watermarkFactory(__assign({}, (link || {}), (doc || {}))).then(function (watermark) {
                                            _this.setState({
                                                watermark: watermark,
                                                width: window.innerWidth
                                            });
                                        });
                                        this.fetchPDF();
                                    }
                                    else {
                                        // .dwt dxf文件，不支持预览的格式
                                        this.setState({
                                            status: helper_1.Status.INVALID_FORMAT
                                        });
                                    }
                                }
                                break;
                            case 'hc':
                            default:
                                // 浩辰CAD，使用CADPreview组件预览
                                this.setState({
                                    status: helper_1.Status.CADPreview
                                });
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * 下载权限
     * @param downloadEnabled
     */
    PreviewBase.prototype.checkEnableDownload = function () {
        var _this = this;
        var _a = this.props, doc = _a.doc, link = _a.link;
        var userid = openapi_1.getOpenAPIConfig('userid');
        if (browser_1.userAgent().os === browser_1.OSType.IOS && browser_1.userAgent().app !== browser_1.Browser.WeChat) {
            this.setState({
                downloadEnabled: false
            });
        }
        else {
            (link && link.link ? permission_1.checkLinkPerm(lodash_1.assign(link, { perm: permission_1.LinkSharePermission.DOWNLOAD })) : permission_1.checkPermItem(doc.docid, permission_1.SharePermission.COPY, userid)).then(function (downloadEnabled) {
                _this.setState({
                    downloadEnabled: downloadEnabled
                });
            });
        }
    };
    /**
     * 开始下载
     */
    PreviewBase.prototype.handleDownload = function () {
        var _a = this.props, _b = _a.doc, doc = _b === void 0 ? {} : _b, _c = _a.link, link = _c === void 0 ? {} : _c;
        download_1.download(__assign({}, link, doc));
    };
    /**
     * 检查浏览器是否支持预览
     * @returns true--支持预览；false--不支持预览
     */
    PreviewBase.prototype.checkCapable = function () {
        if (navigator.userAgent.indexOf('MSIE 8.0') !== -1) {
            this.setState({ status: helper_1.Status.BROWSER_INCOMPATIABLE });
            this.props.onIncompatiable();
            return false;
        }
        return true;
    };
    /**
     * 检查文件格式是否支持
     */
    PreviewBase.prototype.checkSupport = function (name) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, cadpreview, sursenpreview;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, Promise.all([
                            docs_1.canCADPreview(),
                            docs_1.canSursenPreview()
                        ])];
                    case 1:
                        _a = __read.apply(void 0, [_b.sent(), 2]), cadpreview = _a[0], sursenpreview = _a[1];
                        if (!((lodash_1.indexOf(['WORD', 'EXCEL', 'PPT', 'PDF', 'TXT'], extension_1.findType(name)) !== -1) || (extension_1.findType(name) === 'CAD' && cadpreview) || (extension_1.findType(name) === 'SEP' && sursenpreview))) {
                            this.setState({
                                status: helper_1.Status.INVALID_FORMAT
                            });
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * 获取PDF
     */
    PreviewBase.prototype.fetchPDF = function () {
        var _this = this;
        var self = this;
        var _a = this.props, link = _a.link, doc = _a.doc, illegalContentQuarantine = _a.illegalContentQuarantine;
        this.setState({
            status: helper_1.Status.FETCHING
        });
        preview_1.previewOSS(lodash_1.assign({ illegalContentQuarantine: illegalContentQuarantine }, lodash_1.pick(link, ['link', 'password']), lodash_1.pick(doc, ['docid', 'rev']))).then(function (_a) {
            var url = _a.url;
            PDFJS.getDocument(url, null, function (updatePassword, reason) {
                _this.setState({
                    status: helper_1.Status.PASSWORD_REQUIRED,
                    showPasswordError: _this.tryPasswordCount > 0
                });
                _this.tryPassword = function (password) {
                    this.tryPasswordCount++;
                    updatePassword(password);
                    this.setState({ status: helper_1.Status.OK });
                };
            }).then(function (pdf) {
                _this.tryPasswordCount = 0;
                _this.setState({
                    showPasswordError: false,
                    pdf: pdf,
                    status: helper_1.Status.OK
                });
            }, function (_a) {
                var status = _a.status;
                _this.tryPasswordCount = 0;
                _this.setState({
                    showPasswordError: false,
                    status: helper_1.Status.FAILED
                });
                if (status === 0) {
                    var onNetworkError = openapi_1.getOpenAPIConfig('onNetworkError');
                    if (lodash_1.isFunction(onNetworkError)) {
                        onNetworkError();
                    }
                }
            });
        }, function (_a) {
            var errcode = _a.errcode;
            switch (errcode) {
                case 503002:
                    setTimeout(self.fetchPDF, 2000);
                    break;
                case 403026:
                    self.setState({
                        status: helper_1.Status.INVALID_FORMAT
                    });
                    break;
                case 403002:
                    self.setState({
                        status: helper_1.Status.NO_PERMISSION
                    });
                    break;
                case 403170:
                    self.setState({
                        status: helper_1.Status.WATERMARKING_FAILED
                    });
                    break;
                case 503005:
                    self.setState({
                        status: helper_1.Status.MAKING_WATERMARK
                    });
                    break;
                case 404006:
                    self.setState({
                        status: helper_1.Status.GNS_NOT_EXIST
                    });
                    break;
                //403065 密级不足
                case errorcode_1.ErrorCode.CSFLevelMismatch:
                    self.setState({ status: helper_1.Status.SECURITY_LOWER });
                    break;
                // 外链密码不正确
                case errorcode_1.ErrorCode.LinkAuthFailed:
                // 外链关闭
                case errorcode_1.ErrorCode.LinkInaccessable:
                    self.props.onError(errcode);
                    break;
                default:
                    self.setState({
                        status: errcode
                    });
                    break;
            }
        });
    };
    /**
     * 更新文档密码
     */
    PreviewBase.prototype.updatePassword = function (password) {
        this.setState({
            showPasswordError: false,
            password: password
        });
    };
    /**
     * 尝试密码
     */
    PreviewBase.prototype.tryPassword = function (password) {
    };
    PreviewBase.defaultProps = {
        // 检查登录
        onCheckLogin: lodash_1.noop,
        // 登录成功
        onLoginSuccess: lodash_1.noop,
        // 查看
        onRedirect: lodash_1.noop,
        // ie8时
        onIncompatiable: lodash_1.noop,
        illegalContentQuarantine: false,
        skipPermissionCheck: false,
        onError: lodash_1.noop
    };
    return PreviewBase;
}(webcomponent_1["default"]));
exports["default"] = PreviewBase;


/***/ }),

/***/ "../ShareWebComponents/src/Preview/component.mobile.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var classnames = __webpack_require__("../node_modules/classnames/index.js");
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/index.ts");
var errcode_1 = __webpack_require__("../ShareWebCore/src/errcode/index.ts");
var ui_mobile_1 = __webpack_require__("../ShareWebUI/src/TextBox/ui.mobile.tsx");
var ui_mobile_2 = __webpack_require__("../ShareWebUI/src/Button/ui.mobile.tsx");
var ui_mobile_3 = __webpack_require__("../ShareWebUI/src/PDF2/ui.mobile.tsx");
var ui_mobile_4 = __webpack_require__("../ShareWebUI/src/Dialog/ui.mobile.tsx");
var ui_desktop_1 = __webpack_require__("../ShareWebUI/src/Form/ui.desktop.tsx");
var ui_desktop_2 = __webpack_require__("../ShareWebUI/src/FlexBox/ui.desktop.tsx");
var ui_desktop_3 = __webpack_require__("../ShareWebUI/src/UIIcon/ui.desktop.tsx");
var component_mobile_1 = __webpack_require__("../ShareWebComponents/src/Viewer/component.mobile.tsx");
var component_base_1 = __webpack_require__("../ShareWebComponents/src/Preview/component.base.tsx");
var helper_1 = __webpack_require__("../ShareWebComponents/src/Preview/helper.ts");
var locale_1 = __webpack_require__("../ShareWebComponents/src/Preview/locale.ts");
var styles = __webpack_require__("../ShareWebComponents/src/Preview/styles.mobile.css");
var Preview = /** @class */ (function (_super) {
    __extends(Preview, _super);
    function Preview() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Preview.prototype.switchContent = function () {
        switch (this.state.status) {
            case helper_1.Status.PENDING:
                return null;
            case helper_1.Status.BROWSER_INCOMPATIABLE:
                return (React.createElement("div", { className: styles.flex },
                    React.createElement("div", { className: styles.message }, locale_1["default"]('不支持IE8及其更早版本的浏览器'))));
            case helper_1.Status.FETCHING:
                return (React.createElement("div", { className: styles.flex },
                    React.createElement("div", { className: styles.message }, locale_1["default"]('正在加载...'))));
            case helper_1.Status.CADPreview:
            case helper_1.Status.INVALID_FORMAT:
                return (React.createElement(ui_desktop_2["default"], null,
                    React.createElement(ui_desktop_2["default"].Item, { align: "middle center" },
                        React.createElement("div", { className: styles.waring },
                            React.createElement(ui_desktop_3["default"], { size: '60px', code: '\uf021', color: "#bdbdbd" })),
                        React.createElement("div", { className: styles.message }, locale_1["default"]('当前格式不支持预览或文件内容已加密')),
                        this.state.downloadEnabled ? React.createElement("div", null,
                            locale_1["default"]('您可以选择'),
                            "\u00A0",
                            React.createElement("a", { href: "javascript:;", className: styles['download-link'], onClick: this.handleDownload.bind(this) }, locale_1["default"]('下载查看'))) : null)));
            case helper_1.Status.FAILED:
                return (React.createElement("div", { className: styles.flex },
                    React.createElement("div", { className: styles.message }, locale_1["default"]('加载失败'))));
            case helper_1.Status.NO_PERMISSION:
                return (React.createElement("div", { className: styles.flex },
                    React.createElement("div", { className: classnames(styles.message, styles['tip-message']) }, locale_1["default"]('您对文件“${filename}”没有预览权限', { filename: docs_1.docname(this.props.doc) }))));
            case helper_1.Status.WATERMARKING_FAILED:
                return (React.createElement("div", { className: styles.flex },
                    React.createElement("div", { className: styles.message }, locale_1["default"]('无法预览文件“${filename}”，水印制作失败', { filename: docs_1.docname(this.props.doc) }))));
            case helper_1.Status.SECURITY_LOWER:
                return (React.createElement("div", { className: styles.flex },
                    React.createElement("div", { className: styles.message }, locale_1["default"]('无法预览该文件，您的密级不足'))));
            case helper_1.Status.MAKING_WATERMARK:
                return (React.createElement("div", { className: styles.flex },
                    React.createElement("div", { className: styles.message }, errcode_1.getErrorMessage(helper_1.Status.MAKING_WATERMARK))));
            case helper_1.Status.LINK_PWD_ERROR:
                return (React.createElement("div", { className: styles.flex },
                    React.createElement("div", { className: styles.message }, errcode_1.getErrorMessage(helper_1.Status.LINK_PWD_ERROR))));
            case helper_1.Status.PASSWORD_REQUIRED:
                return this.queryPassword();
            case helper_1.Status.OK:
                return (React.createElement(ui_mobile_3["default"], { pdf: this.state.pdf, width: this.state.width, watermark: this.state.watermark }));
        }
    };
    Preview.prototype.queryPassword = function () {
        var _this = this;
        return (React.createElement(ui_mobile_4["default"], null,
            React.createElement(ui_mobile_4["default"].Header, null, locale_1["default"]('密码')),
            React.createElement(ui_mobile_4["default"].Main, null,
                React.createElement(ui_desktop_1["default"], { onSubmit: function () { return _this.tryPassword(_this.state.password); } },
                    React.createElement(ui_desktop_1["default"].Row, null,
                        React.createElement(ui_desktop_1["default"].Label, null,
                            React.createElement("label", { htmlFor: "password" }, locale_1["default"]('打开密码：'))),
                        React.createElement(ui_desktop_1["default"].Field, null,
                            React.createElement(ui_mobile_1["default"], { type: "password", id: "password", onChange: this.updatePassword.bind(this) }))))),
            React.createElement(ui_mobile_4["default"].Footer, null,
                React.createElement(ui_mobile_2["default"], { onClick: function () { return _this.tryPassword(_this.state.password); } }, locale_1["default"]('确定')))));
    };
    Preview.prototype.render = function () {
        return (React.createElement(component_mobile_1["default"], { onRequestBack: this.props.onRequestBack, doc: this.props.doc, link: this.props.link }, this.switchContent()));
    };
    return Preview;
}(component_base_1["default"]));
exports["default"] = Preview;


/***/ }),

/***/ "../ShareWebComponents/src/Preview/helper.ts":
/***/ (function(module, exports) {

exports.__esModule = true;
/**
 * 文档状态
 */
var Status;
(function (Status) {
    // 默认状态
    Status[Status["PENDING"] = 0] = "PENDING";
    // 正在获取
    Status[Status["FETCHING"] = 1] = "FETCHING";
    // 获取成功
    Status[Status["OK"] = 2] = "OK";
    // 浏览器不支持
    Status[Status["BROWSER_INCOMPATIABLE"] = 3] = "BROWSER_INCOMPATIABLE";
    // 需要密码
    Status[Status["PASSWORD_REQUIRED"] = 4] = "PASSWORD_REQUIRED";
    // 格式错误
    Status[Status["INVALID_FORMAT"] = 5] = "INVALID_FORMAT";
    // 预览失败
    Status[Status["FAILED"] = 6] = "FAILED";
    // 没有预览权限
    Status[Status["NO_PERMISSION"] = 403002] = "NO_PERMISSION";
    // 外链密码不正确
    Status[Status["LINK_PWD_ERROR"] = 401002] = "LINK_PWD_ERROR";
    // 添加水印失败
    Status[Status["WATERMARKING_FAILED"] = 403170] = "WATERMARKING_FAILED";
    // 正在制作水印
    Status[Status["MAKING_WATERMARK"] = 503005] = "MAKING_WATERMARK";
    // 密级不足
    Status[Status["SECURITY_LOWER"] = 403065] = "SECURITY_LOWER";
    // 文件不存在
    Status[Status["GNS_NOT_EXIST"] = 404006] = "GNS_NOT_EXIST";
    // CAD预览
    Status[Status["CADPreview"] = 404007] = "CADPreview";
})(Status = exports.Status || (exports.Status = {}));


/***/ }),

/***/ "../ShareWebComponents/src/Preview/locale.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var i18n_1 = __webpack_require__("../ShareWebComponents/src/i18n.ts");
exports["default"] = i18n_1["default"]([
    [
        '密码',
        '密碼',
        'Password'
    ],
    [
        '打开密码：',
        '打開密碼：',
        'Password: '
    ],
    [
        '正在加载...',
        '正在載入...',
        'Loading...'
    ],
    [
        '不支持IE8及其更早版本的浏览器',
        '不支援IE8及其更早版本的瀏覽器',
        'IE8 or earlier version are not supported to preview'
    ],
    [
        '不支持当前格式的文件预览',
        '不支援當前的檔案格式預覽',
        'File of this type is unsupported for previewing'
    ],
    [
        '加载失败',
        '載入失敗',
        'Load failed'
    ],
    [
        '确定',
        '確定',
        'OK'
    ],
    [
        '您可以选择',
        '您可以選取',
        'You can download and view the file.'
    ],
    [
        '下载查看',
        '下載檢視',
        'Download'
    ],
    [
        '无法预览文件“${filename}”，水印制作失败',
        '無法預覽檔案“${filename}”，浮水印製作失敗',
        'Failed to preview file “${filename}”, watermarking failed. '
    ],
    [
        '文件或文件夹“${filename}”不存在, 可能其所在路径发生变更。',
        '檔案或資料夾“${filename}”不存在, 可能其所在路徑發生變更。',
        'File "${filename}" does not exist in this location.'
    ],
    [
        '当前格式不支持预览或文件内容已加密',
        '當前格式不支持預覽或檔案內容已加密',
        'The current format does not support preview or file content  encrypted'
    ],
    [
        '无法预览该文件,您的访问权限不足',
        '無法預覽該檔案，您的存取權限不足',
        'Preview failed, insufficient permission'
    ],
    [
        '您对文件“${filename}”没有预览权限',
        '您對檔案“${filename}”沒有預覽權限',
        'You are not authorized to preview the file "${filename}"'
    ],
    [
        '无法预览该文件，您的密级不足',
        '無法預覽該檔案，您的密級不足',
        'Preview failed, your security level is lower than that of files.'
    ]
]);


/***/ }),

/***/ "../ShareWebComponents/src/Preview/styles.mobile.css":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin
module.exports = {"flex":"_-ShareWebComponents-src-Preview-styles-mobile---flex","message":"_-ShareWebComponents-src-Preview-styles-mobile---message","tip-message":"_-ShareWebComponents-src-Preview-styles-mobile---tip-message","download-link":"_-ShareWebComponents-src-Preview-styles-mobile---download-link","waring":"_-ShareWebComponents-src-Preview-styles-mobile---waring"};

/***/ }),

/***/ "../ShareWebComponents/src/SSO/component.base.tsx":
/***/ (function(module, exports, __webpack_require__) {

///<reference path="./component.base.d.ts" />
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
exports.__esModule = true;
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var webcomponent_1 = __webpack_require__("../ShareWebComponents/src/webcomponent.tsx");
var auth_1 = __webpack_require__("../ShareWebCore/src/auth/index.ts");
// 单点登录状态
var Status;
(function (Status) {
    Status[Status["PENDING"] = 0] = "PENDING";
    Status[Status["OK"] = 1] = "OK"; // 鉴权正确
})(Status = exports.Status || (exports.Status = {}));
var SSOBase = /** @class */ (function (_super) {
    __extends(SSOBase, _super);
    function SSOBase() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            status: Status.PENDING
        };
        return _this;
    }
    SSOBase.prototype.componentWillMount = function () {
        var _this = this;
        if (!lodash_1.keys(this.props.params).length) {
            auth_1.redirect();
        }
        else {
            auth_1.loginByParams(lodash_1.reduce(this.props.params, function (result, value, key) {
                var _a;
                if (key !== 'asplatform') {
                    return __assign({}, result, (_a = {}, _a[key] = value, _a));
                }
                else {
                    return result;
                }
            }, {}), this.props.ostype).then(function (res) {
                _this.setState({ status: Status.OK });
                _this.props.onAuthSuccess(res);
            }, function (error) {
                _this.setState({ status: error });
            });
        }
    };
    SSOBase.defaultProps = {
        onAuthSuccess: lodash_1.noop,
        ostype: auth_1.OS_TYPE.WEB
    };
    return SSOBase;
}(webcomponent_1["default"]));
exports["default"] = SSOBase;


/***/ }),

/***/ "../ShareWebComponents/src/SSO/component.mobile.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var component_base_1 = __webpack_require__("../ShareWebComponents/src/SSO/component.base.tsx");
var component_mobile_1 = __webpack_require__("../ShareWebComponents/src/ErrorOverlay/component.mobile.tsx");
var SSO = /** @class */ (function (_super) {
    __extends(SSO, _super);
    function SSO() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SSO.prototype.render = function () {
        return this.state.status === component_base_1.Status.PENDING || this.state.status === component_base_1.Status.OK ?
            React.createElement("div", null) :
            React.createElement(component_mobile_1["default"], { error: this.state.status });
    };
    return SSO;
}(component_base_1["default"]));
exports["default"] = SSO;


/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images recursive ^\\.\\/.*\\.png$":
/***/ (function(module, exports, __webpack_require__) {

var map = {
	"./ARCHIVE.png": "../ShareWebComponents/src/Thumbnail/assets/images/ARCHIVE.png",
	"./ARCHIVEDOC.png": "../ShareWebComponents/src/Thumbnail/assets/images/ARCHIVEDOC.png",
	"./AUDIO.png": "../ShareWebComponents/src/Thumbnail/assets/images/AUDIO.png",
	"./CAD.png": "../ShareWebComponents/src/Thumbnail/assets/images/CAD.png",
	"./CUSTOMDOC.png": "../ShareWebComponents/src/Thumbnail/assets/images/CUSTOMDOC.png",
	"./DIR.png": "../ShareWebComponents/src/Thumbnail/assets/images/DIR.png",
	"./EXCEL.png": "../ShareWebComponents/src/Thumbnail/assets/images/EXCEL.png",
	"./EXE.png": "../ShareWebComponents/src/Thumbnail/assets/images/EXE.png",
	"./GROUPDOC.png": "../ShareWebComponents/src/Thumbnail/assets/images/GROUPDOC.png",
	"./HTML.png": "../ShareWebComponents/src/Thumbnail/assets/images/HTML.png",
	"./IMG.png": "../ShareWebComponents/src/Thumbnail/assets/images/IMG.png",
	"./LOGO.png": "../ShareWebComponents/src/Thumbnail/assets/images/LOGO.png",
	"./NAS.png": "../ShareWebComponents/src/Thumbnail/assets/images/NAS.png",
	"./PDF.png": "../ShareWebComponents/src/Thumbnail/assets/images/PDF.png",
	"./PPT.png": "../ShareWebComponents/src/Thumbnail/assets/images/PPT.png",
	"./PSD.png": "../ShareWebComponents/src/Thumbnail/assets/images/PSD.png",
	"./SHAREDOC.png": "../ShareWebComponents/src/Thumbnail/assets/images/SHAREDOC.png",
	"./TXT.png": "../ShareWebComponents/src/Thumbnail/assets/images/TXT.png",
	"./UNKNOWN.png": "../ShareWebComponents/src/Thumbnail/assets/images/UNKNOWN.png",
	"./UNSYNCDOC.png": "../ShareWebComponents/src/Thumbnail/assets/images/UNSYNCDOC.png",
	"./USERDOC.png": "../ShareWebComponents/src/Thumbnail/assets/images/USERDOC.png",
	"./VIDEO.png": "../ShareWebComponents/src/Thumbnail/assets/images/VIDEO.png",
	"./VSD.png": "../ShareWebComponents/src/Thumbnail/assets/images/VSD.png",
	"./WORD.png": "../ShareWebComponents/src/Thumbnail/assets/images/WORD.png"
};
function webpackContext(req) {
	return __webpack_require__(webpackContextResolve(req));
};
function webpackContextResolve(req) {
	var id = map[req];
	if(!(id + 1)) // check for number or string
		throw new Error("Cannot find module '" + req + "'.");
	return id;
};
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = "../ShareWebComponents/src/Thumbnail/assets/images recursive ^\\.\\/.*\\.png$";

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/ARCHIVE.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/ARCHIVEDOC.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/AUDIO.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/CAD.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/CUSTOMDOC.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIAAAACACAYAAADDPmHLAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA4ZpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMTMyIDc5LjE1OTI4NCwgMjAxNi8wNC8xOS0xMzoxMzo0MCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpmZmRiM2JlMC1iMTM2LWJkNGMtODRmOS1iOTIyNWVlMDVlZTQiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6RTFENzFCMzQ4MjFBMTFFN0IzNkM4Q0VFRkE2M0I0OUIiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6RTFENzFCMzM4MjFBMTFFN0IzNkM4Q0VFRkE2M0I0OUIiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIDIwMTUuNSAoV2luZG93cykiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDozMTM1MTBmYS03ZGIzLWViNDItOWM4OC1hZDVkZjc5NWFkNjgiIHN0UmVmOmRvY3VtZW50SUQ9ImFkb2JlOmRvY2lkOnBob3Rvc2hvcDozMWMwYTFjNi03Y2U1LTExZTctODg5MS1jZWI3MjU0YjRmYjgiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz4u7WvsAAAInUlEQVR42uxdS28bVRQ+8/DYiZMmaZKmaUOaFrVElJZSUYFQF7wWCPEbEKwqUYQQSGxYgYA1O8QGxI4dUhFUCBWhFiGqigoKlD5pAnm0amIndmyPHzPDOeNx6zi246Qde+6d80knj4nkie/55jvn3HvuteI4DjDCC5WHgAnAYAIwmAAMJgCDCcBgAjCYAAwmAIMJwGACMJgADCYAgwnAYAIwZITe/M8OOFYGv3HPgLhwQNHigF82QQA7D+bFNwGsLL6A+hxe2d3hd3MR7Wd26gbcjw9wbO/7oPYe2IwC0CsUVbSPMFq8hb9FOvx+sh4JvkP7Cu0KWprd3NR/rgpsMgQQlCNo6HwlEoC30432uGfvop3zyHAK7TRpFnt8jf/uJQdwsTsAT34jHPHsbbRraCfRTqD9hbbEzr/nJNCFJsD76EI74Nk7aOfRfvQIQcpQYFdvngAilgCHPXsdbdpThW/RfkdbZLeHZx7AQNvrhQjKE35A+wTtBbQ4u781BZAJBz07VqUM36P9grbAChCu1HgC7Q20r9HOoH2O9hLaICtA+DDp2StoM2jfQHnCKbduHRVMclM5fBbtXybAxjHmhYhjgr+PKbSXPXXjEBBCUIj7YL2HnAkgNw6hxZgA4cW6k3hMALnhMAEYTAAGE4DBBGAwARhMAMaGCKDwCElRCTb2ow5Ok2aZ8t8yjlMCMRqDGLUeVBR9Bch/df2sguL893HlN/IwtX4P3RUABez8wlMl89bxRn3ljCA/+appdI+9BlosXyP2f4KTvwDxR0kB8nSBmj4/RXt19Ws4oBp9YBgDPJ5ikiAGjv1ZuTV8FRJgm8fx+pe6Fx+eWeP8Sg7g0NIyd1uLjTU5wFZUhA/x+omKLmzjQQodRtGiFQJkeDxCB9o3YVUIkAYx278Zm0cSrVQhwAqayWMSXgJQCMjxmIQKy6wAnAPYrADhJgCwAoScAJWW4Zx0BFBUz9p4TzpKxzUhJs6S1QRwpJoL0HSwCzko5DPoC7uNnNPAiPWAqhsYXS0RksBVmwbkOFABnZBenIFbU79BNpMEx6KVTKVNt9ahe8swjE4cgu6+bUEnQaqWAEkZnJ9L3Ybpv8+AVcy7DlG0dh5u4kA6OQ9FMw17DjwPRteWIIeDTHUSKAcBEAtzV6BUNF3ndyDxAA3va+bSkLh5zSVkQEFLwOlaBUjIQIDcSsLLx/x/8hRFqRte6EousxTkhqqcV/lJFgIQESMGRhQTMdXfdkciWKlgoujbSAS1oSIEFGY9BRCfAJh07X7k2bbcyioVIJXAZHP6AhTMLFYAQvXX3lEAVbYQ0LZKMxKFgR2TMD55FH82QLDFVFPcHIDiLvUntltdaYKnuqyj360ilnsj0D+8C27PXnYTQIEUICPePADJrG2DmVl0Jbh9ub0CerTrbllXOTybvmsaxOIDosz+VRPAriUAXaRRNYJa4xfNFZi/cR5j76xb57ezvKMZvsEd+2DbA/u95M6pqQaEQqryQzUBCl4iOBJE2betEsxePQvJhWl86AzkQ3tPry3mMzD/z68oQhoMjT0swlRvM9wJ92oNAZaD+fTrkEnOQSo5D7pudOSJo3l+yj0W566AVciWF5okI0CxWhqCpgB5M4MPXbGjtTXNLeTNNOYfxXIyKi6SYikAgwnA8CcEVCeBjogEoOTQcSyfQoODSq91aGGpPQqgNyoPhHA+ZuJDWJpFewcBLB+ycq28vJy4ed3N/mVXAIJQTSEOEqB/eALi2x8E8GNiSI9CavaSm/lDSAggXAigtX8bM3MolXwgQAGsonS9sjRQ2UYEEOoTuDTdgJmrZwGunQN/FmMUd9mX7iMRlr2SXw4FsO2Sr59rWS73FdkIUGiWBBI7IuK8H0XwOZm2Y6maAGodAuR5jKRGigkQbqzKAdRm8YEhLQGsZjmAUArgJoHu7h+fZgKx/pdsEmhVol+vDBRGAahE6+kbAT3a7XYK3XeoKhTNDGTTC006f4XMARoSQKg9grQOMLLrIPSM7KEZoft/A6z/U3OX4Z8/Tsk0F9BUAQhidQe7kwAO+DMZ4NfrMgHuj0JrEZi7cR70mYv+OEpR3M0f7W4/8xnp9QggzIIQtYblVpJeR65fy8FquR1MDpTWywGECwHlDJ3PMW4R+VoCqMLnAMFNToL4TxVayQGSog10EBeDYt39QUwg8xKGAN1r0fZvOdhpeQ+Ag6WpBREjDlupScW2mQB+graHje9/GnqHx31qCInA8s3rMH3pp6bzAEQS+l/KR8QMwejEYxCl7WLB2zxSaIUAQvUF6pEYqLFe31rCtEhsPRbClq07Yd/hF91ykaRfM7rQ+aUgDlfOqwSaEoB6oCwRUmsqz5ZuT0GOWsJ8bAptWgbi0x+J9kCku8/bQWwH1fl1S/xGBCAVCPzHhFAJSGcCdbwtnOYhSkLsDl5slQBpEQjgksB1jnR9+35hTYWntpIpMsJHgBUeq/ASgEJAsLqDMbmKdvVgThbp6OQKNZ5EseLQ9Iioq4SJVghQDJwCYFYd7x+FnoHtULIKOPZOB5xvgY3J5uDoPizzukU7EqYhARplT6mgKQAle2N7n3SfvlRirr1HxCgKGNG46/yhnZNBnOHbdAgQgwCuClgQicVh/KGjYGaX23tIFBJAN+ocEiUxAYK5Q4iePHRGrGew88fEiQeSrZzYBKg4wikBY8NYgTod36pwBGBsFmmo86kwapNYwR8kKRdSGyHAqu1DDGkUoOUQsMQECHcIYAWQMwQUNqIAnGrLpwCwEQWweMykKwNbJgDJ/xSPmVS4Ue+i3qTaew/tC7RhHjvhcdrzZRXKeyp1UBp205xEow/geQIkOyUphNJ/Emon9xTLPf1ccawsD1FY4RLA4Qm/MEPlIWACMJgADCYAgwnAYAIwmAAMJgCDCcBgAjCYAAwmAIMJwGACMJgADBnxvwADAEl68U0MKI0jAAAAAElFTkSuQmCC"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/DIR.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIAAAACACAYAAADDPmHLAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA4ZpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMTMyIDc5LjE1OTI4NCwgMjAxNi8wNC8xOS0xMzoxMzo0MCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpmZmRiM2JlMC1iMTM2LWJkNGMtODRmOS1iOTIyNWVlMDVlZTQiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6RDQxQzI2RkI5QzQ2MTFFNzlEOTU5NjU0REMwQkQyOTEiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6RDQxQzI2RkE5QzQ2MTFFNzlEOTU5NjU0REMwQkQyOTEiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIDIwMTUuNSAoV2luZG93cykiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDpkOWQ0ZjAwMS05MWIwLTI2NGYtOGMyZi1hODVkNGNmODJiMTIiIHN0UmVmOmRvY3VtZW50SUQ9ImFkb2JlOmRvY2lkOnBob3Rvc2hvcDplMmNmYmYwNi04ZDYyLTExZTctYjc0Ni1iNjhmNDI4NmJmNWMiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz4BTE5RAAADIUlEQVR42uzcOU9UYRSHcWZCMFhoYaKxdd+D4kcgVlYmJpZW6jdw39dQW5nQqx/BhMQPIO770tC4MSCFAYnkeiYZCHMdR9CwzH1/T/KvmJDhvA/nnHuZSynLsjakS1kJCAACgAAgAAgAAoAAIAAIAAKAACAACAACoIi0N/vi2ONDKlQAOrtu/1cHWBm5GxmPZIuYF5ELke2OdGFHwM3IwciyRX6v2yLnI88jLyMXIzsc4fwLcGAJvu+tkXORZ5FXkUuRnY5zfgRYvsR/hi2Rs5GnkdeRy5FdjjbNq4DNkTORJ5E3kSuRLsec5mXgpsjpyKPI28jVyG5HnuZ9gI2RU5GHkXeRa5E9jj/NG0EbIicjA5H3keuRbgKkyfrIiciDyIfIjcjelArQrglOsy5yvJbPke8t+nNU3/edmsyTBPg31rT4+6/eE1lRk9kISJTDdoC0WU0AEAAEAAFAABAABAABQABMU8oGe5u+YKwy4P/ItSidq7pLf3vN1B+D1kZuRfZFOnLfRCVbl/wv70TkXuRI5OPMEdAX2Z8/fBSOjto59+V3gB61SYqevADjapIUY3kBKmqSFJW8AMNqkhQjeQFG1IQAIAASYdgSSABLIAGMAAIQwBJoBBBAB9ABkBIVl4GWwDoBqo8UT6hLEky0zXj0vdxoLiCN+U8AAtQJYBFMbP7nBbAIJnYFYAQYAQQwAuwAOoAOQAACEKBtSG2SYEgH0AEIQAACEIAABJgpwM/IqPoUmtHaOTcUoIqbQcXmt/MtN2sPKHb71wF0AB1AByAAAYwAI2AKnwoqNhUjwAggAAEIQABLoCXQEmgJNAKMgHqqDw3+UKdCUvdQ6J8E0AUSmv8ESLz9E4AADQXw8fBErgB0ADsAAYwAAhBgNq0CBEAiSyABLIEwAuAqAEYAEuwAk5Fv6lUoRmvnOisB7AGJtP9mAhgDBEDR578RQAAdgACN+apmheLLXAXoV7NC0T9XAe5HjkY+qV1LUz2/Y7XzbEgpG+xVpoQpK0HalLIsUwUdAAQAAUAAEAAEAAFAABAABAABQAAQAAQAAVAsfgkwALsL4+sMLjRpAAAAAElFTkSuQmCC"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/EXCEL.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/EXE.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/GROUPDOC.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/HTML.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/IMG.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIAAAACACAYAAADDPmHLAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA4ZpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMTMyIDc5LjE1OTI4NCwgMjAxNi8wNC8xOS0xMzoxMzo0MCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpmZmRiM2JlMC1iMTM2LWJkNGMtODRmOS1iOTIyNWVlMDVlZTQiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6Q0JFRUQxMDhCREUxMTFFN0JFRkNGNTlDNkU1MTcwNDIiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6Q0JFRUQxMDdCREUxMTFFN0JFRkNGNTlDNkU1MTcwNDIiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIDIwMTUuNSAoV2luZG93cykiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDo0MTE5NjY1Yy0zYjVmLTg1NDgtYTFjYy1iNTlmZmMzMWYxNGMiIHN0UmVmOmRvY3VtZW50SUQ9ImFkb2JlOmRvY2lkOnBob3Rvc2hvcDo3NThkNzUwZi1iZDQ2LTExZTctYWViMy1hMzcxZGI2ZjMzNzkiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz7zFsqWAAAIm0lEQVR42uydC2xTZRTHzx6MWeZejgnhNWGIMAlEAwMl8iaiSCQxMUJiDCYiARSjvIxCBEUTXomYKCJTkYiAugkIBkHeA4YEBhkELTAGyBhs68pWuq1r/U7bW1i5t+vWdb2P/y/5svXe9m655/+d1/3ubZTL5SJgXGJD+XD8mmKo535uivGUfVqGWQv/bDTs1ep0FGOnmBxpEIBxyRRjkxBBHARgXEaJkSNEEKXbHMAfEfcMa+06p4sS11723zxFjCtiLIAH0Dlx0YoTfb7wAtMhAGOzWohgIgRgXGLE2ChEMAACMC4mMbYLEXSFAIwLG3+HEEESBGAAkuJkT29/MX5VS48AAggjm8alK1UHqukRQABhZESXeFozIo0UrMw9gqUQgM55pXcHWpydorR7nvACUyAAnTNnYBK90e9BuV1R3lAwCgLQOauGPUQTMkxyu+K8SWF/CEDHxIi5vn50RxqU3l62YPCWh10hAB1jio2i3PHp1CupnWp6BBBAG5MWH0NbhQj4p0KPYIsQQQwEoGPYA7AnYI8gw1gxVkMAOodzAc4JYuSbBNOFF5gPAegcrgq4OlBgaVv0CCCACMP9Ae4TRKpHAAGoAO4UcscwEj0CCEAF8FTnawZ87UChR5AnRNARAtAxfNWQrx4+nip7lbinGNuECEwQgI7h9QO/PZdOXTrILtbOJs+yshgIQMew8VkEHeR7BBNbu0cAAagQDgPft1GPIBanO3wIQ4Xr0NwjuGiflrEZHsC4hcO3QgTZEIBx4YpgGwRgbELuDSAHaEXa4ubY1s4r4AEMDgQAAQAIAEAAAAIAEAAwGqrrA4Sxf64K1PYgLXgAhACAEKBSrr/WXRcnufN3JRBAS0hpDweFEAAgAGDQEBAIc1U9fXCskvZctbtfj+4aTx9np1Cm/K3XQE8COG+pp+G518lS5/Rty7tko33X7HRgUmd6NBki0HUIWFRQ2cj4ErxtodgHdC4Aye3L8dc1O6yqdwFEBXi8YhRsqn8BcMKnxKgA+4BOBLB4cIpsk4i3LRmcAqvqXQC9Ral3UGT7k3qaKDku2j34d96GMtAgfQA29Max6bCgET1AuFlVWOXuNUAABuRCVT19dNxC0/bdIqcLAjAcbx2qIHuDi47eqKUvi6wQgJH4yVxDe67e8b1eVGCh4tsOCMAIVNY6aW5+RaNt1fVOmnmgnFwQgLawOVw090hFsz7zYUElld1puG/7buERNpyvhgC0xLKTVfT5aSvtuGwL6v0c73PO3Vbcz2K6YWuAALQArxNYKco4ZvbhCqpxBHbg9SLVn3WwPGDGz+Hh7UPlEIAWmCPieG2Dx5olIoH75G9LwPezpzhTXtfkcXm9Qe5FGwSgZrYV22hnyZ3GBj5jpdMKBr7MAjlhCfr4sw+XU0WtEwJQI1y7z8m/P/FzCN8+U8HFs1u3OYLP8TkPmNfM5BICaCOWi8RPqWYvEEneN35J3i8Xa+gPP28RDD+IimD31TsQgJpgwy8/VRXwPQuPVVKpN5O31jnpvfyWz+QZB8rdPQIIQCWwMe0NgV05rxeUegO8bvB6TcvLOs4dFhZYIAA1wEnf9uLgsvPN5hr6QiSFa8/eDvnvflVkpSOltRBAJKlVSPwC8b4IBQ2t0NvlpPLN/bd8JScEEAFWFFa5Gz/Noa4VDcZrBpae0HYoUPWKoMoANfe1Goe75RtpVhZaaWy3ByhL/oseIIBQUPNt1RLcSh6ztRQhAEAAACEgdNT2ECV4AAABAAgAQAAAAgAQAIAAAAQAIAAAAQAIABhVAHr/YgetEKodYtX0zwCEAAABAAgAQAAAAgAQAAg3sTgFLSMzPpqGd/TcC3De6qBDVQ4IIJxseSaVenlvvngirzTg/lOldpp6tOk7dhZnJdCE3gm+13LH9Tf6p4OTaWh3E6V1aHzqbPVO2mOupgUFFjLbnRBAa8PG7fdwfFD7M8TvwQjg5axE6pES3B09LJaZ2alkaicfNXn7C30TaXRmAs35s4zWXbFDAJGCjfFupolWmJXvGh6WFNss488dluZ7favGQT8XWenMLc+jZ3okxro9CQuQ//aysem0LqcEAogkYzICC2Bq34SgjvN6t/hGxv+x0CLrXRYWVbtF986QVJq1qwxVQKTg2cmM7JXgjtlKjMtM8MXuQMx4MrlJ40uw4LpuuEq5ZXUQQKQ4UnJ31r/ayyT7nknpcb4k7liJLeDsl/IKFlYweQX6ACpg7wXPo11H9pAXwOTHPLP/7A07Xa9WLt+efeTu53NOWvR4qvQnAK4GdnsfGTOom8md7Pkz2uv+t/9b3eSxJNZfsEEAWoFjsRTbX+rZ2AtwoiaVcmzUgZ2US0vJ/fOxtFTbowrwxnZOBMeL8mz2SWuj6oA5fsUWtFGLK+oUS8k+ifKncP/NOk2IRrcC+Pq01S0ArvU56ePMnKuC7O4eAeT9E/oj4LmUnDwgWb562FFKZg00g3R7MYgNLpWEUtLHVQG7f3bpgXoE/qQn6PeSia6vBu4ye2b5UO+sl6qCQKWfXE/Bv+/v8wCiLOR1kNLgWQ8BqIicc9U+A3IYyPImfBweguHSPbGfk0d4AI3Bl2gvV3qM+NmINLf751kdbKdu7z3fOCIljxCAxtjk/eo36cKPFBaCgctEqZzkhJK9CASgMfwbOFJYCAYu4/LO3g0X6yZ00p0IdC8ANiLX/AyHg+au3OFETwojHEJYBDlDku/rMHKOMHdoqubOjyGWhC04XEF9Eq3upVst4fmtpfT7xE7uMMIi4Npfqf6XqoeW/i0IIEzJYChr9tiL9Nn8n3vmv9gvUXFVEOcLHDKWnrJqpnWsGQEsya+g1PbRTe5v7pc6NXVc/3DAgy8TP92l8TWEw9fsmlkGdi9RLlfLHp/uvRHURSDiNgzl6aq4L8DgQAAQAIAAAAQAjEmoZWAUTqG2+V+AAQDaMx1bHW95SgAAAABJRU5ErkJggg=="

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/LOGO.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIAAAACACAYAAADDPmHLAAAACXBIWXMAAAsTAAALEwEAmpwYAAAKTWlDQ1BQaG90b3Nob3AgSUNDIHByb2ZpbGUAAHjanVN3WJP3Fj7f92UPVkLY8LGXbIEAIiOsCMgQWaIQkgBhhBASQMWFiApWFBURnEhVxILVCkidiOKgKLhnQYqIWotVXDjuH9yntX167+3t+9f7vOec5/zOec8PgBESJpHmomoAOVKFPDrYH49PSMTJvYACFUjgBCAQ5svCZwXFAADwA3l4fnSwP/wBr28AAgBw1S4kEsfh/4O6UCZXACCRAOAiEucLAZBSAMguVMgUAMgYALBTs2QKAJQAAGx5fEIiAKoNAOz0ST4FANipk9wXANiiHKkIAI0BAJkoRyQCQLsAYFWBUiwCwMIAoKxAIi4EwK4BgFm2MkcCgL0FAHaOWJAPQGAAgJlCLMwAIDgCAEMeE80DIEwDoDDSv+CpX3CFuEgBAMDLlc2XS9IzFLiV0Bp38vDg4iHiwmyxQmEXKRBmCeQinJebIxNI5wNMzgwAABr50cH+OD+Q5+bk4eZm52zv9MWi/mvwbyI+IfHf/ryMAgQAEE7P79pf5eXWA3DHAbB1v2upWwDaVgBo3/ldM9sJoFoK0Hr5i3k4/EAenqFQyDwdHAoLC+0lYqG9MOOLPv8z4W/gi372/EAe/tt68ABxmkCZrcCjg/1xYW52rlKO58sEQjFu9+cj/seFf/2OKdHiNLFcLBWK8ViJuFAiTcd5uVKRRCHJleIS6X8y8R+W/QmTdw0ArIZPwE62B7XLbMB+7gECiw5Y0nYAQH7zLYwaC5EAEGc0Mnn3AACTv/mPQCsBAM2XpOMAALzoGFyolBdMxggAAESggSqwQQcMwRSswA6cwR28wBcCYQZEQAwkwDwQQgbkgBwKoRiWQRlUwDrYBLWwAxqgEZrhELTBMTgN5+ASXIHrcBcGYBiewhi8hgkEQcgIE2EhOogRYo7YIs4IF5mOBCJhSDSSgKQg6YgUUSLFyHKkAqlCapFdSCPyLXIUOY1cQPqQ28ggMor8irxHMZSBslED1AJ1QLmoHxqKxqBz0XQ0D12AlqJr0Rq0Hj2AtqKn0UvodXQAfYqOY4DRMQ5mjNlhXIyHRWCJWBomxxZj5Vg1Vo81Yx1YN3YVG8CeYe8IJAKLgBPsCF6EEMJsgpCQR1hMWEOoJewjtBK6CFcJg4Qxwicik6hPtCV6EvnEeGI6sZBYRqwm7iEeIZ4lXicOE1+TSCQOyZLkTgohJZAySQtJa0jbSC2kU6Q+0hBpnEwm65Btyd7kCLKArCCXkbeQD5BPkvvJw+S3FDrFiOJMCaIkUqSUEko1ZT/lBKWfMkKZoKpRzame1AiqiDqfWkltoHZQL1OHqRM0dZolzZsWQ8ukLaPV0JppZ2n3aC/pdLoJ3YMeRZfQl9Jr6Afp5+mD9HcMDYYNg8dIYigZaxl7GacYtxkvmUymBdOXmchUMNcyG5lnmA+Yb1VYKvYqfBWRyhKVOpVWlX6V56pUVXNVP9V5qgtUq1UPq15WfaZGVbNQ46kJ1Bar1akdVbupNq7OUndSj1DPUV+jvl/9gvpjDbKGhUaghkijVGO3xhmNIRbGMmXxWELWclYD6yxrmE1iW7L57Ex2Bfsbdi97TFNDc6pmrGaRZp3mcc0BDsax4PA52ZxKziHODc57LQMtPy2x1mqtZq1+rTfaetq+2mLtcu0W7eva73VwnUCdLJ31Om0693UJuja6UbqFutt1z+o+02PreekJ9cr1Dund0Uf1bfSj9Rfq79bv0R83MDQINpAZbDE4Y/DMkGPoa5hpuNHwhOGoEctoupHEaKPRSaMnuCbuh2fjNXgXPmasbxxirDTeZdxrPGFiaTLbpMSkxeS+Kc2Ua5pmutG003TMzMgs3KzYrMnsjjnVnGueYb7ZvNv8jYWlRZzFSos2i8eW2pZ8ywWWTZb3rJhWPlZ5VvVW16xJ1lzrLOtt1ldsUBtXmwybOpvLtqitm63Edptt3xTiFI8p0in1U27aMez87ArsmuwG7Tn2YfYl9m32zx3MHBId1jt0O3xydHXMdmxwvOuk4TTDqcSpw+lXZxtnoXOd8zUXpkuQyxKXdpcXU22niqdun3rLleUa7rrStdP1o5u7m9yt2W3U3cw9xX2r+00umxvJXcM970H08PdY4nHM452nm6fC85DnL152Xlle+70eT7OcJp7WMG3I28Rb4L3Le2A6Pj1l+s7pAz7GPgKfep+Hvqa+It89viN+1n6Zfgf8nvs7+sv9j/i/4XnyFvFOBWABwQHlAb2BGoGzA2sDHwSZBKUHNQWNBbsGLww+FUIMCQ1ZH3KTb8AX8hv5YzPcZyya0RXKCJ0VWhv6MMwmTB7WEY6GzwjfEH5vpvlM6cy2CIjgR2yIuB9pGZkX+X0UKSoyqi7qUbRTdHF09yzWrORZ+2e9jvGPqYy5O9tqtnJ2Z6xqbFJsY+ybuIC4qriBeIf4RfGXEnQTJAntieTE2MQ9ieNzAudsmjOc5JpUlnRjruXcorkX5unOy553PFk1WZB8OIWYEpeyP+WDIEJQLxhP5aduTR0T8oSbhU9FvqKNolGxt7hKPJLmnVaV9jjdO31D+miGT0Z1xjMJT1IreZEZkrkj801WRNberM/ZcdktOZSclJyjUg1plrQr1zC3KLdPZisrkw3keeZtyhuTh8r35CP5c/PbFWyFTNGjtFKuUA4WTC+oK3hbGFt4uEi9SFrUM99m/ur5IwuCFny9kLBQuLCz2Lh4WfHgIr9FuxYji1MXdy4xXVK6ZHhp8NJ9y2jLspb9UOJYUlXyannc8o5Sg9KlpUMrglc0lamUycturvRauWMVYZVkVe9ql9VbVn8qF5VfrHCsqK74sEa45uJXTl/VfPV5bdra3kq3yu3rSOuk626s91m/r0q9akHV0IbwDa0b8Y3lG19tSt50oXpq9Y7NtM3KzQM1YTXtW8y2rNvyoTaj9nqdf13LVv2tq7e+2Sba1r/dd3vzDoMdFTve75TsvLUreFdrvUV99W7S7oLdjxpiG7q/5n7duEd3T8Wej3ulewf2Re/ranRvbNyvv7+yCW1SNo0eSDpw5ZuAb9qb7Zp3tXBaKg7CQeXBJ9+mfHvjUOihzsPcw83fmX+39QjrSHkr0jq/dawto22gPaG97+iMo50dXh1Hvrf/fu8x42N1xzWPV56gnSg98fnkgpPjp2Snnp1OPz3Umdx590z8mWtdUV29Z0PPnj8XdO5Mt1/3yfPe549d8Lxw9CL3Ytslt0utPa49R35w/eFIr1tv62X3y+1XPK509E3rO9Hv03/6asDVc9f41y5dn3m978bsG7duJt0cuCW69fh29u0XdwruTNxdeo94r/y+2v3qB/oP6n+0/rFlwG3g+GDAYM/DWQ/vDgmHnv6U/9OH4dJHzEfVI0YjjY+dHx8bDRq98mTOk+GnsqcTz8p+Vv9563Or59/94vtLz1j82PAL+YvPv655qfNy76uprzrHI8cfvM55PfGm/K3O233vuO+638e9H5ko/ED+UPPR+mPHp9BP9z7nfP78L/eE8/sl0p8zAAA71GlUWHRYTUw6Y29tLmFkb2JlLnhtcAAAAAAAPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNS42LWMwNjcgNzkuMTU3NzQ3LCAyMDE1LzAzLzMwLTIzOjQwOjQyICAgICAgICAiPgogICA8cmRmOlJERiB4bWxuczpyZGY9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkvMDIvMjItcmRmLXN5bnRheC1ucyMiPgogICAgICA8cmRmOkRlc2NyaXB0aW9uIHJkZjphYm91dD0iIgogICAgICAgICAgICB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iCiAgICAgICAgICAgIHhtbG5zOnhtcE1NPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvbW0vIgogICAgICAgICAgICB4bWxuczpzdEV2dD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL3NUeXBlL1Jlc291cmNlRXZlbnQjIgogICAgICAgICAgICB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iCiAgICAgICAgICAgIHhtbG5zOnBob3Rvc2hvcD0iaHR0cDovL25zLmFkb2JlLmNvbS9waG90b3Nob3AvMS4wLyIKICAgICAgICAgICAgeG1sbnM6dGlmZj0iaHR0cDovL25zLmFkb2JlLmNvbS90aWZmLzEuMC8iCiAgICAgICAgICAgIHhtbG5zOmV4aWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20vZXhpZi8xLjAvIj4KICAgICAgICAgPHhtcDpDcmVhdG9yVG9vbD5BZG9iZSBQaG90b3Nob3AgQ0MgMjAxNSAoV2luZG93cyk8L3htcDpDcmVhdG9yVG9vbD4KICAgICAgICAgPHhtcDpDcmVhdGVEYXRlPjIwMTUtMDMtMzFUMTE6MjY6MTArMDg6MDA8L3htcDpDcmVhdGVEYXRlPgogICAgICAgICA8eG1wOk1ldGFkYXRhRGF0ZT4yMDE3LTA2LTE2VDEwOjQwOjQ4KzA4OjAwPC94bXA6TWV0YWRhdGFEYXRlPgogICAgICAgICA8eG1wOk1vZGlmeURhdGU+MjAxNy0wNi0xNlQxMDo0MDo0OCswODowMDwveG1wOk1vZGlmeURhdGU+CiAgICAgICAgIDx4bXBNTTpJbnN0YW5jZUlEPnhtcC5paWQ6ZDk0OTQyMzctODc1ZC1iMTQ4LTlhMmEtOWJjZDVlYTM1ZDgyPC94bXBNTTpJbnN0YW5jZUlEPgogICAgICAgICA8eG1wTU06RG9jdW1lbnRJRD54bXAuZGlkOjkzYmM4Njc0LTIxMmMtMWY0MS1hMWE1LThiNTBlMDRlNWE1YTwveG1wTU06RG9jdW1lbnRJRD4KICAgICAgICAgPHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD54bXAuZGlkOjkzYmM4Njc0LTIxMmMtMWY0MS1hMWE1LThiNTBlMDRlNWE1YTwveG1wTU06T3JpZ2luYWxEb2N1bWVudElEPgogICAgICAgICA8eG1wTU06SGlzdG9yeT4KICAgICAgICAgICAgPHJkZjpTZXE+CiAgICAgICAgICAgICAgIDxyZGY6bGkgcmRmOnBhcnNlVHlwZT0iUmVzb3VyY2UiPgogICAgICAgICAgICAgICAgICA8c3RFdnQ6YWN0aW9uPmNyZWF0ZWQ8L3N0RXZ0OmFjdGlvbj4KICAgICAgICAgICAgICAgICAgPHN0RXZ0Omluc3RhbmNlSUQ+eG1wLmlpZDo5M2JjODY3NC0yMTJjLTFmNDEtYTFhNS04YjUwZTA0ZTVhNWE8L3N0RXZ0Omluc3RhbmNlSUQ+CiAgICAgICAgICAgICAgICAgIDxzdEV2dDp3aGVuPjIwMTUtMDMtMzFUMTE6MjY6MTArMDg6MDA8L3N0RXZ0OndoZW4+CiAgICAgICAgICAgICAgICAgIDxzdEV2dDpzb2Z0d2FyZUFnZW50PkFkb2JlIFBob3Rvc2hvcCBDQyAoV2luZG93cyk8L3N0RXZ0OnNvZnR3YXJlQWdlbnQ+CiAgICAgICAgICAgICAgIDwvcmRmOmxpPgogICAgICAgICAgICAgICA8cmRmOmxpIHJkZjpwYXJzZVR5cGU9IlJlc291cmNlIj4KICAgICAgICAgICAgICAgICAgPHN0RXZ0OmFjdGlvbj5zYXZlZDwvc3RFdnQ6YWN0aW9uPgogICAgICAgICAgICAgICAgICA8c3RFdnQ6aW5zdGFuY2VJRD54bXAuaWlkOmU0ZDJiNmIzLTU0YzItZWY0OS05MjJhLTk2MDE1M2IxYTY3NDwvc3RFdnQ6aW5zdGFuY2VJRD4KICAgICAgICAgICAgICAgICAgPHN0RXZ0OndoZW4+MjAxNS0wMy0zMVQxMToyNjoxMCswODowMDwvc3RFdnQ6d2hlbj4KICAgICAgICAgICAgICAgICAgPHN0RXZ0OnNvZnR3YXJlQWdlbnQ+QWRvYmUgUGhvdG9zaG9wIENDIChXaW5kb3dzKTwvc3RFdnQ6c29mdHdhcmVBZ2VudD4KICAgICAgICAgICAgICAgICAgPHN0RXZ0OmNoYW5nZWQ+Lzwvc3RFdnQ6Y2hhbmdlZD4KICAgICAgICAgICAgICAgPC9yZGY6bGk+CiAgICAgICAgICAgICAgIDxyZGY6bGkgcmRmOnBhcnNlVHlwZT0iUmVzb3VyY2UiPgogICAgICAgICAgICAgICAgICA8c3RFdnQ6YWN0aW9uPnNhdmVkPC9zdEV2dDphY3Rpb24+CiAgICAgICAgICAgICAgICAgIDxzdEV2dDppbnN0YW5jZUlEPnhtcC5paWQ6ZDk0OTQyMzctODc1ZC1iMTQ4LTlhMmEtOWJjZDVlYTM1ZDgyPC9zdEV2dDppbnN0YW5jZUlEPgogICAgICAgICAgICAgICAgICA8c3RFdnQ6d2hlbj4yMDE3LTA2LTE2VDEwOjQwOjQ4KzA4OjAwPC9zdEV2dDp3aGVuPgogICAgICAgICAgICAgICAgICA8c3RFdnQ6c29mdHdhcmVBZ2VudD5BZG9iZSBQaG90b3Nob3AgQ0MgMjAxNSAoV2luZG93cyk8L3N0RXZ0OnNvZnR3YXJlQWdlbnQ+CiAgICAgICAgICAgICAgICAgIDxzdEV2dDpjaGFuZ2VkPi88L3N0RXZ0OmNoYW5nZWQ+CiAgICAgICAgICAgICAgIDwvcmRmOmxpPgogICAgICAgICAgICA8L3JkZjpTZXE+CiAgICAgICAgIDwveG1wTU06SGlzdG9yeT4KICAgICAgICAgPGRjOmZvcm1hdD5pbWFnZS9wbmc8L2RjOmZvcm1hdD4KICAgICAgICAgPHBob3Rvc2hvcDpDb2xvck1vZGU+MzwvcGhvdG9zaG9wOkNvbG9yTW9kZT4KICAgICAgICAgPHBob3Rvc2hvcDpJQ0NQcm9maWxlPnNSR0IgSUVDNjE5NjYtMi4xPC9waG90b3Nob3A6SUNDUHJvZmlsZT4KICAgICAgICAgPHRpZmY6T3JpZW50YXRpb24+MTwvdGlmZjpPcmllbnRhdGlvbj4KICAgICAgICAgPHRpZmY6WFJlc29sdXRpb24+NzIwMDAwLzEwMDAwPC90aWZmOlhSZXNvbHV0aW9uPgogICAgICAgICA8dGlmZjpZUmVzb2x1dGlvbj43MjAwMDAvMTAwMDA8L3RpZmY6WVJlc29sdXRpb24+CiAgICAgICAgIDx0aWZmOlJlc29sdXRpb25Vbml0PjI8L3RpZmY6UmVzb2x1dGlvblVuaXQ+CiAgICAgICAgIDxleGlmOkNvbG9yU3BhY2U+MTwvZXhpZjpDb2xvclNwYWNlPgogICAgICAgICA8ZXhpZjpQaXhlbFhEaW1lbnNpb24+MTI4PC9leGlmOlBpeGVsWERpbWVuc2lvbj4KICAgICAgICAgPGV4aWY6UGl4ZWxZRGltZW5zaW9uPjEyODwvZXhpZjpQaXhlbFlEaW1lbnNpb24+CiAgICAgIDwvcmRmOkRlc2NyaXB0aW9uPgogICA8L3JkZjpSREY+CjwveDp4bXBtZXRhPgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgIAo8P3hwYWNrZXQgZW5kPSJ3Ij8+drAqgwAAACBjSFJNAAB6JQAAgIMAAPn/AACA6QAAdTAAAOpgAAA6mAAAF2+SX8VGAAAQKElEQVR42uydf5RVVRXHP/MUGQWRLhM/jkpmKj9ETVEglIWGP0orjQxRMzQxdWlmKmKUhmIuFQFTK1pBWYa/SPM3GqAigoIgmhSiYph6haQzAzICjjPTH2c/fY4zzD7v3fveGzzftWYtFuuce8/b+3vO3WefvfepaGxsJOCzi0wQQSBAQCBAQCBAQCBAQCBAQCBAQCBAQCBAQCBAQCBAQCBAQCBAQCBAQCBAQCBAQCBAQCBAwDaE7QEqKiq26R8ZE1UCg4ABQG9gH6An0En+KoA6YCNQDfwbWAGsBJ4G/mGwDduibCoaGxu3SQLERF2Ak4DhwGBgxwIeZ4HHgbuBBwx2SyBA+Sp+CPAT4DhghxReUQPcCUwy2NcCAcpH8YcD44GhRXplPXA7cI3BvhwIUDrF7wrcCJxYoiHUATcAVxvs+4EAxVX+2cBEYOcyGM5qYJTBPhUIkL7iOwJTgVPLbGj1wM+B6wy2MRAgHeXvATwC9CnjYT4AnNwWPgltigAx0X7AbKBbGxjuIuAYg10fCJCc8h8Hqgpcop8BFgAv4xw+63EOoE5AF+BLQD/ZTfQrcNhLgWHlTII2QQBZ9hcCPfJ8xAJgOnCPwW7w3GF8DzhLiJEPFgoJNgcC5G/wLQL65tH9KWCcwS4ocAwZYARwFbB3Ho+43WBPDQTIT/i3ySz0wTrgQoOdkfBY2gM/BcYB7Ty7n2uwUwMB/AR+OvBHz27PAsMN9p0Ux3UIcC+wm0e3zcAAg30pEEAn5B640zgfJ8/twBkG+0ERxtcNeBjo72kUDiink8Vyjge4wVP504DvF0P5AAa7FhgGLPbo1h84O6wArc+uIWLAafEQcILB1pdgrFXy2dHuEmqAvQ12XVgBWsYvPNquwHnd6ksxUFHkcUCtsktn4PywArQ8owbKjNLgA2CQwS4rg3GPBn6vbF4N9DTYjWEF+DQu9mh7fTkoX1aCacBcZfPPAaPDCvDpWdQZWIsukicG9jHY2nJhrrirlwHbKZq/YLAHhhXgkxiBPozrmnJSvqwCL+HCxTT4cky0byDApwmgwf/wdxAVC5M82p4UCPDx8lkJHKZsflu5nrWLTbJI2fyrgQAfYxDQXtn2LsobdyvbDYiJdgoEcNDO/rUeM6xUuE/Zrh0uWSUQAOilbDe/3OPtDPZ14G1l8z6BAA69le2eoW3g2YSJnwq2LyOBfVHZ7tUEDc92wChc6lgt8B4uPOw13EnkygIieVYq2+0VCODQRdkuyXSsm9n66VxDTLQMmIPz8j1psHXKZ69Wtuv0mf8ESNiXFjUJvnqYQj79gbHA34E4JroxJtJ48NYFAujhQ4BNCb7XN6yrCvgx8HxM9KjkI7aE2rZAgHL5BLTFdOtjgGNiornA+c0kiL4I3A98AVd/oDnUSZuSoSwOg8QY00by9DTYNxN672pRUKH4AJejOKGt1Q5IlQAxUQfZ5vQRK78KF+a1nSyR1xjs29J2C7qDoC8b7ItlRoAsngdGGOwqBeH7AvviKpV0xwWKgEteeU9siI8qlaR18LV9CkrvDxyP83MPbOUda3Gx9gBrRBiabdOLCQ23OmECHCT2wSiDva8Z2VwIfEu2ne09nvthTLQIlxl1v8EuLSsjMCbqHBNdEhMtB5YAlwOHKghm8tjf905QYVclbFRmjbp7RNlNMQ44wlP52Yl6qMh1SUy0XOTduaQEEMWPlz3vRFnSfFCZ8+8Vyj5DktKUwf4NF9v/HVyEzqW4sK4FYqAVItcpMdFlTf7/vISGvq/Ie3VMNL4QIuRlA8REFbjc/ElA1wJ+yJ8M9nR55jnAbxV9NgBVHg6ZQuyXI3BZSd8m/3pDFxnslJznTgEuTHi4/8WF0s3wPSfJ5CGY7sBjwG0FKr8p5ngsscNIGQZba7APGexIWSWuy/NzMTkmyi1fM4bkTzO7ij4eE/2kQ4CYaKhYukclNPD3cgT+GvoTtFOKuVUy2HcN9jJcfcEH8njErTFRb3nWh8DpKfk+jhIjdGjiBIiJTsUVZ+iR4ICbzqhHlf2+GxN1pcgw2LcM9njgDFyunxYdgJkS9YQ4jcalNMwewGzRVzI2QEx0HnBLgQNbK5b+/2Tm7whca7BLct5zOPCE8nkTDPaKEjqv+uNyA32qldxssBfk2FFTcR7FNfJXK2TpgktDL7QSyvkG++uCCJBnhi6yxN0LPAjMMdh3FULNAG+gy7rdiEuxWlNCEuwFPAnsquzSAByszWWIiT4PHAl8E1fxtH0ewzzDYG/NiwAx0dflm+fjMFovBtNUg63OQ6hXAFf67iJKSII+uCCVXZRdngUG+1rrMdHngHNwJ5O7eHT9EPiWwc7yIoCUZVnGxy5KDaYBl+aj+CY/9E1ZCjU43mAfKDEJhuGOi7U21XDxQeQrn+vxyyyqAQ402NUqI1B81Xd4KL8GONZgzypE+WIgVQO/8egyPSb6QikJYLBzRSlajCtEPgZ7FnAs+tiIzsAdolfVLuBiXJi2BquAgS0tMXniepyfXoMq4MGYqKTn6sAVwD+VbQ+OiY4pkHSzcBHFq5RdBtFM3mWmmdm/O87nrMHrwOEG+0rCM2odcJlHl/2AWTHRLiVcBepwVcq1GJ3AO18FDhc9aHC56HerK8B1gCZZIbvsv5WSTKfhFwE8WPa/3UtIgtnoPZrfTIKwIv9jlSvmTqLf5gkg25qRynefarArUxRmA3AazvevxSHA0phocAk/BROV7doD301IVivR100eKXpudgW4jJbDl3LxO4N9pAgzalUeS6UB5sdEk0uUdjUb0H4Sv5agrGaJY6k1VOR+Xj/aBooRtZZPHtE2BwvsVai177n1mQhckkfXNTk+ic1FHO8EXNXw1rAO6JpUppMcC79K6+V0NwPdDHZD7grwHYXywblgq4s8q8biSsD5ojswBXgnJro5JhoSExUjEPYejx1M3wRXgRrgakXTStH3J1aAObR+zFqy2jYx0Q64rOATCnzUe7jj2BW4QJZq3Hn6nKQCOsWlvQ5XCqY1nGawf0lQTh1wjrTW3j3XYI/MSCdtbv6tpSpsJPX/TgT+VOCjdsb513+EC2j5A67M3KqYqFdCY23w2MHsnbCcaoFbFU0Pi4kqMzlOAs1BQ0nz8qUU3BnAz3AHK0liV1zSR1LQXiTVOwVR3aHchQzKEuBQRYe1BlvyvHyDbTTYa2QWr0348UnuGrQ5jN1SkNFzStkcmvFg4XzKCAb7BHCAku2lwLvKdmm5sJ/UrD5Zi1jz7VualqRiou3k2761GzrqceFoP8xum6Re7ykx0R9wmb69y4gA2kSOjim9/3laL0LVK0uA3RUPfDVFYUXoPFkH4YIqa5qsBnOk5NoI3KFMOVwopS1du0NK79foa/eMBwvfSlFYPjuLHVuyvA32TlzM/NHiN/CN4k3SsNTGM9SkJFONvjr6ECC1oowGu8lD+J0VRuJsuaKlO87fPhWde/bxBH9WVQrkT/oT1NHHK5Z2HX6rFNpeKLOI5IKov8ofcvrWS2yFnkL8bLLq/QnHNOyhbLchJXmq9JUlwCZav169Q8oEWKUkwN4FrDTrcRc8LCZ9aJ1KadlWmlV9U8ZjGfp8ygLTHi1/hbYBbUTVKym9X6OvjVkCaEKr90xZYOrkUImpL1vERHuiDxVfkdIwNDeYrMl4sDDtytZPK9t1w9UdKGecoGxXl+LnSHPK+EqWABq/9ZCUhbbYY9t2UpkTQFv1fHGKh2safb2cJcASReP908zHk9M+7SpwWqmLLG9l+T/QY4V6IqUxdAX2VzRdkiXAPMU+vAJ3HJsmtKeNXXCnguWIi1P4vb4YTutJKg3AvIzMvmqc77g1/CBl4f0Vfdr0OAl+KKfZvx/6oNoXDXZ5SkM5U9HmeYOtzmXJTEWn/j6553nu0+9TN/fLHSgGpqC7LwgKD2xpiYRDgIMVTWfSZJmYAWiCEyekLMSJHm3HKsu2FmP2j0ZfuWQ9+ivmfKHRT6Po+2MCSL0+jSt0SEw0IsVVYCmuBI0G7YAZnrWG01B+L+BGjy43pWH9SykazQo9K1ufsamhcK3yXb+Wy5MpIYuz6APcKTEFpVB+F1yhCJ/Tv5tSsvy1SbUf6TnTZPbNRxf5UwX8Ja0Qa4NdgCt6pMVxwO+KTQI5XHoE/b3BAD9P+t5g+d0z0Ll/54ueoYWtwhilLXAkcEuKbtkx+J2UnQncJuHjxVB+N9wdAj53/ryALnvHF7eIPjTf/jG5/5FpZvYtAqYrX3w28Js0SCDhXr6FFU8G5sVEPVJW/iE451l/j25bcNfb1yc4joqY6Le4yiEaTG8a2NuSs2As+pJt5wB3pWGIScKE73ZpELA8JjotBcW3j4muBBaiq2OUiwvlZtGkxtIBd0upVvlvi14/ga2ViDkMF1mq/a6uAE432MUJC70DLslivzy6PwVcbrBPFTiGDM6/P4H87vi5w2BPSVAmA3DJH9rYx3pcHYen1QSQF43Br/RJAy6vf7zBvlPAD+yLq9u72mDHx0Q9Zdbtmucjn5HP2j2SP6cdx264UrGjPQ29XCwEhiWRnCqftvEyHp8in5cabLP+FU2ZuF8BF3iOdTPu9szpwALNdy8mai/W/ChcWbTsoK4w2AkxUT/c4UlVATKsx+UFLsSVc/kPLhRts2zjIlw10D64OsGFJm6+IDNvfc7MHQQsF7lsUchlO1zizpmyClV6juEmg20x40lDgAzwZ/QFCJqiWhT3Eu7YuUYEvjPuUKc3cKAIpqUkiR8Y7B/F1/53XLBnuWMxcHSO8r8qjrbsLqUWV5X8OVxY2BoxFCtxga+9cCd6R6BLMm0OM8TwbMibAFlrUzxdF5RImHW40moPSUWwh0k/QKUQPAiMzF5wHRMNxEUcF/MI+yYxPLe6pfcqFx8TXYwruFAKr9sm4OsGO092HFMLWJXSQgOuMMS1WcGLMf0wxbsdrB4Ya7Cqa+y97wuQH3RnAQZZIdgAHCnJj9kDmMnyOSk13gBGGey8HFkdj8td3LFIY3hbVh5tYI3/fQHy8H44v3OxL3GuzN0OGuw0sSFmllDxH+J8632bKH9/XKWQYii/UfTRz0f5ea0AzXjEJuAqXqf9A+8GxsnN3M2NZSiuxvDQIim+Xmb3L5u5M5CY6CBcXeB2KY/jMfF1PJdP50SujYuJBsm+/RsJ/+D3RciTDfZfyrEMBi6SrWQa5wI18gmcJJdctObPOBdX7i7JIpZ1uKom1xvss4U8KNF7A+VodCTujp3BeS5/tWIxz8Sla23IcyyRjGV4AWPJ3crOzRnTFs+xVIpMjpXVMp8km03iv/gbcFdSJ4qpXRwpjp2BuCIO+8jfLriUpY4yu2tl//uGOEeWAUvlWpWkx/IVXKhUXxnL7jKeTuJ0qsNlSFXjiketEL/FAlz8XkNCY8mIHXOA2FL7iAOqk+z/N8rfely+xiu4exIXpXEraUVjY7HtuIByQiaIIBAgIBAgIBAgIBAgIBAgIBAgIBAgIBAgIBAgIBAgIBAgIBAgIBAgIBAgIBAgYJvD/wcAiVfz9rJBRBMAAAAASUVORK5CYII="

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/NAS.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/PDF.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/PPT.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/PSD.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/SHAREDOC.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/TXT.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/UNKNOWN.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/UNSYNCDOC.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/USERDOC.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/VIDEO.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/VSD.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/assets/images/WORD.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/component.base.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var extension_1 = __webpack_require__("../ShareWebCore/src/extension/index.ts");
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/index.ts");
var http_1 = __webpack_require__("../ShareWebUtil/src/http/index.ts");
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/index.ts");
var Types = [
    /** 文件类型 */
    'WORD',
    'EXCEL',
    'PPT',
    'PDF',
    'TXT',
    'IMG',
    'ARCHIVE',
    'VIDEO',
    'AUDIO',
    'EXE',
    'CAD',
    /** 文件夹 */
    'DIR',
    /** 未知类型 */
    'UNKNOWN',
    /** oem logo */
    'LOGO',
    /** 文件分类类型 */
    'USERDOC',
    'SHAREDOC',
    'GROUPDOC',
    'CUSTOMDOC',
    'ARCHIVEDOC',
    /** 未同步文档 */
    'UNSYNCDOC'
];
/** 图标资源 */
var Icons = Types.reduce(function (preIcons, type) {
    var _a;
    return (__assign({}, preIcons, (_a = {}, _a[type] = __webpack_require__("../ShareWebComponents/src/Thumbnail/assets/images recursive ^\\.\\/.*\\.png$")("./" + type + ".png"), _a)));
}, {});
var ThumbnailBase = /** @class */ (function (_super) {
    __extends(ThumbnailBase, _super);
    function ThumbnailBase() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            iconSrc: '',
            thumbnailSrc: '',
            thumbnailLoaded: false
        };
        return _this;
    }
    ThumbnailBase.prototype.componentWillMount = function () {
        var _a = this.props, doc = _a.doc, size = _a.size, quality = _a.quality, type = _a.type, fallback = _a.fallback, nostatistic = _a.nostatistic;
        this.buildThumbnail({ doc: doc, size: size, quality: quality, type: type, fallback: fallback, nostatistic: nostatistic });
    };
    ThumbnailBase.prototype.componentWillReceiveProps = function (nextProps) {
        if (nextProps.doc !== this.props.doc) {
            this.buildThumbnail(nextProps);
        }
    };
    /** 构造缩略图 */
    ThumbnailBase.prototype.buildThumbnail = function (_a) {
        var doc = _a.doc, size = _a.size, quality = _a.quality, type = _a.type, fallback = _a.fallback, nostatistic = _a.nostatistic;
        var thumbnailSrc = '';
        if (doc) {
            var _b = openapi_1.getOpenAPIConfig(['host', 'EFSPPort', 'userid', 'tokenid']), host = _b.host, EFSPPort = _b.EFSPPort, userid = _b.userid, tokenid = _b.tokenid;
            var link = doc.link, password = doc.password, docid = doc.docid, rev = doc.rev;
            if (!lodash_1.includes(Types, type)) {
                switch (true) {
                    case typeof doc.doc_type === 'string':
                        type = doc.doc_type.toUpperCase();
                        break;
                    case typeof doc.doctype === 'string':
                        type = doc.doctype.toUpperCase();
                        break;
                    case docs_1.isDir(doc):
                        type = 'DIR';
                        break;
                    default:
                        type = extension_1.findType(docs_1.docname(doc)) || 'UNKNOWN';
                        break;
                }
            }
            if (docid) {
                if (type === 'VIDEO') {
                    /** 视频缩略图 */
                    thumbnailSrc = http_1.joinURL(host + ":" + EFSPPort + "/v1/" + (link ? 'link' : 'file'), __assign({ method: 'playthumbnail', docid: docid,
                        rev: rev }, (link ? {} : { userid: userid, tokenid: tokenid }), { 
                        /** 缩略图禁用缓存 */
                        hash: Math.random() }));
                }
                else if (type === 'IMG') {
                    /** 图片缩略图 */
                    thumbnailSrc = http_1.joinURL(host + ":" + EFSPPort + "/v1/" + (link ? 'link' : 'file'), __assign({ method: 'thumbnail', docid: docid,
                        rev: rev, width: size, height: size, quality: quality }, (link ? { link: link, password: password } : { userid: userid, tokenid: tokenid }), { 
                        /** 缩略图禁用缓存 */
                        hash: Math.random(), 
                        /**是否进行预览统计 */
                        nostatistic: nostatistic }));
                }
            }
        }
        this.setState({
            iconSrc: typeof fallback === 'undefined' ? Icons[type] || Icons['UNKNOWN'] : fallback,
            thumbnailSrc: thumbnailSrc,
            thumbnailLoaded: false
        });
    };
    /** 缩略图加载成功 */
    ThumbnailBase.prototype.handleThumbnailLoaded = function (e) {
        if (typeof this.props.onThumbnailLoad === 'function') {
            this.props.onThumbnailLoad(e);
        }
        this.setState({
            thumbnailLoaded: true
        });
    };
    /**
     * 缩略图加载失败
     * @param e
     */
    ThumbnailBase.prototype.handleThumbnailError = function (e) {
        var _a = this.props, onThumbnailError = _a.onThumbnailError, errorFallback = _a.errorFallback;
        if (typeof onThumbnailError === 'function') {
            onThumbnailError(e);
        }
        if (errorFallback) {
            this.setState({
                iconSrc: errorFallback
            });
        }
    };
    ThumbnailBase.defaultProps = {
        size: 64,
        quality: 50,
        type: ''
    };
    return ThumbnailBase;
}(React.Component));
exports["default"] = ThumbnailBase;


/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/component.mobile.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var classnames = __webpack_require__("../node_modules/classnames/index.js");
var component_base_1 = __webpack_require__("../ShareWebComponents/src/Thumbnail/component.base.tsx");
var styles = __webpack_require__("../ShareWebComponents/src/Thumbnail/styles.mobile.css");
var Thumbnail = /** @class */ (function (_super) {
    __extends(Thumbnail, _super);
    function Thumbnail() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Thumbnail.prototype.render = function () {
        var _a = this.props, size = _a.size, className = _a.className;
        var _b = this.state, iconSrc = _b.iconSrc, thumbnailSrc = _b.thumbnailSrc, thumbnailLoaded = _b.thumbnailLoaded;
        return (React.createElement("div", { className: classnames(styles['container'], className), style: { width: size } },
            React.createElement("img", { style: { maxWidth: size, maxHeight: size, display: thumbnailLoaded ? 'none' : 'inline-block' }, src: iconSrc, draggable: false }),
            thumbnailSrc ?
                React.createElement("img", { style: { maxWidth: size, maxHeight: size, display: thumbnailLoaded ? 'inline-block' : 'none' }, src: thumbnailSrc, draggable: false, onLoad: this.handleThumbnailLoaded.bind(this) }) : null));
    };
    return Thumbnail;
}(component_base_1["default"]));
exports["default"] = Thumbnail;


/***/ }),

/***/ "../ShareWebComponents/src/Thumbnail/styles.mobile.css":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin
module.exports = {"container":"_-ShareWebComponents-src-Thumbnail-styles-mobile---container"};

/***/ }),

/***/ "../ShareWebComponents/src/Upload/Exceptions/component.base.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var upload_1 = __webpack_require__("../ShareWebCore/src/upload/index.ts");
var decorators_1 = __webpack_require__("../ShareWebUI/src/decorators.tsx");
var ExceptionsBase = /** @class */ (function (_super) {
    __extends(ExceptionsBase, _super);
    function ExceptionsBase(props, context) {
        var _this = _super.call(this, props, context) || this;
        _this.state = {
            type: -1,
            event: null,
            setDefault: false,
            showSkipTips: true,
            ondup: upload_1.OnDup.Skip
        };
        _this.unsubscribe = [];
        _this.handleUploadDup = _this.handleUploadDup.bind(_this);
        _this.handleUploadError = _this.handleUploadError.bind(_this);
        _this.handleUploadRuntimeError = _this.handleUploadRuntimeError.bind(_this);
        _this.close = _this.close.bind(_this);
        _this.confirmDup = _this.confirmDup.bind(_this);
        _this.closeDup = _this.closeDup.bind(_this);
        _this.confirmError = _this.confirmError.bind(_this);
        _this.toggleOnDup = _this.toggleOnDup.bind(_this);
        _this.toggleSetDefault = _this.toggleSetDefault.bind(_this);
        return _this;
    }
    ExceptionsBase.prototype.componentWillMount = function () {
        this.unsubscribe = [
            upload_1.subscribe(upload_1.EventType.UPLOAD_DUP, this.handleUploadDup),
            upload_1.subscribe(upload_1.EventType.UPLOAD_ERROR, this.handleUploadError),
            upload_1.subscribe(upload_1.EventType.UPLOAD_RUNTIME_ERROR, this.handleUploadRuntimeError)
        ];
    };
    ExceptionsBase.prototype.componentWillUnmount = function () {
        this.unsubscribe.forEach(function (f) { return f(); });
    };
    /**
     * 运行环境错误， 未安装flash
     */
    ExceptionsBase.prototype.handleUploadRuntimeError = function (event) {
        this.setState({
            type: upload_1.EventType.UPLOAD_RUNTIME_ERROR,
            event: event
        });
    };
    /**
     * 同名冲突
     */
    ExceptionsBase.prototype.handleUploadDup = function (event) {
        this.setState({
            type: upload_1.EventType.UPLOAD_DUP,
            event: event,
            setDefault: false,
            ondup: event.suggestName ? upload_1.OnDup.Rename : upload_1.OnDup.Cover
        });
    };
    /**
     * 上传出错
     */
    ExceptionsBase.prototype.handleUploadError = function (event) {
        var errcode = event.errcode;
        var showSkipTips = true;
        var setDefault = false;
        switch (errcode) {
            case upload_1.ErrorCode.FileNotExist:
            case upload_1.ErrorCode.NoCreatePermission:
            case upload_1.ErrorCode.ArchiveCover:
            case upload_1.ErrorCode.LinkNotExist:
            case upload_1.ErrorCode.UserFreezed:
            case upload_1.ErrorCode.DocFreezed:
            case upload_1.ErrorCode.SiteRemoved:
                showSkipTips = false;
                setDefault = true;
        }
        this.setState({
            type: upload_1.EventType.UPLOAD_ERROR,
            event: event,
            setDefault: setDefault,
            showSkipTips: showSkipTips
        });
    };
    /**
     * 关闭错误弹窗
     */
    ExceptionsBase.prototype.close = function () {
        this.setState({
            event: null
        });
    };
    /**
     * 确认重名冲突
     */
    ExceptionsBase.prototype.confirmDup = function () {
        var _a = this.state, event = _a.event, ondup = _a.ondup, setDefault = _a.setDefault;
        if (event) {
            switch (ondup) {
                case upload_1.OnDup.Rename:
                    event.uploadWithSuggestName(setDefault);
                    break;
                case upload_1.OnDup.Cover:
                    event.cover(setDefault);
                    break;
                default:
                    event.skip(setDefault);
                    break;
            }
        }
        this.close();
    };
    /**
     * 关闭重名冲突对话框
     */
    ExceptionsBase.prototype.closeDup = function () {
        if (this.state.event) {
            this.state.event.skip();
        }
        this.close();
    };
    /**
     * 确认错误弹窗
     */
    ExceptionsBase.prototype.confirmError = function () {
        var _a = this.state, event = _a.event, setDefault = _a.setDefault;
        if (event) {
            event.skip(setDefault);
        }
        this.close();
    };
    /**
     * 切换错误处理策略
     * @param checked
     * @param ondup
     */
    ExceptionsBase.prototype.toggleOnDup = function (checked, ondup) {
        this.setState({
            ondup: ondup
        });
    };
    /**
     * 切换记住选项
     */
    ExceptionsBase.prototype.toggleSetDefault = function (setDefault) {
        this.setState({
            setDefault: setDefault
        });
    };
    ExceptionsBase = __decorate([
        decorators_1.webcomponent
    ], ExceptionsBase);
    return ExceptionsBase;
}(React.Component));
exports["default"] = ExceptionsBase;


/***/ }),

/***/ "../ShareWebComponents/src/Upload/Exceptions/component.mobile.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var component_base_1 = __webpack_require__("../ShareWebComponents/src/Upload/Exceptions/component.base.tsx");
var upload_1 = __webpack_require__("../ShareWebCore/src/upload/index.ts");
var ui_mobile_1 = __webpack_require__("../ShareWebUI/src/Dialog/ui.mobile.tsx");
var ui_mobile_2 = __webpack_require__("../ShareWebUI/src/LinkButton/ui.mobile.tsx");
var ui_mobile_3 = __webpack_require__("../ShareWebUI/src/MessageDialog/ui.mobile.tsx");
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/index.ts");
var formatters_1 = __webpack_require__("../ShareWebUtil/src/formatters/index.ts");
var errcode_1 = __webpack_require__("../ShareWebCore/src/errcode/index.ts");
var locale_1 = __webpack_require__("../ShareWebComponents/src/Upload/Exceptions/locale.ts");
var commonStyles = __webpack_require__("../ShareWebComponents/src/styles.mobile.css");
var styles = __webpack_require__("../ShareWebComponents/src/Upload/Exceptions/styles.mobile.css");
var Exceptions = /** @class */ (function (_super) {
    __extends(Exceptions, _super);
    function Exceptions() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Exceptions.prototype.render = function () {
        var _this = this;
        var _a = this.state, type = _a.type, event = _a.event;
        if (event) {
            var _b = event, target = _b.target, errcode = _b.errcode, suggestName = _b.suggestName, uploadWithSuggestName_1 = _b.uploadWithSuggestName, cover_1 = _b.cover, skip_1 = _b.skip;
            switch (type) {
                case upload_1.EventType.UPLOAD_RUNTIME_ERROR:
                    return (React.createElement(ui_mobile_3["default"], { onConfirm: this.close },
                        React.createElement("h1", null, locale_1["default"]('您的浏览器未安装Flash插件，将无法使用上传功能。'))));
                case upload_1.EventType.UPLOAD_DUP:
                    return (React.createElement(ui_mobile_1["default"], null,
                        React.createElement(ui_mobile_1["default"].Main, null,
                            React.createElement("div", { className: commonStyles['warningHeader'] }, locale_1["default"]('目标位置已存在同名文档')),
                            React.createElement("div", { className: commonStyles['warningContent'] }, docs_1.isDir(target) ?
                                locale_1["default"]('您可以将当前文件夹“${name}”做如下处理：', { name: docs_1.docname(target) }) :
                                locale_1["default"]('您可以将当前文件“${name}”做如下处理：', { name: docs_1.docname(target) }))),
                        React.createElement(ui_mobile_1["default"].Footer, null,
                            suggestName && typeof suggestName === 'string' ?
                                React.createElement("div", { className: styles['ondup-option'] },
                                    React.createElement(ui_mobile_2["default"], { onClick: function () {
                                            uploadWithSuggestName_1();
                                            _this.close();
                                        } }, locale_1["default"]('保留两者'))) :
                                null,
                            errcode === upload_1.ErrorCode.SameTypeDup ?
                                React.createElement("div", { className: styles['ondup-option'] },
                                    React.createElement(ui_mobile_2["default"], { onClick: function () {
                                            cover_1();
                                            _this.close();
                                        } }, locale_1["default"]('替换'))) :
                                null,
                            React.createElement("div", { className: styles['ondup-option'] },
                                React.createElement(ui_mobile_2["default"], { onClick: function () {
                                        skip_1();
                                        _this.close();
                                    } }, locale_1["default"]('取消'))))));
                case upload_1.EventType.UPLOAD_ERROR:
                    return (React.createElement(ui_mobile_3["default"], { onConfirm: this.confirmError },
                        React.createElement("div", { className: commonStyles['warningHeader'] }, errcode === upload_1.ErrorCode.FileLocked ?
                            locale_1["default"]('无法执行覆盖操作') :
                            locale_1["default"]('无法执行上传操作')),
                        React.createElement("div", { className: commonStyles['warningContent'] }, this.getErrorMessage(event))));
                default: return null;
            }
        }
        return null;
    };
    Exceptions.prototype.getErrorMessage = function (event) {
        var errcode = event.errcode, target = event.target, dest = event.dest, locker = event.locker, fileSizeLimit = event.fileSizeLimit;
        switch (errcode) {
            case upload_1.ErrorCode.FileNotExist:
                return locale_1["default"]('您选择的目标文件夹不存在，可能其所在路径发生变更。');
            case upload_1.ErrorCode.NoCreatePermission:
                return docs_1.isDir(target) ?
                    locale_1["default"]('您对选择的目标文件夹“${name}”没有新建权限。', { name: docs_1.docname(dest) }) :
                    locale_1["default"]('您对选择的目标文件夹“${name}”没有上传权限。', { name: docs_1.docname(dest) });
            case upload_1.ErrorCode.NoSpace:
                return locale_1["default"]('您选择的目标位置配额空间不足。');
            case upload_1.ErrorCode.ArchiveCover:
                return locale_1["default"]('您无法修改归档库的文件。');
            case upload_1.ErrorCode.NoStorage:
                return locale_1["default"]('物理磁盘剩余空间不足，请联系管理员。');
            case upload_1.ErrorCode.FileLocked:
                return locale_1["default"]('文件“${name}已被用户“${user}”锁定”。', { name: target.suggestName || docs_1.docname(target), user: locker });
            case upload_1.ErrorCode.LargeFileLimit:
                return locale_1["default"]('文件 “${name}” 已大于${limit}文件大小的限制。', { name: docs_1.docname(target), limit: formatters_1.formatSize(fileSizeLimit) });
            case upload_1.ErrorCode.LinkNotExist:
                return locale_1["default"]('外链地址不存在。');
            case upload_1.ErrorCode.LowerCSFLevel:
                return locale_1["default"]('您对同名文件“${name}”的密级权限不足。', { name: target.suggestName || docs_1.docname(target) });
            case upload_1.ErrorCode.ExceedSizeLimit:
                return locale_1["default"]('文件“${name}”的大小超出 ${fileSizeLimit}, 无法上传。', { name: docs_1.docname(target), fileSizeLimit: formatters_1.formatSize(fileSizeLimit) });
            case upload_1.ErrorCode.IllegalName:
                return docs_1.isDir(target) ?
                    locale_1["default"]('文件夹名不能包含下列字符：\\ / : * ? " < > |，且长度不能大于244个字符。') :
                    locale_1["default"]('文件名不能包含下列字符：\\ / : * ? " < > |，且长度不能大于244个字符。');
            case upload_1.ErrorCode.UserFreezed:
                return locale_1["default"]('您的账号已被冻结');
            case upload_1.ErrorCode.DocFreezed:
                return locale_1["default"]('该文档已被冻结');
            case upload_1.ErrorCode.SiteRemoved:
                return locale_1["default"]('目标站点已经离线。');
            case upload_1.ErrorCode.FileTypeLimited:
                return locale_1["default"]('文件 “${name}” 的格式已被禁止上传。', { name: docs_1.docname(target) });
            default:
                return errcode_1.getErrorMessage(errcode);
        }
    };
    return Exceptions;
}(component_base_1["default"]));
exports["default"] = Exceptions;


/***/ }),

/***/ "../ShareWebComponents/src/Upload/Exceptions/locale.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var i18n_1 = __webpack_require__("../ShareWebComponents/src/i18n.ts");
exports["default"] = i18n_1["default"]([
    [
        '目标位置已存在同名文档',
        '目標位置已存在同名文件',
        'Same Name Conflic'
    ],
    [
        '您可以将当前文件夹“${name}”做如下处理：',
        '您可以對當前資料夾“${name}”做如下處理：',
        'You can deal with this folder "${name}" as follows:'
    ],
    [
        '同时保留两个文档，当前文件夹重命名为“${suggestName}”',
        '同時保留兩個文件，當前資料夾重命名為“${suggestName}”',
        'Keep both and rename this file as "${suggestName}"'
    ],
    [
        '使用当前文件夹合并已存在的同名文件夹',
        '使用當前資料夾合併已存在的同名資料夾',
        'Merge this folder with the same name folder'
    ],
    [
        '取消当前文件夹的上传',
        '取消當前資料夾的上載',
        'Skip this folder'
    ],
    [
        '为之后所有的相同冲突执行此操作',
        '為之後所有的相同衝突執行此操作',
        'Always do this for the conflicts'
    ],
    [
        '无法执行上传操作',
        '無法執行上載操作',
        'Upload failed'
    ],
    [
        '无法执行覆盖操作',
        '無法執行覆蓋操作',
        'Replace failed'
    ],
    [
        '您选择的目标文件夹不存在，可能其所在路径发生变更。',
        '您選取的目標資料夾不存在，可能其所在路徑發生變更。',
        'Target folder does not exist or its location has been changed.'
    ],
    [
        '您对选择的目标文件夹“${name}”没有新建权限。',
        '您對選取的目標資料夾“${name}”沒有新增權限。',
        'You do not have Create permission for target folder "${name}"'
    ],
    [
        '您对选择的目标文件夹“${name}”没有上传权限。',
        '您對選取的目標資料夾“${name}”沒有上載權限。',
        'You do not have upload permission for target folder "${name}"'
    ],
    [
        '您选择的目标位置配额空间不足。',
        '您選取的目標位置配額空間不足。',
        'There is not enough quota in destination'
    ],
    [
        '您可以将当前文件“${name}”做如下处理：',
        '您可以對當前資料“${name}”做如下處理：',
        'You can deal with this file "${name}" as follows:'
    ],
    [
        '同时保留两个文档，当前文件重命名为“${suggestName}”',
        '同時保留兩個文件，當前資料重命名為“${suggestName}”',
        'Keep both and rename this file as "${suggestName}"'
    ],
    [
        '上传并替换，使用当前文件覆盖同名文件',
        '上載並替換，使用當前檔案覆蓋同名檔案',
        'Replace the same name file'
    ],
    [
        '取消当前文件的上传',
        '取消當前檔案的上載',
        'Skip this file'
    ],
    [
        '外链地址不存在。',
        '外連結已失效。',
        'Link has expired.'
    ],
    [
        '您无法修改归档库的文件。',
        '您無法修改歸檔庫的檔案。',
        'you cannot modify files in Archive Library.'
    ],
    [
        '物理磁盘剩余空间不足，请联系管理员。',
        '物理磁片剩餘空間不足，請聯繫管理員。',
        'There is no enough physical disk space，please contact admin.'
    ],
    [
        '文件“${name}”的大小超出 ${fileSizeLimit}, 无法上传。',
        '檔案“${name}”的大小超過 ${fileSizeLimit}，無法上載。',
        'Upload failed, file "${name}" is larger than ${fileSizeLimit}.'
    ],
    [
        '文件名不能包含下列字符：\\ / : * ? " < > |，且长度不能大于244个字符。',
        '檔案名不能包含下列字元：\\ / : * ? " < > |，且長度不能大於244個字元。',
        'The filename cannot include the following characters \\ / : * ? " < > | and it should be less than 245 characters.'
    ],
    [
        '文件夹名不能包含下列字符：\\ / : * ? " < > |，且长度不能大于244个字符。',
        '資料夾名不能包含下列字元：\\ / : * ? " < > |，且長度不能大於244個字元。',
        'Folder name cannot include the following characters \\ / : * ? " < > | and it should be less than 245 characters.'
    ],
    [
        '您对同名文件“${name}”的密级权限不足。',
        '您對同名檔案“${name}”的密級權限不足。',
        'You do not have enough permissions for file "${name}" with the same name.'
    ],
    [
        '文件“${name}已被用户“${user}”锁定”。',
        '檔案“${name}”已被“${user}”鎖定。',
        'File "${name}" has been locked by ${user}'
    ],
    [
        '文件“${name}”过大，无法同步，您所在的网络存在限制。',
        '檔案“${name}”過大，無法同步，您所在的網路存在限制。',
        'File "${name}" is too large and cannot be synced, your network is limited.'
    ],
    [
        '跳过之后所有的相同冲突提示',
        '跳過之後所有相同的衝突提示',
        'Skip all the same conflict tips'
    ],
    [
        '列表中有未上传完成的文件',
        '列表中有未上载完成的档案',
        'There are unuploaded files in the list'
    ],
    [
        '您还有未上传的文件',
        '您还有未上载的档案',
        'You still have unuploaded files'
    ],
    [
        '您的账号已被冻结',
        '您的帳號已被凍結',
        'Upload failed, your account has been frozen.'
    ],
    [
        '该文档已被冻结',
        '該文件已被凍結',
        'Upload failed, the file has been frozen.'
    ],
    [
        '目标站点已经离线。',
        '目標網站已經離線。',
        'The target site is offline.'
    ],
    [
        '您的浏览器未安装Flash插件，将无法使用上传功能。',
        '您的浏览器未安装Flash插件，将无法使用上载功能。',
        'Your browser does not have a Flash plugin installed and can\'t upload it.',
    ],
    [
        '文件 “${name}” 的格式已被禁止上传。',
        '檔案 “${name}” 的格式已被禁止上載。',
        'The format of the file "${name}" has been banned from uploading.',
    ],
    [
        '文件 “${name}” 已大于${limit}文件大小的限制。',
        '檔案 “${name}” 已大於${limit}文件大小的限制。',
        'The file "${name}" is larger than the limit of ${limit}.',
    ],
    [
        '刷新或关闭当前页面，将不会继续上传，确定要执行此操作？',
        '刷新或關閉當前頁面，將不會繼續上载，確認要執行此操作?',
        'Refresh or close the current page, and the document will not continue to upload, are you sure want to do this?'
    ],
    [
        '保留两者',
        '保留兩者',
        'Keep both'
    ],
    [
        '替换',
        '替換',
        'Replace'
    ],
    [
        '取消',
        '取消',
        'Cancel'
    ]
]);


/***/ }),

/***/ "../ShareWebComponents/src/Upload/Exceptions/styles.mobile.css":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin
module.exports = {"ondup-option":"_-ShareWebComponents-src-Upload-Exceptions-styles-mobile---ondup-option"};

/***/ }),

/***/ "../ShareWebComponents/src/Upload/Panel/component.base.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var upload_1 = __webpack_require__("../ShareWebCore/src/upload/index.ts");
var decorators_1 = __webpack_require__("../ShareWebUI/src/decorators.tsx");
var Status;
(function (Status) {
    Status[Status["Inited"] = 0] = "Inited";
    Status[Status["Preparing"] = 1] = "Preparing";
    Status[Status["Progress"] = 2] = "Progress";
    Status[Status["Finished"] = 3] = "Finished";
})(Status = exports.Status || (exports.Status = {}));
var Panel = /** @class */ (function (_super) {
    __extends(Panel, _super);
    function Panel(props, context) {
        var _this = _super.call(this, props, context) || this;
        _this.state = {
            files: [],
            percentage: 0,
            speed: 0,
            uploaded: 0,
            minimized: true,
            open: false,
            status: Status.Inited,
            deferredClose: null,
            fileStatus: {},
            uploadCount: 0,
            errorCount: 0,
            completedCount: 0
        };
        /**
         *
         */
        _this.files = [];
        _this.currentFile = null;
        /**
         *
         */
        _this.unsubscribe = [];
        _this.minimizeWhenFinished = true;
        _this.handleMouseEnter = _this.handleMouseEnter.bind(_this);
        _this.handleMouseLeave = _this.handleMouseLeave.bind(_this);
        _this.handleClose = _this.handleClose.bind(_this);
        _this.toggleMinimize = _this.toggleMinimize.bind(_this);
        _this.togglePanel = _this.togglePanel.bind(_this);
        _this.handleParseDirStart = _this.handleParseDirStart.bind(_this);
        _this.handleParseDirEnd = _this.handleParseDirEnd.bind(_this);
        _this.handleFilesQueued = _this.handleFilesQueued.bind(_this);
        _this.handleFileDeQueued = _this.handleFileDeQueued.bind(_this);
        _this.handleFileCanceled = _this.handleFileCanceled.bind(_this);
        _this.handleUploadStart = _this.handleUploadStart.bind(_this);
        _this.handleUploadBeforeSend = _this.handleUploadBeforeSend.bind(_this);
        _this.handleUploadProgress = _this.handleUploadProgress.bind(_this);
        _this.handleUploadComplete = _this.handleUploadComplete.bind(_this);
        _this.handleUploadFinished = _this.handleUploadFinished.bind(_this);
        _this.handleReset = _this.handleReset.bind(_this);
        _this.cancelAll = _this.cancelAll.bind(_this);
        _this.clearCompleted = _this.clearCompleted.bind(_this);
        return _this;
    }
    Panel.prototype.componentWillMount = function () {
        this.unsubscribe = [
            upload_1.subscribe(upload_1.EventType.UPLOAD_FILES_QUEUED, this.handleFilesQueued),
            upload_1.subscribe(upload_1.EventType.UPLOAD_FILE_DEQUEUED, this.handleFileDeQueued),
            upload_1.subscribe(upload_1.EventType.UPLOAD_FILE_CANCELED, this.handleFileCanceled),
            upload_1.subscribe(upload_1.EventType.UPLOAD_START, this.handleUploadStart),
            upload_1.subscribe(upload_1.EventType.UPLOAD_BEFORE_SEND, this.handleUploadBeforeSend),
            upload_1.subscribe(upload_1.EventType.UPLOAD_PROGRESS, this.handleUploadProgress),
            upload_1.subscribe(upload_1.EventType.UPLOAD_COMPLETE, this.handleUploadComplete),
            upload_1.subscribe(upload_1.EventType.UPLOAD_PAESR_DIR_START, this.handleParseDirStart),
            upload_1.subscribe(upload_1.EventType.UPLOAD_PAESR_DIR_END, this.handleParseDirEnd),
            upload_1.subscribe(upload_1.EventType.UPLOAD_FINISHED, this.handleUploadFinished),
            upload_1.subscribe(upload_1.EventType.UPLOAD_RESET, this.handleReset)
        ];
    };
    Panel.prototype.componentWillUnmount = function () {
        this.unsubscribe.forEach(function (fn) { return fn(); });
    };
    /**
     * 鼠标移入
     */
    Panel.prototype.handleMouseEnter = function () {
        this.minimizeWhenFinished = false;
    };
    /**
     * 鼠标移出
     */
    Panel.prototype.handleMouseLeave = function () {
        this.minimizeWhenFinished = true;
    };
    /**
     * 开始解析上传目录
     */
    Panel.prototype.handleParseDirStart = function () {
        this.setState({
            status: Status.Preparing,
            files: this.files
        });
        if (!this.state.open) {
            this.setState({
                open: true
            });
        }
        if (this.state.minimized) {
            setTimeout(this.toggleMinimize, 1);
        }
    };
    /**
     * 目录创建完成
     */
    Panel.prototype.handleParseDirEnd = function () {
        this.setState({
            status: Status.Progress
        });
    };
    /**
     * 文件进入队列
     */
    Panel.prototype.handleFilesQueued = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, upload_1.runtime];
                    case 1:
                        if ((_a.sent()) === 'flash') {
                            if (!this.state.open) {
                                this.setState({
                                    open: true
                                });
                            }
                            if (this.state.minimized) {
                                setTimeout(this.toggleMinimize, 1);
                            }
                        }
                        this.updateUploadStatus();
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * 文件移除队列
     */
    Panel.prototype.handleFileDeQueued = function () {
        this.updateUploadStatus();
    };
    /**
     * 文件上传取消
     */
    Panel.prototype.handleFileCanceled = function () {
        this.updateUploadStatus();
    };
    /**
     * 开始上传
     */
    Panel.prototype.handleUploadStart = function () {
        this.setState({
            status: Status.Progress
        });
        this.updateUploadStatus();
    };
    /**
     *
     */
    Panel.prototype.handleUploadBeforeSend = function () {
        this.updateUploadStatus();
    };
    /**
     * 文件上传进度
     * @param param0
     */
    Panel.prototype.handleUploadProgress = function (_a) {
        var percentage = _a.percentage, speed = _a.speed, uploaded = _a.uploaded;
        this.setState({
            percentage: percentage,
            speed: speed,
            uploaded: uploaded
        });
    };
    /**
     * 文件上传完成
     */
    Panel.prototype.handleUploadComplete = function () {
        this.setState({
            percentage: 0,
            speed: 0,
            uploaded: 0
        });
        this.updateUploadStatus();
    };
    /**
     * 所有文件上传完成
     */
    Panel.prototype.handleUploadFinished = function () {
        this.setState({
            status: Status.Finished,
            minimized: this.minimizeWhenFinished
        });
        this.updateUploadStatus();
    };
    /**
     * 更新上传状态
     */
    Panel.prototype.updateUploadStatus = function () {
        return __awaiter(this, void 0, void 0, function () {
            var fileStatus, uploadCount, errorCount, completedCount, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        fileStatus = {}, uploadCount = 0, errorCount = 0, completedCount = 0;
                        _a = this;
                        return [4 /*yield*/, upload_1.getFiles(upload_1.FileStatus.Inited, upload_1.FileStatus.Queued, upload_1.FileStatus.Progress, upload_1.FileStatus.Completed, upload_1.FileStatus.Error, upload_1.FileStatus.Interrupt, upload_1.FileStatus.Invalid)];
                    case 1:
                        _a.files = _b.sent();
                        this.files.forEach(function (file) {
                            var status = file.getStatus();
                            fileStatus[file.id] = status;
                            switch (status) {
                                case upload_1.FileStatus.Inited:
                                case upload_1.FileStatus.Queued:
                                case upload_1.FileStatus.Progress:
                                    uploadCount++;
                                    break;
                                case upload_1.FileStatus.Error:
                                    errorCount++;
                                    break;
                                case upload_1.FileStatus.Completed:
                                    completedCount++;
                            }
                        });
                        this.setState({
                            files: this.files,
                            fileStatus: fileStatus,
                            uploadCount: uploadCount,
                            errorCount: errorCount,
                            completedCount: completedCount
                        });
                        return [2 /*return*/];
                }
            });
        });
    };
    Panel.prototype.retry = function (file) {
        upload_1.retry(file);
    };
    /**
     * 移除文件
     */
    Panel.prototype.cancel = function (file) {
        upload_1.cancel(file);
    };
    /**
     * 全部取消
     */
    Panel.prototype.cancelAll = function () {
        upload_1.stop();
        var i = this.files.length - 1;
        while (i >= 0) {
            var status = this.files[i].getStatus();
            if (status === upload_1.FileStatus.Inited || status === upload_1.FileStatus.Queued || status === upload_1.FileStatus.Progress) {
                this.cancel(this.files[i]);
            }
            i = i - 1;
        }
    };
    /**
     * 情空已完成
     */
    Panel.prototype.clearCompleted = function () {
        this.files.forEach(function (file) {
            if (file.getStatus() === upload_1.FileStatus.Completed) {
                upload_1.cancel(file);
            }
        });
    };
    /**
     * 重置上传组件
     */
    Panel.prototype.handleReset = function () {
        this.files = [];
        this.setState({
            status: Status.Inited,
            fileStatus: {},
            uploadCount: 0,
            errorCount: 0,
            completedCount: 0
        });
    };
    /**
    * 切换最小化
    */
    Panel.prototype.toggleMinimize = function () {
        this.setState({
            minimized: !this.state.minimized
        });
    };
    /**
     * 点击关闭按钮
     */
    Panel.prototype.handleClose = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _a.trys.push([0, , 3, 4]);
                        if (!this.state.uploadCount) return [3 /*break*/, 2];
                        upload_1.stop();
                        return [4 /*yield*/, new Promise(function (resolve, reject) {
                                var deferredClose = {
                                    confirm: function () {
                                        resolve();
                                    },
                                    cancel: function () {
                                        upload_1.upload();
                                        reject();
                                    }
                                };
                                _this.setState({
                                    deferredClose: deferredClose
                                });
                            })];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2:
                        upload_1.reset();
                        if (!this.state.minimized) {
                            this.toggleMinimize();
                            setTimeout(this.togglePanel, 400);
                        }
                        else {
                            this.togglePanel();
                        }
                        return [3 /*break*/, 4];
                    case 3:
                        this.setState({ deferredClose: null });
                        return [7 /*endfinally*/];
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    /**
     * 切换面板开关
     */
    Panel.prototype.togglePanel = function () {
        this.setState({
            open: !this.state.open
        });
    };
    Panel = __decorate([
        decorators_1.webcomponent
    ], Panel);
    return Panel;
}(React.Component));
exports["default"] = Panel;


/***/ }),

/***/ "../ShareWebComponents/src/Upload/Panel/component.mobile.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var component_base_1 = __webpack_require__("../ShareWebComponents/src/Upload/Panel/component.base.tsx");
var ui_mobile_1 = __webpack_require__("../ShareWebUI/src/Dialog/ui.mobile.tsx");
var ui_mobile_2 = __webpack_require__("../ShareWebUI/src/UIIcon/ui.mobile.tsx");
var component_mobile_1 = __webpack_require__("../ShareWebComponents/src/Thumbnail/component.mobile.tsx");
var upload_1 = __webpack_require__("../ShareWebCore/src/upload/index.ts");
var locale_1 = __webpack_require__("../ShareWebComponents/src/Upload/Panel/locale.ts");
var formatters_1 = __webpack_require__("../ShareWebUtil/src/formatters/index.ts");
var styles = __webpack_require__("../ShareWebComponents/src/Upload/Panel/styles.mobile.css");
var Panel = /** @class */ (function (_super) {
    __extends(Panel, _super);
    function Panel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * 所有文件上传完成
     */
    Panel.prototype.handleUploadFinished = function () {
        this.setState({
            status: component_base_1.Status.Finished,
            minimized: this.minimizeWhenFinished,
            open: false
        });
        this.updateUploadStatus();
    };
    /**
     * 点击关闭按钮
     */
    Panel.prototype.handleClose = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                upload_1.reset();
                this.togglePanel();
                return [2 /*return*/];
            });
        });
    };
    Panel.prototype.render = function () {
        var _a = this.state, files = _a.files, fileStatus = _a.fileStatus, uploaded = _a.uploaded, open = _a.open, deferredClose = _a.deferredClose;
        if (open) {
            var uploadInfos = files.reduce(function (infos, file) {
                if (fileStatus[file.id] === upload_1.FileStatus.Progress) {
                    return __spread(infos, [
                        React.createElement("div", { className: styles['title'] },
                            React.createElement("div", { className: styles['thumbnail'] },
                                React.createElement(component_mobile_1["default"], { doc: file, size: 32 })),
                            React.createElement("div", { className: styles['name'] }, file.name)),
                        React.createElement("div", { className: styles['progress'] },
                            React.createElement("div", { className: styles['percentage'], style: { width: uploaded / file.size * 100 + "%" } })),
                        React.createElement("div", { className: styles['status'] },
                            React.createElement("div", { className: styles['text'] },
                                " ",
                                locale_1["default"]('正在上传...'),
                                "  "),
                            React.createElement("div", { className: styles['size'] },
                                " ", formatters_1.formatSize(uploaded) + " / " + formatters_1.formatSize(file.size),
                                " "))
                    ]);
                }
                return infos;
            }, []);
            if (uploadInfos.length) {
                return (React.createElement(ui_mobile_1["default"], null,
                    React.createElement(ui_mobile_1["default"].Main, null,
                        React.createElement(ui_mobile_2["default"], { className: styles['close'], code: '\uf014', onClick: this.handleClose, color: '#868686' }),
                        uploadInfos)));
            }
        }
        return null;
    };
    return Panel;
}(component_base_1["default"]));
exports["default"] = Panel;


/***/ }),

/***/ "../ShareWebComponents/src/Upload/Panel/locale.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var i18n_1 = __webpack_require__("../ShareWebComponents/src/i18n.ts");
exports["default"] = i18n_1["default"]([
    [
        '正在上传',
        '正在上載',
        'Uploading'
    ],
    [
        '正在上传...',
        '正在上載...',
        'Uploading...'
    ],
    [
        '全部开始',
        '全部開始',
        'Resume All'
    ],
    [
        '全部暂停',
        '全部暫停',
        'Pause All'
    ],
    [
        '全部取消',
        '全部取消',
        'Cancel All'
    ],
    [
        '文件名',
        '檔案名',
        'File Name'
    ],
    [
        '大小',
        '大小',
        'Size'
    ],
    [
        '状态',
        '狀態',
        'Status'
    ],
    [
        '操作',
        '操作',
        'Operation'
    ],
    [
        '上传失败',
        '上載失敗',
        'Upload faild'
    ],
    [
        '上传完成',
        '上載完成',
        'Upload Completed'
    ],
    [
        '等待中...',
        '等待中...',
        'Pending...'
    ],
    [
        '取消',
        '取消',
        'Cancel'
    ],
    [
        '列表中有未上传完成的文件',
        '清單中有未上載完成的檔案',
        'There are unuploaded files in the list'
    ],
    [
        '刷新或关闭当前页面，将不会继续上传，确定要执行此操作？',
        '刷新或關閉當前頁面，將不會繼續上載，確認要執行此操作?',
        'Refresh or close the current page, the file will not continue to upload, are you sure to do this operation?'
    ],
    [
        '正在准备上传队列',
        '正在準備上載隊列',
        'The upload queue is readying'
    ],
    [
        '清空已完成',
        '清空已完成',
        '清空已完成'
    ],
    [
        '正在上传 ${uploadCount} 个文件 ${speed}',
        '正在上載 ${uploadCount} 個檔案 ${speed}',
        '${uploadCount} uploading(s) ${speed}'
    ],
    [
        '上传完成（${errorCount} 个文件上传失败）',
        '上传完成（${errorCount} 个文件上传失败）',
        'Upload completed (${errorCount} failed)'
    ]
]);


/***/ }),

/***/ "../ShareWebComponents/src/Upload/Panel/styles.mobile.css":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin
module.exports = {"close":"_-ShareWebComponents-src-Upload-Panel-styles-mobile---close","title":"_-ShareWebComponents-src-Upload-Panel-styles-mobile---title","thumbnail":"_-ShareWebComponents-src-Upload-Panel-styles-mobile---thumbnail","name":"_-ShareWebComponents-src-Upload-Panel-styles-mobile---name","progress":"_-ShareWebComponents-src-Upload-Panel-styles-mobile---progress","percentage":"_-ShareWebComponents-src-Upload-Panel-styles-mobile---percentage","status":"_-ShareWebComponents-src-Upload-Panel-styles-mobile---status","text":"_-ShareWebComponents-src-Upload-Panel-styles-mobile---text","size":"_-ShareWebComponents-src-Upload-Panel-styles-mobile---size"};

/***/ }),

/***/ "../ShareWebComponents/src/Upload/Picker/component.base.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var upload_1 = __webpack_require__("../ShareWebCore/src/upload/index.ts");
var decorators_1 = __webpack_require__("../ShareWebUI/src/decorators.tsx");
var Picker = /** @class */ (function (_super) {
    __extends(Picker, _super);
    function Picker(props, context) {
        var _this = _super.call(this, props, context) || this;
        _this.state = {
            runtime: '',
            clearing: false
        };
        _this.runtimeError = null;
        _this.setDirectoryPicker = _this.setDirectoryPicker.bind(_this);
        _this.handleChange = _this.handleChange.bind(_this);
        _this.handleMouseEnter = _this.handleMouseEnter.bind(_this);
        _this.handleClick = _this.handleClick.bind(_this);
        return _this;
    }
    Picker.prototype.componentWillMount = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, _b, e_1;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _c.trys.push([0, 2, , 3]);
                        _a = this.setState;
                        _b = {};
                        return [4 /*yield*/, upload_1.runtime];
                    case 1:
                        _a.apply(this, [(_b.runtime = _c.sent(),
                                _b)]);
                        return [3 /*break*/, 3];
                    case 2:
                        e_1 = _c.sent();
                        this.runtimeError = e_1;
                        return [3 /*break*/, 3];
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    Picker.prototype.setDirectoryPicker = function (input) {
        var runtime = this.state.runtime;
        var directory = this.props.directory;
        if (runtime === 'html5' && directory && input) {
            /**
             * react低版本不支持 webkitdirectory
             * 在 componentDidMount 后设置 webkitdirectory
             **/
            input.setAttribute('webkitdirectory', '');
        }
    };
    /**
     * 鼠标移入事件
     * @param e
     */
    Picker.prototype.handleMouseEnter = function (e) {
        if (this.state.runtime === 'flash') {
            upload_1.attachFlashPicker(e.currentTarget, this.props.dest);
        }
        if (typeof this.props.onMouseEnter === 'function') {
            this.props.onMouseEnter(e);
        }
    };
    /**
     * 文件输入框onChange
     * @param e
     */
    Picker.prototype.handleChange = function (e) {
        var _this = this;
        upload_1.uploadFileList(e.target.files, this.props.dest);
        if (typeof this.props.onChange === 'function') {
            this.props.onChange(e);
        }
        /**
         * 清除input数据
         */
        this.setState({ clearing: true }, function () {
            _this.setState({ clearing: false });
        });
    };
    /**
     * 点击事件
     * @param e
     */
    Picker.prototype.handleClick = function (e) {
        if (this.runtimeError) {
            upload_1.trigger(upload_1.EventType.UPLOAD_RUNTIME_ERROR, null, this.runtimeError);
        }
        if (typeof this.props.onClick === 'function') {
            this.props.onClick(e);
        }
    };
    Picker.defaultProps = {
        directory: false,
        multiple: true
    };
    Picker = __decorate([
        decorators_1.webcomponent
    ], Picker);
    return Picker;
}(React.Component));
exports["default"] = Picker;


/***/ }),

/***/ "../ShareWebComponents/src/Upload/Picker/component.mobile.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var classnames = __webpack_require__("../node_modules/classnames/index.js");
var component_base_1 = __webpack_require__("../ShareWebComponents/src/Upload/Picker/component.base.tsx");
var styles = __webpack_require__("../ShareWebComponents/src/Upload/Picker/styles.mobile.css");
var Picker = /** @class */ (function (_super) {
    __extends(Picker, _super);
    function Picker() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Picker.prototype.render = function () {
        var _a = this.props, _b = _a.style, style = _b === void 0 ? {} : _b, className = _a.className, children = _a.children, otherProps = __rest(_a, ["style", "className", "children"]);
        var _c = this.state, runtime = _c.runtime, clearing = _c.clearing;
        return (React.createElement("label", { className: classnames(styles['label'], className), style: style, onMouseEnter: this.handleMouseEnter.bind(this) },
            runtime === 'html5' && !clearing ?
                React.createElement("input", __assign({}, otherProps, { type: "file", className: styles['input'], ref: this.setDirectoryPicker, onChange: this.handleChange.bind(this) })) :
                null,
            children));
    };
    return Picker;
}(component_base_1["default"]));
exports["default"] = Picker;


/***/ }),

/***/ "../ShareWebComponents/src/Upload/Picker/styles.mobile.css":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin
module.exports = {"label":"_-ShareWebComponents-src-Upload-Picker-styles-mobile---label","input":"_-ShareWebComponents-src-Upload-Picker-styles-mobile---input"};

/***/ }),

/***/ "../ShareWebComponents/src/Upload/component.base.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var upload_1 = __webpack_require__("../ShareWebCore/src/upload/index.ts");
var browser_1 = __webpack_require__("../ShareWebUtil/src/browser/index.ts");
var decorators_1 = __webpack_require__("../ShareWebUI/src/decorators.tsx");
var Upload = /** @class */ (function (_super) {
    __extends(Upload, _super);
    function Upload(props, context) {
        var _this = _super.call(this, props, context) || this;
        /**
         * 绑定的事件
         */
        _this.unsubscribe = [];
        _this.handleFilesQueued = _this.handleFilesQueued.bind(_this);
        return _this;
    }
    Upload.prototype.componentWillMount = function () {
        this.unsubscribe = [
            upload_1.subscribe(upload_1.EventType.UPLOAD_FILES_QUEUED, this.handleFilesQueued),
        ];
    };
    Upload.prototype.componentDidMount = function () {
        var _a = this.props, swf = _a.swf, fileSizeLimit = _a.fileSizeLimit;
        upload_1.init({ swf: swf, fileSizeLimit: fileSizeLimit });
    };
    Upload.prototype.componentWillUnmount = function () {
        this.unsubscribe.forEach(function (f) { return f(); });
    };
    /**
     * 文件入队开始上传
     */
    Upload.prototype.handleFilesQueued = function () {
        upload_1.upload();
    };
    Upload.defaultProps = {
        swf: '',
        /**
         * 默认上传大小ie8 为 1G，
         */
        fileSizeLimit: browser_1.isIE8() ? 1024 * 1024 * 1024 : Infinity
    };
    Upload = __decorate([
        decorators_1.webcomponent
    ], Upload);
    return Upload;
}(React.Component));
exports["default"] = Upload;


/***/ }),

/***/ "../ShareWebComponents/src/Upload/component.mobile.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var component_base_1 = __webpack_require__("../ShareWebComponents/src/Upload/component.base.tsx");
var component_mobile_1 = __webpack_require__("../ShareWebComponents/src/Upload/Picker/component.mobile.tsx");
var component_mobile_2 = __webpack_require__("../ShareWebComponents/src/Upload/Panel/component.mobile.tsx");
var component_mobile_3 = __webpack_require__("../ShareWebComponents/src/Upload/Exceptions/component.mobile.tsx");
var Upload = /** @class */ (function (_super) {
    __extends(Upload, _super);
    function Upload() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Upload.prototype.render = function () {
        return (React.createElement("div", null,
            React.createElement(component_mobile_2["default"], null),
            React.createElement(component_mobile_3["default"], null)));
    };
    Upload.Picker = component_mobile_1["default"];
    Upload.Panel = component_mobile_2["default"];
    Upload.Exceptions = component_mobile_3["default"];
    return Upload;
}(component_base_1["default"]));
exports["default"] = Upload;


/***/ }),

/***/ "../ShareWebComponents/src/Viewer/assets/back.mobile.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebComponents/src/Viewer/component.base.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var browser_1 = __webpack_require__("../ShareWebUtil/src/browser/index.ts");
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/index.ts");
var download_1 = __webpack_require__("../ShareWebCore/src/download/index.ts");
var permission_1 = __webpack_require__("../ShareWebCore/src/permission/index.ts");
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/index.ts");
var entrydoc_1 = __webpack_require__("../ShareWebCore/src/apis/eachttp/entrydoc/index.ts");
var session_1 = __webpack_require__("../ShareWebUtil/src/session/index.ts");
var locale_1 = __webpack_require__("../ShareWebComponents/src/Viewer/locale.ts");
var ViewerBase = /** @class */ (function (_super) {
    __extends(ViewerBase, _super);
    function ViewerBase(props) {
        var _this = _super.call(this, props) || this;
        _this.state = {
            downloading: false,
            avoidPrint: typeof session_1["default"].get('leakproofvalue') === 'number' && (session_1["default"].get('leakproofvalue') & 1) !== 1,
            avoidCopy: false,
            downloadEnabled: false,
            saveToEnabled: false,
            savingTo: false,
            logedIn: false
        };
        _this.handleKeyDown = function (e) {
            if (e.altKey || e.ctrlKey || e.shiftKey) {
                _this.setAvoidCopy();
            }
        };
        _this.handleKeyUp = function (e) {
            if (!(e.altKey || e.ctrlKey || e.shiftKey)) {
                _this.cancelAvoidCopy();
            }
        };
        _this.handleBlur = function () {
            _this.setAvoidCopy();
        };
        _this.handleFocus = function () {
            _this.cancelAvoidCopy();
        };
        _this.download = _this.download.bind(_this);
        _this.rewriteTitle = _this.rewriteTitle.bind(_this);
        _this.preventEvent = _this.preventEvent.bind(_this);
        return _this;
    }
    /**
     * 开始下载
     */
    ViewerBase.prototype.download = function () {
        this.setState({
            downloading: true
        });
    };
    /**
     * 下载完成后重置状态，返回false避免<Download />组件自我销毁。
     */
    ViewerBase.prototype.downloadComplete = function () {
        this.setState({
            downloading: false
        });
        return false;
    };
    /**
     * mobile 下载
     */
    ViewerBase.prototype.downloadMobile = function () {
        download_1.download(__assign({}, this.props.link, this.props.doc));
    };
    /**
     * 开始转存
     */
    ViewerBase.prototype.saveTo = function () {
        if (this.props.onCheckLogin()) {
            this.setState({
                logedIn: true
            });
        }
        else {
            this.setState({
                logedIn: false
            });
        }
        this.setState({
            savingTo: true
        });
    };
    /**
     * 转存完成
     */
    ViewerBase.prototype.saveToComplete = function () {
        this.setState({
            savingTo: false
        });
    };
    /**
     * 登录成功
     */
    ViewerBase.prototype.loginSuccess = function (userInfo) {
        this.props.onLoginSuccess(userInfo);
        this.setState({
            savingTo: true,
            logedIn: true
        });
    };
    ViewerBase.prototype.checkEnableDownload = function (_a) {
        var _this = this;
        var doc = _a.doc, link = _a.link;
        var userid = openapi_1.getOpenAPIConfig('userid');
        if (this.props.skipPermissionCheck) {
            this.setState({
                downloadEnabled: true
            });
        }
        else {
            (link && link.link ? permission_1.checkLinkPerm(lodash_1.assign(link, { perm: permission_1.LinkSharePermission.DOWNLOAD })) : permission_1.checkPermItem(doc.docid, permission_1.SharePermission.COPY, userid)).then(function (downloadEnabled) {
                if (!downloadEnabled) {
                    browser_1.bindEvent(window, 'contextmenu', _this.preventEvent);
                }
                _this.setState({
                    downloadEnabled: downloadEnabled
                });
            });
        }
    };
    ViewerBase.prototype.checkEnabledSaveTo = function (_a) {
        var _this = this;
        var doc = _a.doc, link = _a.link;
        var userid = openapi_1.getOpenAPIConfig('userid');
        if (this.props.skipPermissionCheck) {
            this.setState({
                saveToEnabled: true
            });
        }
        else {
            if (link && link.link) {
                permission_1.checkLinkPerm(lodash_1.assign(link, { perm: permission_1.LinkSharePermission.DOWNLOAD })).then(function (saveToEnabled) {
                    _this.setState({
                        saveToEnabled: saveToEnabled
                    });
                });
            }
            else {
                Promise.all([
                    permission_1.checkPermItem(doc.docid, permission_1.SharePermission.COPY, userid),
                    entrydoc_1.getDocType({ docid: doc.docid }),
                ]).then(function (_a) {
                    var _b = __read(_a, 2), saveToEnabled = _b[0], doctype = _b[1].doctype;
                    if (doctype === 'userdoc') {
                        _this.setState({
                            saveToEnabled: false
                        });
                    }
                    else {
                        _this.setState({
                            saveToEnabled: saveToEnabled
                        });
                    }
                });
            }
        }
    };
    ViewerBase.prototype.back = function () {
        this.props.onRequestBack();
    };
    ViewerBase.prototype.loadAvoidPrintStyle = function () {
        var style = document.createElement('style'), cssText = ".no-print *{display:none;}.no-print:after{display:block;content:\"" + locale_1["default"]('无法执行打印操作，您的权限不足，请联系管理员。') + "\";font-size:24px;text-align:center;}";
        style.setAttribute('type', 'text/css');
        style.setAttribute('media', 'print');
        if (browser_1.isBrowser({ app: browser_1.Browser.MSIE, version: 8 })) {
            style.styleSheet.cssText = cssText;
        }
        else {
            style.innerHTML = cssText;
        }
        document.querySelector('head').appendChild(style);
    };
    ViewerBase.prototype.setAvoidCopy = function () {
        if (typeof session_1["default"].get('leakproofvalue') === 'number' && (session_1["default"].get('leakproofvalue') & 2) !== 2) {
            this.setState({
                avoidCopy: true
            });
        }
    };
    ViewerBase.prototype.cancelAvoidCopy = function () {
        this.setState({
            avoidCopy: false
        });
    };
    /**
     * 阻止默认事件
     * @param e
     */
    ViewerBase.prototype.preventEvent = function (e) {
        if (e && typeof e.preventDefault === 'function') {
            e.preventDefault();
        }
    };
    ViewerBase.prototype.componentDidMount = function () {
        var _a = this.props, illegalContentQuarantine = _a.illegalContentQuarantine, doc = _a.doc;
        this.loadAvoidPrintStyle();
        // 非法内容隔离区文件没有下载/转存权限
        !illegalContentQuarantine && this.checkEnableDownload(this.props);
        !illegalContentQuarantine && this.checkEnabledSaveTo(this.props);
        browser_1.bindEvent(window, 'keydown', this.handleKeyDown);
        browser_1.bindEvent(window, 'keyup', this.handleKeyUp);
        browser_1.bindEvent(window, 'blur', this.handleBlur);
        browser_1.bindEvent(window, 'focus', this.handleFocus);
        this.rewriteTitle(docs_1.docname(doc));
    };
    ViewerBase.prototype.rewriteTitle = function (title) {
        // 当页面中嵌入了flash，并且页面的地址中含有“片段标识”（即网址#之后的文字）IE标签页标题被自动修改为网址片段标识
        if (browser_1.userAgent().app === browser_1.Browser.MSIE || browser_1.userAgent().app === browser_1.Browser.Edge) {
            setTimeout(function () {
                document.title = title;
            }, 2000);
        }
        else {
            document.title = title;
        }
    };
    ViewerBase.prototype.componentWillReceiveProps = function (nextProps) {
        !nextProps.illegalContentQuarantine && this.checkEnableDownload(nextProps);
    };
    ViewerBase.prototype.componentWillUnmount = function () {
        browser_1.unbindEvent(window, 'keydown', this.handleKeyDown);
        browser_1.unbindEvent(window, 'keyup', this.handleKeyUp);
        browser_1.unbindEvent(window, 'blur', this.handleBlur);
        browser_1.unbindEvent(window, 'focus', this.handleFocus);
        browser_1.unbindEvent(window, 'contextmenu', this.preventEvent);
    };
    /**
     * 预览非法内容隔离区文件禁止鼠标右键
     */
    ViewerBase.prototype.forbidContextMenu = function (event) {
        if (this.props.illegalContentQuarantine) {
            event.preventDefault();
        }
    };
    ViewerBase.defaultProps = {
        // 是否使用较暗的UI
        lightoff: false,
        // 检查登录
        onCheckLogin: lodash_1.noop,
        // 登录成功
        onLoginSuccess: lodash_1.noop,
        // 查看跳转
        onRedirect: lodash_1.noop,
        onPasswordChange: lodash_1.noop,
        // 是否非法内容隔离区文件
        illegalContentQuarantine: false,
        // 回退目录
        onRequestBack: lodash_1.noop
    };
    return ViewerBase;
}(React.Component));
exports["default"] = ViewerBase;


/***/ }),

/***/ "../ShareWebComponents/src/Viewer/component.mobile.tsx":
/***/ (function(module, exports, __webpack_require__) {

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var classnames = __webpack_require__("../node_modules/classnames/index.js");
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/index.ts");
var helper_1 = __webpack_require__("../ShareWebUI/src/helper.tsx");
var ui_mobile_1 = __webpack_require__("../ShareWebUI/src/UIIcon/ui.mobile.tsx");
var ui_mobile_2 = __webpack_require__("../ShareWebUI/src/LinkIcon/ui.mobile.tsx");
var component_base_1 = __webpack_require__("../ShareWebComponents/src/Viewer/component.base.tsx");
var styles = __webpack_require__("../ShareWebComponents/src/Viewer/style.mobile.css");
var backImg = __webpack_require__("../ShareWebComponents/src/Viewer/assets/back.mobile.png");
var formatters_1 = __webpack_require__("../ShareWebUtil/src/formatters/index.ts");
var Viewer = /** @class */ (function (_super) {
    __extends(Viewer, _super);
    function Viewer() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Viewer.prototype.render = function () {
        var _a = this.props, link = _a.link, doc = _a.doc;
        return (React.createElement("div", { className: styles.container },
            React.createElement("div", { className: classnames(styles.header, helper_1.ClassName.BackgroundColor), style: this.props.style },
                React.createElement("div", { className: styles.headerPadding },
                    React.createElement("div", { className: styles.back },
                        React.createElement(ui_mobile_2["default"], { size: ".5rem", url: backImg, onClick: this.back.bind(this) })),
                    React.createElement("h1", { className: styles.title }, formatters_1.shrinkText(link ? (link.size === -1 ? docs_1.docname(doc) : link.name) : docs_1.docname(doc), { limit: 30 })),
                    React.createElement("div", { className: styles.action }, this.state.downloadEnabled ? React.createElement(ui_mobile_1["default"], { size: "20px", code: '\uf01b', onClick: this.downloadMobile.bind(this) }) : null))),
            React.createElement("div", { className: styles.main }, this.props.children)));
    };
    return Viewer;
}(component_base_1["default"]));
exports["default"] = Viewer;


/***/ }),

/***/ "../ShareWebComponents/src/Viewer/locale.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var i18n_1 = __webpack_require__("../ShareWebComponents/src/i18n.ts");
exports["default"] = i18n_1["default"]([
    [
        '下载',
        '下載',
        'Download'
    ],
    [
        '无法执行打印操作，您的权限不足，请联系管理员。',
        '無法執行列印操作，您的權限不足，請聯繫管理員。',
        'You are not  authorized to print, please contact admin.'
    ],
    [
        '转存到我的云盘',
        '轉存到我的雲盤',
        'Save to Web Disk'
    ]
]);


/***/ }),

/***/ "../ShareWebComponents/src/Viewer/style.mobile.css":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin
module.exports = {"container":"_-ShareWebComponents-src-Viewer-style-mobile---container","header":"_-ShareWebComponents-src-Viewer-style-mobile---header","headerPadding":"_-ShareWebComponents-src-Viewer-style-mobile---headerPadding","back":"_-ShareWebComponents-src-Viewer-style-mobile---back","title":"_-ShareWebComponents-src-Viewer-style-mobile---title","action":"_-ShareWebComponents-src-Viewer-style-mobile---action","main":"_-ShareWebComponents-src-Viewer-style-mobile---main"};

/***/ }),

/***/ "../ShareWebComponents/src/helper.tsx":
/***/ (function(module, exports, __webpack_require__) {

/// <reference path="./helper.d.ts" />
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/index.ts");
var entrydoc_1 = __webpack_require__("../ShareWebCore/src/entrydoc/index.ts");
var extension_1 = __webpack_require__("../ShareWebCore/src/extension/index.ts");
var ui_desktop_1 = __webpack_require__("../ShareWebUI/src/Icon/ui.desktop.tsx");
var iconView = __webpack_require__("../ShareWebCore/src/icons/assets/desktop/icon-doc-view.png");
var iconDir = __webpack_require__("../ShareWebCore/src/icons/assets/desktop/icon-doc-dir.png");
var iconWord = __webpack_require__("../ShareWebCore/src/icons/assets/desktop/icon-doc-word.png");
var iconExcel = __webpack_require__("../ShareWebCore/src/icons/assets/desktop/icon-doc-excel.png");
var iconPPT = __webpack_require__("../ShareWebCore/src/icons/assets/desktop/icon-doc-ppt.png");
var iconPDF = __webpack_require__("../ShareWebCore/src/icons/assets/desktop/icon-doc-pdf.png");
var iconTXT = __webpack_require__("../ShareWebCore/src/icons/assets/desktop/icon-doc-txt.png");
var iconIMG = __webpack_require__("../ShareWebCore/src/icons/assets/desktop/icon-doc-image.png");
var iconArchive = __webpack_require__("../ShareWebCore/src/icons/assets/desktop/icon-doc-archive.png");
var iconVideo = __webpack_require__("../ShareWebCore/src/icons/assets/desktop/icon-doc-video.png");
var iconAudio = __webpack_require__("../ShareWebCore/src/icons/assets/desktop/icon-doc-audio.png");
var iconExe = __webpack_require__("../ShareWebCore/src/icons/assets/desktop/icon-doc-exe.png");
var iconFile = __webpack_require__("../ShareWebCore/src/icons/assets/desktop/icon-doc-file.png");
var iconCAD = __webpack_require__("../ShareWebCore/src/icons/assets/desktop/icon-cad-file.png");
var iconPSD = __webpack_require__("../ShareWebCore/src/icons/assets/desktop/icon-doc-psd.png");
var iconVisio = __webpack_require__("../ShareWebCore/src/icons/assets/desktop/icon-doc-visio.png");
var iconHTML = __webpack_require__("../ShareWebCore/src/icons/assets/desktop/icon-doc-html.png");
var iconViewMobile = __webpack_require__("../ShareWebCore/src/icons/assets/mobile/icon-doc-view.png");
var iconDirMobile = __webpack_require__("../ShareWebCore/src/icons/assets/mobile/icon-doc-dir.png");
var iconWordMobile = __webpack_require__("../ShareWebCore/src/icons/assets/mobile/icon-doc-word.png");
var iconExcelMobile = __webpack_require__("../ShareWebCore/src/icons/assets/mobile/icon-doc-excel.png");
var iconPPTMobile = __webpack_require__("../ShareWebCore/src/icons/assets/mobile/icon-doc-ppt.png");
var iconPDFMobile = __webpack_require__("../ShareWebCore/src/icons/assets/mobile/icon-doc-pdf.png");
var iconTXTMobile = __webpack_require__("../ShareWebCore/src/icons/assets/mobile/icon-doc-txt.png");
var iconIMGMobile = __webpack_require__("../ShareWebCore/src/icons/assets/mobile/icon-doc-image.png");
var iconArchiveMobile = __webpack_require__("../ShareWebCore/src/icons/assets/mobile/icon-doc-archive.png");
var iconVideoMobile = __webpack_require__("../ShareWebCore/src/icons/assets/mobile/icon-doc-video.png");
var iconAudioMobile = __webpack_require__("../ShareWebCore/src/icons/assets/mobile/icon-doc-audio.png");
var iconExeMobile = __webpack_require__("../ShareWebCore/src/icons/assets/mobile/icon-doc-exe.png");
var iconFileMobile = __webpack_require__("../ShareWebCore/src/icons/assets/mobile/icon-doc-file.png");
var iconCADMobile = __webpack_require__("../ShareWebCore/src/icons/assets/mobile/icon-cad-file.png");
/**
 * 获取扩展名对应图标
 * @param doc 文档对象
 * @return 返回Icon组件
 */
function getIcon(doc, _a) {
    var _b = (_a === void 0 ? {} : _a).size, size = _b === void 0 ? 32 : _b;
    if (entrydoc_1.isTopView(doc)) {
        return React.createElement(ui_desktop_1["default"], { size: size, url: iconView });
    }
    else if (docs_1.isDir(doc)) {
        return React.createElement(ui_desktop_1["default"], { size: size, url: iconDir });
    }
    else {
        switch (extension_1.findType(docs_1.docname(doc))) {
            case 'WORD':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconWord });
            case 'EXCEL':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconExcel });
            case 'PPT':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconPPT });
            case 'PDF':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconPDF });
            case 'TXT':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconTXT });
            case 'IMG':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconIMG });
            case 'ARCHIVE':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconArchive });
            case 'VIDEO':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconVideo });
            case 'AUDIO':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconAudio });
            case 'EXE':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconExe });
            case 'CAD':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconCAD });
            case 'PSD':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconPSD });
            case 'VISIO':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconVisio });
            case 'HTML':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconHTML });
            default:
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconFile });
        }
    }
}
exports.getIcon = getIcon;
/**
 * 获取扩展名对应移动端图标
 * @param record 文档对象
 * @return 返回Icon组件
 */
function getMobileIcon(doc, _a) {
    var _b = (_a === void 0 ? {} : _a).size, size = _b === void 0 ? '1rem' : _b;
    if (entrydoc_1.isTopView(doc)) {
        return React.createElement(ui_desktop_1["default"], { size: size, url: iconViewMobile });
    }
    else if (docs_1.isDir(doc)) {
        return React.createElement(ui_desktop_1["default"], { size: size, url: iconDirMobile });
    }
    else {
        switch (extension_1.findType(docs_1.docname(doc))) {
            case 'WORD':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconWordMobile });
            case 'EXCEL':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconExcelMobile });
            case 'PPT':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconPPTMobile });
            case 'PDF':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconPDFMobile });
            case 'TXT':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconTXTMobile });
            case 'IMG':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconIMGMobile });
            case 'ARCHIVE':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconArchiveMobile });
            case 'VIDEO':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconVideoMobile });
            case 'AUDIO':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconAudioMobile });
            case 'EXE':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconExeMobile });
            case 'CAD':
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconCADMobile });
            default:
                return React.createElement(ui_desktop_1["default"], { size: size, url: iconFileMobile });
        }
    }
}
exports.getMobileIcon = getMobileIcon;
exports.createSharedContext = function (ConsumerComponent) {
    var context;
    return {
        Provider: /** @class */ (function (_super) {
            __extends(class_1, _super);
            function class_1() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            class_1.prototype.componentDidMount = function () {
                context = this.props;
            };
            class_1.prototype.componentWillReceiveProps = function (next) {
                context = next;
            };
            class_1.prototype.render = function () {
                return this.props.children;
            };
            return class_1;
        }(React.Component)),
        Consumer: function (_a) {
            var children = _a.children;
            return (React.createElement(ConsumerComponent, __assign({}, context), children));
        }
    };
};
exports.ClientComponentContext = exports.createSharedContext(function (_a) {
    var children = _a.children, froozen = _a.froozen;
    return (React.createElement("div", null,
        children,
        froozen ? (React.createElement("div", { style: {
                position: 'absolute',
                top: 0,
                bottom: 0,
                left: 0,
                right: 0,
                backgroundColor: '#FFF',
                opacity: 0.5
            } })) : null));
});


/***/ }),

/***/ "../ShareWebComponents/src/i18n.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var I18NFactory_1 = __webpack_require__("../ShareWebUtil/src/I18NFactory/index.ts");
var browser_1 = __webpack_require__("../ShareWebUtil/src/browser/index.ts");
/**
 * 导出i18n实例
 */
exports["default"] = I18NFactory_1["default"]({
    translations: ['zh-cn', 'zh-tw', 'en-us'],
    locale: browser_1.envLanguage()
});


/***/ }),

/***/ "../ShareWebComponents/src/styles.desktop.css":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin
module.exports = {"warningHeader":"_-ShareWebComponents-src-styles-desktop---warningHeader","warningContent":"_-ShareWebComponents-src-styles-desktop---warningContent","warningFooter":"_-ShareWebComponents-src-styles-desktop---warningFooter"};

/***/ }),

/***/ "../ShareWebComponents/src/styles.mobile.css":
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin
module.exports = {"warningHeader":"_-ShareWebComponents-src-styles-mobile---warningHeader","warningContent":"_-ShareWebComponents-src-styles-mobile---warningContent","warningFooter":"_-ShareWebComponents-src-styles-mobile---warningFooter"};

/***/ }),

/***/ "../ShareWebComponents/src/webcomponent.tsx":
/***/ (function(module, exports, __webpack_require__) {

/// <reference path="./webcomponent.d.ts" />
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
exports.__esModule = true;
var React = __webpack_require__("../node_modules/react/react.js");
var ReactDOM = __webpack_require__("../node_modules/react-dom/index.js");
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var WebComponent = /** @class */ (function (_super) {
    __extends(WebComponent, _super);
    function WebComponent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * 销毁组件
     */
    WebComponent.prototype.destroy = function () {
        if (!lodash_1.isFunction(this.props.beforeDestroy) || this.props.beforeDestroy() !== false) {
            var dom = ReactDOM.findDOMNode(this);
            var container = dom ? dom.parentNode : null;
            if (lodash_1.isFunction(this.componentWillUnmount)) {
                this.componentWillUnmount();
            }
            if (container) {
                ReactDOM.unmountComponentAtNode(container);
            }
        }
    };
    return WebComponent;
}(React.Component));
exports["default"] = WebComponent;


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/audit/audit.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 获取我的共享申请
 */
exports.getApplys = function (_a, options) {
    var type = (_a === void 0 ? { type: 0 } : _a).type;
    return openapi_1.eachttp('audit', 'getapplys', { type: type }, options);
};
/**
 * 获取待审核的共享申请
 */
exports.getPendingApprovals = function (_a, options) {
    var type = (_a === void 0 ? { type: 0 } : _a).type;
    return openapi_1.eachttp('audit', 'getpendingapprovals', { type: type }, options);
};
/**
 * 获取待审核的共享申请数(只针对特定客户有效，数据库中用户名需要有后缀：@csic719.net)
 */
exports.getPendingApprovalsCount = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('audit', 'getpendingapprovalscount', {}, options);
};
/**
 *获取待审流程信息
 */
exports.getDocApprovals = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('audit', 'getdocapprovals', {}, options);
};
/**
 *获取所有流程信息
 */
exports.getDocProcesses = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('audit', 'getdocprocesses', {}, options);
};
/**
 *发起流程申请
 */
exports.publishDoc = function (_a, options) {
    var processid = _a.processid, docid = _a.docid, applymsg = _a.applymsg, recipients = _a.recipients, recvareaid = _a.recvareaid, dstdocname = _a.dstdocname;
    return openapi_1.eachttp('audit', 'publishdoc', { processid: processid, docid: docid, applymsg: applymsg, recipients: recipients, recvareaid: recvareaid, dstdocname: dstdocname }, options);
};
/**
 *获取申请中的流程信息
 */
exports.getDocApplys = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('audit', 'getdocapplys', {}, options);
};
/**
 *获取流程申请历史总数量
 */
exports.getApplyHistoryCount = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('audit', 'getapplyhistorycount', {}, options);
};
/**
 *获取流程申请历史
 */
exports.getApplyHistory = function (_a, options) {
    var start = _a.start, limit = _a.limit;
    return openapi_1.eachttp('audit', 'getapplyhistory', { start: start, limit: limit }, options);
};
/**
 *获取流程审核历史总数量
 */
exports.getApproveHistoryCount = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('audit', 'getapprovehistorycount', {}, options);
};
/**
 *获取流程审核历史
 */
exports.getApproveHistory = function (_a, options) {
    var start = _a.start, limit = _a.limit;
    return openapi_1.eachttp('audit', 'getapprovehistory', { start: start, limit: limit }, options);
};
/**
 *获取共享申请历史数量
 */
exports.getShareApplyHistoryCount = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('audit', 'getshareapplyhistorycount', {}, options);
};
/**
 *获取共享申请历史
 */
exports.getShareApplyHistory = function (_a, options) {
    var start = _a.start, limit = _a.limit, type = _a.type;
    return openapi_1.eachttp('audit', 'getshareapplyhistory', { start: start, limit: limit, type: type }, options);
};
/**
 *获取共享审核历史数
 */
exports.getShareApproveHistoryCount = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('audit', 'getshareapprovehistorycount', {}, options);
};
/**
 *获取共享审核历史
 */
exports.getShareApproveHistory = function (_a, options) {
    var _b = _a === void 0 ? { start: 0, limit: -1, type: 0 } : _a, start = _b.start, limit = _b.limit, type = _b.type;
    return openapi_1.eachttp('audit', 'getshareapprovehistory', { start: start, limit: limit, type: type }, options);
};
/**
 * 共享审核
 */
exports.approve = function (applyid, result, msg, options) {
    return openapi_1.eachttp('audit', 'approve', { applyid: applyid, result: result, msg: msg }, options);
};
/**
 * 流程审核
 */
exports.approveDoc = function (applyid, result, auditmsg, options) {
    return openapi_1.eachttp('audit', 'approvedoc', { applyid: applyid, result: result, auditmsg: auditmsg }, options);
};
/**
 * 获取待审核的条目
 */
exports.getpendingapprovalscounts = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('audit', 'getpendingapprovalscounts', {}, options);
};
/**
 * 获取接收站点信息
 */
exports.getDocRecvArea = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('audit', 'getdocrecvarea', {}, options);
};
/**
 * 搜索目标文档库名
 */
exports.searchDstDocname = function (recvareaid, key, start, limit, options) {
    return openapi_1.eachttp('audit', 'searchdstdocname', { recvareaid: recvareaid, key: key, start: start, limit: limit }, options);
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/auth/auth.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 获取服务器时间
 */
exports.servertime = function (options) {
    return openapi_1.eachttp('auth', 'servertime', {}, options);
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/auth1/auth1.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 获取服务器配置信息
 */
exports.getConfig = openapi_1.CacheableOpenAPIFactory(openapi_1.eachttp, 'auth1', 'getconfig', { expires: 60 * 1000 }).bind(null, null, { userid: null, tokenid: null });
/**
 * 获取OAuth信息
 */
exports.getOAuthInfo = openapi_1.CacheableOpenAPIFactory(openapi_1.eachttp, 'auth1', 'getoauthinfo', { expires: 60 * 1000 }).bind(null, null, { userid: null, tokenid: null });
/**
 * 认证用户
 */
exports.getNew = function (_a) {
    var account = _a.account, _b = _a.deviceinfo, name = _b.name, ostype = _b.ostype, version = _b.version, devicetype = _b.devicetype, udid = _b.udid, password = _a.password, vcodeinfo = _a.vcodeinfo;
    return openapi_1.eachttp('auth1', 'getnew', { account: account, deviceinfo: { name: name, ostype: ostype, version: version, devicetype: devicetype, udid: udid }, password: password, vcodeinfo: vcodeinfo }, { userid: null, tokenid: null });
};
/**
 * 登录（使用第三方凭证）
 */
exports.getByThirdParty = function (_a) {
    var thirdpartyid = _a.thirdpartyid, params = _a.params, _b = _a.deviceinfo, name = _b.name, ostype = _b.ostype, devicetype = _b.devicetype, udid = _b.udid;
    return openapi_1.eachttp('auth1', 'getbythirdparty', { thirdpartyid: thirdpartyid, params: params, deviceinfo: { name: name, ostype: ostype, devicetype: devicetype, udid: udid } }, { userid: null, tokenid: null });
};
/**
 * 登录（西电ticket）
 */
exports.getByTicket = function (_a) {
    var ticket = _a.ticket, service = _a.service;
    return openapi_1.eachttp('auth1', 'getbyticket', { ticket: ticket, service: service }, { userid: null, tokenid: null });
};
/**
 * 登录（使用windows登录凭据）
 */
exports.getByADSession = function (_a) {
    var adsession = _a.adsession;
    return openapi_1.eachttp('auth1', 'getbyadsession', { adsession: adsession }, { userid: null, tokenid: null });
};
/**
 * 信任的第三方应用appid登录
 */
exports.extLoginClient = function (_a) {
    var account = _a.account, appid = _a.appid, key = _a.key;
    return openapi_1.eachttp('auth1', 'extloginclient', { account: account, appid: appid, key: key }, { userid: null, tokenid: null });
};
/**
 * 登录web(信任的第三方应用appid登录)
 */
exports.extLoginWeb = function (_a) {
    var account = _a.account, appid = _a.appid, key = _a.key;
    return openapi_1.eachttp('auth1', 'extloginweb', { account: account, appid: appid, key: key }, { userid: null, tokenid: null });
};
/**
 * 登录外部应用（集成到anyshare）
 */
exports.getExtAppInfo = function (_a) {
    var apptype = _a.apptype, params = _a.params;
    return openapi_1.eachttp('auth1', 'getextappinfo', { apptype: apptype, params: params });
};
/**
 * 刷新身份凭证有效期
 */
exports.refreshToken = function (_a) {
    var userid = _a.userid, tokenid = _a.tokenid, expirestype = _a.expirestype;
    return openapi_1.eachttp('auth1', 'refreshtoken', { userid: userid, tokenid: tokenid, expirestype: expirestype });
};
/**
 * 回收身份凭证
 */
exports.revokeToken = function (_a) {
    var tokenid = _a.tokenid;
    return openapi_1.eachttp('auth1', 'revoketoken', { tokenid: tokenid });
};
/**
 * 修改用户密码
 */
exports.modifyPassword = function (_a, _b) {
    var account = _a.account, oldpwd = _a.oldpwd, newpwd = _a.newpwd, vcodeinfo = _a.vcodeinfo;
    var sign = _b.sign;
    return openapi_1.eachttp('auth1', 'modifypassword', { account: account, oldpwd: oldpwd, newpwd: newpwd, vcodeinfo: vcodeinfo }, { sign: sign, userid: null, tokenid: null });
};
/**
 * 本地登出
 */
exports.logout = function (_a, options) {
    var ostype = _a.ostype, timeout_auto_logout = _a.timeout_auto_logout;
    return openapi_1.eachttp('auth1', 'logout', { ostype: ostype, timeout_auto_logout: timeout_auto_logout }, options);
};
/**
 * 二次验证
 */
exports.validateSecurityDevice = function (_a) {
    var thirdpartyid = _a.thirdpartyid, _b = _a.params, account = _b.account, key = _b.key;
    return openapi_1.eachttp('auth1', 'validatesecuritydevice', { thirdpartyid: thirdpartyid, params: { account: account, key: key } });
};
/**
 * PC客户端卸载输入口令
 */
exports.checkUninstallPwd = function (_a) {
    var uninstallpwd = _a.uninstallpwd;
    return openapi_1.eachttp('auth1', 'checkuninstallpwd', { uninstallpwd: uninstallpwd });
};
/**
 * 获取验证码
 */
exports.getVcode = function (_a) {
    var uuid = _a.uuid;
    return openapi_1.eachttp('auth1', 'getvcode', { uuid: uuid });
};
/**
 * 获取验证码
 */
exports.sendsMS = function (_a) {
    var account = _a.account, password = _a.password, tel_number = _a.tel_number;
    return openapi_1.eachttp('auth1', 'sendsms', { account: account, password: password, tel_number: tel_number });
};
/**
 * 获取验证码
 */
exports.smsActivate = function (_a) {
    var account = _a.account, password = _a.password, tel_number = _a.tel_number, mail_address = _a.mail_address, verify_code = _a.verify_code;
    return openapi_1.eachttp('auth1', 'smsactivate', { account: account, password: password, tel_number: tel_number, mail_address: mail_address, verify_code: verify_code });
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/auth1/index.ts":
/***/ (function(module, exports, __webpack_require__) {

function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
exports.__esModule = true;
__export(__webpack_require__("../ShareWebCore/src/apis/eachttp/auth1/auth1.ts"));


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/auth2/auth2.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 登录
 */
exports.login = function (_a, options) {
    var _b = _a === void 0 ? { params: {} } : _a, _c = _b.grant_type, grant_type = _c === void 0 ? 'anyshare_plain' : _c, _d = _b.token_type, token_type = _d === void 0 ? 'short-lived' : _d, params = _b.params;
    return openapi_1.eachttp('auth2', 'login', { grant_type: grant_type, token_type: token_type, params: params }, { userid: null, tokenid: null });
};
/**
 * 获取新的token
 */
exports.refresh = function (_a, options) {
    var refresh_token = _a.refresh_token;
    return openapi_1.eachttp('auth2', 'refresh', { refresh_token: refresh_token }, { userid: null, tokenid: null });
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/autolock/autolock.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 锁定文件
 */
exports.lock = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('autolock', 'lock', { docid: docid }, options);
};
/**
 * 尝试锁定文件
 */
exports.trylock = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('autolock', 'trylock', { docid: docid }, options);
};
/**
 * 刷新文件锁
 */
exports.refresh = function (_a, options) {
    var lockinfos = _a.lockinfos;
    return openapi_1.eachttp('autolock', 'refresh', { lockinfos: lockinfos }, options);
};
/**
 * 解锁
 */
exports.unlock = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('autolock', 'unlock', { docid: docid }, options);
};
/**
 * 获取文件锁信息
 */
exports.getLockInfo = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('autolock', 'getlockinfo', { docid: docid }, options);
};
/**
 * 获取文件夹锁信息
 */
exports.getDirLockInfo = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('autolock', 'getdirlockinfo', { docid: docid }, options);
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/ca/ca.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 获取CA信息
 */
exports.get = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('ca', 'get', {}, { userid: null, tokenid: null });
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/config/config.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 获取配置信息
 */
exports.get = openapi_1.CacheableOpenAPIFactory(openapi_1.eachttp, 'config', 'get', { expires: 60 * 1000 }).bind(null, null, { userid: null, tokenid: null });
/**
 * 获取OEM配置
 */
exports.getOemConfigBySection = lodash_1.curryRight(openapi_1.CacheableOpenAPIFactory(openapi_1.eachttp, 'config', 'getoemconfigbysection', { expires: 60 * 1000 }))({ userid: null, tokenid: null });
/**
 * 获取水印配置
 */
exports.getDocWatermarkConfig = openapi_1.CacheableOpenAPIFactory(openapi_1.eachttp, 'config', 'getdocwatermarkconfig', { expires: 60 * 1000 }).bind(null, null, { userid: null, tokenid: null });
/**
 * 获取OfficeOnline配置
 */
exports.getSiteOfficeOnLineInfo = lodash_1.curryRight(openapi_1.CacheableOpenAPIFactory(openapi_1.eachttp, 'config', 'getsiteofficeonlineinfo', { expires: 60 * 1000 }))({ userid: null, tokenid: null });


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/config/index.ts":
/***/ (function(module, exports, __webpack_require__) {

function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
exports.__esModule = true;
__export(__webpack_require__("../ShareWebCore/src/apis/eachttp/config/config.ts"));


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/contact/contact.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 获取所有联系人分组
 */
exports.getGroups = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('contactor', 'getgroups', {}, options);
};
/**
 * 获取分组下所有联系人
 */
exports.get = function (_a, options) {
    var groupid = _a.groupid;
    return openapi_1.eachttp('contactor', 'get', { groupid: groupid }, options);
};
/**
 * 在联系人组搜索用户和联系人组信息
 */
exports.search = function (_a, options) {
    var key = _a.key, start = _a.start, limit = _a.limit;
    return openapi_1.eachttp('contactor', 'search', { key: key, start: start, limit: limit }, options);
};
/**
 * 新建联系人分组
 */
exports.addGroup = function (_a, options) {
    var groupname = _a.groupname;
    return openapi_1.eachttp('contactor', 'addgroup', { groupname: groupname }, options);
};
/**
 * 编辑联系人分组
 */
exports.editGroup = function (_a, options) {
    var groupid = _a.groupid, newname = _a.newname;
    return openapi_1.eachttp('contactor', 'editgroup', { groupid: groupid, newname: newname }, options);
};
/**
 * 删除联系人分组
 */
exports.deleteGroup = function (_a, options) {
    var groupid = _a.groupid;
    return openapi_1.eachttp('contactor', 'deletegroup', { groupid: groupid }, options);
};
/**
 * 添加联系人到指定分组
 */
exports.addPersons = function (_a, options) {
    var groupid = _a.groupid, userids = _a.userids;
    return openapi_1.eachttp('contactor', 'addpersons', { groupid: groupid, userids: userids }, options);
};
/**
 * 删除指定联系人
 */
exports.deletePersons = function (_a, options) {
    var groupid = _a.groupid, userids = _a.userids;
    return openapi_1.eachttp('contactor', 'deletepersons', { groupid: groupid, userids: userids }, options);
};
/**
 * 获取分组下所有联系人
 */
exports.getPersons = function (_a, options) {
    var groupid = _a.groupid, start = _a.start, limit = _a.limit;
    return openapi_1.eachttp('contactor', 'getpersons', { groupid: groupid, start: start, limit: limit }, options);
};
/**
 * 搜索联系人
 */
exports.searchPersons = function (_a, options) {
    var key = _a.key;
    return openapi_1.eachttp('contactor', 'searchpersons', { key: key }, options);
};
/**
 * 搜索联系人组获取搜索数目
 */
exports.searchCount = function (_a, options) {
    var key = _a.key;
    return openapi_1.eachttp('contactor', 'searchcount', { key: key }, options);
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/department/department.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 获取用户所能访问的根部门信息
 */
exports.getRoots = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('department', 'getroots', {}, options);
};
/**
 * 获取子部门信息
 */
exports.getSubDeps = function (_a, options) {
    var depid = _a.depid;
    return openapi_1.eachttp('department', 'getsubdeps', { depid: depid }, options);
};
/**
 * 获取部门下的子用户信息
 */
exports.getSubUsers = function (_a, options) {
    var depid = _a.depid;
    return openapi_1.eachttp('department', 'getsubusers', { depid: depid }, options);
};
/**
 * 在组织下搜索用户和部门信息
 */
exports.search = function (_a, options) {
    var key = _a.key, start = _a.start, limit = _a.limit;
    return openapi_1.eachttp('department', 'search', { key: key, start: start, limit: limit }, options);
};
/**
 * 搜索组织架构获取搜索条目
 */
exports.searchCount = function (_a, options) {
    var key = _a.key;
    return openapi_1.eachttp('department', 'searchcount', { key: key }, options);
};
/**
 * 获取部门完整路径
 */
exports.getBasicInfo = function (_a, options) {
    var depid = _a.depid;
    return openapi_1.eachttp('department', 'getbasicinfo', { depid: depid }, options);
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/device/device.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 获取所有设备信息
 */
exports.list = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('device', 'list', {}, options);
};
/**
 * 禁用设备
 */
exports.disable = function (_a, options) {
    var udid = _a.udid;
    return openapi_1.eachttp('device', 'disable', { udid: udid }, options);
};
/**
 * 启用设备
 */
exports.enable = function (_a, options) {
    var udid = _a.udid;
    return openapi_1.eachttp('device', 'enable', { udid: udid }, options);
};
/**
 * 擦出缓存
 */
exports.erase = function (_a, options) {
    var udid = _a.udid;
    return openapi_1.eachttp('device', 'erase', { udid: udid }, options);
};
/**
 * 获取设备状态（mobile）
 */
exports.getStatus = function (_a, options) {
    var udid = _a.udid;
    return openapi_1.eachttp('device', 'getstatus', { udid: udid }, options);
};
/**
 * 通知anyshare缓存擦除成功（mobile）
 */
exports.onEraseSuc = function (_a, options) {
    var udid = _a.udid;
    return openapi_1.eachttp('device', 'onerasesuc', { udid: udid }, options);
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/entrydoc/entrydoc.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 获取入口文档
 */
exports.get = openapi_1.CacheableOpenAPIFactory(openapi_1.eachttp, 'entrydoc', 'get');
/**
 * 根据文档类型获取入口文档
 */
exports.getByType = openapi_1.CacheableOpenAPIFactory(openapi_1.eachttp, 'entrydoc', 'getbytype');
/**
 * 获取顶层文档入口视图
 */
exports.getViews = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('entrydoc', 'getviews', null, options);
};
/**
 * 获取文档类型
 */
exports.getDocType = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('entrydoc', 'getdoctype', { docid: docid }, options);
};
/**
 * 退出入口文档
 */
exports.quit = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('entrydoc', 'quit', { docid: docid }, options);
};
/**
 * 加入入口文档
 */
exports.join = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('entrydoc', 'join', { docid: docid }, options);
};
/**
 * 获取已退出的入口文档
 */
exports.getQuitInfos = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('entrydoc', 'getquitinfos', {}, options);
};
/**
 * 获取入口文档信息（根据文档ID）
 */
exports.getByDocId = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('entrydoc', 'getbydocid', { docid: docid }, options);
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/entrydoc/index.ts":
/***/ (function(module, exports, __webpack_require__) {

function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
exports.__esModule = true;
__export(__webpack_require__("../ShareWebCore/src/apis/eachttp/entrydoc/entrydoc.ts"));


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/finder/finder.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 获取文档发现状态
 */
exports.getStatus = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('finder', 'getstatus', { docid: docid }, options);
};
/**
 * 开启文档发现状态
 */
exports.enable = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('finder', 'enable', { docid: docid }, options);
};
/**
 * 关闭文档发现状态
 */
exports.disable = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('finder', 'disable', { docid: docid }, options);
};
/**
 * 获取用户开启发现的文档
 */
exports.getEnabled = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('finder', 'getenabled', {}, options);
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/groupdoc/groupdoc.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 删除群组
 */
exports.del = function (_a) {
    var docid = _a.docid;
    return openapi_1.eachttp('groupdoc', 'delete', { docid: docid });
};
/**
 * 新建群组
 */
exports.add = function (_a) {
    var name = _a.name, quota = _a.quota;
    return openapi_1.eachttp('groupdoc', 'add', { name: name, quota: quota });
};
/**
 * 编辑群组名称
 */
exports.edit = function (_a) {
    var docid = _a.docid, name = _a.name;
    return openapi_1.eachttp('groupdoc', 'edit', { docid: docid, name: name });
};
/**
 * 编辑群组配额
 */
exports.editQuota = function (_a) {
    var docid = _a.docid, quota = _a.quota;
    return openapi_1.eachttp('groupdoc', 'editquota', { docid: docid, quota: quota });
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/invitation/invitation.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 打开邀请链接
 */
exports.open = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('invitation', 'open', { docid: docid }, options);
};
/**
 * 设置共享邀请基本信息
 */
exports.setBaseInfo = function (_a, options) {
    var docid = _a.docid, invitationendtime = _a.invitationendtime, perm = _a.perm, permendtime = _a.permendtime;
    return openapi_1.eachttp('invitation', 'setbaseinfo', { docid: docid, invitationendtime: invitationendtime, perm: perm, permendtime: permendtime }, options);
};
/**
 * 设置共享邀请备注信息
 */
exports.setNoteInfo = function (_a, options) {
    var docid = _a.docid, image = _a.image, description = _a.description;
    return openapi_1.eachttp('invitation', 'setnoteinfo', { docid: docid, image: image, description: description }, options);
};
/**
 * 根据文档id获取共享邀请基本信息
 */
exports.getBaseInfoByDocId = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('invitation', 'getbaseinfobydocid', { docid: docid }, options);
};
/**
 * 根据文档id获取图片备注信息
 */
exports.getNoteInfoByDocId = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('invitation', 'getnoteinfobydocid', { docid: docid }, options);
};
/**
 * 关闭共享邀请
 */
exports.close = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('invitation', 'close', { docid: docid }, options);
};
/**
 * 根据InvitationId 根据文档id获取共享邀请所有信息
 */
exports.get = function (_a, options) {
    var invitationid = _a.invitationid;
    return openapi_1.eachttp('invitation', 'get', { invitationid: invitationid }, { userid: null, tokenid: null });
};
/**
 * 加入群组
 */
exports.join = function (_a, options) {
    var invitationid = _a.invitationid;
    return openapi_1.eachttp('invitation', 'join', { invitationid: invitationid }, options);
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/managedoc/managedoc.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 获取用户管理的文档
 */
exports.get = function () {
    return openapi_1.eachttp('managedoc', 'get', {});
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/message/message.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 外链发送邮件
 */
exports.sendMail = function (_a, options) {
    var mailto = _a.mailto, subject = _a.subject, content = _a.content;
    return openapi_1.eachttp('message', 'sendmail', { mailto: mailto, subject: subject, content: content }, options);
};
/**
 * 获取消息通知
 */
exports.get = function (_a, options) {
    var stamp = _a.stamp;
    return openapi_1.eachttp('message', 'get', { stamp: stamp }, options);
};
/**
 * 确认消息已读
 */
exports.read2 = function (_a, options) {
    var msgids = _a.msgids;
    return openapi_1.eachttp('message', 'read2', { msgids: msgids }, options);
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/owner/owner.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 检查是否文档id的所有者
 */
exports.check = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('owner', 'check', { docid: docid }, options);
};
/**
 * 添加所有者（永久有效）
 */
exports.addByEndTime = function (_a, options) {
    var docid = _a.docid, userids = _a.userids;
    return openapi_1.eachttp('owner', 'addbyendtime', { docid: docid, userids: userids }, options);
};
/**
 * 获取所有者信息
 */
exports.get = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('owner', 'get', { docid: docid }, options);
};
/**
 * 删除所有者
 */
exports.del = function (_a, options) {
    var docid = _a.docid, userids = _a.userids;
    return openapi_1.eachttp('owner', 'delete', { docid: docid, userids: userids }, options);
};
/**
 *批量设置所有者
 */
exports.set = function (_a, options) {
    var docid = _a.docid, userconfigs = _a.userconfigs;
    return openapi_1.eachttp('owner', 'set', { docid: docid, userconfigs: userconfigs }, options);
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/perm/perm.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 检查单个权限
 */
exports.check = function (_a, options) {
    var docid = _a.docid, perm = _a.perm, userid = _a.userid;
    return openapi_1.eachttp('perm1', 'check', { docid: docid, perm: perm, userid: userid }, options);
};
/**
 * 获取权限配置信息
 */
exports.get = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('perm1', 'get', { docid: docid }, options);
};
/**
 * 批量设置权限
 */
exports.set = function (_a, options) {
    var docid = _a.docid, permconfigs = _a.permconfigs;
    return openapi_1.eachttp('perm1', 'set', { docid: docid, permconfigs: permconfigs }, options);
};
/**
 * 获取内链共享模板
 */
exports.getInternalLinkTemplate = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('perm1', 'getinternallinktemplate', {}, options);
};
/**
 * 获取外链共享模板
 */
exports.getExternalLinkTemplate = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('perm1', 'getexternallinktemplate', {}, options);
};
/**
 * 获取各访问者的最终权限
 */
exports.list = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.eachttp('perm1', 'list', { docid: docid }, options);
};
/**
 * 添加权限配置
 */
exports.add = function (_a, options) {
    var docid = _a.docid, permconfigs = _a.permconfigs;
    return openapi_1.eachttp('perm1', 'add', { docid: docid, permconfigs: permconfigs }, options);
};
/**
 * 编辑权限配置
 */
exports.edit = function (_a, options) {
    var docid = _a.docid, permconfigs = _a.permconfigs;
    return openapi_1.eachttp('perm1', 'edit', { docid: docid, permconfigs: permconfigs }, options);
};
/**
 * 删除权限配置
 */
exports.del = function (_a, options) {
    var docid = _a.docid, permids = _a.permids;
    return openapi_1.eachttp('perm1', 'delete', { docid: docid, permids: permids }, options);
};
/**
 * 检查所有权限
 */
exports.checkAll = function (_a, options) {
    var docid = _a.docid, userid = _a.userid;
    return openapi_1.eachttp('perm1', 'checkall', { docid: docid, userid: userid }, options);
};
/**
 * 获取用户已共享的文档
 */
exports.getShared = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('perm1', 'getshared', {}, options);
};
/**
 * 获取共享文档开关配置
 */
exports.getShareDocConfig = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('perm1', 'getsharedocconfig', {}, options);
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/pki/pki.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 获取original
 */
exports.original = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('pki', 'original', {}, { userid: null, tokenid: null });
};
/**
 * 使用PKI认证
 */
exports.authen = function (_a, options) {
    var original = _a.original, detach = _a.detach;
    return openapi_1.eachttp('pki', 'authen', { original: original, detach: detach }, { userid: null, tokenid: null });
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/quota/quota.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 获取用户配额
 */
exports.getUserQuota = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('quota', 'getuserquota', {}, options);
};
/**
 * 获取cid路径获取配额信息
 */
exports.getByCid = function (_a, options) {
    var cid = _a.cid;
    return openapi_1.eachttp('quota', 'getbycid', { cid: cid }, options);
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/redirect/redirect.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 获取地址信息
 * @return 返回地址信息
 */
exports.getHostInfo = openapi_1.CacheableOpenAPIFactory(openapi_1.eachttp, 'redirect', 'gethostinfo', { expires: 60 * 1000 }).bind(null, null, { userid: null, tokenid: null });


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/update/update.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 检查客户端是否需要更新
 */
exports.check = function (_a) {
    var platform = _a.platform, arch = _a.arch, version = _a.version, softwaretype = _a.softwaretype;
    return openapi_1.eachttp('update', 'check', { platform: platform, arch: arch, version: version, softwaretype: softwaretype });
};
/**
 * 下载客户端
 */
exports.download = function (_a) {
    var osType = _a.osType, reqhost = _a.reqhost, usehttps = _a.usehttps;
    return openapi_1.eachttp('update', 'download', { osType: osType, reqhost: reqhost, usehttps: usehttps }, { userid: null, tokenid: null });
};


/***/ }),

/***/ "../ShareWebCore/src/apis/eachttp/user/user.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 获取用户信息
 */
exports.get = openapi_1.CacheableOpenAPIFactory(openapi_1.eachttp, 'user', 'get', { expires: 60 * 1000 });
/**
 * 同意用户使用协议
 */
exports.agreedToTermsOfUse = function (_a, options) {
    _a = {};
    return openapi_1.eachttp('user', 'agreedtotermsofuse', {}, options);
};
/**
 * 修改邮箱
 */
exports.editeMailAddress = function (_a, options) {
    var emailaddress = _a.emailaddress;
    return openapi_1.eachttp('user', 'editemailaddress', { emailaddress: emailaddress }, options);
};
/**
 * 编辑用户信息
 */
exports.edit = function (_a, options) {
    var emailaddress = _a.emailaddress, displayname = _a.displayname;
    return openapi_1.eachttp('user', 'edit', { emailaddress: emailaddress, displayname: displayname }, options);
};
/**
   * 获取用户基本信息包括所属部门的信息
*/
exports.getBasicInfo = function (_a, options) {
    var userid = _a.userid;
    return openapi_1.eachttp('user', 'getbasicinfo', { userid: userid }, options);
};


/***/ }),

/***/ "../ShareWebCore/src/apis/efshttp/dir/dir.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 获取文档目录
 */
exports.list = openapi_1.CacheableOpenAPIFactory(openapi_1.efshttp, 'dir', 'list');
/**
 * 获取目录属性
 */
exports.attribute = openapi_1.CacheableOpenAPIFactory(openapi_1.efshttp, 'dir', 'attribute');
/**
 * 设置目录密级
 */
exports.setCsfLevel = function (_a, options) {
    var docid = _a.docid, csflevel = _a.csflevel;
    return openapi_1.efshttp('dir', 'setcsflevel', { docid: docid, csflevel: csflevel }, options);
};
/**
 * 创建目录
 */
exports.create = function (_a, options) {
    var docid = _a.docid, name = _a.name, ondup = _a.ondup;
    return openapi_1.efshttp('dir', 'create', { docid: docid, name: name, ondup: ondup }, options);
};
/**
 * 创建多级目录
 */
exports.createMultiLevelDir = function (_a, options) {
    var docid = _a.docid, path = _a.path;
    return openapi_1.efshttp('dir', 'createmultileveldir', { docid: docid, path: path }, options);
};
/**
 * 删除目录
 */
exports.del = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.efshttp('dir', 'delete', { docid: docid }, options);
};
/**
 * 重命名目录
 */
exports.rename = function (_a, options) {
    var docid = _a.docid, name = _a.name, ondup = _a.ondup;
    return openapi_1.efshttp('dir', 'rename', { docid: docid, name: name, ondup: ondup }, options);
};
/**
 * 移动目录
 */
exports.move = function (_a, options) {
    var docid = _a.docid, destparent = _a.destparent, ondup = _a.ondup;
    return openapi_1.efshttp('dir', 'move', { docid: docid, destparent: destparent, ondup: ondup }, options);
};
/**
 * 复制目录
 */
exports.copy = function (_a, options) {
    var docid = _a.docid, destparent = _a.destparent, ondup = _a.ondup;
    return openapi_1.efshttp('dir', 'copy', { docid: docid, destparent: destparent, ondup: ondup }, options);
};
/**
 * 复制进度查询
 */
exports.copyProgress = function (_a, options) {
    var id = _a.id;
    return openapi_1.efshttp('dir', 'copyprogress', { id: id }, options);
};
/**
 * 获取目录建议名
 */
exports.getSuggestName = function (_a, options) {
    var docid = _a.docid, name = _a.name;
    return openapi_1.efshttp('dir', 'getsuggestname', { docid: docid, name: name }, options);
};
/**
 * 获取文件夹大小
 */
exports.size = openapi_1.CacheableOpenAPIFactory(openapi_1.efshttp, 'dir', 'size');
/**
 * 检查是否是发件箱协议
 */
exports.isFileoutBox = openapi_1.CacheableOpenAPIFactory(openapi_1.efshttp, 'dir', 'isfileoutbox');
/**
 * 检查目录水印策略
 */
exports.checkWatermark = openapi_1.CacheableOpenAPIFactory(openapi_1.efshttp, 'dir', 'checkwatermark');


/***/ }),

/***/ "../ShareWebCore/src/apis/efshttp/favorites/favorites.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 添加收藏
 */
exports.add = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.efshttp('favorites', 'add', { docid: docid }, options);
};
/**
 * 获取收藏列表
 */
exports.list = openapi_1.CacheableOpenAPIFactory(openapi_1.efshttp, 'favorites', 'list');
/**
 * 删除收藏
 */
exports.del = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.efshttp('favorites', 'delete', { docid: docid }, options);
};
/**
 * 批量查询收藏状态
 */
exports.check = openapi_1.CacheableOpenAPIFactory(openapi_1.efshttp, 'favorites', 'check');


/***/ }),

/***/ "../ShareWebCore/src/apis/efshttp/file/file.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 获取文件属性协议
 */
exports.attribute = openapi_1.CacheableOpenAPIFactory(openapi_1.efshttp, 'file', 'attribute');
/**
 * 视频播放信息
 */
exports.playInfo = function (_a, options) {
    var docid = _a.docid, rev = _a.rev, definition = _a.definition;
    return openapi_1.efshttp('file', 'playinfo', { docid: docid, rev: rev, definition: definition }, options);
};
/**
 * 文档预览
 */
exports.previewOSS = function (_a, options) {
    var docid = _a.docid, rev = _a.rev, type = _a.type, reqhost = _a.reqhost, usehttps = _a.usehttps, watermark = _a.watermark;
    return openapi_1.efshttp('file', 'previewoss', { docid: docid, rev: rev, type: type, reqhost: reqhost, usehttps: usehttps, watermark: watermark }, options);
};
/**
 * 文件下载
 */
exports.OSDownload = function (_a, options) {
    var docid = _a.docid, rev = _a.rev, authtype = _a.authtype, reqhost = _a.reqhost, usehttps = _a.usehttps, savename = _a.savename;
    return openapi_1.efshttp('file', 'osdownload', { docid: docid, rev: rev, authtype: authtype, reqhost: reqhost, usehttps: usehttps, savename: savename }, options);
};
/**
 * 获取元数据
 */
exports.metaData = openapi_1.CacheableOpenAPIFactory(openapi_1.efshttp, 'file', 'metadata');
/**
 * 获取重名冲突对象的建议名称
*/
exports.getSuggestName = function (_a, options) {
    var docid = _a.docid, name = _a.name;
    return openapi_1.efshttp('file', 'getsuggestname', { docid: docid, name: name }, options);
};
/**
 * 正式开始上传前，调用osbeingupload获取上传信息
 */
exports.OSBeginUpload = function (_a, options) {
    var docid = _a.docid, length = _a.length, name = _a.name, client_mtime = _a.client_mtime, ondup = _a.ondup, reqmethod = _a.reqmethod, reqhost = _a.reqhost, usehttps = _a.usehttps, csflevel = _a.csflevel;
    return openapi_1.efshttp('file', 'osbeginupload', { docid: docid, length: length, name: name, client_mtime: client_mtime, ondup: ondup, reqmethod: reqmethod, reqhost: reqhost, usehttps: usehttps, csflevel: csflevel }, options);
};
/**
 * OSS上传完成
 */
exports.OSEndUpload = function (_a, options) {
    var docid = _a.docid, rev = _a.rev, md5 = _a.md5, crc32 = _a.crc32, slice_md5 = _a.slice_md5, csflevel = _a.csflevel;
    return openapi_1.efshttp('file', 'osendupload', { docid: docid, rev: rev, md5: md5, crc32: crc32, slice_md5: slice_md5, csflevel: csflevel }, options);
};
/**
 * 获取外部文件下载
 */
exports.OSDownloadEXT = function (_a, options) {
    var docid = _a.docid, rev = _a.rev, authtype = _a.authtype, reqhost = _a.reqhost, usehttps = _a.usehttps, savename = _a.savename;
    return openapi_1.efshttp('file', 'osdownloadext', { docid: docid, rev: rev, authtype: authtype, reqhost: reqhost, usehttps: usehttps, savename: savename }, options);
};
/**
 * 获取自定义属性值
 */
exports.customAttributeValue = openapi_1.CacheableOpenAPIFactory(openapi_1.efshttp, 'file', 'customattributevalue');
/**
 * 获取文件自定义属性
 */
exports.getFileCustomAttribute = openapi_1.CacheableOpenAPIFactory(openapi_1.efshttp, 'file', 'getfilecustomattribute');
/**
 * 设置文件属性值
 */
exports.setFileCustomAttribute = function (_a, options) {
    var docid = _a.docid, attribute = _a.attribute;
    return openapi_1.efshttp('file', 'setfilecustomattribute', { docid: docid, attribute: attribute }, options);
};
/**
 * 设置文件密级
 */
exports.setCsfLevel = function (_a, options) {
    var docid = _a.docid, csflevel = _a.csflevel;
    return openapi_1.efshttp('file', 'setcsflevel', { docid: docid, csflevel: csflevel }, options);
};
/**
 * 新增标签
 */
exports.addTag = function (_a, options) {
    var docid = _a.docid, tag = _a.tag;
    return openapi_1.efshttp('file', 'addtag', { docid: docid, tag: tag }, options);
};
/**
 *删除标签
 */
exports.deleteTag = function (_a, options) {
    var docid = _a.docid, tag = _a.tag;
    return openapi_1.efshttp('file', 'deletetag', { docid: docid, tag: tag }, options);
};
/**
 * 获取文件点评
 */
exports.getComment = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.efshttp('file', 'getcomment', { docid: docid }, options);
};
/**
 * 提交文件点评
 */
exports.submitComment = function (_a, options) {
    var docid = _a.docid, answertoid = _a.answertoid, score = _a.score, comment = _a.comment;
    return openapi_1.efshttp('file', 'submitcomment', { docid: docid, answertoid: answertoid, score: score, comment: comment }, options);
};
/**
 * 删除文件点评
 */
exports.deleteComment = function (_a, options) {
    var docid = _a.docid, commentid = _a.commentid;
    return openapi_1.efshttp('file', 'deletecomment', { docid: docid, commentid: commentid }, options);
};
/**
 * 删除文件
 */
exports.del = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.efshttp('file', 'delete', { docid: docid }, options);
};
/**
 * 重命名文件
 */
exports.rename = function (_a, options) {
    var docid = _a.docid, name = _a.name, ondup = _a.ondup;
    return openapi_1.efshttp('file', 'rename', { docid: docid, name: name, ondup: ondup }, options);
};
/**
 * 移动文件
 */
exports.move = function (_a, options) {
    var docid = _a.docid, destparent = _a.destparent, ondup = _a.ondup;
    return openapi_1.efshttp('file', 'move', { docid: docid, destparent: destparent, ondup: ondup }, options);
};
/**
 * 复制文件
 */
exports.copy = function (_a, options) {
    var docid = _a.docid, destparent = _a.destparent, ondup = _a.ondup;
    return openapi_1.efshttp('file', 'copy', { docid: docid, destparent: destparent, ondup: ondup }, options);
};
/**
 * 获取应用元数据
 */
exports.getAppmetadata = function (_a, options) {
    var docid = _a.docid, appid = _a.appid;
    return openapi_1.efshttp('file', 'getappmetadata', { docid: docid, appid: appid }, options);
};
/**
 * 转换路径协议
 */
exports.convertPath = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.efshttp('file', 'convertpath', { docid: docid }, options);
};
/**
 * 添加文件多个标签
 */
exports.addTags = function (_a, options) {
    var docid = _a.docid, tags = _a.tags;
    return openapi_1.efshttp('file', 'addtags', { docid: docid, tags: tags }, options);
};
/**
 * 批量下载
 */
exports.batchDownload = function (_a, options) {
    var name = _a.name, reqhost = _a.reqhost, usehttps = _a.usehttps, files = _a.files, dirs = _a.dirs;
    return openapi_1.efshttp('file', 'batchdownload', { name: name, reqhost: reqhost, usehttps: usehttps, files: files, dirs: dirs }, options);
};
/**
 * 大文件切片上传
 */
exports.OSInitMultiUpload = function (_a, options) {
    var docid = _a.docid, length = _a.length, name = _a.name, _b = _a.ondup, ondup = _b === void 0 ? 0 : _b, client_mtime = _a.client_mtime, csflevel = _a.csflevel;
    return openapi_1.efshttp('file', 'osinitmultiupload', { docid: docid, length: length, name: name, ondup: ondup, client_mtime: client_mtime, csflevel: csflevel }, options);
};
/**
 * 文件分片上传完成
 */
exports.OSCompleteUpload = function (_a, options) {
    var partinfo = _a.partinfo, docid = _a.docid, rev = _a.rev, uploadid = _a.uploadid, usehttps = _a.usehttps, reqhost = _a.reqhost;
    return openapi_1.efshttp('file', 'oscompleteupload', { partinfo: partinfo, docid: docid, rev: rev, uploadid: uploadid, usehttps: usehttps, reqhost: reqhost }, options);
};
/**
 * 上传大文件的分块协议
 */
exports.OSUploadPart = function (_a, options) {
    var docid = _a.docid, rev = _a.rev, uploadid = _a.uploadid, usehttps = _a.usehttps, parts = _a.parts, reqhost = _a.reqhost;
    return openapi_1.efshttp('file', 'osuploadpart', { docid: docid, rev: rev, uploadid: uploadid, usehttps: usehttps, parts: parts, reqhost: reqhost }, options);
};
/**
* 获取文件历史版本
*/
exports.revisions = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.efshttp('file', 'revisions', { docid: docid }, options);
};
/**
 * 还原文件历史版本
 */
exports.restoreRevision = function (_a, options) {
    var docid = _a.docid, rev = _a.rev;
    return openapi_1.efshttp('file', 'restorerevision', { docid: docid, rev: rev }, options);
};
/**
 * 对象存储的选项值
 */
exports.osOption = function (_a, options) {
    _a = {};
    return openapi_1.efshttp('file', 'osoption', {}, options);
};
/**
 * 上传文件更新协议
 */
exports.osUploadRefresh = function (_a, options) {
    var docid = _a.docid, rev = _a.rev, length = _a.length, multiupload = _a.multiupload, reqmethod = _a.reqmethod, reqhost = _a.reqhost, usehttps = _a.usehttps;
    return openapi_1.efshttp('file', 'osuploadrefresh', { docid: docid, rev: rev, length: length, multiupload: multiupload, reqmethod: reqmethod, reqhost: reqhost, usehttps: usehttps }, options);
};
/**
 * 秒传校验码协议
 */
exports.predUpload = function (_a, options) {
    var length = _a.length, slice_md5 = _a.slice_md5;
    return openapi_1.efshttp('file', 'predupload', { length: length, slice_md5: slice_md5 }, options);
};
/**
 * 秒传校验码协议
 */
exports.dupload = function (_a, options) {
    var docid = _a.docid, length = _a.length, md5 = _a.md5, crc32 = _a.crc32, name = _a.name, ondup = _a.ondup, client_mtime = _a.client_mtime, csflevel = _a.csflevel;
    return openapi_1.efshttp('file', 'dupload', { docid: docid, length: length, md5: md5, crc32: crc32, name: name, ondup: ondup, client_mtime: client_mtime, csflevel: csflevel }, options);
};
/**
 * 图片缩略图协议
 */
exports.thumbnail = function (_a, options) {
    var docid = _a.docid, height = _a.height, width = _a.width, rev = _a.rev, quality = _a.quality;
    return openapi_1.efshttp('file', 'thumbnail', { docid: docid, height: height, width: width, rev: rev, quality: quality }, options);
};
/**
 * 在线播放协议
 */
exports.play = function (_a, options) {
    var docid = _a.docid, reqhost = _a.reqhost, usehttps = _a.usehttps;
    return openapi_1.efshttp('file', 'play', { docid: docid, reqhost: reqhost, usehttps: usehttps }, options);
};
/**
 * 获取视频缩略图协议
 */
exports.playthumbnail = function (_a, options) {
    var docid = _a.docid, rev = _a.rev;
    return openapi_1.efshttp('file', 'playthumbnail', { docid: docid, rev: rev }, options);
};
/**
 * 发送文件协议
 */
exports.send = function (_a, options) {
    var docid = _a.docid, recipients = _a.recipients;
    return openapi_1.efshttp('file', 'send', { docid: docid, recipients: recipients }, options);
};
/**
 * 由名字路径获取对象信息协议
 */
exports.getInfoByPath = function (_a, options) {
    var namepath = _a.namepath;
    return openapi_1.efshttp('file', 'getinfobypath', { namepath: namepath }, options);
};
/**
 * 设置应用元数据
 */
exports.setAppMetaData = function (_a, options) {
    var docid = _a.docid, appid = _a.appid, appmetadata = _a.appmetadata;
    return openapi_1.efshttp('file', 'setappmetadata', { docid: docid, appid: appid, appmetadata: appmetadata }, options);
};
/**
 * 批量获取文件操作统计
 */
exports.opStatistics = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.efshttp('file', 'opstatistics', { docid: docid }, options);
};


/***/ }),

/***/ "../ShareWebCore/src/apis/efshttp/link/link.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 获取外链
 */
exports.get = function (_a) {
    var link = _a.link, password = _a.password, docid = _a.docid;
    return openapi_1.efshttp('link', 'get', { link: link, password: password, docid: docid }, { userid: null, tokenid: null });
};
/**
 * 获取外链文件信息
 */
exports.getInfo = openapi_1.CacheableOpenAPIFactory(openapi_1.efshttp, 'link', 'getinfo');
/**
 * 获取图片Base64编码
 */
exports.thumbnail = function (_a) {
    var link = _a.link, password = _a.password, docid = _a.docid, rev = _a.rev, height = _a.height, width = _a.width, quality = _a.quality;
    return openapi_1.efshttp('link', 'thumbnail', { link: link, password: password, docid: docid, rev: rev, height: height, width: width, quality: quality }, { readAs: 'text', userid: null, tokenid: null });
};
/**
 * 外链列举目录
 */
exports.listDir = openapi_1.CacheableOpenAPIFactory(openapi_1.efshttp, 'link', 'listdir');
/**
 * 外链下载
 */
exports.OSDownload = function (_a) {
    var link = _a.link, password = _a.password, docid = _a.docid, reqhost = _a.reqhost, usehttps = _a.usehttps, savename = _a.savename;
    return openapi_1.efshttp('link', 'osdownload', { link: link, password: password, docid: docid, reqhost: reqhost, usehttps: usehttps, savename: savename }, { userid: null, tokenid: null });
};
/**
 * 外链视频播放信息
 */
exports.playInfo = function (_a) {
    var link = _a.link, password = _a.password, docid = _a.docid, rev = _a.rev, definition = _a.definition;
    return openapi_1.efshttp('link', 'playinfo', { link: link, password: password, docid: docid, rev: rev, definition: definition }, { userid: null, tokenid: null });
};
/**
 * 文档预览
 */
exports.previewOSS = function (_a) {
    var link = _a.link, password = _a.password, docid = _a.docid, type = _a.type, reqhost = _a.reqhost, usehttps = _a.usehttps;
    return openapi_1.efshttp('link', 'previewoss', { link: link, password: password, docid: docid, type: type, reqhost: reqhost, usehttps: usehttps }, { userid: null, tokenid: null });
};
/**
 * 外链上传前，调用osbeingupload获取上传信息
 */
exports.OSBeginUpload = function (_a) {
    var link = _a.link, docid = _a.docid, password = _a.password, length = _a.length, name = _a.name, ondup = _a.ondup, client_mtime = _a.client_mtime, reqhost = _a.reqhost, reqmethod = _a.reqmethod, usehttps = _a.usehttps;
    return openapi_1.efshttp('link', 'osbeginupload', { link: link, docid: docid, password: password, length: length, name: name, ondup: ondup, client_mtime: client_mtime, reqhost: reqhost, reqmethod: reqmethod, usehttps: usehttps }, { userid: null, tokenid: null });
};
/**
 * 获取外部下载链接
 */
exports.OSDownloadExt = function (_a) {
    var link = _a.link, password = _a.password, docid = _a.docid, reqhost = _a.reqhost, usehttps = _a.usehttps;
    return openapi_1.efshttp('link', 'osdownloadext', { link: link, password: password, docid: docid, reqhost: reqhost, usehttps: usehttps }, { userid: null, tokenid: null });
};
/**
 * 外链上传完成
 */
exports.OSEndUpload = function (_a) {
    var link = _a.link, docid = _a.docid, rev = _a.rev, md5 = _a.md5, crc32 = _a.crc32, slice_md5 = _a.slice_md5;
    return openapi_1.efshttp('link', 'osendupload', { link: link, docid: docid, rev: rev, md5: md5, crc32: crc32, slice_md5: slice_md5 }, { userid: null, tokenid: null });
};
/**
 * 获取外链详细信息
 */
exports.getDetail = openapi_1.CacheableOpenAPIFactory(openapi_1.efshttp, 'link', 'getdetail');
/**
 * 设置外链详细信息
 */
exports.set = function (_a) {
    var docid = _a.docid, open = _a.open, endtime = _a.endtime, perm = _a.perm, limittimes = _a.limittimes;
    return openapi_1.efshttp('link', 'set', { docid: docid, open: open, endtime: endtime, perm: perm, limittimes: limittimes });
};
/**
 * 开启外链
 */
exports.open = function (_a) {
    var docid = _a.docid, open = _a.open, endtime = _a.endtime, perm = _a.perm, limittimes = _a.limittimes;
    return openapi_1.efshttp('link', 'open', { docid: docid, open: open, endtime: endtime, perm: perm, limittimes: limittimes });
};
/**
 * 关闭外链
 */
exports.close = function (_a) {
    var docid = _a.docid;
    return openapi_1.efshttp('link', 'close', { docid: docid });
};
/**
 * 检查权限
 */
exports.checkPerm = openapi_1.CacheableOpenAPIFactory(openapi_1.efshttp, 'link', 'checkperm');
/**
 * 由提取码获取外链
 */
exports.getLinkByAccessCode = function (_a) {
    var accesscode = _a.accesscode;
    return openapi_1.efshttp('link', 'getlinkbyaccesscode', { accesscode: accesscode });
};
/**
 * 批量下载
 */
exports.batchDownload = function (_a) {
    var name = _a.name, reqhost = _a.reqhost, usehttps = _a.usehttps, files = _a.files, dirs = _a.dirs, link = _a.link, password = _a.password;
    return openapi_1.efshttp('link', 'batchdownload', { name: name, reqhost: reqhost, usehttps: usehttps, files: files, dirs: dirs, link: link, password: password }, { userid: null, tokenid: null });
};
/**
 * 云端复制
 */
exports.copy = function (_a) {
    var link = _a.link, password = _a.password, docid = _a.docid, destparent = _a.destparent, ondup = _a.ondup;
    return openapi_1.efshttp('link', 'copy', { link: link, password: password, docid: docid, destparent: destparent, ondup: ondup });
};
/**
 * 获取外链访问详情的文件列表
 */
exports.opFiles = function (_a) {
    var docid = _a.docid, start = _a.start, limit = _a.limit;
    return openapi_1.efshttp('link', 'opfiles', { docid: docid, start: start, limit: limit });
};
/**
 * 获取外链访问详情的文件列表
 */
exports.opStatistics = function (_a) {
    var link_docid = _a.link_docid, file_docid = _a.file_docid, start = _a.start, limit = _a.limit;
    return openapi_1.efshttp('link', 'opstatistics', { link_docid: link_docid, file_docid: file_docid, start: start, limit: limit });
};
/**
 * 获取我的外链
 */
exports.getLinked = openapi_1.CacheableOpenAPIFactory(openapi_1.efshttp, 'link', 'getlinked');
/**
 * 在线播放
 */
exports.play = function (_a) {
    var docid = _a.docid, reqhost = _a.reqhost, usehttps = _a.usehttps;
    return openapi_1.efshttp('link', 'play', { docid: docid, reqhost: reqhost, usehttps: usehttps }, { userid: null, tokenid: null });
};
/**
 * 获取视频缩略图
 */
exports.playThumbnail = function (_a) {
    var docid = _a.docid, rev = _a.rev;
    return openapi_1.efshttp('link', 'playthumbnail', { docid: docid, rev: rev }, { userid: null, tokenid: null });
};
/**
 * 复制目录进度查询协议
 */
exports.copyProgress = function (_a) {
    var id = _a.id;
    return openapi_1.efshttp('link', 'copyprogress', { id: id });
};
/**
 * 外链检查目录水印策略
 */
exports.checkWatermark = openapi_1.CacheableOpenAPIFactory(openapi_1.efshttp, 'link', 'checkwatermark');


/***/ }),

/***/ "../ShareWebCore/src/apis/efshttp/quarantine/quarantine.ts":
/***/ (function(module, exports, __webpack_require__) {

/// <reference path="./quarantine.d.ts" />
exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 获取文件信息
 */
exports.list = function (_a, options) {
    _a = {};
    return openapi_1.efshttp('quarantine', 'list', {}, options);
};
/**
 * 获取文件历史版本信息
 */
exports.listReversion = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.efshttp('quarantine', 'listreversion', { docid: docid }, options);
};
/**
 * 文件申诉
 */
exports.appeal = function (_a, options) {
    var docid = _a.docid, reason = _a.reason;
    return openapi_1.efshttp('quarantine', 'appeal', { docid: docid, reason: reason }, options);
};
/**
 * 历史文件预览
 */
exports.preview = function (_a, options) {
    var docid = _a.docid, rev = _a.rev, reqhost = _a.reqhost, _b = _a.usehttps, usehttps = _b === void 0 ? true : _b;
    return openapi_1.efshttp('quarantine', 'preview', { docid: docid, rev: rev, reqhost: reqhost, usehttps: usehttps }, options);
};


/***/ }),

/***/ "../ShareWebCore/src/apis/efshttp/recycle/recycle.ts":
/***/ (function(module, exports, __webpack_require__) {

/// <reference path="./recycle.d.ts" />
exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 浏览回收站资源协议
 */
exports.list = function (_a, options) {
    var docid = _a.docid, by = _a.by, sort = _a.sort, name = _a.name, path = _a.path, editor = _a.editor, start = _a.start, limit = _a.limit;
    return openapi_1.efshttp('recycle', 'list', { docid: docid, by: by, sort: sort, name: name, path: path, editor: editor, start: start, limit: limit }, options);
};
/**
 * 删除回收站资源协议
 */
exports.del = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.efshttp('recycle', 'delete', { docid: docid }, options);
};
/**
 * 还原回收站资源协议
 */
exports.restore = function (_a, options) {
    var docid = _a.docid, ondup = _a.ondup;
    return openapi_1.efshttp('recycle', 'restore', { docid: docid, ondup: ondup }, options);
};
/**
 * 获取回收站还原后的建议名称协议
 */
exports.getSuggestName = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.efshttp('recycle', 'getsuggestname', { docid: docid }, options);
};
/**
 * 设置回收站资源保留天数
 */
exports.setRetentionDays = function (_a, options) {
    var docid = _a.docid, days = _a.days;
    return openapi_1.efshttp('recycle', 'setretentiondays', { docid: docid, days: days }, options);
};
/**
 * 获取回收站资源保留天数
 */
exports.getRetentionDays = function (_a, options) {
    var docid = _a.docid;
    return openapi_1.efshttp('recycle', 'getretentiondays', { docid: docid }, options);
};


/***/ }),

/***/ "../ShareWebCore/src/apis/efshttp/search/search.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
/**
 * 全文检索
 */
exports.search = function (_a, options) {
    var start = _a.start, rows = _a.rows, hlpre = _a.hlpre, hlpost = _a.hlpost, style = _a.style, range = _a.range, begin = _a.begin, end = _a.end, keys = _a.keys, keysfields = _a.keysfields, ext = _a.ext, sort = _a.sort, tags = _a.tags, size = _a.size, customattr = _a.customattr, createtime = _a.createtime;
    return openapi_1.efshttp('search', 'search', { start: start, rows: rows, hlpre: hlpre, hlpost: hlpost, style: style, range: range, begin: begin, end: end, keys: keys, keysfields: keysfields, ext: ext, sort: sort, tags: tags, size: size, customattr: customattr, createtime: createtime }, options);
};
/**
 * 标签补全协议
 */
exports.tagSuggest = function (_a, options) {
    var prefix = _a.prefix, count = _a.count;
    return openapi_1.efshttp('search', 'tagsuggest', { prefix: prefix, count: count }, options);
};
/**
 * 获取自定义属性协议
 */
exports.customAttribute = openapi_1.CacheableOpenAPIFactory(openapi_1.efshttp, 'search', 'customattribute');


/***/ }),

/***/ "../ShareWebCore/src/apis/openapi/errorcode.ts":
/***/ (function(module, exports) {

exports.__esModule = true;
/**
 * 错误码定义
 * 命名规则：操作／对象 + 状态
 * 常用状态表示：
 * * 非法值 Illegal
 * * 无效值 Invalid
 * * 操作对象不存在（被删除） Inaccessible
 * * 操作对象缺失（未配置） Missing
 * * 操作对象冲突 Conflict
 * * 超出允许范围 Exceeded
 * * 操作被限制 Restricted
 * * 操作对象不完整 Incomplete
 */
var ErrorCode;
(function (ErrorCode) {
    ErrorCode[ErrorCode["URINotExists"] = 400001] = "URINotExists";
    ErrorCode[ErrorCode["ParametersIllegal"] = 400002] = "ParametersIllegal";
    ErrorCode[ErrorCode["URIFormatIllegal"] = 400003] = "URIFormatIllegal";
    ErrorCode[ErrorCode["JSONFormatIllegal"] = 400004] = "JSONFormatIllegal";
    ErrorCode[ErrorCode["PermConfigIllegal"] = 400005] = "PermConfigIllegal";
    ErrorCode[ErrorCode["AccessorIllegal"] = 400006] = "AccessorIllegal";
    ErrorCode[ErrorCode["ChunkMismatched"] = 400007] = "ChunkMismatched";
    ErrorCode[ErrorCode["SearchCharacterIllegal"] = 400008] = "SearchCharacterIllegal";
    ErrorCode[ErrorCode["SearchParameterInvalid"] = 400009] = "SearchParameterInvalid";
    ErrorCode[ErrorCode["LocalTimeInvalid"] = 400010] = "LocalTimeInvalid";
    ErrorCode[ErrorCode["ExpirationInvalid"] = 400011] = "ExpirationInvalid";
    ErrorCode[ErrorCode["NameInvalid"] = 400012] = "NameInvalid";
    ErrorCode[ErrorCode["GroupNameInvalid"] = 400013] = "GroupNameInvalid";
    ErrorCode[ErrorCode["TagNameInvalid"] = 400014] = "TagNameInvalid";
    ErrorCode[ErrorCode["PermConfigExpired"] = 400015] = "PermConfigExpired";
    ErrorCode[ErrorCode["LinkConfigExpired"] = 400016] = "LinkConfigExpired";
    ErrorCode[ErrorCode["ExpirationConflict"] = 400017] = "ExpirationConflict";
    ErrorCode[ErrorCode["DispalyNameNull"] = 400018] = "DispalyNameNull";
    ErrorCode[ErrorCode["TokenExpired"] = 401001] = "TokenExpired";
    ErrorCode[ErrorCode["LinkAuthFailed"] = 401002] = "LinkAuthFailed";
    ErrorCode[ErrorCode["AuthFailed"] = 401003] = "AuthFailed";
    ErrorCode[ErrorCode["UserDisabled"] = 401004] = "UserDisabled";
    ErrorCode[ErrorCode["EncryptionInvalid"] = 401005] = "EncryptionInvalid";
    ErrorCode[ErrorCode["AdminLoginFailed"] = 401006] = "AdminLoginFailed";
    ErrorCode[ErrorCode["DomainDisabled"] = 401007] = "DomainDisabled";
    ErrorCode[ErrorCode["UserNotInDomain"] = 401008] = "UserNotInDomain";
    ErrorCode[ErrorCode["DeviceBinded"] = 401011] = "DeviceBinded";
    ErrorCode[ErrorCode["PasswordFailure"] = 401012] = "PasswordFailure";
    ErrorCode[ErrorCode["PasswordInsecure"] = 401013] = "PasswordInsecure";
    ErrorCode[ErrorCode["PasswordInvalid"] = 401014] = "PasswordInvalid";
    ErrorCode[ErrorCode["PasswordWeak"] = 401015] = "PasswordWeak";
    ErrorCode[ErrorCode["PasswordChangeNotSupported"] = 401016] = "PasswordChangeNotSupported";
    ErrorCode[ErrorCode["PasswordIsInitial"] = 401017] = "PasswordIsInitial";
    ErrorCode[ErrorCode["PasswordInvalidOnce"] = 401018] = "PasswordInvalidOnce";
    ErrorCode[ErrorCode["PasswordInvalidTwice"] = 401019] = "PasswordInvalidTwice";
    ErrorCode[ErrorCode["PasswordInvalidLocked"] = 401020] = "PasswordInvalidLocked";
    ErrorCode[ErrorCode["LicenseInvalid"] = 401021] = "LicenseInvalid";
    ErrorCode[ErrorCode["AccountDuplicatedLogin"] = 401025] = "AccountDuplicatedLogin";
    ErrorCode[ErrorCode["PasswordRestricted"] = 401026] = "PasswordRestricted";
    ErrorCode[ErrorCode["PasswordExpired"] = 401027] = "PasswordExpired";
    ErrorCode[ErrorCode["LoginSiteInvalid"] = 401028] = "LoginSiteInvalid";
    ErrorCode[ErrorCode["LicenseExpired"] = 401029] = "LicenseExpired";
    ErrorCode[ErrorCode["LinkVisitExceeded"] = 401030] = "LinkVisitExceeded";
    ErrorCode[ErrorCode["IPRestricted"] = 401031] = "IPRestricted";
    ErrorCode[ErrorCode["AccountLocked"] = 401032] = "AccountLocked";
    ErrorCode[ErrorCode["ClientRestricted"] = 401033] = "ClientRestricted";
    ErrorCode[ErrorCode["NetworkChanged"] = 401036] = "NetworkChanged";
    ErrorCode[ErrorCode["VCodeMissing"] = 401037] = "VCodeMissing";
    ErrorCode[ErrorCode["VCodeExpired"] = 401038] = "VCodeExpired";
    ErrorCode[ErrorCode["VCodeInvalid"] = 401039] = "VCodeInvalid";
    ErrorCode[ErrorCode["DisplayNameInvalid"] = 401052] = "DisplayNameInvalid";
    ErrorCode[ErrorCode["DisplayNameDuplicated"] = 401053] = "DisplayNameDuplicated";
    ErrorCode[ErrorCode["QuotaExhausted"] = 403001] = "QuotaExhausted";
    ErrorCode[ErrorCode["PermissionRestricted"] = 403002] = "PermissionRestricted";
    ErrorCode[ErrorCode["OwnershipRestricted"] = 403003] = "OwnershipRestricted";
    ErrorCode[ErrorCode["OwnershipTypeError"] = 403004] = "OwnershipTypeError";
    ErrorCode[ErrorCode["SelfOwnershipRestricted"] = 403005] = "SelfOwnershipRestricted";
    ErrorCode[ErrorCode["SelfDeOwnershipRestricted"] = 403006] = "SelfDeOwnershipRestricted";
    ErrorCode[ErrorCode["GroupCountLimited"] = 403007] = "GroupCountLimited";
    ErrorCode[ErrorCode["PermissionAccessorInaccessible"] = 403008] = "PermissionAccessorInaccessible";
    ErrorCode[ErrorCode["PersonalQuotaZero"] = 403009] = "PersonalQuotaZero";
    ErrorCode[ErrorCode["GroupNameDuplicated"] = 403010] = "GroupNameDuplicated";
    ErrorCode[ErrorCode["OwnershipAccessorInaccessible"] = 403011] = "OwnershipAccessorInaccessible";
    ErrorCode[ErrorCode["AccessorDuplicated"] = 403012] = "AccessorDuplicated";
    ErrorCode[ErrorCode["LinkDuplicated"] = 403013] = "LinkDuplicated";
    ErrorCode[ErrorCode["WriteCompleteReversion"] = 403014] = "WriteCompleteReversion";
    ErrorCode[ErrorCode["ObjectTypeError"] = 403015] = "ObjectTypeError";
    ErrorCode[ErrorCode["RecycleDeleteInaccessible"] = 403016] = "RecycleDeleteInaccessible";
    ErrorCode[ErrorCode["RecycleRestoreInaccessible"] = 403017] = "RecycleRestoreInaccessible";
    ErrorCode[ErrorCode["DownloadReversionIncomplete"] = 403018] = "DownloadReversionIncomplete";
    ErrorCode[ErrorCode["PathInvalid"] = 403019] = "PathInvalid";
    ErrorCode[ErrorCode["PublicShareDuplicated"] = 403020] = "PublicShareDuplicated";
    ErrorCode[ErrorCode["ParentPublicShareEnabled"] = 403021] = "ParentPublicShareEnabled";
    ErrorCode[ErrorCode["DocumentDeleteInaccessible"] = 403022] = "DocumentDeleteInaccessible";
    ErrorCode[ErrorCode["PreviewSizeExceeded"] = 403023] = "PreviewSizeExceeded";
    ErrorCode[ErrorCode["GNSInvalid"] = 403024] = "GNSInvalid";
    ErrorCode[ErrorCode["SizeExceeded"] = 403025] = "SizeExceeded";
    ErrorCode[ErrorCode["PreviewFormatInvalid"] = 403026] = "PreviewFormatInvalid";
    ErrorCode[ErrorCode["ThumbnailFormatInvalid"] = 403027] = "ThumbnailFormatInvalid";
    ErrorCode[ErrorCode["CASDisabled"] = 403028] = "CASDisabled";
    ErrorCode[ErrorCode["TicketInvalid"] = 403029] = "TicketInvalid";
    ErrorCode[ErrorCode["UserNotFound"] = 403030] = "UserNotFound";
    ErrorCode[ErrorCode["FileLocked"] = 403031] = "FileLocked";
    ErrorCode[ErrorCode["FullnameDuplicated"] = 403039] = "FullnameDuplicated";
    ErrorCode[ErrorCode["NameDuplicatedReadonly"] = 403040] = "NameDuplicatedReadonly";
    ErrorCode[ErrorCode["DiffTypeNameDuplicated"] = 403041] = "DiffTypeNameDuplicated";
    ErrorCode[ErrorCode["TrancodeFormatUnsupported"] = 403047] = "TrancodeFormatUnsupported";
    ErrorCode[ErrorCode["CopyToSelfDisabled"] = 403054] = "CopyToSelfDisabled";
    ErrorCode[ErrorCode["PermissionMismath"] = 403056] = "PermissionMismath";
    ErrorCode[ErrorCode["LinkRestricted"] = 403063] = "LinkRestricted";
    ErrorCode[ErrorCode["CSFLevelMismatch"] = 403065] = "CSFLevelMismatch";
    ErrorCode[ErrorCode["TranscodeSpaceExhausted"] = 403069] = "TranscodeSpaceExhausted";
    ErrorCode[ErrorCode["DocumentSizeExceeded"] = 403070] = "DocumentSizeExceeded";
    ErrorCode[ErrorCode["TagsNumExceeded"] = 403092] = "TagsNumExceeded";
    ErrorCode[ErrorCode["ApplyAuditMissing"] = 403094] = "ApplyAuditMissing";
    ErrorCode[ErrorCode["ShareApplyComplete"] = 403095] = "ShareApplyComplete";
    ErrorCode[ErrorCode["ShareApplyInvalid"] = 403096] = "ShareApplyInvalid";
    ErrorCode[ErrorCode["ShareApplyAccessorInaccessible"] = 403097] = "ShareApplyAccessorInaccessible";
    ErrorCode[ErrorCode["ApplyDenyConcentMissing"] = 403098] = "ApplyDenyConcentMissing";
    ErrorCode[ErrorCode["ShareApplySharerInaccessible"] = 403099] = "ShareApplySharerInaccessible";
    ErrorCode[ErrorCode["ShareApplyExpired"] = 403100] = "ShareApplyExpired";
    ErrorCode[ErrorCode["LinkApplyInvalid"] = 403102] = "LinkApplyInvalid";
    ErrorCode[ErrorCode["LinkApplyDuplicated"] = 403103] = "LinkApplyDuplicated";
    ErrorCode[ErrorCode["ExtLoginFailed"] = 403106] = "ExtLoginFailed";
    ErrorCode[ErrorCode["AuditCSFMismatch"] = 403107] = "AuditCSFMismatch";
    ErrorCode[ErrorCode["InsufficientCSFLevel"] = 403108] = "InsufficientCSFLevel";
    ErrorCode[ErrorCode["ArchiveModificationRestriced"] = 403125] = "ArchiveModificationRestriced";
    ErrorCode[ErrorCode["NotNullGroup"] = 403129] = "NotNullGroup";
    ErrorCode[ErrorCode["InvitationDuplicated"] = 403134] = "InvitationDuplicated";
    ErrorCode[ErrorCode["InvitationExcluded"] = 403135] = "InvitationExcluded";
    ErrorCode[ErrorCode["InvitationDisabled"] = 403136] = "InvitationDisabled";
    ErrorCode[ErrorCode["InvitationRestricted"] = 403137] = "InvitationRestricted";
    ErrorCode[ErrorCode["ShareExpirationExpired"] = 403138] = "ShareExpirationExpired";
    ErrorCode[ErrorCode["LinkExpirationExpired"] = 403139] = "LinkExpirationExpired";
    ErrorCode[ErrorCode["LinkExpirationConflict"] = 403140] = "LinkExpirationConflict";
    ErrorCode[ErrorCode["CommentSubmitDisabled"] = 403142] = "CommentSubmitDisabled";
    ErrorCode[ErrorCode["CommentDeleteDisabled"] = 403143] = "CommentDeleteDisabled";
    ErrorCode[ErrorCode["CommentSubmitDuplicated"] = 403144] = "CommentSubmitDuplicated";
    ErrorCode[ErrorCode["CommentDeleteUnauthorized"] = 403145] = "CommentDeleteUnauthorized";
    ErrorCode[ErrorCode["PermissionExceeded"] = 403148] = "PermissionExceeded";
    ErrorCode[ErrorCode["ExpireDaysExceeded"] = 403149] = "ExpireDaysExceeded";
    ErrorCode[ErrorCode["LimitationExceeded"] = 403150] = "LimitationExceeded";
    ErrorCode[ErrorCode["LinkPasswordMissing"] = 403151] = "LinkPasswordMissing";
    ErrorCode[ErrorCode["DownloadExceeded"] = 403153] = "DownloadExceeded";
    ErrorCode[ErrorCode["SmallQuota"] = 403154] = "SmallQuota";
    ErrorCode[ErrorCode["DeleteOutboxDisabled"] = 403155] = "DeleteOutboxDisabled";
    ErrorCode[ErrorCode["PersonalShareUnauthorized"] = 403156] = "PersonalShareUnauthorized";
    ErrorCode[ErrorCode["GroupShareUnauthorized"] = 403157] = "GroupShareUnauthorized";
    ErrorCode[ErrorCode["PersonalInvitationUnauthorized"] = 403158] = "PersonalInvitationUnauthorized";
    ErrorCode[ErrorCode["GroupInvitationUnauthorized"] = 403159] = "GroupInvitationUnauthorized";
    ErrorCode[ErrorCode["PersonLinkUnauthorized"] = 403162] = "PersonLinkUnauthorized";
    ErrorCode[ErrorCode["GroupLinkUnauthorized"] = 403163] = "GroupLinkUnauthorized";
    ErrorCode[ErrorCode["PersonLinkModificationUnauthorized"] = 403164] = "PersonLinkModificationUnauthorized";
    ErrorCode[ErrorCode["GroupLinkModificationUnathorized"] = 403165] = "GroupLinkModificationUnathorized";
    ErrorCode[ErrorCode["PersonalInvitationModificationUnauthorized"] = 403166] = "PersonalInvitationModificationUnauthorized";
    ErrorCode[ErrorCode["GroupInvitationModificationUnauthorized"] = 403167] = "GroupInvitationModificationUnauthorized";
    ErrorCode[ErrorCode["CopyToWatermarkLibraryDisabled"] = 403168] = "CopyToWatermarkLibraryDisabled";
    ErrorCode[ErrorCode["MoveToWatermarkLibraryDisabled"] = 403169] = "MoveToWatermarkLibraryDisabled";
    ErrorCode[ErrorCode["AccountFrozen"] = 403171] = "AccountFrozen";
    ErrorCode[ErrorCode["DocumentFrozen"] = 403172] = "DocumentFrozen";
    ErrorCode[ErrorCode["SourceDocLocked"] = 403176] = "SourceDocLocked";
    ErrorCode[ErrorCode["UserNotRealName"] = 403179] = "UserNotRealName";
    ErrorCode[ErrorCode["CreatorNotRealName"] = 403180] = "CreatorNotRealName";
    ErrorCode[ErrorCode["FileTypeRestricted"] = 403182] = "FileTypeRestricted";
    ErrorCode[ErrorCode["PermModifyDeniedWithGroupCreater"] = 403184] = "PermModifyDeniedWithGroupCreater";
    ErrorCode[ErrorCode["EmailInvalid"] = 403185] = "EmailInvalid";
    ErrorCode[ErrorCode["EmailDuplicated"] = 403186] = "EmailDuplicated";
    ErrorCode[ErrorCode["ContactGroupDuplicated"] = 403188] = "ContactGroupDuplicated";
    ErrorCode[ErrorCode["GroupInaccessible"] = 404001] = "GroupInaccessible";
    ErrorCode[ErrorCode["DeparmentInaccessible"] = 404002] = "DeparmentInaccessible";
    ErrorCode[ErrorCode["ParentObjectInaccessible"] = 404003] = "ParentObjectInaccessible";
    ErrorCode[ErrorCode["UserInfoInaccessible"] = 404004] = "UserInfoInaccessible";
    ErrorCode[ErrorCode["EntrydocInaccessible"] = 404005] = "EntrydocInaccessible";
    ErrorCode[ErrorCode["GNSInaccessible"] = 404006] = "GNSInaccessible";
    ErrorCode[ErrorCode["LinkInaccessable"] = 404008] = "LinkInaccessable";
    ErrorCode[ErrorCode["DataChunkInaccessible"] = 404009] = "DataChunkInaccessible";
    ErrorCode[ErrorCode["ReversionIncomplete"] = 404010] = "ReversionIncomplete";
    ErrorCode[ErrorCode["DataChunkIncomplete"] = 404011] = "DataChunkIncomplete";
    ErrorCode[ErrorCode["MissingDestination"] = 404013] = "MissingDestination";
    ErrorCode[ErrorCode["SiteOffline"] = 404017] = "SiteOffline";
    ErrorCode[ErrorCode["UserdocMissing"] = 404019] = "UserdocMissing";
    ErrorCode[ErrorCode["MailtoFormatInvalid"] = 404020] = "MailtoFormatInvalid";
    ErrorCode[ErrorCode["SMTPConfigMissing"] = 404021] = "SMTPConfigMissing";
    ErrorCode[ErrorCode["SMTPUnknownError"] = 404022] = "SMTPUnknownError";
    ErrorCode[ErrorCode["SMTPInaccessible"] = 404023] = "SMTPInaccessible";
    ErrorCode[ErrorCode["DocumentInaccessible"] = 404024] = "DocumentInaccessible";
    ErrorCode[ErrorCode["InvitationInaccessible"] = 404025] = "InvitationInaccessible";
    ErrorCode[ErrorCode["OwnerMissing"] = 404026] = "OwnerMissing";
    ErrorCode[ErrorCode["HTTPMethodError"] = 405001] = "HTTPMethodError";
    ErrorCode[ErrorCode["InternalError"] = 500001] = "InternalError";
    ErrorCode[ErrorCode["PreviewFailed"] = 500002] = "PreviewFailed";
    ErrorCode[ErrorCode["StorageUninitialized"] = 500003] = "StorageUninitialized";
    ErrorCode[ErrorCode["DataCorrupted"] = 500004] = "DataCorrupted";
    ErrorCode[ErrorCode["MetadataCorrupted"] = 500005] = "MetadataCorrupted";
    ErrorCode[ErrorCode["DataIncompatibale"] = 500006] = "DataIncompatibale";
    ErrorCode[ErrorCode["ServerClientMismatch"] = 500007] = "ServerClientMismatch";
    ErrorCode[ErrorCode["SearchEngineIndexFailed"] = 500008] = "SearchEngineIndexFailed";
    ErrorCode[ErrorCode["SearchEngineInternalError"] = 500009] = "SearchEngineInternalError";
    ErrorCode[ErrorCode["SearchEngineNotInstalled"] = 500011] = "SearchEngineNotInstalled";
    ErrorCode[ErrorCode["HTTPNotPOST"] = 501001] = "HTTPNotPOST";
    ErrorCode[ErrorCode["ServiceBusy"] = 503001] = "ServiceBusy";
    ErrorCode[ErrorCode["DocumentConverting"] = 503002] = "DocumentConverting";
    ErrorCode[ErrorCode["WatermarkProcessing"] = 503005] = "WatermarkProcessing";
    ErrorCode[ErrorCode["ResourcesNotEnough"] = 404027] = "ResourcesNotEnough";
    ErrorCode[ErrorCode["NeedAction"] = 401040] = "NeedAction";
    ErrorCode[ErrorCode["UserActivated"] = 401041] = "UserActivated";
    ErrorCode[ErrorCode["SendCaprchaFail"] = 401046] = "SendCaprchaFail";
    ErrorCode[ErrorCode["NotOpenActivated"] = 401047] = "NotOpenActivated";
    ErrorCode[ErrorCode["FailActivated"] = 401050] = "FailActivated";
    ErrorCode[ErrorCode["PhoneCorrectFormat"] = 401042] = "PhoneCorrectFormat";
    ErrorCode[ErrorCode["PhoneExist"] = 401043] = "PhoneExist";
    ErrorCode[ErrorCode["CaprchaWrong"] = 401044] = "CaprchaWrong";
    ErrorCode[ErrorCode["CaprchaOverstayed"] = 401045] = "CaprchaOverstayed";
    ErrorCode[ErrorCode["EmailCorrectFormat"] = 401048] = "EmailCorrectFormat";
    ErrorCode[ErrorCode["EmailExist"] = 401049] = "EmailExist";
    ErrorCode[ErrorCode["IDAuthDisabled"] = 401051] = "IDAuthDisabled";
    ErrorCode[ErrorCode["GNSInaccessibleInFileFlow"] = 403109] = "GNSInaccessibleInFileFlow";
    ErrorCode[ErrorCode["CSFLevelMismatchInFileFlow"] = 403114] = "CSFLevelMismatchInFileFlow";
    ErrorCode[ErrorCode["NoModificationPermission"] = 403113] = "NoModificationPermission";
    ErrorCode[ErrorCode["PendingFileFlow"] = 403105] = "PendingFileFlow";
    ErrorCode[ErrorCode["ExchangeServiceUnRegistered"] = 403126] = "ExchangeServiceUnRegistered";
    ErrorCode[ErrorCode["FileFlowInaccessible"] = 403110] = "FileFlowInaccessible";
    ErrorCode[ErrorCode["FileFlowUnavailable"] = 403187] = "FileFlowUnavailable";
    ErrorCode[ErrorCode["FileFlowInvalid"] = 403117] = "FileFlowInvalid";
    ErrorCode[ErrorCode["ApplyAuditCSFLevelMismatch"] = 403116] = "ApplyAuditCSFLevelMismatch";
    ErrorCode[ErrorCode["ExchangeServiceRestricted"] = 403123] = "ExchangeServiceRestricted";
    ErrorCode[ErrorCode["FileExceeded"] = 403122] = "FileExceeded";
    ErrorCode[ErrorCode["WorkflowApplicationInvalid"] = 403118] = "WorkflowApplicationInvalid";
    ErrorCode[ErrorCode["DocExchangeRecvAreaInaccessible"] = 403199] = "DocExchangeRecvAreaInaccessible";
    ErrorCode[ErrorCode["DocExchangeDstDocNameInvalid"] = 403200] = "DocExchangeDstDocNameInvalid";
    ErrorCode[ErrorCode["WorkFlowCommentsOverWords"] = 403112] = "WorkFlowCommentsOverWords";
    ErrorCode[ErrorCode["ReceivingSiteNotExist"] = 403199] = "ReceivingSiteNotExist";
    ErrorCode[ErrorCode["ContactNotExist"] = 403193] = "ContactNotExist";
    ErrorCode[ErrorCode["UserNotExist"] = 401023] = "UserNotExist";
    ErrorCode[ErrorCode["ContactGroupNotExist"] = 403194] = "ContactGroupNotExist";
})(ErrorCode = exports.ErrorCode || (exports.ErrorCode = {}));


/***/ }),

/***/ "../ShareWebCore/src/apis/openapi/openapi.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var audit = __webpack_require__("../ShareWebCore/src/apis/eachttp/audit/audit.ts");
var auth1 = __webpack_require__("../ShareWebCore/src/apis/eachttp/auth1/auth1.ts");
var auth2 = __webpack_require__("../ShareWebCore/src/apis/eachttp/auth2/auth2.ts");
var autolock = __webpack_require__("../ShareWebCore/src/apis/eachttp/autolock/autolock.ts");
var ca = __webpack_require__("../ShareWebCore/src/apis/eachttp/ca/ca.ts");
var config = __webpack_require__("../ShareWebCore/src/apis/eachttp/config/config.ts");
var contact = __webpack_require__("../ShareWebCore/src/apis/eachttp/contact/contact.ts");
var department = __webpack_require__("../ShareWebCore/src/apis/eachttp/department/department.ts");
var entrydoc = __webpack_require__("../ShareWebCore/src/apis/eachttp/entrydoc/entrydoc.ts");
var finder = __webpack_require__("../ShareWebCore/src/apis/eachttp/finder/finder.ts");
var groupdoc = __webpack_require__("../ShareWebCore/src/apis/eachttp/groupdoc/groupdoc.ts");
var invitation = __webpack_require__("../ShareWebCore/src/apis/eachttp/invitation/invitation.ts");
var managedoc = __webpack_require__("../ShareWebCore/src/apis/eachttp/managedoc/managedoc.ts");
var message = __webpack_require__("../ShareWebCore/src/apis/eachttp/message/message.ts");
var owner = __webpack_require__("../ShareWebCore/src/apis/eachttp/owner/owner.ts");
var perm = __webpack_require__("../ShareWebCore/src/apis/eachttp/perm/perm.ts");
var device = __webpack_require__("../ShareWebCore/src/apis/eachttp/device/device.ts");
var pki = __webpack_require__("../ShareWebCore/src/apis/eachttp/pki/pki.ts");
var quota = __webpack_require__("../ShareWebCore/src/apis/eachttp/quota/quota.ts");
var redirect = __webpack_require__("../ShareWebCore/src/apis/eachttp/redirect/redirect.ts");
var update = __webpack_require__("../ShareWebCore/src/apis/eachttp/update/update.ts");
var user = __webpack_require__("../ShareWebCore/src/apis/eachttp/user/user.ts");
var dir = __webpack_require__("../ShareWebCore/src/apis/efshttp/dir/dir.ts");
var file = __webpack_require__("../ShareWebCore/src/apis/efshttp/file/file.ts");
var link = __webpack_require__("../ShareWebCore/src/apis/efshttp/link/link.ts");
var favorites = __webpack_require__("../ShareWebCore/src/apis/efshttp/favorites/favorites.ts");
var quarantine = __webpack_require__("../ShareWebCore/src/apis/efshttp/quarantine/quarantine.ts");
var recycle = __webpack_require__("../ShareWebCore/src/apis/efshttp/recycle/recycle.ts");
var search = __webpack_require__("../ShareWebCore/src/apis/efshttp/search/search.ts");
exports["default"] = {
    eachttp: {
        audit: audit, auth1: auth1, auth2: auth2, autolock: autolock, ca: ca, config: config, contact: contact, department: department, entrydoc: entrydoc, finder: finder, groupdoc: groupdoc, device: device,
        invitation: invitation, managedoc: managedoc, message: message, owner: owner, perm: perm, pki: pki, quota: quota, redirect: redirect, update: update, user: user
    },
    efshttp: { dir: dir, file: file, link: link, favorites: favorites, quarantine: quarantine, recycle: recycle, search: search }
};


/***/ }),

/***/ "../ShareWebCore/src/auth/auth.ts":
/***/ (function(module, exports, __webpack_require__) {

/// <reference path="../apis/eachttp/auth1/auth1.d.ts" />
/// <reference path="../user/user.d.ts" />
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
exports.__esModule = true;
var react_cookie_1 = __webpack_require__("../node_modules/react-cookie/build/cookie.js");
var session_1 = __webpack_require__("../ShareWebUtil/src/session/index.ts");
var rsa_1 = __webpack_require__("../ShareWebUtil/src/rsa/index.ts");
var auth1_1 = __webpack_require__("../ShareWebCore/src/apis/eachttp/auth1/auth1.ts");
var user_1 = __webpack_require__("../ShareWebCore/src/apis/eachttp/user/user.ts");
var config_1 = __webpack_require__("../ShareWebCore/src/config/config.ts");
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var user_2 = __webpack_require__("../ShareWebCore/src/user/user.ts");
/**
 * 登录类型
 */
exports.OS_TYPE = {
    UNKNOWN: 0,
    IOS: 1,
    ANDROID: 2,
    WINDOWS_PHONE: 3,
    WINDOWS: 4,
    MACOSX: 5,
    WEB: 6,
    MOBILEWEB: 7
};
// AnyShare公钥
var PUBLIC_KEY = 'BB24BD0371A3141EE992761C574F1AA20010420C446144922C00F07EFB3C752' +
    '0D81210A3C66DEC43B75A2370D01CD1F23E1BFC93B907201F5116F29A2C8149' +
    'E2D2671313A0A78E455BBFC20B802BA1CBEE1EBBEDA50290F040F0FD4EBE89F' +
    '24DB546EBB6B16579675551B9016A1A6FDCE6F6933901395453885CF55369AD' +
    'B999';
/**
 * 使用AnyShare公钥进行加密
 */
function encrypt(input) {
    return rsa_1.rsaEncrypt(input, PUBLIC_KEY);
}
exports.encrypt = encrypt;
/**
 * 认证用户
 * @param account {string}
 * @param password {string}
 */
function auth(account, password, ostype, vcodeinfo) {
    return auth1_1.getNew({
        account: account,
        password: encrypt(password),
        deviceinfo: {
            ostype: ostype
        },
        vcodeinfo: vcodeinfo
    });
}
exports.auth = auth;
/**
 * 登录并获取用户信息
 * @param account {string}
 * @param password {string}
 */
function login(account, password, ostype, vcodeinfo) {
    return auth(account, password, ostype, vcodeinfo).then(function (_a) {
        var userid = _a.userid, tokenid = _a.tokenid;
        return user_2.getFullInfo(userid, tokenid);
    });
}
exports.login = login;
/**
 *重定向
 */
function redirect() {
    config_1.getConfig('thirdauth').then(function (res) {
        if (res && res.config) {
            location.replace(res.config.authServer);
        }
    });
}
exports.redirect = redirect;
/**
 * 获取第三方配置
 */
function getAuth() {
    return config_1.getConfig('thirdauth').then(function (thirdAuth) {
        return thirdAuth;
    });
}
exports.getAuth = getAuth;
/**
 * 获取地第三方认证ID
 */
function getID() {
    return getAuth().then(function (thirdAuth) {
        return thirdAuth.id;
    });
}
exports.getID = getID;
/**
 * 获取登录用户类型
 */
function getUserType() {
    return user_1.get({}).then(function (_a) {
        var usertype = _a.usertype;
        return usertype;
    });
}
exports.getUserType = getUserType;
/**
 * 第三方认证的参数
 */
function authByParams(params, ostype) {
    return getID().then(function (id) {
        return auth1_1.getByThirdParty({
            thirdpartyid: id,
            params: lodash_1.mapValues(params, decodeURIComponent),
            deviceinfo: {
                ostype: ostype ? ostype : exports.OS_TYPE.WEB
            }
        });
    });
}
exports.authByParams = authByParams;
/**
 * 认证并登陆
 */
function loginByParams(params, ostype) {
    if (params === void 0) { params = {}; }
    return authByParams(params, ostype).then(function (_a) {
        var userid = _a.userid, tokenid = _a.tokenid;
        return user_2.getFullInfo(userid, tokenid);
    });
}
exports.loginByParams = loginByParams;
/**
 * 信任的第三方应用appid认证
 */
function extLogin(_a) {
    var account = _a.account, appid = _a.appid, key = _a.key;
    return auth1_1.extLoginClient({ account: account, appid: appid, key: key }).then(function (_a) {
        var userid = _a.userid, tokenid = _a.tokenid;
        return user_2.getFullInfo(userid, tokenid);
    });
}
exports.extLogin = extLogin;
/**
 * 清除会话cookie
 */
function clear() {
    session_1["default"].remove('login');
}
exports.clear = clear;
/**
 * 构造认证URL
 * @param redirectURI 本地重定向URI，如在客户端进行认证后登录到控制台
 * @return 认证地址
 */
function buildURI(redirectURI) {
    return config_1.getConfig('thirdauth').then(function (thirdauth) {
        var authServer = thirdauth.config.authServer;
        return redirectURI ?
            authServer + '?redirect_uri=' + redirectURI : authServer;
    });
}
exports.buildURI = buildURI;
/**
 * 获取金智认证版本
 */
function getVersion() {
    return getID().then(function (id) {
        switch (id) {
            case 'wisedu_v4':
                return 'v4';
            case 'wisedu_sync':
                return 'v5';
        }
    });
}
exports.getVersion = getVersion;
/**
 * 构建退出URL
 * @param redirectURI {string} 重定向目的地
 * @param [thirdLogout=true] {boolean} 是否调用第三方注销接口
 * @return {<string> Promise} 返回登出的URL
 */
function buildLogoutUrl(redirectURI, thirdLogout) {
    if (thirdLogout) {
        return Promise.all([
            config_1.getConfig('thirdauth'),
            buildURI(redirectURI),
            getVersion()
        ]).then(function (_a) {
            var _b = __read(_a, 3), thirdauth = _b[0], uri = _b[1], version = _b[2];
            if (thirdauth.logoutUrl) {
                return thirdauth.logoutUrl;
            }
            else if (version === 'v4') {
                // 金智认证V4用户（目前仅西南交大），直接返回AnyShare登录
                return thirdauth.config.oauthServer.replace(/Login$/, 'Logout') + '?goto=' + uri;
            }
            else {
                return thirdauth.config.oauthServer.replace(/login$/, 'logout') + '?service=' + uri;
            }
        });
    }
    else {
        return Promise.resolve('/');
    }
}
exports.buildLogoutUrl = buildLogoutUrl;
/**
 * wisedu注销
 */
function wiseduLogoff(redirectURI, thirdLogout, _a) {
    var doNotLogoffToken = (_a === void 0 ? {} : _a).doNotLogoffToken;
    return buildLogoutUrl(redirectURI, thirdLogout).then(function (url) {
        // 金智认证V4，删除注入的Cookie
        if (react_cookie_1["default"].load('iPlanetDirectoryPro')) {
            react_cookie_1["default"].remove('iPlanetDirectoryPro');
        }
        authlogout({ doNotLogoffToken: doNotLogoffToken });
        return url;
    });
}
exports.wiseduLogoff = wiseduLogoff;
/**
 * 本地注销登录
 * @param doNotLogoffToken 不要注销token，外部平台跳转登录不调用注销，避免外部平台Token被一并注销
 */
function authlogout(_a) {
    var _b = _a === void 0 ? {} : _a, _c = _b.doNotLogoffToken, doNotLogoffToken = _c === void 0 ? false : _c, _d = _b.isTimeoutAutoLogout, isTimeoutAutoLogout = _d === void 0 ? false : _d;
    var ostype = exports.OS_TYPE.WEB;
    if (doNotLogoffToken) {
        return Promise.resolve(clear());
    }
    else {
        return auth1_1.logout({ ostype: ostype, timeout_auto_logout: isTimeoutAutoLogout }).then(function () {
            clear();
        }, function (xhr) {
            if (/401001|401011|401031|401033|500001/.test(xhr.errcode)) {
                clear();
            }
        });
    }
}
exports.authlogout = authlogout;
/**
 * 第三方登出
 */
function thirdauthLogoff(_a) {
    var doNotLogoffToken = (_a === void 0 ? {} : _a).doNotLogoffToken;
    return config_1.getConfig('thirdauth').then(function (thirdauth) {
        // 先注销AnyShare登录
        authlogout({ doNotLogoffToken: doNotLogoffToken });
        return thirdauth.config;
    });
}
exports.thirdauthLogoff = thirdauthLogoff;


/***/ }),

/***/ "../ShareWebCore/src/auth/index.ts":
/***/ (function(module, exports, __webpack_require__) {

function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
exports.__esModule = true;
__export(__webpack_require__("../ShareWebCore/src/auth/auth.ts"));


/***/ }),

/***/ "../ShareWebCore/src/ca/ca.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var locale_ts_1 = __webpack_require__("../ShareWebCore/src/ca/locale.ts");
function caAuth(account, config) {
    var promise = new Promise(function (resolve, reject) { }), componentCA;
    try {
        componentCA = new ActiveXObject("IAccount.DeskEngine");
        componentCA.SetManager(config.authServer, config.appId, config.appKey);
        if (!componentCA.CheckCertLogin()) {
            promise.reject(locale_ts_1["default"]('意源证书认证失败，请联系意源的技术人员检查。'));
        }
        else {
            if (account !== componentCA.AppUserName) {
                promise.reject(locale_ts_1["default"]('该用户名与此KEY不匹配，请重新输入。'));
            }
            else {
                promise.resolve();
            }
        }
    }
    catch (err) {
        if (window.ActiveXObject === undefined) {
            promise.reject(locale_ts_1["default"]('访问失败。请检查是否已安装认证设备驱动，或者手工调低IE浏览器控件安全级别'));
        }
        else {
            promise.reject(locale_ts_1["default"]('该认证设备仅支持在IE浏览器下访问，请切换至IE浏览器'));
        }
    }
    return promise;
}
exports.caAuth = caAuth;


/***/ }),

/***/ "../ShareWebCore/src/ca/index.ts":
/***/ (function(module, exports, __webpack_require__) {

function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
exports.__esModule = true;
__export(__webpack_require__("../ShareWebCore/src/ca/ca.ts"));


/***/ }),

/***/ "../ShareWebCore/src/ca/locale.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var i18n_1 = __webpack_require__("../ShareWebCore/src/i18n.ts");
exports["default"] = i18n_1["default"]([
    [
        '意源DeskEngine创建组件失败',
        '意源DeskEngine創建元件失敗當前範本已不存在。',
        'Create Ideabank DeskEngine components failure'
    ],
    [
        '意源证书认证失败，请联系意源的技术人员检查。',
        '意源證書認證失敗，請聯繫意源的技術人員檢查。當前範本中的共用者已不存在。',
        'Authentication failed. '
    ],
    [
        '该用户名与此KEY不匹配，请重新输入。[系统配置]-[第三方服务器]” 页面修改配置信息',
        '該使用者名稱與此KEY不匹配，請重新輸入。SMTP設定有誤，請到“[系統設定]-[協力廠商伺服器]” 頁面修改設定資訊',
        'The user name  can‘t match  this key, please  try again.'
    ],
    [
        '该认证设备仅支持在IE浏览器下访问，请切换至IE浏览器',
        '該認證設備僅支援在IE瀏覽器下存取，請切換至IE瀏覽器測試郵件傳送失敗，請檢查您的網路設定',
        'The authentication device is supported only in the IE, please use IE'
    ],
    [
        '访问失败。请检查是否已安装认证设备驱动，或者手工调低IE浏览器控件安全级别',
        '存取失敗。請檢查是否已安裝認證設備驅動，或者手工調低IE瀏覽器控制項安全級別',
        'Access failed. Please check if the device driver is installed, or adjust  IE security control level.'
    ]
]);


/***/ }),

/***/ "../ShareWebCore/src/config/config.ts":
/***/ (function(module, exports, __webpack_require__) {

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
exports.__esModule = true;
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var auth1_1 = __webpack_require__("../ShareWebCore/src/apis/eachttp/auth1/auth1.ts");
var redirect_1 = __webpack_require__("../ShareWebCore/src/apis/eachttp/redirect/redirect.ts");
var http_1 = __webpack_require__("../ShareWebUtil/src/http/index.ts");
/**
 * 获取配置文件
 * @param [item] {string} 要获取的指定项，使用.进行深度搜索，如get('thirdauth.id')
 * @return {Promise} 返回item 值，如果未指定item ，则返回整个JSON对象
 */
function getConfig(item) {
    return auth1_1.getConfig().then(function (config) { return item !== undefined ? lodash_1.get(config, item) : config; });
}
exports.getConfig = getConfig;
/**
 * 判断当前是否是ASE产品,返回true/false
 */
function isASE() {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, getConfig('device_info')];
                case 1: return [2 /*return*/, (_a.sent()).software_type === "ASE"];
            }
        });
    });
}
exports.isASE = isASE;
/**
 * 获取OEM配置
 * @param [item] {string} 返回指定项
 */
function getOEMConfig(item) {
    return getConfig('oemconfig').then(function (config) {
        if (config === void 0) { config = {}; }
        return item !== undefined ? lodash_1.get(config, item) : config;
    });
}
exports.getOEMConfig = getOEMConfig;
/**
 * 获取第三方认证配置
 * @param [item] {string} 返回指定项
 */
function getThirdAuth(item) {
    return getConfig('thirdauth').then(function (config) {
        if (config === void 0) { config = {}; }
        return item !== undefined ? lodash_1.get(config, item) : config;
    });
}
exports.getThirdAuth = getThirdAuth;
/**
 * 获取Web客户端访问端口
 */
function getWebClientHostInfo() {
    return __awaiter(this, void 0, void 0, function () {
        var _a, https, _b, host, port, https_port;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0: return [4 /*yield*/, Promise.all([
                        getConfig(),
                        redirect_1.getHostInfo(),
                    ])];
                case 1:
                    _a = __read.apply(void 0, [_c.sent(), 2]), https = _a[0].https, _b = _a[1], host = _b.host, port = _b.port, https_port = _b.https_port;
                    return [2 /*return*/, {
                            protocol: https ? 'https:' : 'http:',
                            host: host,
                            port: https ? https_port : port
                        }];
            }
        });
    });
}
exports.getWebClientHostInfo = getWebClientHostInfo;
/**
 * 构建Web客户端访问地址
 * @param param0
 */
function buildWebClientURI(_a) {
    var _b = _a.path, path = _b === void 0 ? '' : _b, _c = _a.query, query = _c === void 0 ? {} : _c;
    return __awaiter(this, void 0, void 0, function () {
        var _d, protocol, host, port, qs;
        return __generator(this, function (_e) {
            switch (_e.label) {
                case 0: return [4 /*yield*/, getWebClientHostInfo()];
                case 1:
                    _d = _e.sent(), protocol = _d.protocol, host = _d.host, port = _d.port;
                    qs = http_1.queryString(query);
                    return [2 /*return*/, protocol + "//" + host + ":" + port + (path.startsWith('/') ? "" + path : "/" + path) + "?" + qs];
            }
        });
    });
}
exports.buildWebClientURI = buildWebClientURI;


/***/ }),

/***/ "../ShareWebCore/src/config/index.ts":
/***/ (function(module, exports, __webpack_require__) {

function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
exports.__esModule = true;
__export(__webpack_require__("../ShareWebCore/src/config/config.ts"));


/***/ }),

/***/ "../ShareWebCore/src/csf/csf.ts":
/***/ (function(module, exports, __webpack_require__) {

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
exports.__esModule = true;
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var errorcode_1 = __webpack_require__("../ShareWebCore/src/apis/openapi/errorcode.ts");
var errcode_1 = __webpack_require__("../ShareWebCore/src/errcode/errcode.ts");
var user_1 = __webpack_require__("../ShareWebCore/src/apis/eachttp/user/user.ts");
var file_1 = __webpack_require__("../ShareWebCore/src/apis/efshttp/file/file.ts");
var file_2 = __webpack_require__("../ShareWebCore/src/apis/efshttp/file/file.ts");
var entrydoc_1 = __webpack_require__("../ShareWebCore/src/apis/eachttp/entrydoc/entrydoc.ts");
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/docs.ts");
var config_1 = __webpack_require__("../ShareWebCore/src/config/config.ts");
var locale_1 = __webpack_require__("../ShareWebCore/src/csf/locale.ts");
var CsfStatus;
(function (CsfStatus) {
    CsfStatus[CsfStatus["None"] = 0] = "None";
    /**
     * 没有所有者权限
     */
    CsfStatus[CsfStatus["NoOwnerPerm"] = 1] = "NoOwnerPerm";
    /**
     * 选中多个文档库
     */
    CsfStatus[CsfStatus["SelectMultiLibraries"] = 2] = "SelectMultiLibraries";
    /**
     * 加载中
     */
    CsfStatus[CsfStatus["Loading"] = 3] = "Loading";
    /**
     * '您的操作已提交审核，可在“权限申请”中查看。'
     */
    CsfStatus[CsfStatus["Approval"] = 4] = "Approval";
    /**
     * 事前检查完毕，成功通过检查
     */
    CsfStatus[CsfStatus["OK"] = 5] = "OK";
})(CsfStatus = exports.CsfStatus || (exports.CsfStatus = {}));
/**
 * "文件密级"右侧的按钮点击状态
 */
var CSFBtnStatus;
(function (CSFBtnStatus) {
    /**
     * 未点击状态
     */
    CSFBtnStatus[CSFBtnStatus["None"] = 0] = "None";
    /**
     * 点击了”密级设置“按钮
     */
    CSFBtnStatus[CSFBtnStatus["CsfEditor"] = 1] = "CsfEditor";
    /**
     * 点击了“密级详情”按钮
     */
    CSFBtnStatus[CSFBtnStatus["CsfDetails"] = 2] = "CsfDetails";
})(CSFBtnStatus = exports.CSFBtnStatus || (exports.CSFBtnStatus = {}));
/**
 * 查询用户对某个文件的密级是否足够
 */
function checkCsfLevel(docid) {
    return Promise.all([user_1.get({}), file_1.attribute({ docid: docid })]).then(function (_a) {
        var _b = __read(_a, 2), userinfo = _b[0], docinfo = _b[1];
        return userinfo.csflevel >= docinfo.csflevel;
    });
}
exports.checkCsfLevel = checkCsfLevel;
/**
 * 标密系统ID
 */
exports.CSFSYSID = {
    // 时代亿信
    SDYX: '7270a9fb-ce86-400f-8c0c-7d48b5790b1b',
    // 706所
    706: '04d468ec-972c-4c90-adfc-e7651de139d8',
    // AS
    ANYSHARE: 'b937b8e3-169c-4bee-85c5-865b03d8c29a'
};
/**
 * 判断文件是否未定密
 * @param doc
 */
function checkCsfIsNull(doc) {
    return config_1.getConfig('third_csfsys_config').then(function (csf) {
        // 对接中编办或者8511
        if (csf && (csf.id === exports.CSFSYSID.SDYX || csf.id === exports.CSFSYSID['706'])) {
            return file_2.getAppmetadata({ docid: doc.docid, appid: csf.id }).then(function (res) {
                if (!res || !res[0]) {
                    return false;
                }
                if (res[0].appmetadata.classification_info) {
                    return false;
                }
                else {
                    return true;
                }
            });
        }
        else {
            return false;
        }
    });
}
exports.checkCsfIsNull = checkCsfIsNull;
function isSingleFile(docs) {
    var dirSelNum = 0;
    var fileSelNum = 0;
    docs.map(function (doc) {
        docs_1.isDir(doc) ? dirSelNum++ : fileSelNum++;
    });
    return {
        fileSelNum: fileSelNum,
        dirSelNum: dirSelNum
    };
}
exports.isSingleFile = isSingleFile;
/**
 * 获取密级Dialog标题(密级设置弹窗使用)
 */
function getCsfTip(docs) {
    var _a = isSingleFile(docs), fileSelNum = _a.fileSelNum, dirSelNum = _a.dirSelNum;
    if (dirSelNum) {
        if (fileSelNum) {
            return locale_1["default"]('您已选中了多个文件和文件夹，请设置这些文件及文件夹下所有子文件的密级。');
        }
        else {
            return (dirSelNum === 1) ? locale_1["default"]('您已选中了一个文件夹，请设置该文件夹下所有子文件的密级。') : locale_1["default"]('您已选中了多个文件夹，请设置这些文件夹下所有子文件的密级。');
        }
    }
    else {
        return (fileSelNum === 1) ? locale_1["default"]('您已选中了一个文件，请设置该文件的密级。') : locale_1["default"]('您已选中了多个文件，请设置这些文件的密级。');
    }
}
exports.getCsfTip = getCsfTip;
/**
 * 系统密级从低到高排序
 */
function sortSecu(csfLevelEnum) {
    return lodash_1.pairs(csfLevelEnum).sort(function (_a, _b) {
        var _c = __read(_a, 2), csfText1 = _c[0], csfTextLevel1 = _c[1];
        var _d = __read(_b, 2), csfText2 = _d[0], csfTextLevel2 = _d[1];
        return csfTextLevel1 - csfTextLevel2;
    }).map(function (_a) {
        var _b = __read(_a, 2), csfText = _b[0], csfTextLevel = _b[1];
        return csfText;
    });
}
exports.sortSecu = sortSecu;
/**
 * 获取密级枚举信息
 */
function getCsfLevels() {
    return __awaiter(this, void 0, Promise, function () {
        var _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    _a = sortSecu;
                    return [4 /*yield*/, config_1.getConfig('csf_level_enum')];
                case 1: return [2 /*return*/, _a.apply(void 0, [_b.sent()])];
            }
        });
    });
}
exports.getCsfLevels = getCsfLevels;
/**
 * 根据用户密级构建可选择的密级数组
 * @param userCsflevel 用户密级
 */
function buildCsfarray(userCsflevel) {
    return __awaiter(this, void 0, Promise, function () {
        var arr, _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    _a = lodash_1.map;
                    return [4 /*yield*/, getCsfLevels()];
                case 1:
                    arr = _a.apply(void 0, [(_b.sent()).slice(0, userCsflevel - 4), function (item, index) {
                            return {
                                level: index + 5,
                                text: item
                            };
                        }]);
                    arr.unshift({ level: 0, text: '---' });
                    return [2 /*return*/, arr];
            }
        });
    });
}
exports.buildCsfarray = buildCsfarray;
/**
 *
 */
function getCSFErrorMessage(errCode) {
    switch (errCode) {
        case CsfStatus.NoOwnerPerm:
            return locale_1["default"]('您不是选中文件/文件夹的所有者，无法进行密级设置。');
        case CsfStatus.SelectMultiLibraries:
            return locale_1["default"]('不支持选中多个文档库操作。');
        case errorcode_1.ErrorCode.GNSInaccessible:
            return locale_1["default"]('文件或文件夹不存在, 可能其所在路径发生变更。');
        default:
            return errcode_1.getErrorMessage(errCode);
    }
}
exports.getCSFErrorMessage = getCSFErrorMessage;
/**
 * 检查是否选中多个文档库
 * @returns false-没有选中多个文档库；true--选中多个文档库
 */
function hasMultiLibraries(docs) {
    return __awaiter(this, void 0, Promise, function () {
        var _a, doc, doctype;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    if (!(docs.length > 1)) return [3 /*break*/, 4];
                    _a = __read(docs, 1), doc = _a[0];
                    if (!doc.doctype) return [3 /*break*/, 1];
                    return [2 /*return*/, doc.doctype === 'customdoc'];
                case 1: return [4 /*yield*/, entrydoc_1.getDocType({ docid: doc.docid })];
                case 2:
                    doctype = (_b.sent()).doctype;
                    return [2 /*return*/, doctype === 'customdoc'];
                case 3: return [3 /*break*/, 5];
                case 4: return [2 /*return*/, false];
                case 5: return [2 /*return*/];
            }
        });
    });
}
exports.hasMultiLibraries = hasMultiLibraries;


/***/ }),

/***/ "../ShareWebCore/src/csf/index.ts":
/***/ (function(module, exports, __webpack_require__) {

function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
exports.__esModule = true;
__export(__webpack_require__("../ShareWebCore/src/csf/csf.ts"));


/***/ }),

/***/ "../ShareWebCore/src/csf/locale.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var i18n_1 = __webpack_require__("../ShareWebCore/src/i18n.ts");
exports["default"] = i18n_1["default"]([
    [
        '您已选中了一个文件，请设置该文件的密级。',
        '您已選中了一個檔案，請設定該檔案密級。',
        'You have selected a file, please set the security level for the file.'
    ],
    [
        '您已选中了多个文件，请设置这些文件的密级。',
        '您已選中了多個檔案，請設定這些檔案的密級。',
        'You have selected multiple files, please set the security level for these files.'
    ],
    [
        '您已选中了一个文件夹，请设置该文件夹下所有子文件的密级。',
        '您已選中了一個資料夾，請設定該資料夾下所有子檔案的密級。',
        'You have selected a folder, please set the security level for all files in this folder.'
    ],
    [
        '您已选中了多个文件夹，请设置这些文件夹下所有子文件的密级。',
        '您已選中了多個資料夾，請設定這些資料夾下所有子檔案的密級。',
        'You have selected multiple folders, please set the security level for all files in these folders.'
    ],
    [
        '您已选中了多个文件和文件夹，请设置这些文件及文件夹下所有子文件的密级。',
        '您已選中了多個檔案和資料夾，請設定這些檔案及資料夾下所有子檔案的密級。',
        'You have selected multiple files and folders, please set the security level for all subfolders and files in these folders.'
    ],
    [
        '您不是选中文件/文件夹的所有者，无法进行密级设置。',
        '您不是選中檔案/資料夾的擁有者，無法進行密級設定。',
        'You are not file/folder owner and cannot set security level.'
    ],
    [
        '不支持选中多个文档库操作。',
        '不支援選中多個文件庫操作。',
        'You cannot change security level of multiple libraries at the same time.'
    ],
    [
        '文件或文件夹不存在, 可能其所在路径发生变更。',
        '檔案或資料夾不存在, 可能其所在路徑發生變更。',
        'File does not exist in this location.'
    ]
]);


/***/ }),

/***/ "../ShareWebCore/src/docs/docs.ts":
/***/ (function(module, exports, __webpack_require__) {

/// <reference path="../apis/efshttp/dir/dir.d.ts" />
/// <reference path="./docs.d.ts" />
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
exports.__esModule = true;
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
var gns_1 = __webpack_require__("../ShareWebCore/src/gns/gns.ts");
var dir_1 = __webpack_require__("../ShareWebCore/src/apis/efshttp/dir/dir.ts");
var file_1 = __webpack_require__("../ShareWebCore/src/apis/efshttp/file/file.ts");
var extension_1 = __webpack_require__("../ShareWebCore/src/extension/extension.ts");
var entrydoc_1 = __webpack_require__("../ShareWebCore/src/entrydoc/entrydoc.ts");
var config_1 = __webpack_require__("../ShareWebCore/src/config/config.ts");
/**
 * 文件打开方式
 */
var OpenMethod;
(function (OpenMethod) {
    OpenMethod[OpenMethod["LIST"] = 0] = "LIST";
    OpenMethod[OpenMethod["PREVIEW"] = 1] = "PREVIEW";
    OpenMethod[OpenMethod["PLAY"] = 2] = "PLAY";
    OpenMethod[OpenMethod["THUMBNAIL"] = 3] = "THUMBNAIL";
    OpenMethod[OpenMethod["ABOUT"] = 4] = "ABOUT";
})(OpenMethod = exports.OpenMethod || (exports.OpenMethod = {}));
/**
 * 判断是否为目录
 */
function isDir(doc) {
    return !!doc.isDir || (doc.size === undefined && doc.isdir === undefined) || doc.size === -1 || doc.isdir === true;
}
exports.isDir = isDir;
/**
 * 获取文档名称，包括入口文档和普通文档
 */
function docname(doc) {
    return doc ? doc.name || doc.docname || doc.basename + doc.ext || '' : '';
}
exports.docname = docname;
/**
 * 选择打开方式
 * @param doc 文档对象
 * @return 返回打开方式
 */
function getOpenMethod(doc) {
    if (isDir(doc)) {
        return OpenMethod.LIST;
    }
    else {
        switch (extension_1.findType(docname(doc))) {
            case 'PDF':
            case 'WORD':
            case 'EXCEL':
            case 'PPT':
            case 'PDF':
            case 'TXT':
            case 'CAD':
                return OpenMethod.PREVIEW;
            case 'IMG':
                return OpenMethod.THUMBNAIL;
            case 'VIDEO':
            case 'AUDIO':
                return OpenMethod.PLAY;
            default:
                return OpenMethod.ABOUT;
        }
    }
}
exports.getOpenMethod = getOpenMethod;
/**
 * 对文档排序
 * @desc 文件夹优先，然后按文件名使用localeCompare进行本地化排序
 * @params docs 文档列表
 * @return 返回排序后的文档
 */
function sort(raw) {
    return raw.sort(function (a, b) {
        if (a.size === -1 && b.size !== -1) {
            return -1;
        }
        else if (a.size !== -1 && b.size === -1) {
            return 1;
        }
        else {
            return docname(a).localeCompare(docname(b));
        }
    });
}
exports.sort = sort;
/**
 * 列举目录
 */
function listDir(_a) {
    var docid = _a.docid;
    return dir_1.list({ docid: docid }).then(function (_a) {
        var dirs = _a.dirs, files = _a.files;
        return combineDocs({ dirs: dirs, files: files });
    });
}
exports.listDir = listDir;
/**
 * 列举文档并缓存
 */
exports.listDirDB = gns_1.cacheDB(listDir);
/**
 * 读取docid下所有文档，包括入口文档和list出的文档
 */
function load(docid) {
    return entrydoc_1.isVirtual(docid).then(function (isVirtual) {
        if (isVirtual) {
            return findSubs({ docid: docid });
        }
        else {
            gns_1.omitSubs({ docid: docid });
            return exports.listDirDB({ docid: docid }).then(function (docs) { return findSubs({ docid: docid }); });
        }
    });
}
exports.load = load;
/**
 * 合并dirs和files
 * @param docs 服务端列举出的dirs／files数据结构
 */
function combineDocs(_a) {
    var dirs = _a.dirs, files = _a.files;
    return dirs.concat(files);
}
exports.combineDocs = combineDocs;
/**
 * 获取下载地址
 */
function getDownloadURL(_a) {
    var docid = _a.docid, rev = _a.rev, userid = _a.userid, tokenid = _a.tokenid, savename = _a.savename;
    var _b = __read(openapi_1.getOpenAPIConfig('host').match(/^https?:\/\/(.+)$/), 2), fullhost = _b[0], reqhost = _b[1];
    return file_1.OSDownload({ docid: docid, rev: rev, authtype: 'QUERY_STRING', reqhost: reqhost, usehttps: openapi_1.useHTTPS(), savename: savename }, { userid: userid, tokenid: tokenid })
        .then(function (_a) {
        var _b = __read(_a.authrequest, 2), method = _b[0], url = _b[1];
        return url;
    });
}
exports.getDownloadURL = getDownloadURL;
/**
 * 批量下载
 */
function getBatchDownloadURL(_a) {
    var name = _a.name, files = _a.files, dirs = _a.dirs;
    var _b = __read(openapi_1.getOpenAPIConfig('host').match(/^https?:\/\/(.+)$/), 2), fullhost = _b[0], reqhost = _b[1];
    return file_1.batchDownload({ name: name, reqhost: reqhost, usehttps: openapi_1.useHTTPS(), files: files, dirs: dirs }).then(function (_a) {
        var method = _a.method, url = _a.url;
        return url;
    });
}
exports.getBatchDownloadURL = getBatchDownloadURL;
/**
 * 下载文件
 */
function download(_a) {
    var docid = _a.docid, rev = _a.rev, userid = _a.userid, tokenid = _a.tokenid;
    return getDownloadURL({ docid: docid, rev: rev, userid: userid, tokenid: tokenid }).then(function (url) {
        location.assign(url);
    });
}
exports.download = download;
/**
 * 是否可以使用OWAS预览
 */
function canOWASPreview(doc) {
    return config_1.getOEMConfig().then(function (_a) {
        var owasurl = _a.owasurl, wopiurl = _a.wopiurl;
        return !!(owasurl && wopiurl && extension_1.OWASSupported(docname(doc)));
    });
}
exports.canOWASPreview = canOWASPreview;
/**
 * 是否可以使用OWA编辑
 */
function canOWASEdit(doc) {
    return config_1.getOEMConfig().then(function (_a) {
        var owasurl = _a.owasurl, wopiurl = _a.wopiurl;
        return !!(owasurl && wopiurl && extension_1.OWASSupported(docname(doc), { editable: true }));
    });
}
exports.canOWASEdit = canOWASEdit;
/**
 * 是否支持cad预览
 */
function canCADPreview() {
    return config_1.getOEMConfig('cadpreview');
}
exports.canCADPreview = canCADPreview;
/**
 * 是否支持.dg/.sep预览
 */
function canSursenPreview() {
    return config_1.getOEMConfig('sursenpreview');
}
exports.canSursenPreview = canSursenPreview;
/**
 * 通过名字查找缓存的文档对象，可能返回多个匹配的名字
 */
function listByName(name) {
    return lodash_1.values(gns_1.DATABASE).filter(function (doc) { return docname(doc) === name; });
}
exports.listByName = listByName;
/**
 * 查找目录下子文档
 * @param parent 要查找的目录
 * @param predicate 对子文档进行进一步过滤的函数
 * @return 返回所有子文档或符合filter函数的子文档
 */
function findSubs(parent, predicate) {
    if (predicate === void 0) { predicate = function () { return true; }; }
    var REG_SUB_DOC = new RegExp(parent.docid + "/\\w+$");
    return lodash_1.values(gns_1.DATABASE).filter(function (doc) { return REG_SUB_DOC.test(doc.docid) && predicate(doc); });
}
exports.findSubs = findSubs;
/**
 * 从数据中中查找docid对应的文档
 * @param docid 文档docid
 * @return 匹配的文档对象
 */
function findById(docid) {
    return gns_1.DATABASE[docid] || null;
}
exports.findById = findById;


/***/ }),

/***/ "../ShareWebCore/src/docs/index.ts":
/***/ (function(module, exports, __webpack_require__) {

function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
exports.__esModule = true;
__export(__webpack_require__("../ShareWebCore/src/docs/docs.ts"));


/***/ }),

/***/ "../ShareWebCore/src/download/download.ts":
/***/ (function(module, exports, __webpack_require__) {

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
exports.__esModule = true;
var _a;
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/docs.ts");
var extension_1 = __webpack_require__("../ShareWebCore/src/extension/extension.ts");
var file_1 = __webpack_require__("../ShareWebCore/src/apis/efshttp/file/file.ts");
var link_1 = __webpack_require__("../ShareWebCore/src/apis/efshttp/link/link.ts");
var openapi_1 = __webpack_require__("../ShareWebCore/src/openapi/openapi.ts");
var browser_1 = __webpack_require__("../ShareWebUtil/src/browser/index.ts");
var event_1 = __webpack_require__("../ShareWebCore/src/event/event.ts");
var http_1 = __webpack_require__("../ShareWebUtil/src/http/index.ts");
var permission_1 = __webpack_require__("../ShareWebCore/src/permission/permission.ts");
var fs = __webpack_require__("../ShareWebCore/src/filesystem/filesystem.ts");
var EventType;
(function (EventType) {
    /**
     * 下载成功
     */
    EventType[EventType["DOWNLOAD_SUCCESS"] = 0] = "DOWNLOAD_SUCCESS";
    /**
     * 下载失败
     */
    EventType[EventType["DOWNLOAD_ERROR"] = 1] = "DOWNLOAD_ERROR";
})(EventType = exports.EventType || (exports.EventType = {}));
exports.subscribe = (_a = event_1.eventFactory(EventType), _a.subscribe), exports.trigger = _a.trigger;
var ErrorCode;
(function (ErrorCode) {
    /** iOS不允许下载 */
    ErrorCode[ErrorCode["FAIL_IOS"] = 0] = "FAIL_IOS";
    /** 微信不支持下载 */
    ErrorCode[ErrorCode["FAIL_WECHAT"] = 1] = "FAIL_WECHAT";
    /** 无复制权限 */
    ErrorCode[ErrorCode["No_COPY_PERMISSION"] = 2] = "No_COPY_PERMISSION";
    /** 密级不足 */
    ErrorCode[ErrorCode["SECURITY_INSUFICIENT"] = 403065] = "SECURITY_INSUFICIENT";
    /** 文件不存在 */
    ErrorCode[ErrorCode["FILE_NOT_EXISTED"] = 404006] = "FILE_NOT_EXISTED";
    /** 无下载权限 */
    ErrorCode[ErrorCode["FILE_NO_PERMISSION"] = 403002] = "FILE_NO_PERMISSION";
    /** 无法传输大文件 */
    ErrorCode[ErrorCode["FILE_SIZE_LIMITED"] = 403070] = "FILE_SIZE_LIMITED";
    /** 外链不存在 */
    ErrorCode[ErrorCode["LINK_NOT_EXISTED"] = 404008] = "LINK_NOT_EXISTED";
    /** 下载次数达到上线 */
    ErrorCode[ErrorCode["DOWNLOADS_LIMIT"] = 403153] = "DOWNLOADS_LIMIT";
    /** 添加水印失败 */
    ErrorCode[ErrorCode["WATERMARKING_FAILED"] = 403170] = "WATERMARKING_FAILED";
    /** 等待制作水印 */
    ErrorCode[ErrorCode["WAITING_WATERMARK"] = 503006] = "WAITING_WATERMARK";
    /** 正在制作水印  */
    ErrorCode[ErrorCode["MAKING_WATERMARK"] = 503005] = "MAKING_WATERMARK";
    /** 站点被移除 */
    ErrorCode[ErrorCode["SITE_REMOVED"] = 404017] = "SITE_REMOVED";
    /** 水印文档禁止批量下载 */
    ErrorCode[ErrorCode["WATERMARK_BATCH_DENIED"] = 403183] = "WATERMARK_BATCH_DENIED";
    /** 不支持水印 */
    ErrorCode[ErrorCode["WATERMARK_NOT_SUPPORT"] = 403178] = "WATERMARK_NOT_SUPPORT";
    /** 外链密码不正确 */
    ErrorCode[ErrorCode["LINK_AUTH_FAILED"] = 401002] = "LINK_AUTH_FAILED";
})(ErrorCode = exports.ErrorCode || (exports.ErrorCode = {}));
/**
 * 截取文件名，下载地址url长度限制
 * @param name 文件名
 * @param saveExt 后缀名
 * @param length 长度限制
 */
function subName(doc, saveExt, length) {
    if (saveExt === void 0) { saveExt = ''; }
    var name;
    if (doc === null) {
        /**
         * 根目录压缩包名为 files.zip
         */
        name = 'files';
    }
    else {
        name = docs_1.docname(doc);
    }
    var _a = __read((doc === null || docs_1.isDir(doc)) ? [name, ''] : extension_1.splitName(name), 2), base = _a[0], ext = _a[1];
    ext = saveExt || ext || '';
    if (ext && !ext.startsWith('.')) {
        ext = '.' + ext;
    }
    var result = base + ext, encoded = encodeURIComponent(encodeURIComponent(result)), top = result.length, bottom = 0;
    if (encoded.length <= length) {
        return result;
    }
    while (bottom <= top) {
        var mid = Math.floor(bottom + (top - bottom) / 2);
        result = base.slice(0, mid) + ext;
        /**
         * 下载地址对文件名进行两次 encodeURI
         **/
        encoded = encodeURIComponent(encodeURIComponent(result));
        if (encoded.length < length) {
            if (encodeURIComponent(encodeURIComponent(base.slice(0, mid + 1) + ext)).length > length) {
                break;
            }
            bottom = mid + 1;
        }
        else if (encoded.length > length) {
            if (encodeURIComponent(encodeURIComponent(base.slice(0, mid - 1) + ext)).length < length) {
                break;
            }
            top = mid - 1;
        }
        else {
            break;
        }
    }
    return result;
}
exports.subName = subName;
/**
 * 获取保存文件名
 * @param doc
 */
function getSaveName(doc) {
    return __awaiter(this, void 0, void 0, function () {
        var _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    if (!Array.isArray(doc)) return [3 /*break*/, 2];
                    if (doc.length === 1) {
                        return [2 /*return*/, subName(doc[0], 'zip', 750)];
                    }
                    _a = subName;
                    return [4 /*yield*/, fs.getParent(doc[0])];
                case 1: return [2 /*return*/, _a.apply(void 0, [_b.sent(), 'zip', 750])];
                case 2: return [2 /*return*/, subName(doc, '', 750)];
            }
        });
    });
}
/**
 * 获取下载地址
 * @param doc
 * @param savename
 */
function download(doc, _a, savename) {
    var _b = _a === void 0 ? {} : _a, _c = _b.IOSDisabled, IOSDisabled = _c === void 0 ? true : _c, _d = _b.WeChatDisabled, WeChatDisabled = _d === void 0 ? true : _d, _e = _b.checkPermission, checkPermission = _e === void 0 ? true : _e;
    if (savename === void 0) { savename = getSaveName; }
    return __awaiter(this, void 0, void 0, function () {
        var e_1, _f, host, userid, canDownload, _g, e_2, e_3, _h, reqhost, _j, dirs, files, _k, link, password, url, _l, link, password, docid, rev, _m, _o, url, need_watermark, _p, urlChunks, watermarkQuery_1, watermarkUrl, _q, body, _r, response, status, e_4, errcode;
        return __generator(this, function (_s) {
            switch (_s.label) {
                case 0:
                    /**
                     * 微信不支持下载
                     */
                    if (WeChatDisabled && browser_1.isBrowser({ app: browser_1.Browser.WeChat })) {
                        exports.trigger(EventType.DOWNLOAD_ERROR, null, { errcode: ErrorCode.FAIL_WECHAT });
                        return [2 /*return*/];
                    }
                    /**
                     * IOS 不支持下载
                     */
                    if (IOSDisabled && browser_1.isBrowser({ os: browser_1.OSType.IOS })) {
                        exports.trigger(EventType.DOWNLOAD_ERROR, null, { errcode: ErrorCode.FAIL_IOS });
                        return [2 /*return*/];
                    }
                    _s.label = 1;
                case 1:
                    _s.trys.push([1, 3, , 4]);
                    return [4 /*yield*/, (typeof doc === 'function' ? doc() : doc)];
                case 2:
                    doc = _s.sent();
                    return [3 /*break*/, 4];
                case 3:
                    e_1 = _s.sent();
                    return [2 /*return*/];
                case 4:
                    if (!doc || Array.isArray(doc) && doc.length === 0) {
                        return [2 /*return*/];
                    }
                    if (Array.isArray(doc) && doc.length === 1 && !docs_1.isDir(doc[0])) {
                        doc = doc[0];
                    }
                    else if (!Array.isArray(doc) && docs_1.isDir(doc)) {
                        doc = [doc];
                    }
                    _f = openapi_1.getOpenAPIConfig(), host = _f.host, userid = _f.userid;
                    if (!(checkPermission && !Array.isArray(doc))) return [3 /*break*/, 11];
                    _s.label = 5;
                case 5:
                    _s.trys.push([5, 10, , 11]);
                    if (!doc.link) return [3 /*break*/, 7];
                    return [4 /*yield*/, permission_1.checkLinkPerm({ link: doc.link, password: doc.password, perm: permission_1.LinkSharePermission.DOWNLOAD })];
                case 6:
                    _g = (_s.sent());
                    return [3 /*break*/, 9];
                case 7: return [4 /*yield*/, permission_1.checkPermItem(doc.docid, permission_1.SharePermission.COPY, userid)];
                case 8:
                    _g = (_s.sent());
                    _s.label = 9;
                case 9:
                    canDownload = _g;
                    if (!canDownload) {
                        throw { errcode: doc.link ? ErrorCode.FILE_NO_PERMISSION : ErrorCode.No_COPY_PERMISSION };
                    }
                    return [3 /*break*/, 11];
                case 10:
                    e_2 = _s.sent();
                    exports.trigger(EventType.DOWNLOAD_ERROR, null, {
                        errcode: e_2.errcode,
                        nativeEvent: e_2,
                        target: doc
                    });
                    return [2 /*return*/];
                case 11:
                    _s.trys.push([11, 13, , 14]);
                    return [4 /*yield*/, (typeof savename === 'function' ? savename(doc) : savename)];
                case 12:
                    savename = _s.sent();
                    return [3 /*break*/, 14];
                case 13:
                    e_3 = _s.sent();
                    return [2 /*return*/];
                case 14:
                    _h = __read(host.match(/^https?:\/\/(.+)$/), 2), reqhost = _h[1];
                    _s.label = 15;
                case 15:
                    _s.trys.push([15, 28, , 29]);
                    if (!Array.isArray(doc)) return [3 /*break*/, 20];
                    _j = doc.reduce(function (_a, doc) {
                        var dirs = _a.dirs, files = _a.files;
                        if (docs_1.isDir(doc)) {
                            dirs = __spread(dirs, [doc.docid]);
                        }
                        else {
                            files = __spread(files, [doc.docid]);
                        }
                        return { dirs: dirs, files: files };
                    }, { dirs: [], files: [] }), dirs = _j.dirs, files = _j.files;
                    _k = doc[0], link = _k.link, password = _k.password;
                    if (!link) return [3 /*break*/, 17];
                    return [4 /*yield*/, link_1.batchDownload({ name: savename, reqhost: reqhost, usehttps: openapi_1.useHTTPS(), files: files, dirs: dirs, link: link, password: password })];
                case 16:
                    _l = _s.sent();
                    return [3 /*break*/, 19];
                case 17: return [4 /*yield*/, file_1.batchDownload({ name: savename, reqhost: reqhost, usehttps: openapi_1.useHTTPS(), files: files, dirs: dirs })];
                case 18:
                    _l = _s.sent();
                    _s.label = 19;
                case 19:
                    url = (_l).url;
                    exports.trigger(EventType.DOWNLOAD_SUCCESS, null, url);
                    return [3 /*break*/, 27];
                case 20:
                    link = doc.link, password = doc.password, docid = doc.docid, rev = doc.rev;
                    if (!link) return [3 /*break*/, 22];
                    return [4 /*yield*/, link_1.OSDownload({ link: link, password: password, docid: docid, reqhost: reqhost, usehttps: openapi_1.useHTTPS(), savename: savename })];
                case 21:
                    _p = _s.sent();
                    return [3 /*break*/, 24];
                case 22: return [4 /*yield*/, file_1.OSDownload({ docid: docid, rev: rev, authtype: 'QUERY_STRING', reqhost: reqhost, usehttps: openapi_1.useHTTPS(), savename: savename })
                    /**
                     * 下载水印
                     */
                ];
                case 23:
                    _p = _s.sent();
                    _s.label = 24;
                case 24:
                    _m = _p, _o = __read(_m.authrequest, 2), url = _o[1], need_watermark = _m.need_watermark;
                    if (!need_watermark) return [3 /*break*/, 26];
                    urlChunks = url.split('&');
                    watermarkQuery_1 = urlChunks.filter(function (str) { return str.startsWith('watermark='); })[0];
                    watermarkUrl = urlChunks.filter(function (str) { return str !== watermarkQuery_1; }).join('&');
                    _q = __read(watermarkQuery_1.split('='), 2), body = _q[1];
                    body = JSON.parse(decodeURIComponent(body));
                    body.usehttps = openapi_1.useHTTPS();
                    body.reqhost = reqhost;
                    /**
                     * @todo: 当组件调用不是在as页面时，port 不一定是 location.port
                     */
                    body.reqport = location.port;
                    return [4 /*yield*/, http_1.post(watermarkUrl, JSON.stringify(body), { sendAs: 'text', readAs: 'json' })
                        /**
                        * 抛错
                        */
                    ];
                case 25:
                    _r = _s.sent(), response = _r.response, status = _r.status;
                    /**
                    * 抛错
                    */
                    if (status > 400) {
                        throw response;
                    }
                    url = response.authrequest[1];
                    _s.label = 26;
                case 26:
                    exports.trigger(EventType.DOWNLOAD_SUCCESS, null, url);
                    _s.label = 27;
                case 27: return [3 /*break*/, 29];
                case 28:
                    e_4 = _s.sent();
                    if (e_4) {
                        errcode = e_4.errcode;
                        exports.trigger(EventType.DOWNLOAD_ERROR, null, {
                            errcode: errcode,
                            nativeEvent: e_4,
                            target: doc
                        });
                    }
                    return [3 /*break*/, 29];
                case 29: return [2 /*return*/];
            }
        });
    });
}
exports.download = download;


/***/ }),

/***/ "../ShareWebCore/src/download/index.ts":
/***/ (function(module, exports, __webpack_require__) {

function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
exports.__esModule = true;
__export(__webpack_require__("../ShareWebCore/src/download/download.ts"));


/***/ }),

/***/ "../ShareWebCore/src/entrydoc/entrydoc.ts":
/***/ (function(module, exports, __webpack_require__) {

/// <reference path="./entrydoc.d.ts" />
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
exports.__esModule = true;
var _a;
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var gns_1 = __webpack_require__("../ShareWebCore/src/gns/gns.ts");
var cache_1 = __webpack_require__("../ShareWebUtil/src/cache/index.ts");
var entrydoc_1 = __webpack_require__("../ShareWebCore/src/apis/eachttp/entrydoc/entrydoc.ts");
var locale_1 = __webpack_require__("../ShareWebCore/src/entrydoc/locale.ts");
/**
 * 文档类型参数
 */
var DocType;
(function (DocType) {
    DocType[DocType["userdoc"] = 1] = "userdoc";
    DocType[DocType["groupdoc"] = 2] = "groupdoc";
    DocType[DocType["customdoc"] = 3] = "customdoc";
    DocType[DocType["sharedoc"] = 4] = "sharedoc";
    DocType[DocType["archivedoc"] = 5] = "archivedoc";
})(DocType = exports.DocType || (exports.DocType = {}));
/**
 * 文档分类
 */
var ViewDocType;
(function (ViewDocType) {
    ViewDocType[ViewDocType["UserDoc"] = 10] = "UserDoc";
    ViewDocType[ViewDocType["ShareDoc"] = 11] = "ShareDoc";
    ViewDocType[ViewDocType["GroupDoc"] = 20] = "GroupDoc";
    ViewDocType[ViewDocType["ShareGroup"] = 21] = "ShareGroup";
    ViewDocType[ViewDocType["CustomDoc"] = 30] = "CustomDoc";
    ViewDocType[ViewDocType["ArchiveDoc"] = 40] = "ArchiveDoc";
})(ViewDocType = exports.ViewDocType || (exports.ViewDocType = {}));
/**
 * 文档分类的名称
 */
exports.ViewTypesName = (_a = {},
    _a[ViewDocType.UserDoc] = locale_1["default"]('个人文档'),
    _a[ViewDocType.ShareDoc] = locale_1["default"]('共享文档'),
    _a[ViewDocType.GroupDoc] = locale_1["default"]('个人群组文档'),
    _a[ViewDocType.ShareGroup] = locale_1["default"]('共享群组文档'),
    _a[ViewDocType.CustomDoc] = locale_1["default"]('文档库'),
    _a[ViewDocType.ArchiveDoc] = locale_1["default"]('归档库'),
    _a);
/**
 * 根据type获取文档分类的名称
 */
function getViewTypesName(type) {
    var _a;
    var viewTypesName = (_a = {},
        _a[ViewDocType.UserDoc] = locale_1["default"]('个人文档'),
        _a[ViewDocType.ShareDoc] = locale_1["default"]('共享文档'),
        _a[ViewDocType.GroupDoc] = locale_1["default"]('个人群组文档'),
        _a[ViewDocType.ShareGroup] = locale_1["default"]('共享群组文档'),
        _a[ViewDocType.CustomDoc] = locale_1["default"]('文档库'),
        _a[ViewDocType.ArchiveDoc] = locale_1["default"]('归档库'),
        _a);
    return viewTypesName[type];
}
exports.getViewTypesName = getViewTypesName;
/**
 * 文档类型对应的名称
 */
var Types = {
    userdoc: locale_1["default"]('个人文档'),
    sharedoc: locale_1["default"]('共享文档'),
    groupdoc: locale_1["default"]('群组文档'),
    customdoc: locale_1["default"]('文档库'),
    archivedoc: locale_1["default"]('归档库')
};
// 指定类型的入口文档缓存
var Caches = {};
/**
 * 根据docid获取视图
 */
function getViewById(docid) {
    return Promise.all([getTypeById(docid), getTopViews()]).then(function (_a) {
        var _b = __read(_a, 2), doctype = _b[0], views = _b[1];
        return views.find(function (view) { return view.doc_type === doctype; });
    });
}
exports.getViewById = getViewById;
/**
 * 根据docType获取视图对象
 */
function getViewByType(docType) {
    return getTopViews().then(function (views) { return views.find(function (view) { return view.doc_type === DocType[docType]; }); });
}
exports.getViewByType = getViewByType;
/**
 * 获取入口文档顶级视图
 */
function getTopViews(options) {
    return entrydoc_1.getViews(null, options).then(function (_a) {
        var viewsinfo = _a.viewsinfo;
        return viewsinfo;
    });
}
exports.getTopViews = getTopViews;
/**
 * 判断是否是视图对象
 * @param o 任意文档对象
 */
function isTopView(o) {
    return !!(o && o.doc_type !== undefined);
}
exports.isTopView = isTopView;
/**
 * 根据doctype获取对应名称
 */
function getTypeNameByDocType(doctype) {
    if (typeof doctype === 'string') {
        return Types[doctype];
    }
    else if (typeof doctype === 'number') {
        return Types[DocType[doctype]];
    }
}
exports.getTypeNameByDocType = getTypeNameByDocType;
/**
 * 根据名称获取doctype
 * @param name 文档类型的名称
 */
function getDocTypeByName(name) {
    switch (name) {
        case locale_1["default"]('个人文档'):
            return DocType['userdoc'];
        case locale_1["default"]('共享文档'):
            return DocType['sharedoc'];
        case locale_1["default"]('群组文档'):
            return DocType['groupdoc'];
        case locale_1["default"]('文档库'):
            return DocType['customdoc'];
        case locale_1["default"]('归档库'):
            return DocType['archivedoc'];
    }
}
exports.getDocTypeByName = getDocTypeByName;
/**
 * 根据docid获取doctype
 * @param docid
 */
function getTypeById(docid) {
    return exports.queryAll().then(function (entries) {
        var finded = lodash_1.find(entries, function (entry) { return entry.docid.indexOf(docid) !== -1 || docid.indexOf(entry.docid) !== -1; });
        return finded && finded.doctype;
    });
}
exports.getTypeById = getTypeById;
/**
 * 获取视图名称
 */
function getViewName(view) {
    switch (view.doc_type) {
        case 'userdoc':
            return locale_1["default"]('个人文档');
        case 'sharedoc':
            return locale_1["default"]('共享文档');
        case 'groupdoc':
            return locale_1["default"]('群组文档');
        case 'customdoc':
            return locale_1["default"]('文档库');
        case 'archivedoc':
            return locale_1["default"]('归档库');
        default:
            return '';
    }
}
exports.getViewName = getViewName;
/**
 * 批量分解入口文档
 */
function resolveEntries(raw) {
    return raw.reduce(function (result, entry) { return result.concat(resolveSingleEntry(entry)); }, []);
}
exports.resolveEntries = resolveEntries;
/**
 * 将单条入口文档分解成文档组成的数组
 */
function resolveSingleEntry(entry) {
    var gnsList = splitGNS(entry.docid);
    var docnames = entry.docname.split('\\');
    return gnsList.reduce(function (prev, gns, i, arr) {
        return prev.concat(i === arr.length - 1 ?
            // 最后一级文档即为入口文档本身
            lodash_1.assign(lodash_1.omit(entry, ['docname', 'docid']), { docname: docnames[i], docid: gns }) :
            // 否则认为是虚拟目录
            lodash_1.assign(lodash_1.pick(entry, ['doctype', 'typename']), { docname: docnames[i], docid: gns }));
    }, []);
}
;
/**
 * 获取某一类型顶级入口文档
 */
function getTopEntriesByType(doctype) {
    return exports.getResolvedByTypeDB(doctype).then(function (entries) { return lodash_1.uniq(entries.filter(function (entry) { return calcGNSLevel(entry.docid) === 1; }), function (entry) { return entry.docname; }); });
}
exports.getTopEntriesByType = getTopEntriesByType;
/**
 * 将单条gns路径分解成多条
 */
function splitGNS(GNS) {
    return GNS.replace(/^gns:\/\//, '').split('/').reduce(function (prev, path, i, arr) {
        return prev.concat('gns://' + arr.slice(0, i + 1).join('/'));
    }, []);
}
exports.splitGNS = splitGNS;
/**
 * 计算GNS路径的层级
 */
function calcGNSLevel(gns) {
    return splitGNS(gns).length;
}
exports.calcGNSLevel = calcGNSLevel;
/**
 * 获取所有入口文档
 */
exports.queryAll = cache_1.cache(function () { return entrydoc_1.get().then(function (_a) {
    var docinfos = _a.docinfos;
    return docinfos;
}); });
/**
 * 获取指定类型的入口文档
 */
function queryByType(doctype, _a) {
    var _b = (_a === void 0 ? {} : _a).update, update = _b === void 0 ? false : _b;
    if (!Caches[DocType[doctype]] || update === true) {
        Caches[DocType[doctype]] = entrydoc_1.getByType({ doctype: doctype }).then(function (_a) {
            var docinfos = _a.docinfos;
            return docinfos;
        });
    }
    return Caches[DocType[doctype]];
}
exports.queryByType = queryByType;
;
/**
 * 比较指定类型的文档，返回三元数组 [新增，修改，删除] 的入口文档
 * @param doctype 文档类型
 * @param prev 现有的指定类型入口文档
 */
function compare(next, prev) {
    if (next === void 0) { next = []; }
    if (prev === void 0) { prev = []; }
    var added = next.filter(function (_a) {
        var docid = _a.docid;
        return !lodash_1.some(prev, function (doc) { return doc.docid === docid; });
    });
    var modified = next.filter(function (_a) {
        var docid = _a.docid, otag = _a.otag;
        return lodash_1.some(prev, function (doc) { return doc.docid === docid && doc.otag !== otag; });
    });
    var deleted = prev.filter(function (_a) {
        var docid = _a.docid;
        return !lodash_1.some(next, function (doc) { return doc.docid === docid; });
    });
    return [added, modified, deleted];
}
/**
 * 比较指定类型的文档，返回三元数组 [新增，修改，删除] 的入口文档
 * @param doctype 文档类型
 * @param prev
 */
function getCompared(doctype) {
    var query = doctype ? entrydoc_1.getByType({ doctype: doctype }) : entrydoc_1.get();
    return query.then(function (_a) {
        var docinfos = _a.docinfos;
        var _b;
        var next = doctype ? (_b = {}, _b[doctype] = docinfos, _b) : groupByType(docinfos);
        var unzipped = lodash_1.map(next, function (entries, doctype) {
            return compare(next[doctype], Caches[DocType[doctype]]);
        }); // [[added, modified, deleted], [added, modified, deleted], ...]
        if (!doctype) {
            Caches = lodash_1.mapKeys(next, function (docs, doctype) { return DocType[doctype]; });
        }
        else {
            Caches = lodash_1.assign({}, Caches, lodash_1.mapKeys(next, function (docs, doctype) { return DocType[doctype]; }));
        }
        return lodash_1.zipWith.apply(void 0, __spread(unzipped, [function (accumulator, value) { return __spread(accumulator, value); }])); // 合并 unzipped => [added, modified, deleted]
    });
}
exports.getCompared = getCompared;
/**
 * 将入口文档分类
 * @param entries 入口文档
 */
function groupByType(entries) {
    return lodash_1.assign({
        userdoc: [],
        sharedoc: [],
        groupdoc: [],
        customdoc: [],
        archivedoc: []
    }, lodash_1.groupBy(entries, 'doctype'));
}
exports.groupByType = groupByType;
/**
 * 获取组织好的数据
 */
function getResolvedAll(_a) {
    var _b = (_a === void 0 ? {} : _a).update, update = _b === void 0 ? false : _b;
    return exports.queryAll({ update: update }).then(function (raw) { return resolveEntries(raw); });
}
exports.getResolvedAll = getResolvedAll;
;
/**
 * 获取组织好的数据并缓存
 */
exports.getResolvedAllDB = gns_1.cacheDB(getResolvedAll);
/**
 * 获取组织好的指定类型数据
 */
function getResolvedByType(doctype, _a) {
    var _b = (_a === void 0 ? {} : _a).update, update = _b === void 0 ? false : _b;
    return queryByType(doctype, { update: update }).then(function (raw) { return resolveEntries(raw); });
}
exports.getResolvedByType = getResolvedByType;
/**
 * 获取组织好的指定类型数据并缓存
 */
exports.getResolvedByTypeDB = gns_1.cacheDB(getResolvedByType);
/**
 * 获取所有入口文档的docid
 */
function getIds(_a) {
    var _b = (_a === void 0 ? {} : _a).update, update = _b === void 0 ? false : _b;
    return exports.queryAll({ update: update }).then(function (raw) { return lodash_1.map(raw, function (doc) { return doc.docid; }); });
}
exports.getIds = getIds;
;
/**
 * 获取所有入口文档的docid
 */
function getIdsByType(doctype, _a) {
    var _b = (_a === void 0 ? {} : _a).update, update = _b === void 0 ? false : _b;
    return queryByType(doctype, { update: update }).then(function (raw) { return lodash_1.map(raw, function (doc) { return doc.docid; }); });
}
exports.getIdsByType = getIdsByType;
;
/**
 * 判断一个目录是否是虚拟目录
 */
function isVirtual(docid, _a) {
    var _b = (_a === void 0 ? {} : _a).update, update = _b === void 0 ? false : _b;
    return getIds({ update: update }).then(function (entryIds) { return lodash_1.some(entryIds, function (entryId) { return entryId.indexOf(docid) !== -1 && entryId !== docid; }); });
}
exports.isVirtual = isVirtual;
;
/**
 * 判断一个文档是否是入口文档或虚拟目录
 */
function isInEntry(docid) {
    return __awaiter(this, void 0, void 0, function () {
        var entryIds;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, getIds({ update: true })];
                case 1:
                    entryIds = (_a.sent()) || [];
                    return [2 /*return*/, entryIds.some(function (entryId) { return entryId.indexOf(docid) !== -1; })];
            }
        });
    });
}
exports.isInEntry = isInEntry;


/***/ }),

/***/ "../ShareWebCore/src/entrydoc/index.ts":
/***/ (function(module, exports, __webpack_require__) {

function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
exports.__esModule = true;
__export(__webpack_require__("../ShareWebCore/src/entrydoc/entrydoc.ts"));


/***/ }),

/***/ "../ShareWebCore/src/entrydoc/locale.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var i18n_1 = __webpack_require__("../ShareWebCore/src/i18n.ts");
exports["default"] = i18n_1["default"]([
    [
        '个人文档',
        '個人文件',
        'My Documents'
    ],
    [
        '共享文档',
        '共用文件',
        'Shared Documents'
    ],
    [
        '群组文档',
        '群組文件',
        'Group Documents'
    ],
    [
        '文档库',
        '文件庫',
        'Libraries'
    ],
    [
        '归档库',
        '歸檔庫',
        'Archive Libraries'
    ],
    [
        '个人群组文档',
        '個人群組文件',
        'My Group Documents'
    ],
    [
        '共享群组文档',
        '共用群組文件',
        'Shared Group Documents'
    ]
]);


/***/ }),

/***/ "../ShareWebCore/src/errcode/errcode.ts":
/***/ (function(module, exports, __webpack_require__) {

var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
exports.__esModule = true;
var _a;
var optype_1 = __webpack_require__("../ShareWebCore/src/optype/optype.ts");
var errorcode_1 = __webpack_require__("../ShareWebCore/src/apis/openapi/errorcode.ts");
var locale_1 = __webpack_require__("../ShareWebCore/src/errcode/locale.ts");
// 异常码对应中文描述，用于在国际化资源中查找对应信息
// 国际化资源需要在locale中定义
var ErrorKeyHash = (_a = {},
    _a[errorcode_1.ErrorCode.URINotExists] = '不支持的接口',
    _a[errorcode_1.ErrorCode.ParametersIllegal] = '非法参数',
    _a[errorcode_1.ErrorCode.URIFormatIllegal] = '非法URI参数',
    _a[errorcode_1.ErrorCode.JSONFormatIllegal] = '非法JSON字符串',
    _a[errorcode_1.ErrorCode.PermConfigIllegal] = '非法权限值类型',
    _a[errorcode_1.ErrorCode.AccessorIllegal] = '非法访问者类型',
    _a[errorcode_1.ErrorCode.ChunkMismatched] = '数据块大小和实际大小不匹配',
    _a[errorcode_1.ErrorCode.SearchCharacterIllegal] = '全文检索语法错误，特殊字符或错误编码',
    _a[errorcode_1.ErrorCode.SearchParameterInvalid] = '全文检索请求查询的参数无效',
    _a[errorcode_1.ErrorCode.LocalTimeInvalid] = '您设置的时间已经早于服务器的当前时间，请重新设置或校对时间。',
    _a[errorcode_1.ErrorCode.ExpirationInvalid] = '您设置的有效期已经超过了5年的限制，请重新设置或校对时间。',
    _a[errorcode_1.ErrorCode.NameInvalid] = '标签名不能包含 / : * ? " < > | 特殊字符，请重新输入',
    _a[errorcode_1.ErrorCode.PermConfigExpired] = '您设置的权限有效期限已经早于服务器的当前时间，请重新设置或校对时间。',
    _a[errorcode_1.ErrorCode.LinkConfigExpired] = '您设置的链接有效期限已经早于服务器的当前时间，请重新设置或校对时间。',
    _a[errorcode_1.ErrorCode.TokenExpired] = '登录已超时',
    _a[errorcode_1.ErrorCode.LinkAuthFailed] = '外链密码不正确',
    _a[errorcode_1.ErrorCode.AuthFailed] = '用户名或者密码不正确。',
    _a[errorcode_1.ErrorCode.UserDisabled] = '账号已被禁用',
    _a[errorcode_1.ErrorCode.EncryptionInvalid] = '加密凭证无效',
    _a[errorcode_1.ErrorCode.AdminLoginFailed] = '您是管理员角色，无法登录Web客户端',
    _a[errorcode_1.ErrorCode.DomainDisabled] = '域用户所属的域已被禁用或删除',
    _a[errorcode_1.ErrorCode.UserNotInDomain] = '用户不存在于域控中',
    _a[errorcode_1.ErrorCode.DeviceBinded] = '该账号已绑定设备，无法登录Web端',
    _a[errorcode_1.ErrorCode.PasswordFailure] = '您的登录密码已失效，是否立即修改密码？',
    _a[errorcode_1.ErrorCode.PasswordInsecure] = '您的密码安全系数过低，是否立即修改密码？',
    _a[errorcode_1.ErrorCode.PasswordInvalid] = '新密码格式不正确，请输入10-32个字符，且只能包含大小写字母、数字及~`!@#$%-_,.特殊字符',
    _a[errorcode_1.ErrorCode.PasswordWeak] = '新密码格式不正确，请输入10-32个字符，需同时包含大小写字母及数字，支持~`!@#$%-_,.特殊字符',
    _a[errorcode_1.ErrorCode.PasswordChangeNotSupported] = '当前用户为外部用户，不支持修改密码',
    _a[errorcode_1.ErrorCode.PasswordIsInitial] = '无法使用初始密码登录，是否立即修改密码？',
    _a[errorcode_1.ErrorCode.PasswordInvalidOnce] = '您已输错1次密码，连续输错3次将导致账号被锁定',
    _a[errorcode_1.ErrorCode.PasswordInvalidTwice] = '您已输错2次密码，连续输错3次将导致账号被锁定',
    _a[errorcode_1.ErrorCode.PasswordInvalidLocked] = '您输入错误次数超过限制，账号已被锁定，1小时内无法登录，请稍后重试',
    _a[errorcode_1.ErrorCode.PasswordRestricted] = '您没有权限修改密码，请联系管理员。',
    _a[errorcode_1.ErrorCode.LicenseInvalid] = '当前产品未经授权，您无法登录，请联系管理员。',
    _a[errorcode_1.ErrorCode.AccountDuplicatedLogin] = '当前帐号在另一地点登录，您被迫下线！',
    _a[errorcode_1.ErrorCode.PasswordExpired] = '您的密码已过期, 请联系管理员。',
    _a[errorcode_1.ErrorCode.LoginSiteInvalid] = '当前站点为分站点模式，无法登录。',
    _a[errorcode_1.ErrorCode.LicenseExpired] = '产品授权已过期，您无法登录，请联系管理员。',
    _a[errorcode_1.ErrorCode.LinkVisitExceeded] = '抱歉，您的打开次数已达上限！',
    _a[errorcode_1.ErrorCode.IPRestricted] = '您受到IP 网段限制，无法登录，请联系管理员',
    _a[errorcode_1.ErrorCode.AccountLocked] = '您输入错误次数超过限制，账号已被锁定，请联系安全管理员',
    _a[errorcode_1.ErrorCode.ClientRestricted] = '管理员已禁止此类客户端登录',
    _a[errorcode_1.ErrorCode.NetworkChanged] = '您所在的网络环境已改变，请重新登录。',
    _a[errorcode_1.ErrorCode.VCodeMissing] = '验证码不能为空，请重新输入',
    _a[errorcode_1.ErrorCode.VCodeExpired] = '验证码已过期，请重新输入',
    _a[errorcode_1.ErrorCode.VCodeInvalid] = '验证码不正确，请重新输入',
    _a[errorcode_1.ErrorCode.QuotaExhausted] = '目标位置的配额空间不足。',
    _a[errorcode_1.ErrorCode.PermissionRestricted] = function (opType) {
        switch (opType) {
            case optype_1.OpType.ALL:
                return '没有权限执行此操作。';
            case optype_1.OpType.DOWNLOAD:
                return '您没有下载权限。';
            case optype_1.OpType.UPLOAD:
                return '您没有上传权限。';
            case optype_1.OpType.COLLECT:
                return '无法执行收藏操作，您对文件“${filename}”没有显示权限。';
        }
    },
    _a[errorcode_1.ErrorCode.OwnershipRestricted] = '只有文档所有者才能进行该操作',
    _a[errorcode_1.ErrorCode.OwnershipTypeError] = '个人文档不能设置所有者',
    _a[errorcode_1.ErrorCode.SelfOwnershipRestricted] = '不能添加自己或设置管理员为所有者',
    _a[errorcode_1.ErrorCode.SelfDeOwnershipRestricted] = '不能删除自己的所有者配置',
    _a[errorcode_1.ErrorCode.GroupCountLimited] = '个人创建的群组个数不能超过3个',
    _a[errorcode_1.ErrorCode.PermissionAccessorInaccessible] = '配权限时，访问者不存在',
    _a[errorcode_1.ErrorCode.PersonalQuotaZero] = '个人空间配额不能设置为0',
    _a[errorcode_1.ErrorCode.GroupNameDuplicated] = '该名称已被占用，请重新输入',
    _a[errorcode_1.ErrorCode.OwnershipAccessorInaccessible] = '配所有者时，指定用户不存在',
    _a[errorcode_1.ErrorCode.AccessorDuplicated] = '用户已经存在',
    _a[errorcode_1.ErrorCode.LinkDuplicated] = '外链已经存在',
    _a[errorcode_1.ErrorCode.WriteCompleteReversion] = '不能向完整版本添加数据块',
    _a[errorcode_1.ErrorCode.ObjectTypeError] = '操作的对象类型不正确',
    _a[errorcode_1.ErrorCode.RecycleDeleteInaccessible] = '不能删除不在回收站的文件或目录',
    _a[errorcode_1.ErrorCode.RecycleRestoreInaccessible] = '不能还原不在回收站的文件或目录',
    _a[errorcode_1.ErrorCode.DownloadReversionIncomplete] = '不能下载非完整的版本对象',
    _a[errorcode_1.ErrorCode.PathInvalid] = '对象无法移动到相同的路径，或跨管理节点移动对象',
    _a[errorcode_1.ErrorCode.PublicShareDuplicated] = '当前目录已经开启或关闭发现共享，导致操作失败',
    _a[errorcode_1.ErrorCode.ParentPublicShareEnabled] = '父目录已经开启或关闭发现共享，导致操作失败',
    _a[errorcode_1.ErrorCode.DocumentDeleteInaccessible] = '不能删除不存在的数据块',
    _a[errorcode_1.ErrorCode.PreviewSizeExceeded] = '预览文档或缩略图过大，预览失败',
    _a[errorcode_1.ErrorCode.GNSInvalid] = '管理对象不存在',
    _a[errorcode_1.ErrorCode.SizeExceeded] = '请求内容超过对象大小',
    _a[errorcode_1.ErrorCode.PreviewFormatInvalid] = '文档预览失败，格式错误',
    _a[errorcode_1.ErrorCode.ThumbnailFormatInvalid] = '缩略图预览失败，格式错误',
    _a[errorcode_1.ErrorCode.CASDisabled] = '第三方认证未开启',
    _a[errorcode_1.ErrorCode.TicketInvalid] = '无法验证ticket',
    _a[errorcode_1.ErrorCode.UserNotFound] = '该用户未导入到AnyShare系统中',
    _a[errorcode_1.ErrorCode.FullnameDuplicated] = '已存在同类型的同名文档',
    _a[errorcode_1.ErrorCode.NameDuplicatedReadonly] = '存在与当前文件“${filename}”同名的文件但无修改权限',
    _a[errorcode_1.ErrorCode.DiffTypeNameDuplicated] = '与当前文件“${filename}”同名的是一个文件夹。',
    _a[errorcode_1.ErrorCode.TrancodeFormatUnsupported] = '转码失败，文件格式不支持',
    _a[errorcode_1.ErrorCode.PermissionMismath] = '没有权限操作目标位置的对象',
    _a[errorcode_1.ErrorCode.LinkRestricted] = '您没有外链共享权限，请联系管理员。',
    _a[errorcode_1.ErrorCode.CSFLevelMismatch] = '您的密级不足。',
    _a[errorcode_1.ErrorCode.TranscodeSpaceExhausted] = '转码失败，服务器缓存空间不足',
    _a[errorcode_1.ErrorCode.DocumentSizeExceeded] = '文件“${filename}”过大，无法同步，您所在的网络存在限制。',
    _a[errorcode_1.ErrorCode.ApplyAuditMissing] = '当前无匹配的审核员，本次操作无法生效，请联系管理员。',
    _a[errorcode_1.ErrorCode.ShareApplyComplete] = '此条记录已失效或被其他审核员审核完成。',
    _a[errorcode_1.ErrorCode.ShareApplyInvalid] = '您的审核权限已失效。',
    _a[errorcode_1.ErrorCode.ShareApplyAccessorInaccessible] = '此条申请已经失效（访问者已经被删除）',
    _a[errorcode_1.ErrorCode.ApplyDenyConcentMissing] = '否决申请时，内容不能为空',
    _a[errorcode_1.ErrorCode.ShareApplySharerInaccessible] = '此条申请已失效（共享者已经被删除）',
    _a[errorcode_1.ErrorCode.ShareApplyExpired] = '此条申请已失效（截止时间已经过期）',
    _a[errorcode_1.ErrorCode.LinkApplyInvalid] = '此条申请已失效（外链已失效）',
    _a[errorcode_1.ErrorCode.LinkApplyDuplicated] = '此条申请已失效（外链已存在）',
    _a[errorcode_1.ErrorCode.AuditCSFMismatch] = '当前审核员密级不足，本次操作无法生效，请联系管理员。',
    _a[errorcode_1.ErrorCode.InsufficientCSFLevel] = '您的密级不足。',
    _a[errorcode_1.ErrorCode.ArchiveModificationRestriced] = '您无法修改归档库的文件。',
    _a[errorcode_1.ErrorCode.InvitationDuplicated] = '共享邀请链接已存在。',
    _a[errorcode_1.ErrorCode.InvitationExcluded] = '您不在共享范围内，无法加入。',
    _a[errorcode_1.ErrorCode.InvitationDisabled] = '共享邀请链接功能未开启。',
    _a[errorcode_1.ErrorCode.InvitationRestricted] = '涉密和共享审核模式下不允许邀请加入。',
    _a[errorcode_1.ErrorCode.ShareExpirationExpired] = '您设置的权限有效期限已经早于服务器的当前时间，请重新设置或校对时间。',
    _a[errorcode_1.ErrorCode.LinkExpirationExpired] = '您设置的链接有效期限已经早于服务器的当前时间，请重新设置或校对时间。',
    _a[errorcode_1.ErrorCode.LinkExpirationConflict] = '链接有效期限不能大于权限有效期限。',
    _a[errorcode_1.ErrorCode.CommentSubmitDisabled] = '发表失败，评论功能没有正常启用，请联系管理员。',
    _a[errorcode_1.ErrorCode.CommentDeleteDisabled] = '删除失败，评论功能没有正常启用，请联系管理员。',
    _a[errorcode_1.ErrorCode.CommentSubmitDuplicated] = '发表失败，不能对同一文件重复评分。',
    _a[errorcode_1.ErrorCode.CommentDeleteUnauthorized] = '删除失败，只能删除自己发表的评论。',
    _a[errorcode_1.ErrorCode.DownloadExceeded] = '无法执行下载操作，您的下载次数超出限制',
    _a[errorcode_1.ErrorCode.PersonalShareUnauthorized] = '您没有共享个人文档权限，无法进行权限配置。',
    _a[errorcode_1.ErrorCode.GroupShareUnauthorized] = '您没有共享群组文档权限，无法进行权限配置。',
    _a[errorcode_1.ErrorCode.PersonalInvitationUnauthorized] = '您没有共享个人文档权限，无法开启共享邀请。',
    _a[errorcode_1.ErrorCode.GroupInvitationUnauthorized] = '您没有共享群组文档权限，无法开启共享邀请。',
    _a[errorcode_1.ErrorCode.PersonLinkUnauthorized] = '您没有共享个人文档权限，无法开启外链。',
    _a[errorcode_1.ErrorCode.GroupLinkUnauthorized] = '您没有共享群组文档权限，无法开启外链。',
    _a[errorcode_1.ErrorCode.PersonLinkModificationUnauthorized] = '您没有共享个人文档权限，无法修改外链。',
    _a[errorcode_1.ErrorCode.GroupLinkModificationUnathorized] = '您没有共享群组文档权限，无法修改外链。',
    _a[errorcode_1.ErrorCode.PersonalInvitationModificationUnauthorized] = '您没有共享个人文档权限，无法修改共享邀请。',
    _a[errorcode_1.ErrorCode.GroupInvitationModificationUnauthorized] = '您没有共享群组文档权限，无法修改共享邀请。',
    _a[errorcode_1.ErrorCode.AccountFrozen] = '您的账号已被冻结。',
    _a[errorcode_1.ErrorCode.DocumentFrozen] = '该文档已被冻结。',
    _a[errorcode_1.ErrorCode.GroupInaccessible] = '群组不存在',
    _a[errorcode_1.ErrorCode.DeparmentInaccessible] = '获取子部门或子用户信息时，指定部门不存在',
    _a[errorcode_1.ErrorCode.ParentObjectInaccessible] = '父对象不存在',
    _a[errorcode_1.ErrorCode.UserInfoInaccessible] = '获取用户信息时，用户不存在',
    _a[errorcode_1.ErrorCode.EntrydocInaccessible] = '入口文档记录不存在',
    _a[errorcode_1.ErrorCode.GNSInaccessible] = '文件或文件夹“${filename}”不存在, 可能其所在路径发生变更。',
    _a[errorcode_1.ErrorCode.LinkInaccessable] = '外链地址已失效。',
    _a[errorcode_1.ErrorCode.DataChunkInaccessible] = '请求对应数据块不存在',
    _a[errorcode_1.ErrorCode.ReversionIncomplete] = '没有完整的版本',
    _a[errorcode_1.ErrorCode.DataChunkIncomplete] = '数据块信息不完整',
    _a[errorcode_1.ErrorCode.MailtoFormatInvalid] = '邮箱收件人格式不正确，请重新输入。',
    _a[errorcode_1.ErrorCode.SMTPConfigMissing] = 'SMTP服务器未设置，请联系管理员。',
    _a[errorcode_1.ErrorCode.SMTPUnknownError] = 'SMTP服务器存在未知错误，请联系管理员。',
    _a[errorcode_1.ErrorCode.SMTPInaccessible] = 'SMTP服务器不可用，请联系管理员。',
    _a[errorcode_1.ErrorCode.DocumentInaccessible] = '文档不存在。',
    _a[errorcode_1.ErrorCode.InvitationInaccessible] = '共享邀请链接不存在。',
    _a[errorcode_1.ErrorCode.OwnerMissing] = '文档所有者不存在。',
    _a[errorcode_1.ErrorCode.HTTPMethodError] = 'HTTP方法错误',
    _a[errorcode_1.ErrorCode.InternalError] = '内部错误',
    _a[errorcode_1.ErrorCode.PreviewFailed] = '预览文件或缩略图失败',
    _a[errorcode_1.ErrorCode.StorageUninitialized] = '存储适配层未初始化',
    _a[errorcode_1.ErrorCode.DataCorrupted] = '数据已经损坏',
    _a[errorcode_1.ErrorCode.MetadataCorrupted] = '元数据已损坏',
    _a[errorcode_1.ErrorCode.DataIncompatibale] = '程序与当前数据不兼容',
    _a[errorcode_1.ErrorCode.ServerClientMismatch] = '服务器版本不支持该客户端',
    _a[errorcode_1.ErrorCode.SearchEngineIndexFailed] = '全文检索链接索引服务器失败',
    _a[errorcode_1.ErrorCode.SearchEngineInternalError] = '全文检索索引服务器内部错误',
    _a[errorcode_1.ErrorCode.SearchEngineNotInstalled] = '全文检索未安装',
    _a[errorcode_1.ErrorCode.HTTPNotPOST] = '不支持除POST外的其它方法',
    _a[errorcode_1.ErrorCode.ServiceBusy] = '服务器繁忙',
    _a[errorcode_1.ErrorCode.DocumentConverting] = '文档或缩略图正在转换',
    _a[errorcode_1.ErrorCode.WatermarkProcessing] = '正在制作水印，请稍后再试',
    _a[errorcode_1.ErrorCode.SmallQuota] = '配额空间不能小于已用空间${used}，请重新输入。',
    _a[errorcode_1.ErrorCode.NotNullGroup] = '当前群组文档中存有数据，请先将其迁移后再进行删除操作。',
    _a[errorcode_1.ErrorCode.GroupNameInvalid] = '群组名不合法，可能字符过长或包含 \ / : * ? " < > | 特殊字符。',
    _a[errorcode_1.ErrorCode.UserdocMissing] = '您已被关闭个人文档，无法使用此功能。',
    _a[errorcode_1.ErrorCode.ResourcesNotEnough] = '服务器资源不足，无法访问。',
    _a[errorcode_1.ErrorCode.EmailInvalid] = '邮箱地址只能包含 英文、数字 及 @-_. 字符，格式形如 XXX@XXX.XXX，长度范围 5~100 个字符，请重新输入。',
    _a[errorcode_1.ErrorCode.EmailDuplicated] = '该邮箱已被占用',
    _a[errorcode_1.ErrorCode.ExtLoginFailed] = '登录外部应用失败',
    _a[errorcode_1.ErrorCode.NeedAction] = '用户已被禁用，是否立即激活？',
    _a[errorcode_1.ErrorCode.UserActivated] = '用户已被激活，请到登录页登录',
    _a[errorcode_1.ErrorCode.SendCaprchaFail] = '发送验证码失败',
    _a[errorcode_1.ErrorCode.NotOpenActivated] = '短信激活未开启',
    _a[errorcode_1.ErrorCode.FailActivated] = '激活失败',
    _a[errorcode_1.ErrorCode.DeleteOutboxDisabled] = '无法执行重命名操作。您没有对发送文件箱目录的操作权限。',
    _a[errorcode_1.ErrorCode.WorkflowApplicationInvalid] = '该流程申请已失效。',
    _a[errorcode_1.ErrorCode.WorkFlowCommentsOverWords] = '审核流程失败，补充说明不能超过1024个字节。',
    _a[errorcode_1.ErrorCode.IDAuthDisabled] = '管理员已关闭身份证号登录，请重新登录。',
    _a[errorcode_1.ErrorCode.ReceivingSiteNotExist] = '接收站点不存在。',
    _a[errorcode_1.ErrorCode.ContactNotExist] = '联系人不存在',
    _a[errorcode_1.ErrorCode.UserNotExist] = '用户不存在',
    _a[errorcode_1.ErrorCode.ContactGroupNotExist] = '联系人分组不存在',
    _a[errorcode_1.ErrorCode.DispalyNameNull] = '显示名不能为空',
    _a[errorcode_1.ErrorCode.DisplayNameInvalid] = '显示名不合法，可能字符过长或包含 \\ / : * ? " < > | 特殊字符，请重新输入。',
    _a[errorcode_1.ErrorCode.DisplayNameDuplicated] = '该显示名已被占用，请重新输入。',
    _a);
/**
 * 通过errcode查找资源文件的Key
 * @param errcode 异常码
 * @param optype 操作类型
 * @return 返回异常信息的Key
 */
function findLocale(errcode) {
    var params = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        params[_i - 1] = arguments[_i];
    }
    var match = ErrorKeyHash[errcode];
    if (!match) {
        return '未知的错误码';
    }
    else if (typeof match === 'string') {
        return match;
    }
    else if (typeof match === 'function') {
        return match.apply(void 0, __spread(params));
    }
}
/**
 * 获取异常提示模版
 * @param errcode 异常码
 * @param optype 操作类型
 * @return 返回异常提示模版函数
 */
function getErrorTemplate(errcode) {
    var params = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        params[_i - 1] = arguments[_i];
    }
    return function (args) {
        return locale_1["default"](findLocale.apply(void 0, __spread([errcode], params)), args);
    };
}
exports.getErrorTemplate = getErrorTemplate;
/**
 * 根据异常码获取异常提示
 * @param errcode 异常码
 * @param args 模版填充信息
 * @return 返回异常提示信息
 */
function getErrorMessage(errcode) {
    var params = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        params[_i - 1] = arguments[_i];
    }
    return locale_1["default"](findLocale.apply(void 0, __spread([errcode], params))) || '';
}
exports.getErrorMessage = getErrorMessage;


/***/ }),

/***/ "../ShareWebCore/src/errcode/index.ts":
/***/ (function(module, exports, __webpack_require__) {

function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
exports.__esModule = true;
__export(__webpack_require__("../ShareWebCore/src/errcode/errcode.ts"));


/***/ }),

/***/ "../ShareWebCore/src/errcode/locale.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var i18n_1 = __webpack_require__("../ShareWebCore/src/i18n.ts");
exports["default"] = i18n_1["default"]([
    [
        '未知的错误码',
        '未知的錯誤碼',
        'Unknown errcode'
    ],
    [
        '不支持的接口',
        '不支援的介面',
        'Unsupported interface'
    ],
    [
        '非法参数',
        '非法參數',
        'Invalid parameter'
    ],
    [
        '非法URI参数',
        '非法URI參數',
        'Invalid URI parameter'
    ],
    [
        '非法JSON字符串',
        '非法JSON字串',
        'Invalid JSON string'
    ],
    [
        '非法权限值类型',
        '非法權限值類型',
        'Invalid permission value type'
    ],
    [
        '非法访问者类型',
        '非法訪客類型',
        'Invalid accessor type'
    ],
    [
        '数据块大小和实际大小不匹配',
        '資料區塊大小和實際大小不匹配',
        'Data block size and actual size do not match'
    ],
    [
        '全文检索语法错误，特殊字符或错误编码',
        '全文檢索語法錯誤，特殊字元或錯誤編碼',
        'Full-text search syntax error, special character or wrong encoding'
    ],
    [
        '全文检索请求查询的参数无效',
        '全文檢索請求查詢的參數無效',
        'Invalid full-text search request parameter'
    ],
    [
        '您设置的时间已经早于服务器的当前时间，请重新设置或校对时间。',
        '您設定的時間已經早於伺服器的當前時間，請重新設定或校對時間。',
        'The time you set is earlier then the current time of the server,please reset or proofread.'
    ],
    [
        '登录已超时',
        '登入已逾時',
        'Login timeout'
    ],
    [
        '外链密码不正确',
        '外連結密碼不正確',
        'Incorrect link password'
    ],
    [
        '抱歉，您的打开次数已达上限！',
        '抱歉，您的打開次數已達上限！',
        'Sorry, your opens has reached the limit!'
    ],
    [
        '用户名或者密码不正确。',
        '用戶名或者密碼不正確。',
        'Incorrect account or password'
    ],
    [
        '无法使用初始密码登录，是否立即修改密码？',
        '無法使用初始密碼登入，是否立即修改密碼？',
        'You are not allowed to log in with initial password, change password now?'
    ],
    [
        '您的登录密码已失效，是否立即修改密码？',
        '您的登入密碼已失效，是否立即修改密碼？',
        'Your password has expired, change now?'
    ],
    [
        '您的密码安全系数过低，是否立即修改密码？',
        '您的密碼安全係數過低，是否立即修改密碼？',
        'Weak password, change now?'
    ],
    [
        '您已输错1次密码，连续输错3次将导致账号被锁定',
        '您已輸錯1次密碼，連續輸錯3次將導致帳號被鎖定',
        'Wrong password Once, account will be locked after 3 worng attempts.'
    ],
    [
        '您已输错2次密码，连续输错3次将导致账号被锁定',
        '您已輸錯2次密碼，連續輸錯3次將導致帳號被鎖定',
        'Wrong password Twice, account will be locked after 3 wrong attempts.'
    ],
    [
        '您输入错误次数超过限制，账号已被锁定，1小时内无法登录，请稍后重试',
        '您輸入錯誤次數超過限制，帳號已被鎖定，1小時內無法登入，請稍後重試',
        'Account has been locked and you cannot log in within 1 hour. Please try later.'
    ],
    [
        '账号已被禁用',
        '帳號已被禁用',
        'User has been disabled'
    ],
    [
        '加密凭证无效',
        '加密憑證無效',
        'Invalid password'
    ],
    [
        '您是管理员角色，无法登录Web客户端',
        '您是管理員角色，無法登入Web用戶端',
        'Administrators are not allowed to log in.'
    ],
    [
        '域用户所属的域已被禁用或删除',
        '網域使用者的域已被禁用或刪除',
        'Domain of this domain user has been disabled or removed'
    ],
    [
        '用户不存在于域控中',
        '使用者不存在於網域控制站中',
        'user does not existed in the domain controller'
    ],
    [
        '该账号已绑定设备，无法登录Web端',
        '該帳號已綁定設備，無法登入Web端',
        'Web is unaccessable because user is binded to specific devices.'
    ],
    [
        '新密码格式不正确，请输入10-32个字符，且只能包含大小写字母、数字及~`!@#$%-_,.特殊字符',
        '新密碼格式不正確，請輸入10-32個字元，且只能包含大小寫字母、數位及~`!@#$%-_,.特殊字元',
        'New password can only be letters, numerals and ~`!@#$%-_,. within 10~32 characters."'
    ],
    [
        '新密码格式不正确，请输入10-32个字符，需同时包含大小写字母及数字，支持~`!@#$%-_,.特殊字符',
        '新密碼格式不正確，請輸入10-32個字元，需同時包含大小寫字母及數位，支援~`!@#$%-_,.特殊字元',
        'New password can only be letters, numerals and ~`!@#$%-_,. within 10~32 characters.'
    ],
    [
        '当前用户为外部用户，不支持修改密码',
        '當前使用者為外部使用者，不支援修改密碼',
        'Only local user can change password'
    ],
    [
        '当前产品未经授权，您无法登录，请联系管理员。',
        '當前產品未經授權，您無法登入，請聯繫管理員。',
        'Product is not authorized, please contact your administrator.'
    ],
    [
        '当前帐号在另一地点登录，您被迫下线！',
        '當前帳號在另一地點登入，您被迫下線！',
        'You are forced to log out, as your account has been logged on in other place.'
    ],
    [
        '目标位置的配额空间不足。',
        '目標位置的配額空間不足。',
        'There is not enough quota in destination.'
    ],
    [
        '没有权限执行此操作。',
        '沒有權限執行此操作。',
        'You are not allowed to commit this operation.'
    ],
    [
        '您没有下载权限。',
        '您沒有下載權限。',
        'You do not have download permission.'
    ],
    [
        '您没有上传权限。',
        '您沒有上传權限。',
        'You do not have upload permission.'
    ],
    [
        '只有文档所有者才能进行该操作',
        '只有檔案擁有者才能進行該操作',
        'Only file owner can commit this operation'
    ],
    [
        '个人文档不能设置所有者',
        '個人文件不能設置擁有者',
        'You cannot set owner for My Documents'
    ],
    [
        '不能添加自己或设置管理员为所有者',
        '不能添加自己或設置管理員為擁有者',
        'You cannot add yourself or admin as owner'
    ],
    [
        '不能删除自己的所有者配置',
        '不能删除自己的擁有者設定',
        'You cannot delete your owner settings'
    ],
    [
        '个人创建的群组个数不能超过3个',
        '個人創建的群組個數不能超過3個',
        'At most 3 groups can be created'
    ],
    [
        '配权限时，访问者不存在',
        '設定權限時，訪客不存在',
        'Visitor does not exist when setting permissions'
    ],
    [
        '个人空间配额不能设置为0',
        '個人空間配額不能設定為0',
        'My documents quota cannot be 0'
    ],
    [
        '该名称已被占用，请重新输入',
        '該名稱已被佔用，請重新輸入',
        'The same name already exists'
    ],
    [
        '配所有者时，指定用户不存在',
        '設定擁有者時，指定使用者不存在',
        'Specified user does not exist when setting owners'
    ],
    [
        '用户已经存在',
        '使用者已經存在',
        'User already exists'
    ],
    [
        '外链已经存在',
        '外連結已經存在',
        'Shared link already exists'
    ],
    [
        '不能向完整版本添加数据块',
        '不能向完整版本添加資料區塊',
        'Data block cannot be added to complete version'
    ],
    [
        '操作的对象类型不正确',
        '操作的物件類型不正確',
        'Incorrect operation object type'
    ],
    [
        '不能删除不在回收站的文件或目录',
        '不能刪除不在資源回收筒的檔案或目錄',
        'File or directory not in recycle bin cannot be deleted'
    ],
    [
        '不能还原不在回收站的文件或目录',
        '不能還原不在資源回收筒的檔案或目錄',
        'File or directory not in recycle bin cannot be restored'
    ],
    [
        '不能下载非完整的版本对象',
        '不能下載非完整的版本物件',
        'Incomplete version object cannot be downloaded'
    ],
    [
        '对象无法移动到相同的路径，或跨管理节点移动对象',
        '物件無法移動到相同的路徑，或跨管理節點移動物件',
        'Objects cannot be moved to the same path or cross management nodes'
    ],
    [
        '当前目录已经开启或关闭发现共享，导致操作失败',
        '目前的目錄已經開啟或關閉發現共用，導致操作失敗',
        'Public share has been enabled for this directory, operation failed'
    ],
    [
        '父目录已经开启或关闭发现共享，导致操作失败',
        '父目錄已經開啟或關閉發現共用，導致操作失敗',
        'Public share has been enabled for parent directory, operation failed'
    ],
    [
        '不能删除不存在的数据块',
        '不能刪除不存在的資料區塊',
        'Unable to delete data block that does not exist'
    ],
    [
        '预览文档或缩略图过大，预览失败',
        '預覽檔案或縮圖過大，預覽失敗',
        'File or thumb is too large to preview, preview failed'
    ],
    [
        '管理对象不存在',
        '管理物件不存在',
        'Management object does not exist'
    ],
    [
        '请求内容超过对象大小',
        '請求內容超過物件大小',
        'Request content is larger than object'
    ],
    [
        '文档预览失败，格式错误',
        '檔案預覽失敗，格式錯誤',
        'File preview failure, format error'
    ],
    [
        '缩略图预览失败，格式错误',
        '縮圖預覽失敗，格式錯誤',
        'Thumb preview failure, format error'
    ],
    [
        '该用户未导入到AnyShare系统中',
        '該使用者未導入到AnyShare系統中',
        'This user is not imported to AnyShare'
    ],
    [
        '群组不存在',
        '群組不存在',
        'Group does not exist'
    ],
    [
        '文件“${filename}”过大，无法同步，您所在的网络存在限制。',
        '檔案“${filename}”過大，無法同步，您所在的網路存在限制。',
        'File "${filename}" is too large and cannot be synced, your network is limited.'
    ],
    [
        '获取子部门或子用户信息时，指定部门不存在',
        '獲取子部門或子使用者資訊時，指定部門不存在',
        'Specified department does not exist when getting child department or child user info'
    ],
    [
        '父对象不存在',
        '父物件不存在',
        'Parent object does not exist'
    ],
    [
        '获取用户信息时，用户不存在',
        '獲取使用者資訊時，使用者不存在',
        'User does not exist when getting user info'
    ],
    [
        '入口文档记录不存在',
        '入口檔案記錄不存在',
        'Entry file record does not exist'
    ],
    [
        '文件或文件夹“${filename}”不存在, 可能其所在路径发生变更。',
        '檔案或資料夾“${filename}”不存在, 可能其所在路徑發生變更。',
        'File "${filename}" does not exist in this location.'
    ],
    [
        '外链地址已失效。',
        '外連結位址已失效',
        'Link has expired.'
    ],
    [
        '请求对应数据块不存在',
        '請求對應資料區塊不存在',
        'Request data block does not exist'
    ],
    [
        '没有完整的版本',
        '沒有完整的版本',
        'No complete version'
    ],
    [
        '数据块信息不完整',
        '資料區塊資訊不完整',
        'Data block info is incomplete'
    ],
    [
        'HTTP方法错误',
        'HTTP方法錯誤',
        'HTTP method error'
    ],
    [
        '内部错误',
        '內部錯誤',
        'Internal error'
    ],
    [
        '预览文件或缩略图失败',
        '預覽檔案或縮圖失敗',
        'Preview file or thumb failure'
    ],
    [
        '存储适配层未初始化',
        '存儲配接層未初始化',
        'Storage adaptation layer is not initialized'
    ],
    [
        '数据已经损坏',
        '資料已經損壞',
        'The data is corrupt'
    ],
    [
        '元数据已损坏',
        '中繼資料已損壞',
        'Metadata is corrupt'
    ],
    [
        '程序与当前数据不兼容',
        '程式與當前資料不相容',
        'Program and current data are incompatible'
    ],
    [
        '服务器版本不支持该客户端',
        '伺服器版本不支援該用戶端',
        'Server does not support client of this version'
    ],
    [
        '全文检索链接索引服务器失败',
        '全文檢索連結索引伺服器失敗',
        'Full-text search connect index server failure'
    ],
    [
        '全文检索索引服务器内部错误',
        '全文檢索索引伺服器內部錯誤',
        'Internal error of full-text search index server'
    ],
    [
        '不支持除POST外的其它方法',
        '不支援除POST外的其它方法',
        'Only support POST'
    ],
    [
        '服务器繁忙',
        '伺服器繁忙',
        'The server is busy'
    ],
    [
        '文档或缩略图正在转换',
        '檔案或縮圖正在轉換',
        'Converting file or thumb'
    ],
    [
        '已存在同类型的同名文档',
        '已存在同類型的同名檔案',
        'the same name and type file already exists'
    ],
    [
        '没有权限操作目标位置的对象',
        '沒有權限操作目標位置的物件',
        'Do not have permissions to the destination object'
    ],
    [
        '转码失败，文件格式不支持',
        '轉碼失敗，檔案格式不支持',
        'Transcoding failed, unsupported file type'
    ],
    [
        '转码失败，服务器缓存空间不足',
        '轉碼失敗，伺服器快取空間不足',
        'Transcoding failed, there is not enough cache space in server.'
    ],
    [
        '当前无匹配的审核员，本次操作无法生效，请联系管理员。',
        '當前無匹配的核准者，本次操作無法生效，請聯繫管理員。',
        'There is no matched approver and this operation cannot take effect. Please contact admin.'
    ],
    [
        '此条记录已失效或被其他审核员审核完成。',
        '此條記錄已失效或被其他核准者核准完成。',
        'This record is invalid or has been processed by other approvers.'
    ],
    [
        '您的审核权限已失效。',
        '您的核准權限已失效。',
        'Your approval right has expired.'
    ],
    [
        '此条申请已失效（外链已失效）',
        '此條申請已失效（連結已失效）',
        'This request has been invalid (link has been invalid)'
    ],
    [
        '此条申请已经失效（访问者已经被删除）',
        '此條申請已經失效（訪客已經被刪除）',
        'This request has been invalid (the visitor has been deleted)'
    ],
    [
        '否决申请时，内容不能为空',
        '否決申請時,內容不能為空',
        'When you reject the request, this entry cannot be empty'
    ],
    [
        '此条申请已失效（共享者已经被删除）',
        '此條申請已失效（共用者已經被刪除）',
        'This request has been invalid (The sharer has been deleted)'
    ],
    [
        '此条申请已失效（截止时间已经过期）',
        '此條申請已失效（截止時間已經過期）',
        'This request has been invalid (the expiration has been due)'
    ],
    [
        '此条申请已失效（外链已存在）',
        '此條申請已失效（連結已存在）',
        'This request has been invalid(link already exists)'
    ],
    [
        'SMTP服务器未设置，请联系管理员。',
        'SMTP伺服器未設定，請聯繫管理員。',
        'SMTP server is not set，please contact admin.'
    ],
    [
        'SMTP服务器不可用，请联系管理员。',
        'SMTP伺服器不可用，請聯繫管理員。',
        'SMTP server is not available，please contact admin.'
    ],
    [
        '邮箱收件人格式不正确，请重新输入。',
        '郵箱收件人格式不正確，請重新輸入。',
        ' email address format is incorrect，please enter again.'
    ],
    [
        'SMTP服务器存在未知错误，请联系管理员。',
        'SMTP伺服器存在未知錯誤，請聯繫管理員。',
        'unknown error in SMTP server，please contact admin.'
    ],
    [
        '存在与当前文件“${filename}”同名的文件但无修改权限',
        '存在与当前文件“${filename}”同名的文件但无修改权限',
        '存在与当前文件“${filename}”同名的文件但无修改权限'
    ],
    [
        '与当前文件“${filename}”同名的是一个文件夹。',
        '與當前檔案“${filename}”同名的是一個資料夾。',
        'The same name folder already exists.'
    ],
    [
        '您没有外链共享权限，请联系管理员。',
        '您沒有外鏈共用權限，請聯繫管理員。',
        'You are not authorized to share files by link, please contact administrator.'
    ],
    [
        '您的密级不足。',
        '您的密級不足。',
        'Your security level is lower than that of files.'
    ],
    [
        '当前审核员密级不足，本次操作无法生效，请联系管理员。',
        '當前核准者密級不足，本次操作無法生效，請聯繫管理員。',
        'Approver security level is insufficient and this operation cannot take effect, please contact admin.'
    ],
    [
        '您受到IP 网段限制，无法登录，请联系管理员',
        '您受到IP 網段限制，無法登入，請聯繫管理員',
        'Your account is not allowed to login in this IP segment, please contact admin.'
    ],
    [
        '您输入错误次数超过限制，账号已被锁定，请联系安全管理员',
        '您輸入錯誤次數超過限制，帳號已被鎖定，請聯繫安全管理員',
        'Password attempts exceeded. This account is locked, please contact security.'
    ],
    [
        '您无法修改归档库的文件。',
        '您無法修改歸檔庫的檔案。',
        'you cannot modify files in Archive Library.'
    ],
    [
        '管理员已禁止此类客户端登录',
        '管理員已禁止此類用戶端登入',
        'This type of client has been disabled by admin'
    ],
    [
        '发表失败，评论功能没有正常启用，请联系管理员。',
        '發表失敗，評論功能沒有正常啟用，請聯繫管理員。',
        'Failed to post comment, file comment has not been enabled, please contact admin.'
    ],
    [
        '删除失败，评论功能没有正常启用，请联系管理员。',
        '刪除失敗，评论功能没有正常启用，请联系管理员。',
        'Failed to delete comment,  file comment has not been enabled, please contact admin.'
    ],
    [
        '发表失败，不能对同一文件重复评分。'
    ],
    [
        '删除失败，只能删除自己发表的评论。'
    ],
    [
        '共享邀请链接已存在。',
        '共用邀請連結已存在。',
        'The invite link exists already.'
    ],
    [
        '您不在共享范围内，无法加入。',
        '您不在共用範圍內，無法加入。',
        'You are not invited by the file or folder owner.'
    ],
    [
        '共享邀请链接功能未开启。',
        '共用邀請連結功能未開啟。',
        'The invite link has not been opened.'
    ],
    [
        '涉密和共享审核模式下不允许邀请加入。',
        '涉密和共用核准模式下不允許邀請加入。',
        'Failed to invite users as collaborators, as security mode or file sharing approval has been enabled.'
    ],
    [
        '文档不存在。',
        '文件不存在。',
        'The file or folder does not exist.'
    ],
    [
        '共享邀请链接不存在。',
        '共用邀請連結不存在。',
        'The invite link does not exist.'
    ],
    [
        '文档所有者不存在。',
        '文件擁有者不存在。',
        'The file owner does not exist.'
    ],
    [
        '标签名不能包含 / : * ? " < > | 特殊字符，请重新输入',
        '標記名不能包含 / : * ? " < > | 特殊字元，請重新輸入',
        'Tags cannot contain  / : * ? " < > | special characters , please enter again'
    ],
    [
        '您设置的有效期已经超过了5年的限制，请重新设置或校对时间。',
        '您設定的有效期間已經超過了5年的限制，請重新設定或校對時間。',
        'The validity you can set cannot exceed 5 years, please reset it or check up the time.'
    ],
    [
        '无法执行下载操作，您的下载次数超出限制',
        '無法執行下載操作，您的下載次數超出限制',
        'Download failed, your file downloads exceeded the limit'
    ], [
        '您没有共享个人文档权限，无法进行权限配置。',
        '您沒有共用個人文件權限，無法進行權限設定。',
        'You do not have permission to share My Documents and cannot set permission.'
    ], [
        '您没有共享群组文档权限，无法进行权限配置。',
        '您沒有共用群組文件權限，無法進行權限設定。',
        'You do not have permission to share Group Documents and cannot set permission.'
    ], [
        '您没有共享个人文档权限，无法开启外链。',
        '您沒有共用個人文件權限，無法開啟外連結。',
        'You do not have permission to share My Documents and cannot enable external link.'
    ], [
        '您没有共享群组文档权限，无法开启外链。',
        '您沒有共用群組文件權限，無法開啟外連結。',
        'You do not have permission to share Group Documents and cannot enable external link.'
    ], [
        '您没有共享个人文档权限，无法开启共享邀请。',
        '您沒有共用個人文件權限，無法開啟共用邀請。',
        'You do not have permission to share My Documents and cannot invite others.'
    ], [
        '您没有共享群组文档权限，无法开启共享邀请。',
        '您沒有共用群組文件權限，無法開啟共用邀請。',
        'You do not have permission to share Group Documents and cannot invite others.'
    ], [
        '您没有共享个人文档权限，无法修改外链。',
        '您沒有共用個人文件權限，無法修改外連結。',
        'You do not have permission to share My Documents and cannot modify external link.'
    ], [
        '您没有共享群组文档权限，无法修改外链。',
        '您沒有共用群組文件權限，無法修改外連結。',
        'You do not have permission to share Group Documents and cannot modify external link.'
    ], [
        '您没有共享个人文档权限，无法修改共享邀请。',
        '您沒有共用個人文件權限，無法修改共用邀請。',
        'You do not have permission to share My Documents and cannot modify invite link.'
    ], [
        '您没有共享群组文档权限，无法修改共享邀请。',
        '您沒有共用群組文件權限，無法修改共用邀請。',
        'You do not have permission to share Group Documents and cannot modify invite link.'
    ], [
        '您的密码已过期, 请联系管理员。',
        '您的密碼已過期，請聯繫管理員。',
        'Your password is expired, please contact your administrator.'
    ], [
        '您所在的网络环境已改变，请重新登录。',
        '您所在的網路環境已改變，請重新登入。',
        'Network environment has changed, please login again.'
    ], [
        '产品授权已过期，您无法登录，请联系管理员。',
        '產品授權已過期，您無法登入，請聯繫管理員。',
        'This product has been expired and you cannot log in. Please contact admin.'
    ], [
        '全文检索未安装',
        '全文檢索未安裝',
        'Full-text search has not been installed'
    ], [
        '正在制作水印，请稍后再试',
        '正在製作浮水印，請稍後再試',
        'Making watermark, please try again later'
    ], [
        '您设置的权限有效期限已经早于服务器的当前时间，请重新设置或校对时间。',
        '您設定的權限有效期間已經早於伺服器的當前時間，請重新設定或校對時間。',
        'The permission expiration you set is earlier than the current time of server, please reset it or check up the time.'
    ],
    [
        '您设置的链接有效期限已经早于服务器的当前时间，请重新设置或校对时间。',
        '您設定的連結有效期間已經早於伺服器的當前時間，請重新設定或校對時間。',
        'The link expiration you set is earlier than the current time of server, please reset it or check up the time.'
    ], [
        '链接有效期限不能大于权限有效期限。',
        '連結有效期限不能大於權限有效期限。',
        'The expiration date of link should be earlier than that of permission.'
    ], [
        '第三方认证未开启',
        '協力廠商驗證未開啟',
        'Third-party authentication has not been enabled'
    ], [
        '无法验证ticket',
        '無法驗證ticket',
        'Failed to verify ticket'
    ], [
        '您的账号已被冻结。',
        '您的帳號已被凍結。',
        'your account has been frozen.'
    ], [
        '该文档已被冻结。',
        '該文件已被凍結。',
        'the folder has been frozen.'
    ], [
        '当前群组文档中存有数据，请先将其迁移后再进行删除操作。',
        '當前群組文件中存有數據，請先將其遷移后再進行刪除操作。',
        'Please migrate existing data before executing delete operation.'
    ], [
        '配额空间不能小于已用空间${used}，请重新输入。',
        '配額空間不能小於已用空間${used}，請重新輸入。',
        'Quota cannot less than used space ${used}.'
    ], [
        '群组名不合法，可能字符过长或包含 \ / : * ? " < > | 特殊字符。',
        '群組名不合法，可能字元過長或包含 \ / : * ? " < > | 特殊字元。',
        'Group name is invalid, it is too long or contains \ / : * ? " < > | special characters.'
    ], [
        '当前站点为分站点模式，无法登录。',
        '當前站台為分站台模式，無法登入。',
        'Current site is a branch site, you cannot log in.'
    ], [
        '您已被关闭个人文档，无法使用此功能。',
        '您已被關閉個人文件，無法使用此功能。',
        'My Documents has been disabled and cannot use this feature.'
    ], [
        '验证码已过期，请重新输入',
        '驗證碼已過期，請重新輸入',
        'Invalid verification code, please enter again'
    ], [
        '验证码不正确，请重新输入',
        '驗證碼不正確，請重新輸入',
        'Incorrect verification code, please enter again'
    ], [
        '验证码不能为空，请重新输入',
        '驗證碼不能為空，請重新輸入',
        'Verification code cannot be empty, please enter again'
    ], [
        '服务器资源不足，无法访问。',
        '伺服器資源不足，無法訪問。',
        'Insufficient server resources to access.'
    ], [
        '邮箱地址只能包含 英文、数字 及 @-_. 字符，格式形如 XXX@XXX.XXX，长度范围 5~100 个字符，请重新输入。',
        '電郵位址只能包含 英文、數字 及 @-_. 字元，格式形如 XXX@XXX.XXX，長度範圍 5~100個字元，請重新輸入。',
        'The email address can only contain English characters, numbers and @ -_ characters. The format is XXX @ XXX.XXX and the length is 5 ~ 100 characters. Please enter again.'
    ], [
        '该邮箱已被占用',
        '該電郵已被佔用',
        'This email already exists'
    ], [
        '登录外部应用失败',
        '登入外部應用失敗',
        'Login to external application failed.'
    ], [
        '无法执行收藏操作，您对文件“${filename}”没有显示权限。',
        '無法執行收藏操作，您對檔案”${filename}“沒有顯示權限。',
        'Cannot favorite the folder as you do not have display permission for "${filename}".'
    ], [
        '用户已被禁用，是否立即激活？',
        '用戶已被禁用，是否立即啟動？',
        'User has been disabled，Whether to activate immediately?'
    ], [
        '用户已被激活，请到登录页登录',
        '用戶已被啟動，請到登錄頁登錄',
        'User has been activated，Please log on to the login page'
    ], [
        '短信激活未开启',
        '短信啟動未開啟',
        'SMS activation is not turned on'
    ], [
        '发送验证码失败',
        '發送驗證碼失敗',
        'Failed to send verification code'
    ], [
        '激活失败',
        '啟動失敗',
        'Failed to activated'
    ],
    [
        '您没有权限修改密码，请联系管理员。',
        '您沒有權限修改密碼，請聯系管理員。',
        'You do not have permission to change your password, please contact admin.'
    ],
    [
        '无法执行重命名操作。您没有对发送文件箱目录的操作权限。',
        '無法執行重命名操作。您沒有對傳送檔案箱目錄的操作權限。',
        'Rename failed.You do not have such permission for File Outbox.'
    ],
    [
        '该流程申请已失效。',
        '該流程申請已失效。',
        'This workflow application has been invalid.'
    ],
    [
        '审核流程失败，补充说明不能超过1024个字节。',
        '核准流程失敗，補充說明不能超過1024個字節。',
        'The workflow failed,additional instructions cannot exceed 1024 bytes.'
    ],
    [
        '接收站点不存在。',
        '接收站台不存在。',
        'This receiving site does not exist.'
    ],
    [
        '联系人不存在',
        '連絡人不存在',
        'The contact does not exist'
    ],
    [
        '用户不存在',
        '使用者不存在',
        'User does not exist'
    ],
    [
        '联系人分组不存在',
        '連絡人群組不存在',
        'The contact group does not exist'
    ],
    [
        '显示名不能为空',
        '显示名不能为空',
        'DiaplayName can not be empty'
    ],
    [
        '显示名不合法，可能字符过长或包含 \\ / : * ? " < > | 特殊字符，请重新输入。',
        '顯示名不合法，可能字元過長或包含 \\ / : * ? " < > | 特殊字元，請重新輸入。',
        'Display name is invalid, it is too long or contains \\ / : * ? " < > | special characters, please enter again.'
    ],
    [
        '该显示名已被占用，请重新输入。',
        '該顯示名已被佔用，請重新輸入。',
        'The same display name already exists.'
    ],
]);


/***/ }),

/***/ "../ShareWebCore/src/event/event.ts":
/***/ (function(module, exports) {

var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
exports.__esModule = true;
/**
 * 事件系统工厂函数
 * @param eventTypes 事件类型
 * @returns
 *  subscribe 订阅事件
 *  trigger 触发事件
 */
function eventFactory(eventTypes) {
    if (eventTypes === void 0) { eventTypes = {}; }
    /** 事件 handlers */
    var Handlers = {};
    /**
     * 获取事件处理 handlers
     * @param eventType
     **/
    function getEventHandlers(type) {
        return Array.isArray(Handlers[type]) ? Handlers[type] : [];
    }
    /** 触发事件
     * @param eventType 事件类型
     * @param defaultHandler 默认handler
     * @param args 参数
     **/
    function trigger(type, defaultHandler) {
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        var handlers = getEventHandlers(type);
        if (handlers.length) {
            handlers.forEach(function (handler) { return handler.apply(void 0, __spread(args)); });
            return;
        }
        if (typeof defaultHandler === 'function') {
            defaultHandler.apply(void 0, __spread(args));
        }
    }
    /**
     * 订阅事件
     * @param type 事件类型
     * @param handler 事件处理函数
     */
    function subscribe(type, handler) {
        if (typeof eventTypes[type] === 'undefined') {
            throw "event " + type + " does not exist";
        }
        if (typeof handler !== 'function') {
            throw "handler must be function";
        }
        if (!Handlers[type]) {
            Handlers[type] = [];
        }
        if (Handlers[type].indexOf(handler) === -1) {
            Handlers[type] = __spread(Handlers[type], [handler]);
        }
        /** 取消订阅 */
        return function unsubscribe() {
            if (Array.isArray(Handlers[type])) {
                Handlers[type] = Handlers[type].filter(function (fn) { return fn !== handler; });
            }
        };
    }
    return { trigger: trigger, subscribe: subscribe };
}
exports.eventFactory = eventFactory;


/***/ }),

/***/ "../ShareWebCore/src/extension/extension.ts":
/***/ (function(module, exports, __webpack_require__) {

/// <reference path="./extension.d.ts" />
exports.__esModule = true;
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/docs.ts");
var locale_1 = __webpack_require__("../ShareWebCore/src/extension/locale.ts");
/**
 * @static
 */
exports.EXTENSIONS = {
    'WORD': ['.docx', '.dotx', '.dot', '.doc', '.odt', '.wps', '.docm', '.dotm'],
    'EXCEL': ['.xlsx', '.xlsm', '.xlsb', '.xls', '.et', '.xla', '.xltm', '.xltx', '.xlt', '.ods'],
    'PPT': ['.pptx', '.ppt', '.pot', '.pps', '.ppsx', '.dps', '.potm', '.ppsm', '.potx', '.pptm', '.odp'],
    'PDF': ['.pdf'],
    'TXT': ['.txt'],
    'IMG': ['.jpg', '.jpeg', '.gif', '.bmp', '.png', '.wmf', '.emf', '.svg', '.tga', '.tif'],
    'ARCHIVE': ['.zip', '.rar', '.tgz', '.tar', '.cab', '.uue', '.jar', '.ace', '.lzh', '.arj', '.gzip', '.gz', '.gz2', '.bz', '.bz2', '.7z', '.iso', '.rpm'],
    'VIDEO': ['.avi', '.rmvb', '.rm', '.mp4', '.3gp', '.mkv', '.mov', '.mpg', '.mpeg', '.wmv', '.flv', '.asf', '.h264', '.x264', '.mts', '.m2ts'],
    'AUDIO': ['.mp3', '.aac', '.wav', '.wma', '.flac', '.m4a', '.ape', '.ogg'],
    'EXE': ['.exe', '.msi', '.bat'],
    'CAD': ['.dwg', '.dwt', '.dxf'],
    'PSD': ['.psd'],
    'VISIO': ['.vsd', '.vss', '.vst', '.vdx', '.vsx', '.vtx'],
    'HTML': ['.html'],
    'SEP': ['.gd', '.sep']
};
/**
 * OWAS支持的预览格式
 */
var OWAS_EXTENSIONS = {
    'WORD': ['.docx', '.doc', '.docm', '.odt', '.dotm', '.dotx'],
    'EXCEL': ['.xlsx', '.xls', '.ods', '.xlsb', '.xlsm'],
    'PPT': ['.pptx', '.ppt', '.odp', '.pot', '.potm', '.potx', '.pps', '.ppsm', '.ppsx', '.pptm'],
    'PDF': []
};
/**
 * OWAS支持编辑的格式
 */
var OWAS_EXTENSIONS_EDITABLE = {
    'WORD': ['.docx', '.docm', '.odt'],
    'EXCEL': ['.xlsx', '.ods', '.xlsb', '.xlsm'],
    'PPT': ['.pptx', '.odp', '.ppsx'],
    'PDF': []
};
/**
 * 微信企业号支持的图片格式
 */
var PICTURE_EXTENSIONS = {
    'IMG': ['.jpg', '.tif', '.jpeg', '.gif', '.bmp', '.png']
};
/**
 * 图片预览格式
 */
var IMAGE_EXENSIONS = {
    'IMG': ['.jpg', '.jpeg', '.gif', '.bmp', '.png', '.wmf', '.emf', '.svg', '.tga', '.tif']
};
/**
 * 序列化文件名
 * @param 文件名或扩展名
 */
function serializeName(name) {
    if (!name) {
        return '';
    }
    var dotIndex = name.lastIndexOf('.');
    if (dotIndex === -1) {
        // 输入字段即为扩展名，则加上"."
        return '.' + name;
    }
    else {
        // 截取最后一个"."到结尾字符串
        return name.slice(dotIndex);
    }
}
exports.serializeName = serializeName;
/**
 * 获取文件名
 * @param fullname
 * @return [name, ext]
 */
function splitName(name) {
    if (!name) {
        return ['', ''];
    }
    var dotIndex = name.lastIndexOf('.');
    if (dotIndex === -1) {
        return [name, ''];
    }
    return [name.slice(0, dotIndex), name.slice(dotIndex + 1)];
}
exports.splitName = splitName;
/**
 * 获取文档类型
 * @param extension 文件名或扩展名
 * @return 返回文档类型
 */
function findType(name) {
    return lodash_1.findKey(exports.EXTENSIONS, function (exts) {
        return lodash_1.includes(exts, serializeName(name.toLowerCase()));
    });
}
exports.findType = findType;
/**
 * 获取OWAS文档类型
 */
function findOWASType(name) {
    return lodash_1.findKey(OWAS_EXTENSIONS, function (exts) {
        return lodash_1.includes(exts, serializeName(name.toLowerCase()));
    });
}
exports.findOWASType = findOWASType;
function findOWASEditType(name) {
    return lodash_1.findKey(OWAS_EXTENSIONS_EDITABLE, function (exts) { return lodash_1.includes(exts, serializeName(name.toLowerCase())); });
}
exports.findOWASEditType = findOWASEditType;
/**
 * 微信企业号支持图片类型
 */
function findPictrueType(name) {
    return lodash_1.findKey(PICTURE_EXTENSIONS, function (exts) {
        return lodash_1.includes(exts, serializeName(name.toLowerCase()));
    });
}
exports.findPictrueType = findPictrueType;
/**
 * 图片预览支持格式
 * @param name
 */
function findImageType(name) {
    return lodash_1.findKey(IMAGE_EXENSIONS, function (exts) {
        return lodash_1.includes(exts, serializeName(name.toLowerCase()));
    });
}
exports.findImageType = findImageType;
/**
 * 是否是OWAS支持的文件类型
 */
function OWASSupported(name, _a) {
    var _b = (_a === void 0 ? {} : _a).editable, editable = _b === void 0 ? false : _b;
    return editable ? !!findOWASEditType(name) : !!findOWASType(name);
}
exports.OWASSupported = OWASSupported;
/**
 * 格式化文件类型
 * @param doc {}
 */
function formatType(doc) {
    if (docs_1.isDir(doc)) {
        if (!doc.doctype) {
            return locale_1["default"]('文件夹');
        }
        else {
            if (doc.doctype === 'customdoc') {
                return doc.typename || locale_1["default"]('文档库');
            }
            else {
                switch (doc.doctype) {
                    case 'userdoc':
                        return locale_1["default"]('个人文档');
                    case 'sharedoc':
                        return locale_1["default"]('共享文档');
                    case 'groupdoc':
                        return locale_1["default"]('群组文档');
                }
            }
        }
    }
    else {
        switch (findType(doc.name || doc.docname)) {
            case 'IMG':
                return locale_1["default"]('图片');
            case 'WORD':
                return locale_1["default"]('WORD');
            case 'EXCEL':
                return locale_1["default"]('EXCEL');
            case 'PPT':
                return locale_1["default"]('PPT');
            case 'PDF':
                return locale_1["default"]('PDF');
            case 'TXT':
                return locale_1["default"]('文本');
            case 'ARCHIVE':
                return locale_1["default"]('压缩文件');
            case 'VIDEO':
                return locale_1["default"]('视频');
            case 'AUDIO':
                return locale_1["default"]('音频');
            case 'CAD':
                return locale_1["default"]('CAD');
            default:
                return locale_1["default"]('其他');
        }
    }
}
exports.formatType = formatType;


/***/ }),

/***/ "../ShareWebCore/src/extension/index.ts":
/***/ (function(module, exports, __webpack_require__) {

function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
exports.__esModule = true;
__export(__webpack_require__("../ShareWebCore/src/extension/extension.ts"));


/***/ }),

/***/ "../ShareWebCore/src/extension/locale.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var i18n_1 = __webpack_require__("../ShareWebCore/src/i18n.ts");
exports["default"] = i18n_1["default"]([
    [
        '个人文档',
        '個人文件',
        'My Documents'
    ],
    [
        '共享文档',
        '共用文件',
        'Shared Documents'
    ],
    [
        '群组文档',
        '群組文件',
        'Group Documents'
    ],
    [
        '文档库',
        '文件庫',
        'Libraries'
    ],
    [
        '文件夹',
        '資料夾',
        'Folder'
    ],
    [
        '图片',
        '圖片',
        'Image'
    ],
    [
        'WORD',
        'WORD',
        'WORD'
    ],
    [
        'EXCEL',
        'EXCEL',
        'EXCEL'
    ],
    [
        'PPT',
        'PPT',
        'PPT'
    ],
    [
        'PDF',
        'PDF',
        'PDF'
    ],
    [
        '文本',
        '文字',
        'Text'
    ],
    [
        '压缩文件',
        '壓縮封裝',
        'Package'
    ],
    [
        '视频',
        '視訊',
        'Video'
    ],
    [
        '音频',
        '音訊',
        'Audio'
    ],
    [
        'CAD',
        'CAD',
        'CAD'
    ],
    [
        '其他',
        '其他',
        'Other'
    ]
]);


/***/ }),

/***/ "../ShareWebCore/src/filesystem/filesystem.ts":
/***/ (function(module, exports, __webpack_require__) {

var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __values = (this && this.__values) || function (o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
};
exports.__esModule = true;
var _a;
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
var dir_1 = __webpack_require__("../ShareWebCore/src/apis/efshttp/dir/dir.ts");
var link_1 = __webpack_require__("../ShareWebCore/src/apis/efshttp/link/link.ts");
var entrydoc_1 = __webpack_require__("../ShareWebCore/src/apis/eachttp/entrydoc/entrydoc.ts");
var audit_1 = __webpack_require__("../ShareWebCore/src/apis/eachttp/audit/audit.ts");
var docs_1 = __webpack_require__("../ShareWebCore/src/docs/docs.ts");
var extension_1 = __webpack_require__("../ShareWebCore/src/extension/extension.ts");
var gns_1 = __webpack_require__("../ShareWebCore/src/gns/gns.ts");
var event_1 = __webpack_require__("../ShareWebCore/src/event/event.ts");
var session_1 = __webpack_require__("../ShareWebUtil/src/session/index.ts");
var EventType;
(function (EventType) {
    /** fileSystem 插入文件对象 */
    EventType[EventType["FS_INSERT"] = 0] = "FS_INSERT";
    /** fileSystem 删除文件对象 */
    EventType[EventType["FS_DELETE"] = 1] = "FS_DELETE";
    /** fileSystem 更新文件对象 */
    EventType[EventType["FS_UPDATE"] = 2] = "FS_UPDATE";
})(EventType = exports.EventType || (exports.EventType = {}));
exports.subscribe = (_a = event_1.eventFactory(EventType), _a.subscribe), exports.trigger = _a.trigger;
/**
 * 更新缓存周期
 */
var TIMEOUT = 30000;
/** 一级gns的长度 */
exports.GNS_LENGTH = 32;
/**
 * 缓存list
 */
var Cache = {}, VirtualDocs = {};
/**
 * 外链缓存
 */
var Links = {};
/**
 * 从 session 取 links 数据
 */
try {
    Links = session_1["default"].get('link') || {};
}
catch (e) {
}
/**
 * 本地排序
 * @param docs
 * @param by 排序依据
 * @param sort asc | desc
 */
function sortDoc(docs, by, sort) {
    switch (by) {
        case 'name':
            return docs.sort(function (doc1, doc2) { return sort === 'asc' ?
                docs_1.docname(doc1).localeCompare(docs_1.docname(doc2), 'zh-Hans-CN', { sensitivity: 'accent' }) :
                docs_1.docname(doc2).localeCompare(docs_1.docname(doc1), 'zh-Hans-CN', { sensitivity: 'accent' }); });
        case 'type':
            return docs.sort(function (doc1, doc2) { return sort === 'asc' ?
                extension_1.splitName(docs_1.docname(doc1))[1].localeCompare(extension_1.splitName(docs_1.docname(doc2))[1], 'zh-Hans-CN', { sensitivity: 'accent' }) :
                extension_1.splitName(docs_1.docname(doc2))[1].localeCompare(extension_1.splitName(docs_1.docname(doc1))[1], 'zh-Hans-CN', { sensitivity: 'accent' }); });
        case 'time':
            return docs.sort(function (doc1, doc2) { return sort === 'asc' ?
                (doc1.modified - doc2.modified) :
                (doc2.modified - doc1.modified); });
        default:
            return docs.sort(function (doc1, doc2) { return sort === 'asc' ?
                (typeof doc1[by] === 'number' ? doc1[by] - doc2[by] : String(doc1[by]).localeCompare(String(doc2[by]), 'zh-Hans-CN', { sensitivity: 'accent' })) :
                (typeof doc1[by] === 'number' ? doc2[by] - doc1[by] : String(doc2[by]).localeCompare(String(doc1[by]), 'zh-Hans-CN', { sensitivity: 'accent' })); });
    }
}
/**
 * 清空缓存
 */
function clearCache(cacheIds) {
    if (cacheIds === void 0) { cacheIds = null; }
    if (cacheIds === null) {
        cacheIds = Object.keys(Cache);
    }
    if (typeof cacheIds === 'string') {
        cacheIds = [cacheIds];
    }
    cacheIds.forEach(function (cacheId) {
        if (typeof cacheId === 'string') {
            delete Cache[cacheId];
            if (cacheId === 'entrydoc') {
                for (var key in VirtualDocs) {
                    delete VirtualDocs[key];
                }
            }
        }
    });
}
exports.clearCache = clearCache;
/**
 * 获取外链
 * @param link 外链Id
 */
function getLinkRoot(link, password) {
    if (password === void 0) { password = ''; }
    return __awaiter(this, void 0, void 0, function () {
        var _a, _b, _c, cacheId;
        return __generator(this, function (_d) {
            switch (_d.label) {
                case 0:
                    if (!(!Links[link] || password && password !== Links[link].password)) return [3 /*break*/, 2];
                    _a = Links;
                    _b = link;
                    _c = [{}];
                    return [4 /*yield*/, link_1.get({ link: link, password: password })];
                case 1:
                    _a[_b] = __assign.apply(void 0, _c.concat([(_d.sent()), { link: link, password: password }]));
                    /**
                     * 外链密码改变时删除外链根目录下的缓存
                     */
                    for (cacheId in Cache) {
                        if (cacheId.startsWith(Links[link].docid)) {
                            delete Cache[cacheId];
                        }
                    }
                    session_1["default"].set('link', Links);
                    _d.label = 2;
                case 2: return [2 /*return*/, Links[link]];
            }
        });
    });
}
exports.getLinkRoot = getLinkRoot;
/** 列举目录 */
function list(dir, _a) {
    var _b = _a === void 0 ? {} : _a, _c = _b.by, by = _c === void 0 ? undefined : _c, _d = _b.sort, sort = _d === void 0 ? undefined : _d, _e = _b.attr, attr = _e === void 0 ? false : _e, _f = _b.useCache, useCache = _f === void 0 ? true : _f;
    return __awaiter(this, void 0, void 0, function () {
        var cacheId, entrydoc, entrydocShouldUpdate, docinfos, updateTime_1, _g, dirs_1, files_1, currentSort, currentBy, canServerSort, dirCacheShouldUpdate, _h, link_2, password_1, perm_1, usrdisplayname_1, usrloginname_1, docid, applyid_1, apptype_1, createdate_1, csflevel_1, detail_1, sharername_1, applymsg_1, auditornames_1, auditprogress_1, audittype_1, creatorname_1, processname_1, listBy, listSort, res, applyinfos, dirs_2, files_2, applyinfos, dirs_3, files_3, dirs_4, files_4, _j, dirs, files;
        return __generator(this, function (_k) {
            switch (_k.label) {
                case 0:
                    cacheId = dir ? dir.docid : 'entrydoc';
                    /**
                     * 排序方法
                     * 传入排序方法 或 缓存的排序方法 或 文件名 递增
                     */
                    by = by || (Cache[cacheId] ? Cache[cacheId].by : 'name') || 'name';
                    sort = sort || (Cache[cacheId] ? Cache[cacheId].sort : 'asc') || 'asc';
                    entrydoc = Cache['entrydoc'];
                    entrydocShouldUpdate = 
                    /**
                     * 不是外链文件且不是共享审核且没缓存过entrydoc
                     **/
                    !(dir && (dir.link || dir.docid === 'gns://approval' || dir.applyid || dir.docid === 'gns://docapproval')) && !entrydoc ||
                        /**
                         * 根目录或虚拟目录 且 useCache 为 false 或 entrydoc缓存已过期
                         **/
                        (!dir || isVirtual(dir)) && (!useCache || entrydoc && (Date.now() - entrydoc.updateTime > TIMEOUT));
                    if (!entrydocShouldUpdate) return [3 /*break*/, 2];
                    clearCache('entrydoc');
                    return [4 /*yield*/, entrydoc_1.get()
                        /**
                         * 记录更新时间
                         */
                    ];
                case 1:
                    docinfos = (_k.sent()).docinfos;
                    updateTime_1 = Date.now();
                    if (docinfos.length) {
                        /**
                         * 将入口文档解析成目录结构并缓存
                         */
                        docinfos.forEach(function (docinfo) {
                            var docname = docinfo.docname, docid = docinfo.docid, size = docinfo.size, doctype = docinfo.doctype, otag = docinfo.otag, typename = docinfo.typename, view_doctype = docinfo.view_doctype, view_doctypename = docinfo.view_doctypename, view_name = docinfo.view_name, view_type = docinfo.view_type, otherInfo = __rest(docinfo, ["docname", "docid", "size", "doctype", "otag", "typename", "view_doctype", "view_doctypename", "view_name", "view_type"]);
                            var names = docname.split('\\');
                            var gnses = gns_1.splitGNS(docid);
                            /**
                             * 根据目录名构建入口文档、虚拟目录
                             */
                            names.reduce(function (parentDir, name, i) {
                                var newDoc = __assign({}, otherInfo, { name: name, docid: gnses[i] }, (i === 0 ? { doctype: doctype, otag: otag, typename: typename, view_doctype: view_doctype, view_doctypename: view_doctypename, view_name: view_name, view_type: view_type } : {}), (i === names.length - 1 ? { size: size } : { size: -1 }));
                                /**
                                 * 虚拟目录
                                 */
                                if (names.length > 1 && i < names.length - 1) {
                                    if (!VirtualDocs[newDoc.docid]) {
                                        VirtualDocs[newDoc.docid] = newDoc;
                                    }
                                    else {
                                        var modified = newDoc.modified, editor = newDoc.editor, create_time = newDoc.create_time, creator = newDoc.creator;
                                        if (modified > VirtualDocs[newDoc.docid].modified) {
                                            VirtualDocs[newDoc.docid] = __assign({}, VirtualDocs[newDoc.docid], { modified: modified, editor: editor });
                                        }
                                        if (create_time < VirtualDocs[newDoc.docid].create_time) {
                                            VirtualDocs[newDoc.docid] = __assign({}, VirtualDocs[newDoc.docid], { create_time: create_time, creator: creator });
                                        }
                                    }
                                }
                                var listCache = Cache[parentDir['docid']] || { dirs: [], files: [], updateTime: updateTime_1 };
                                var dirs = listCache.dirs, files = listCache.files;
                                /**
                                 * 根据文件类型将文件放入 dirs 或 files
                                 */
                                if (newDoc.size === -1) {
                                    if (lodash_1.every(dirs, function (_a) {
                                        var docid = _a.docid;
                                        return docid !== newDoc.docid;
                                    })) {
                                        dirs = __spread(dirs, [newDoc]);
                                    }
                                }
                                else {
                                    if (lodash_1.every(files, function (_a) {
                                        var docid = _a.docid;
                                        return docid !== newDoc.docid;
                                    })) {
                                        files = __spread(files, [newDoc]);
                                    }
                                }
                                Cache[parentDir['docid']] = __assign({}, listCache, { dirs: dirs, files: files });
                                /**
                                 * 返回新 doc 作为子路径的 parentDir
                                 */
                                return newDoc;
                            }, { docid: 'entrydoc' });
                        });
                    }
                    else {
                        /**
                         * 关闭个人文档时，docinfos 为空数组，列举报错
                         */
                        Cache['entrydoc'] = { dirs: [], files: [], updateTime: updateTime_1 };
                    }
                    _k.label = 2;
                case 2:
                    /**
                     * 根目录或虚拟目录
                     */
                    if (!dir || isVirtual(dir)) {
                        _g = Cache[cacheId], dirs_1 = _g.dirs, files_1 = _g.files, currentSort = _g.sort, currentBy = _g.by;
                        if (currentBy !== by || currentSort !== sort) {
                            dirs_1 = Cache[cacheId].dirs = sortDoc(dirs_1, by, sort);
                            files_1 = Cache[cacheId].files = sortDoc(files_1, by, sort);
                            Cache[cacheId].sort = currentSort;
                            Cache[cacheId].by = currentBy;
                        }
                        return [2 /*return*/, { dirs: dirs_1, files: files_1 }];
                    }
                    canServerSort = dir.docid !== 'gns://approval' && !dir.applyid && dir.docid !== 'gns://docapproval' && (by === 'name' || by === 'size' || by === 'time');
                    dirCacheShouldUpdate = 
                    /**
                     * 未缓存
                     */
                    !Cache[cacheId] ||
                        /**
                         * 不使用缓存
                         */
                        !useCache ||
                        /**
                         * 缓存已过期
                         */
                        (Date.now() - Cache[cacheId].updateTime > TIMEOUT) ||
                        /**
                         * 使用服务器排序但当前排序方式和缓存不同 或 不使用服务器排序
                         */
                        canServerSort && (Cache[cacheId].sort !== sort || Cache[cacheId].by !== by) || !canServerSort;
                    if (!dirCacheShouldUpdate) return [3 /*break*/, 11];
                    _h = dir, link_2 = _h.link, password_1 = _h.password, perm_1 = _h.perm, usrdisplayname_1 = _h.usrdisplayname, usrloginname_1 = _h.usrloginname, docid = _h.docid, applyid_1 = _h.applyid, apptype_1 = _h.apptype, createdate_1 = _h.createdate, csflevel_1 = _h.csflevel, detail_1 = _h.detail, sharername_1 = _h.sharername, applymsg_1 = _h.applymsg, auditornames_1 = _h.auditornames, auditprogress_1 = _h.auditprogress, audittype_1 = _h.audittype, creatorname_1 = _h.creatorname, processname_1 = _h.processname;
                    listBy = canServerSort ? by : 'name';
                    listSort = canServerSort ? sort : 'asc';
                    res = void 0;
                    if (!link_2) return [3 /*break*/, 4];
                    return [4 /*yield*/, link_1.listDir({ link: link_2, docid: docid, password: password_1, attr: attr, by: listBy, sort: listSort })];
                case 3:
                    res = _k.sent();
                    return [3 /*break*/, 10];
                case 4:
                    if (!(dir.docid === 'gns://approval')) return [3 /*break*/, 6];
                    return [4 /*yield*/, audit_1.getPendingApprovals()];
                case 5:
                    applyinfos = (_k.sent()).applyinfos;
                    dirs_2 = [], files_2 = [];
                    applyinfos.forEach(function (applyinfo) {
                        if (applyinfo.isdir) {
                            dirs_2.push(applyinfo);
                        }
                        else {
                            files_2.push(applyinfo);
                        }
                    });
                    res = { dirs: dirs_2, files: files_2 };
                    return [3 /*break*/, 10];
                case 6:
                    if (!(dir.docid === 'gns://docapproval')) return [3 /*break*/, 8];
                    return [4 /*yield*/, audit_1.getDocApprovals()];
                case 7:
                    applyinfos = (_k.sent()).applyinfos;
                    dirs_3 = [], files_3 = [];
                    applyinfos.forEach(function (applyinfo) {
                        if (applyinfo.isdir) {
                            dirs_3.push(applyinfo);
                        }
                        else {
                            files_3.push(applyinfo);
                        }
                    });
                    res = { dirs: dirs_3, files: files_3 };
                    return [3 /*break*/, 10];
                case 8: return [4 /*yield*/, dir_1.list({ docid: docid, attr: attr, by: listBy, sort: listSort })];
                case 9:
                    res = _k.sent();
                    _k.label = 10;
                case 10:
                    dirs_4 = res.dirs, files_4 = res.files;
                    /**
                     * 外链文件将外链信息添加到文件对象
                     */
                    if (link_2) {
                        dirs_4 = dirs_4.map(function (doc) { return (__assign({ link: link_2, password: password_1, perm: perm_1, usrdisplayname: usrdisplayname_1, usrloginname: usrloginname_1 }, doc)); });
                        files_4 = files_4.map(function (doc) { return (__assign({ link: link_2, password: password_1, perm: perm_1, usrdisplayname: usrdisplayname_1, usrloginname: usrloginname_1 }, doc)); });
                    }
                    if (dir.applyid) {
                        if (dir.docid === 'gns://docapproval' || dir.hasOwnProperty('auditprogress')) { // 申请中的流程审核
                            dirs_4 = dirs_4.map(function (doc) { return (__assign({ applyid: applyid_1, applymsg: applymsg_1, createdate: createdate_1, csflevel: csflevel_1, auditornames: auditornames_1, auditprogress: auditprogress_1, audittype: audittype_1, creatorname: creatorname_1, processname: processname_1 }, doc)); });
                            files_4 = files_4.map(function (doc) { return (__assign({ applyid: applyid_1, applymsg: applymsg_1, createdate: createdate_1, csflevel: csflevel_1, auditornames: auditornames_1, auditprogress: auditprogress_1, audittype: audittype_1, creatorname: creatorname_1, processname: processname_1 }, doc)); });
                        }
                        else { // 申请中的共享审核
                            dirs_4 = dirs_4.map(function (doc) { return (__assign({ applyid: applyid_1, apptype: apptype_1, createdate: createdate_1, csflevel: csflevel_1, detail: detail_1, sharername: sharername_1 }, doc)); });
                            files_4 = files_4.map(function (doc) { return (__assign({ applyid: applyid_1, apptype: apptype_1, createdate: createdate_1, csflevel: csflevel_1, detail: detail_1, sharername: sharername_1 }, doc)); });
                        }
                    }
                    /**
                     * 缓存list数据，更新时间，排序方式
                     */
                    Cache[docid] = { dirs: dirs_4, files: files_4, updateTime: Date.now(), sort: sort, by: by };
                    _k.label = 11;
                case 11:
                    _j = Cache[cacheId], dirs = _j.dirs, files = _j.files;
                    /**
                     * 本地排序
                     */
                    if (!canServerSort) {
                        dirs = sortDoc(dirs, by, sort);
                        files = sortDoc(files, by, sort);
                    }
                    return [2 /*return*/, { dirs: dirs, files: files }];
            }
        });
    });
}
exports.list = list;
/**
 * 判断虚拟目录
 * @param param0
 */
function isVirtual(_a) {
    var docid = _a.docid;
    return typeof VirtualDocs[docid] !== 'undefined';
}
exports.isVirtual = isVirtual;
function isEntryDoc(_a) {
    var docid = _a.docid;
    return /^gns\:\/\/([0-9]|[A-F]){32}$/.test(docid);
}
exports.isEntryDoc = isEntryDoc;
/**
 * 判断 target 是否为 parent 的子目录
 * @param parent 父目录
 * @param target
 */
function isChildOf(parent, target) {
    if (parent === void 0) { parent = null; }
    return isDescentdantOf(parent, target) && target.docid.length === exports.GNS_LENGTH + (parent ? parent.docid.length + 1 : 6);
}
exports.isChildOf = isChildOf;
/**
 * 判断 target 是否为 parent 或 parent 的子目录中
 */
function isDescentdantOf(parent, target) {
    if (parent === void 0) { parent = null; }
    if (target && target.docid) {
        if (parent === null) {
            return true;
        }
        return parent.docid && target.docid.startsWith(parent.docid);
    }
}
exports.isDescentdantOf = isDescentdantOf;
/**
 * 根据文件获取doc路径
 * @param doc
 * @param relativeRoot
 */
function getDocsChainByDocId(docid, relativeRoot) {
    if (docid === void 0) { docid = ''; }
    if (relativeRoot === void 0) { relativeRoot = null; }
    return __awaiter(this, void 0, void 0, function () {
        var e_1, _a, docs, currentIndex, gnses, _loop_1, gnses_1, gnses_1_1, gns, e_1_1, e_2;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    docs = [relativeRoot], currentIndex = 0, gnses = gns_1.splitGNS(docid).slice(relativeRoot ? (relativeRoot.docid.length - 5) / (exports.GNS_LENGTH + 1) : 0);
                    _b.label = 1;
                case 1:
                    _b.trys.push([1, 10, , 11]);
                    _loop_1 = function (gns) {
                        var _a, dirs, files, findScope, findDoc;
                        return __generator(this, function (_b) {
                            switch (_b.label) {
                                case 0: return [4 /*yield*/, list(lodash_1.last(docs))];
                                case 1:
                                    _a = _b.sent(), dirs = _a.dirs, files = _a.files;
                                    findScope = currentIndex === gnses.length - 1 ? __spread(dirs, files) : dirs;
                                    findDoc = findScope.find(function (doc) { return doc.docid === gns; });
                                    currentIndex += 1;
                                    if (findDoc) {
                                        docs = __spread(docs, [findDoc]);
                                    }
                                    else {
                                        throw { errmsg: gns + " not found" };
                                    }
                                    return [2 /*return*/];
                            }
                        });
                    };
                    _b.label = 2;
                case 2:
                    _b.trys.push([2, 7, 8, 9]);
                    gnses_1 = __values(gnses), gnses_1_1 = gnses_1.next();
                    _b.label = 3;
                case 3:
                    if (!!gnses_1_1.done) return [3 /*break*/, 6];
                    gns = gnses_1_1.value;
                    return [5 /*yield**/, _loop_1(gns)];
                case 4:
                    _b.sent();
                    _b.label = 5;
                case 5:
                    gnses_1_1 = gnses_1.next();
                    return [3 /*break*/, 3];
                case 6: return [3 /*break*/, 9];
                case 7:
                    e_1_1 = _b.sent();
                    e_1 = { error: e_1_1 };
                    return [3 /*break*/, 9];
                case 8:
                    try {
                        if (gnses_1_1 && !gnses_1_1.done && (_a = gnses_1["return"])) _a.call(gnses_1);
                    }
                    finally { if (e_1) throw e_1.error; }
                    return [7 /*endfinally*/];
                case 9: return [2 /*return*/, docs];
                case 10:
                    e_2 = _b.sent();
                    throw {
                        errcode: e_2.errcode,
                        nativeEvent: e_2,
                        upperDocsChain: docs
                    };
                case 11: return [2 /*return*/];
            }
        });
    });
}
exports.getDocsChainByDocId = getDocsChainByDocId;
/**
 * 根据docid获取文档
 * @param docid
 * @param relativeRoot
 */
function getDocByDocId(docid, relativeRoot) {
    if (docid === void 0) { docid = ''; }
    if (relativeRoot === void 0) { relativeRoot = null; }
    return __awaiter(this, void 0, void 0, function () {
        var _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    _a = lodash_1.last;
                    return [4 /*yield*/, getDocsChainByDocId(docid, relativeRoot)];
                case 1: return [2 /*return*/, _a.apply(void 0, [_b.sent()])];
            }
        });
    });
}
exports.getDocByDocId = getDocByDocId;
/**
 * 根据doc获取文件链
 * @param doc
 * @param relativeRoot
 */
function getDocsChain(doc, relativeRoot) {
    if (doc === void 0) { doc = null; }
    if (relativeRoot === void 0) { relativeRoot = null; }
    return __awaiter(this, void 0, void 0, function () {
        var approvalRoot, _a, dirs, files, _b;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    if (!(doc && !relativeRoot)) return [3 /*break*/, 5];
                    if (!doc.applyid) return [3 /*break*/, 3];
                    approvalRoot = { docid: 'gns://approval' };
                    return [4 /*yield*/, list(approvalRoot)];
                case 1:
                    _a = _c.sent(), dirs = _a.dirs, files = _a.files;
                    relativeRoot = __spread(dirs, files).find(function (dir) { return dir.applyid === doc.applyid; });
                    if (relativeRoot && relativeRoot.docid === doc.docid) {
                        return [2 /*return*/, [approvalRoot, relativeRoot]];
                    }
                    _b = [[approvalRoot]];
                    return [4 /*yield*/, getDocsChainByDocId(doc && doc.docid ? doc.docid : '', relativeRoot)];
                case 2: return [2 /*return*/, __spread.apply(void 0, _b.concat([(_c.sent())]))];
                case 3:
                    if (!doc.link) return [3 /*break*/, 5];
                    return [4 /*yield*/, getLinkRoot(doc.link, doc.password)];
                case 4:
                    relativeRoot = _c.sent();
                    _c.label = 5;
                case 5: return [2 /*return*/, getDocsChainByDocId(doc && doc.docid ? doc.docid : '', relativeRoot)];
            }
        });
    });
}
exports.getDocsChain = getDocsChain;
/**
 * 获取流程审核待审核文件链
 */
function getFlowApvDocsChain(doc, relativeRoot) {
    if (doc === void 0) { doc = null; }
    if (relativeRoot === void 0) { relativeRoot = null; }
    return __awaiter(this, void 0, void 0, function () {
        var approvalRoot, _a, dirs, files, _b;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    approvalRoot = { docid: 'gns://docapproval' };
                    return [4 /*yield*/, list(approvalRoot)];
                case 1:
                    _a = _c.sent(), dirs = _a.dirs, files = _a.files;
                    relativeRoot = __spread(dirs, files).find(function (dir) { return dir.applyid === doc.applyid; });
                    if (relativeRoot && relativeRoot.docid === doc.docid) {
                        return [2 /*return*/, [approvalRoot, relativeRoot]];
                    }
                    _b = [[approvalRoot]];
                    return [4 /*yield*/, getDocsChainByDocId(doc && doc.docid ? doc.docid : '', relativeRoot)];
                case 2: return [2 /*return*/, __spread.apply(void 0, _b.concat([(_c.sent())]))];
            }
        });
    });
}
exports.getFlowApvDocsChain = getFlowApvDocsChain;
/**
 * 获取父目录
 * @param doc
 */
function getParent(doc) {
    return __awaiter(this, void 0, void 0, function () {
        var relativeRoot;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!(doc && doc.docid && doc.docid.length > exports.GNS_LENGTH + 6)) return [3 /*break*/, 3];
                    relativeRoot = null;
                    if (!(doc && doc.link)) return [3 /*break*/, 2];
                    return [4 /*yield*/, getLinkRoot(doc.link, doc.password)];
                case 1:
                    relativeRoot = _a.sent();
                    _a.label = 2;
                case 2: return [2 /*return*/, getDocByDocId(doc.docid.slice(0, -(exports.GNS_LENGTH + 1)), relativeRoot)];
                case 3: return [2 /*return*/, null];
            }
        });
    });
}
exports.getParent = getParent;
/**
 * 把文件转换为路径
 * @param doc
 */
function convertPath(doc, relativeRoot) {
    return __awaiter(this, void 0, void 0, function () {
        var docs;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, getDocsChain(doc, relativeRoot)];
                case 1:
                    docs = _a.sent();
                    if (!docs[0]) {
                        docs = docs.slice(1);
                    }
                    return [2 /*return*/, docs.map(docs_1.docname).join('/')];
            }
        });
    });
}
exports.convertPath = convertPath;
/**
 * 根据文件路径获取文件链
 * @param path
 * @param relativeRoot
 */
function getDocsChainByNamePath(namepath, relativeRoot) {
    if (namepath === void 0) { namepath = []; }
    if (relativeRoot === void 0) { relativeRoot = null; }
    return __awaiter(this, void 0, void 0, function () {
        var e_3, _a, docs, currentIndex, _loop_2, namepath_1, namepath_1_1, name, e_3_1, e_4;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    if (typeof namepath === 'string') {
                        namepath = namepath.split('/').filter(function (name) { return !!name; });
                    }
                    docs = [relativeRoot], currentIndex = 0;
                    _b.label = 1;
                case 1:
                    _b.trys.push([1, 10, , 11]);
                    _loop_2 = function (name) {
                        var _a, dirs, files, findScope, findDoc;
                        return __generator(this, function (_b) {
                            switch (_b.label) {
                                case 0: return [4 /*yield*/, list(lodash_1.last(docs))];
                                case 1:
                                    _a = _b.sent(), dirs = _a.dirs, files = _a.files;
                                    findScope = currentIndex === namepath.length - 1 ? __spread(dirs, files) : dirs;
                                    findDoc = findScope.find(function (doc) { return docs_1.docname(doc) === name; });
                                    currentIndex += 1;
                                    if (findDoc) {
                                        docs = __spread(docs, [findDoc]);
                                    }
                                    else {
                                        throw { errmsg: name + " not found" };
                                    }
                                    return [2 /*return*/];
                            }
                        });
                    };
                    _b.label = 2;
                case 2:
                    _b.trys.push([2, 7, 8, 9]);
                    namepath_1 = __values(namepath), namepath_1_1 = namepath_1.next();
                    _b.label = 3;
                case 3:
                    if (!!namepath_1_1.done) return [3 /*break*/, 6];
                    name = namepath_1_1.value;
                    return [5 /*yield**/, _loop_2(name)];
                case 4:
                    _b.sent();
                    _b.label = 5;
                case 5:
                    namepath_1_1 = namepath_1.next();
                    return [3 /*break*/, 3];
                case 6: return [3 /*break*/, 9];
                case 7:
                    e_3_1 = _b.sent();
                    e_3 = { error: e_3_1 };
                    return [3 /*break*/, 9];
                case 8:
                    try {
                        if (namepath_1_1 && !namepath_1_1.done && (_a = namepath_1["return"])) _a.call(namepath_1);
                    }
                    finally { if (e_3) throw e_3.error; }
                    return [7 /*endfinally*/];
                case 9: return [2 /*return*/, docs];
                case 10:
                    e_4 = _b.sent();
                    throw {
                        errcode: e_4.errcode,
                        nativeEvent: e_4,
                        upperDocsChain: docs
                    };
                case 11: return [2 /*return*/];
            }
        });
    });
}
exports.getDocsChainByNamePath = getDocsChainByNamePath;
/**
 * 根据路径获取doc
 * @param path
 */
function getDocByNamePath(namepath, relativeRoot) {
    return __awaiter(this, void 0, void 0, function () {
        var _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    _a = lodash_1.last;
                    return [4 /*yield*/, getDocsChainByNamePath(namepath, relativeRoot)];
                case 1: return [2 /*return*/, _a.apply(void 0, [_b.sent()])];
            }
        });
    });
}
exports.getDocByNamePath = getDocByNamePath;
/**
 * 插入新doc
 * @param doc
 * @param parentDir
 */
function insert(doc) {
    return __awaiter(this, void 0, void 0, function () {
        var docid_1, cacheId, listCache, dirs, files, index, index;
        return __generator(this, function (_a) {
            if (doc) {
                docid_1 = doc.docid;
                cacheId = 'entrydoc';
                if (docid_1.length > exports.GNS_LENGTH + 6) {
                    cacheId = docid_1.slice(0, -(exports.GNS_LENGTH + 1));
                }
                listCache = Cache[cacheId] || { dirs: [], files: [], updateTime: Date.now() };
                dirs = listCache.dirs, files = listCache.files;
                if (docs_1.isDir(doc)) {
                    index = lodash_1.findIndex(dirs, function (dir) { return dir.docid === docid_1; });
                    dirs = index === -1 ? __spread([doc], dirs) : __spread(dirs.slice(0, index), [doc], dirs.slice(index + 1));
                }
                else {
                    index = lodash_1.findIndex(files, function (file) { return file.docid === docid_1; });
                    files = index === -1 ? __spread([doc], files) : __spread(files.slice(0, index), [doc], files.slice(index + 1));
                }
                exports.trigger(EventType.FS_INSERT, null, doc);
                Cache[cacheId] = __assign({}, listCache, { dirs: dirs, files: files });
            }
            return [2 /*return*/, doc];
        });
    });
}
exports.insert = insert;
/**
 * 从缓存中删除文档
 * @param doc
 */
function del(doc) {
    if (doc) {
        var docid_2 = doc.docid;
        /**
         * 父目录id
         */
        var cacheId = 'entrydoc';
        /**
         * 非入口文档，id为docid截去最后一级
         * URL protocol “gns://” length 为 6
         */
        if (docid_2.length > exports.GNS_LENGTH + 6) {
            cacheId = docid_2.slice(0, -(exports.GNS_LENGTH + 1));
        }
        var listCache = Cache[cacheId];
        if (listCache) {
            var dirs = listCache.dirs, files = listCache.files;
            if (docs_1.isDir(doc)) {
                dirs = dirs.filter(function (doc) { return doc.docid !== docid_2; });
            }
            else {
                files = files.filter(function (doc) { return doc.docid !== docid_2; });
            }
            exports.trigger(EventType.FS_DELETE, null, doc);
            Cache[cacheId] = __assign({}, listCache, { dirs: dirs, files: files });
        }
        /**
         * 删除文件夹时删除所有子文件夹的缓存
         */
        if (docs_1.isDir(doc)) {
            for (var key in Cache) {
                if (key.startsWith(doc.docid)) {
                    delete Cache[key];
                }
            }
        }
    }
    return doc;
}
exports.del = del;
/**
 * 更新缓存文件信息
 * @param doc
 * @param metas
 */
function update(doc, metas) {
    if (metas === void 0) { metas = {}; }
    if (doc) {
        var docid_3 = doc.docid;
        var cacheId = 'entrydoc';
        if (docid_3.length > exports.GNS_LENGTH + 6) {
            cacheId = docid_3.slice(0, -(exports.GNS_LENGTH + 1));
        }
        var listCache = Cache[cacheId];
        if (listCache) {
            var dirs = listCache.dirs, files = listCache.files;
            if (docs_1.isDir(doc)) {
                var index = lodash_1.findIndex(dirs, function (doc) { return doc.docid === docid_3; });
                if (index !== -1) {
                    doc = __assign({}, dirs[index], metas);
                    dirs = __spread(dirs.slice(0, index), [doc], dirs.slice(index + 1));
                }
            }
            else {
                var index = lodash_1.findIndex(files, function (doc) { return doc.docid === docid_3; });
                if (index !== -1) {
                    doc = __assign({}, files[index], metas);
                    files = __spread(files.slice(0, index), [doc], files.slice(index + 1));
                }
            }
            exports.trigger(EventType.FS_UPDATE, null, doc);
            Cache[cacheId] = __assign({}, listCache, { dirs: dirs, files: files });
        }
        if (docs_1.isDir(doc)) {
            /**
             * 需要更新子目录信息白名单
             */
            var WHITE_LIST = ['password'];
            /**
             * 子目录需要更新的属性
             */
            var shouldUpdateChildrenCacheMetas_1 = lodash_1.pick(metas, WHITE_LIST);
            if (!lodash_1.isEmpty(shouldUpdateChildrenCacheMetas_1)) {
                /**
                 * 遍历Cache，根据缓存id判断
                 */
                for (var key in Cache) {
                    if (key.startsWith(doc.docid)) {
                        var _a = Cache[key], dirs = _a.dirs, files = _a.files, otherInfos = __rest(_a, ["dirs", "files"]);
                        Cache[key] = __assign({ dirs: dirs.map(function (doc) { return (__assign({}, doc, shouldUpdateChildrenCacheMetas_1)); }), files: files.map(function (doc) { return (__assign({}, doc, shouldUpdateChildrenCacheMetas_1)); }) }, otherInfos);
                    }
                }
            }
        }
    }
    return doc;
}
exports.update = update;
/**
 * 获取文件对应的入口文档
 * @param doc
 */
function getViewDoc(doc) {
    return __awaiter(this, void 0, void 0, function () {
        var dirs;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!(doc && typeof doc.docid === 'string' && !doc.link)) return [3 /*break*/, 2];
                    return [4 /*yield*/, list(null)];
                case 1:
                    dirs = (_a.sent()).dirs;
                    return [2 /*return*/, dirs.find(function (dir) { return doc.docid.startsWith(dir.docid); })];
                case 2: return [2 /*return*/];
            }
        });
    });
}
exports.getViewDoc = getViewDoc;
/**
 * 获取文件的 view_type
 * @param doc
 */
function getViewType(doc) {
    return __awaiter(this, void 0, void 0, function () {
        var viewDoc;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, getViewDoc(doc)];
                case 1:
                    viewDoc = _a.sent();
                    if (viewDoc) {
                        return [2 /*return*/, viewDoc.view_type];
                    }
                    return [2 /*return*/];
            }
        });
    });
}
exports.getViewType = getViewType;
/**
 * 获取文件的 view_doctype
 * @param doc
 */
function getViewDocType(doc) {
    return __awaiter(this, void 0, void 0, function () {
        var viewDoc;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, getViewDoc(doc)];
                case 1:
                    viewDoc = _a.sent();
                    if (viewDoc) {
                        return [2 /*return*/, viewDoc.view_doctype];
                    }
                    return [2 /*return*/];
            }
        });
    });
}
exports.getViewDocType = getViewDocType;


/***/ }),

/***/ "../ShareWebCore/src/filesystem/index.ts":
/***/ (function(module, exports, __webpack_require__) {

function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
exports.__esModule = true;
__export(__webpack_require__("../ShareWebCore/src/filesystem/filesystem.ts"));


/***/ }),

/***/ "../ShareWebCore/src/gns/gns.ts":
/***/ (function(module, exports, __webpack_require__) {

var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
exports.__esModule = true;
var lodash_1 = __webpack_require__("../node_modules/lodash/index.js");
/**
 * 文档缓存对象
 * 以docid为键，文档对象为值。
 * 缓存对象以平铺形式保存，不存在层级关系
 */
exports.DATABASE = {};
/**
 * 序列化路径，移除首尾 / ，并分割成数组
 */
function serializePath(path) {
    if (!path)
        return [];
    return path.replace(/^\/+|\/+$/g, '').split('/').map(function (o) { return decodeURIComponent(o); });
}
exports.serializePath = serializePath;
/**
 * 将单条gns路径按层级拆分成多条
 * @param gns
 * @return 拆分后的GNS路径数组
 */
function splitGNS(gns) {
    if (!gns) {
        return [];
    }
    else {
        return gns
            .replace(/^gns:\/\//, '')
            .split('/')
            .reduce(function (prev, id, i, arr) { return prev.concat("gns://" + arr.slice(0, i + 1).join('/')); }, []);
    }
}
exports.splitGNS = splitGNS;
/**
 * 缓存结果
 * @param fn
 */
function cacheDB(fn) {
    return function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        return fn.apply(void 0, __spread(args)).then(function (result) {
            updateCache(result);
            return result;
        });
    };
}
exports.cacheDB = cacheDB;
/**
 * 更新缓存
 */
function updateCache(docs) {
    return exports.DATABASE = lodash_1.merge(exports.DATABASE, lodash_1.indexBy(docs, 'docid'));
}
exports.updateCache = updateCache;
/**
 * 移除docid下的子目录
 * @param {docid} 文档对象
 */
function omitSubs(_a) {
    var docid = _a.docid;
    return exports.DATABASE = lodash_1.omit(exports.DATABASE, function (doc, gns) {
        // 只删除非入口文档子目录
        return gns.indexOf(docid) !== -1 && gns.length > docid.length && !doc.doctype;
    });
}
exports.omitSubs = omitSubs;


/***/ }),

/***/ "../ShareWebCore/src/i18n.ts":
/***/ (function(module, exports, __webpack_require__) {

exports.__esModule = true;
var I18NFactory_1 = __webpack_require__("../ShareWebUtil/src/I18NFactory/index.ts");
var browser_1 = __webpack_require__("../ShareWebUtil/src/browser/index.ts");
/**
 * 导出i18n实例
 */
exports["default"] = I18NFactory_1["default"]({
    translations: ['zh-cn', 'zh-tw', 'en-us'],
    locale: browser_1.envLanguage()
});


/***/ }),

/***/ "../ShareWebCore/src/icons/assets/desktop/icon-cad-file.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/desktop/icon-doc-archive.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/desktop/icon-doc-audio.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/desktop/icon-doc-dir.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA4ZpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMTMyIDc5LjE1OTI4NCwgMjAxNi8wNC8xOS0xMzoxMzo0MCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpmZmRiM2JlMC1iMTM2LWJkNGMtODRmOS1iOTIyNWVlMDVlZTQiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6NzY2MDY1OTBEQkM2MTFFNzgyMDJBRkU4MzZERkM3MTgiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6NzY2MDY1OEZEQkM2MTFFNzgyMDJBRkU4MzZERkM3MTgiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIDIwMTUuNSAoV2luZG93cykiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDo1YzRkYTQ1My03ZGE3LTNhNDEtYjA5Ny0wMjIxYmY4NzEyNWUiIHN0UmVmOmRvY3VtZW50SUQ9ImFkb2JlOmRvY2lkOnBob3Rvc2hvcDo3NThkNzUwZi1iZDQ2LTExZTctYWViMy1hMzcxZGI2ZjMzNzkiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz612OOrAAABhElEQVR42uyXPU7DQBCFZ9fG0NFQQkEVQQUSJ0GIA1DQUnAHhMQNOEMELRWi5gYICUQKCgKOTWyTH3uHGXutRAhBjCNPw5OeYjnF+zQ7u7NWiAiS0iAscQB38tj0UqgJAI66MHw4PQIwW+Uf32hEvrbu1srOBuCtHoBe3rEVwLHGj6djAlj7AYB1SH61EJf296UyQBoDZtH0ElCoWogJAH4BYK2Q960Z5oZ8RY5njHdAe/fUfrdfeuBPYpg96yq6I29w7YtdoBzTbBNylsZiG6Y+rUnPBdXgjlQuKpO4nK2wc3ZCr3bRDNYB0WsGQI2UXnykh3PqAbNNr1rKWZqlAeclD9C0KHuTAFSnWBaUOIyede1DpZ562u5lKfkM8CYIEDCAz6ezEEBYAqQC4VhWICAPBQA4s88APJYSAQAeXokkAGfGDNCvMErnXYEcgBvwXQCAM7NyBIYSZ8D0rVgCIJQGCOyVLJ+AkQBAZAHyIlzY+12TaucDGceSs4gB/j9OhfUpwADEO3vqzsSnPgAAAABJRU5ErkJggg=="

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/desktop/icon-doc-excel.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/desktop/icon-doc-exe.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/desktop/icon-doc-file.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA4ZpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMTMyIDc5LjE1OTI4NCwgMjAxNi8wNC8xOS0xMzoxMzo0MCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpmZmRiM2JlMC1iMTM2LWJkNGMtODRmOS1iOTIyNWVlMDVlZTQiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6Q0QzMjE2RDZEQkM5MTFFNzgxOTRFNTYxNThGNzRDREIiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6Q0QzMjE2RDVEQkM5MTFFNzgxOTRFNTYxNThGNzRDREIiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIDIwMTUuNSAoV2luZG93cykiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDo1OGYyMTFjYy1jMTU1LTZjNDQtOTIwNC02N2NjODA1MzdjODAiIHN0UmVmOmRvY3VtZW50SUQ9ImFkb2JlOmRvY2lkOnBob3Rvc2hvcDo3NThkNzUwZi1iZDQ2LTExZTctYWViMy1hMzcxZGI2ZjMzNzkiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz6iShNsAAABj0lEQVR42uyXMWvCQBTHX2IasYGSEEQIGFKXIIhDh9C9nfo5+jkK/RDt1rHQxa79DlIcDEocLMFsiUjAICaaXO8sgtBGNGq63IMMuRz3fvn/34N7DEII1hGGodrv918WiwXLMAxkiSRJQBTFd13Xn3bZz22+LJdLIQiCW03TICtAFEUwHA6vS6XSl6qqH3sBYDVQsVhMqtUqCxkDqwi2bZ9blvXGcdyNoiif2/b/SkQs2bRl38AqgiAIUKlULkzTbPm+r+0FcGgQeGJfo9EAWZbVTqfTmk6nYm4Aa4hCoQDNZhN4nr/qdruvWJmz3ADWBYyTg2EYpDPusBLPxJ5cAObzOYxGI3AcBzzPA0mSwHXd+8Fg8IDVYU8KQP66XC4DLr7VM5lMVorUajUYj8ePs9nsMrUNjwVQr9f//NZut0mn8ye3IK0w0U9/o38ByLUNKQAFoAAUgAJQAApAAQ4GyDoX7nJV3zobkn1xHLN4kjk6BLkOkrNJjlQAPEyGeKKxer3eSazBZyckx+batwADAMyKoTxq8FXSAAAAAElFTkSuQmCC"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/desktop/icon-doc-html.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/desktop/icon-doc-image.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/desktop/icon-doc-pdf.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/desktop/icon-doc-ppt.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/desktop/icon-doc-psd.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/desktop/icon-doc-txt.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA4ZpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMTMyIDc5LjE1OTI4NCwgMjAxNi8wNC8xOS0xMzoxMzo0MCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpmZmRiM2JlMC1iMTM2LWJkNGMtODRmOS1iOTIyNWVlMDVlZTQiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6NDVDOTE5ODlEQkM2MTFFN0E2Q0Y5MUU2RjFDNUUyNzgiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6NDVDOTE5ODhEQkM2MTFFN0E2Q0Y5MUU2RjFDNUUyNzgiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIDIwMTUuNSAoV2luZG93cykiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDo1YzRkYTQ1My03ZGE3LTNhNDEtYjA5Ny0wMjIxYmY4NzEyNWUiIHN0UmVmOmRvY3VtZW50SUQ9ImFkb2JlOmRvY2lkOnBob3Rvc2hvcDo3NThkNzUwZi1iZDQ2LTExZTctYWViMy1hMzcxZGI2ZjMzNzkiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz6J99WAAAADeElEQVR42rxX70tTYRQ+9+73XenQAjV/TGY6c0OaSdoX0aSyEPrSB79Gf0fQH1Hf6lNiEPOLiJFgQ1AiRZHEpk4lMmXqGOqms+3uds7bJpd5r+7eNg+Mbdz7vud5z3mec87LSZIEWTuIxWpHx8ffHicSPMdxoMfS6TRUV1UNP+jqep3PHkb5n5OTE/tuJNJ7r70deJ0AYvE4fJme7nCUlKzf9fnGNAHAaEh2QUjfaW3lQacdIoCpmRlhbGLig9Viud/a0jJ73vtnHFFKKIx6LZFIwPXycrjV2FjiHx31/9racmoC8L9GBzAYDPC0rw9cdXW17/1+f3h313FpAMhEUQSzyQTP+vvhiiD4Po6MDGJkTJcGIMt+QRDg+cAApETx8eDw8Bsk+eUA2D84gG/z8zC7sAAr6+vgrKmBYCj04lMg8BKjw6uqoBBGp25qaAAk32kkjMiJrs5OWA6FXkX39wevlZWtFQ0A5hye9PYqPkMySqgws+4IkDyZRNWKFCqATk0qUFor/Su7km4AM5TTtTXGcDX2O0pLoa+nB/It5ZoA3PZ4wOt2q25OB+R5HrT0EU0A6ORqp9drmgAQs/ciEeAVcswigHm2Wa1MBUUBED86gkg0Ckaj8jIRAVy124sXATeezK3hdAUHkEwmqayqk4xkiCS0mM3FATC/uAirWFpNF8jwUXd3cWSIgwr4vN4LG1HRZEgap08hjVdqo3oH0nxadO7exlySZUeyQp800wuYD1UApPHw3h68GxpSLLPyER4yueayzzIqkKfrTDfEvclHVUWFOgdSqRR7Mde5zWIBAxagNDKduh29l8AJJ43PsiWaANF/AzqPHx+zyijvnLTmQhLSJsacUksLG10uaKivZ5Xu5+Ym4OWFhXUZu2NHWxvgfQJcTicrxb+3t+Hr3BwDKL9fkEx1qYBK78LSEuA0A56mJhifnGRAHqLeKZw/VlbgezDILiV11dXwORAAKwLJ53LDa2ExJxu76QKyg6m6UVkJQdmMkG3JumSYLxByQhEoczhgOxyGm5iaJKZJaxHSDIAcUy8gTnhwMCGyTkxNgbe5GcxY/ynHSnnWUgk5NVBEzB0kWhRHbsFmg9WNDUZEAhNAEJQCIh8Onqq9IrM3dx4AujkE1UCQMyoklOPDWIyFm37jtZ59ixihP5nnavUo4+PU/gowANklmwCMonwVAAAAAElFTkSuQmCC"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/desktop/icon-doc-video.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/desktop/icon-doc-view.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAKASURBVFhH7Za9b1JhFMZvTBwcHbUhYbQwdXBwJ64uxj/AxOjigDGGxCYFhzZAiJGEpGVw6dBJrHwJBQqEFG0FQmkvnwVboMUGUpoQIErl8Vz6xqahra0F43Cf5Jd7h5vzvPec51zgRIkS9V8qkUhc53nenEwm3w6Qu6z8n0UPK1OpFAZMhJU/W8Vi8Vomk8EwSKfT95jN6crlciYCwyCbzVaYzcmitx8pFAoYMk+ZXb82NzddBIbMDwBXmOWRyuXyna2tLVAX/gVvjh2CzB+USqVCpVLB3t4e6vU69vf3B45Qe3d3F+QHetmXzJ7j3G73/Z2dnQ90qkg2l+tSWnuppdAMDGEVhSA2Go1Up9NJh8Ph/iy4XC7J9PR0V6/XQ6PRQKNW4xVdL4ua6kxNTsJkMsFmsz1kdv0ym81TdAhEIxH4FxfhWViA1+O5NAtuN2LRKDx0Pzc3d/oHyWKxlDPUfmFWwgh6a5PPX5r8xga2ae5FCrnd4YDX6x1hlkeanZ29HaC3brbbaFMYSo0GvtH9INhuNlE7OKCqQHhpCcFgcJzZHorMb1it1tc8haXbagGrq6DUADw/GJJJYH0dqNXwlTrh8/kS5HeL2XMctWSCfoBa33tnJFEGzoTm+VfQegt9EL43fr/fwOx7s38UCoXCiXgcn1ZW8HF5Ge/8frwPBn9jCQR61+DaGj5Tp5YoKxcmFsMXqh2Px2tOp7N/DUdHR59IpdIJpVLZFVZGq9VCp9P1MBgMMBqNUCgUixKJ5LFMJlNdFLlcPk4emrGxsZvM8mTRjFSHsziuarX6kz0yXM3MzFydn59/5nA4Xtjt9ucC1DIV7fD5/9WIEiXqXOK4XxgXGYFCFxOQAAAAAElFTkSuQmCC"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/desktop/icon-doc-visio.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/desktop/icon-doc-word.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/mobile/icon-cad-file.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAACXBIWXMAAAsTAAALEwEAmpwYAAAKTWlDQ1BQaG90b3Nob3AgSUNDIHByb2ZpbGUAAHjanVN3WJP3Fj7f92UPVkLY8LGXbIEAIiOsCMgQWaIQkgBhhBASQMWFiApWFBURnEhVxILVCkidiOKgKLhnQYqIWotVXDjuH9yntX167+3t+9f7vOec5/zOec8PgBESJpHmomoAOVKFPDrYH49PSMTJvYACFUjgBCAQ5svCZwXFAADwA3l4fnSwP/wBr28AAgBw1S4kEsfh/4O6UCZXACCRAOAiEucLAZBSAMguVMgUAMgYALBTs2QKAJQAAGx5fEIiAKoNAOz0ST4FANipk9wXANiiHKkIAI0BAJkoRyQCQLsAYFWBUiwCwMIAoKxAIi4EwK4BgFm2MkcCgL0FAHaOWJAPQGAAgJlCLMwAIDgCAEMeE80DIEwDoDDSv+CpX3CFuEgBAMDLlc2XS9IzFLiV0Bp38vDg4iHiwmyxQmEXKRBmCeQinJebIxNI5wNMzgwAABr50cH+OD+Q5+bk4eZm52zv9MWi/mvwbyI+IfHf/ryMAgQAEE7P79pf5eXWA3DHAbB1v2upWwDaVgBo3/ldM9sJoFoK0Hr5i3k4/EAenqFQyDwdHAoLC+0lYqG9MOOLPv8z4W/gi372/EAe/tt68ABxmkCZrcCjg/1xYW52rlKO58sEQjFu9+cj/seFf/2OKdHiNLFcLBWK8ViJuFAiTcd5uVKRRCHJleIS6X8y8R+W/QmTdw0ArIZPwE62B7XLbMB+7gECiw5Y0nYAQH7zLYwaC5EAEGc0Mnn3AACTv/mPQCsBAM2XpOMAALzoGFyolBdMxggAAESggSqwQQcMwRSswA6cwR28wBcCYQZEQAwkwDwQQgbkgBwKoRiWQRlUwDrYBLWwAxqgEZrhELTBMTgN5+ASXIHrcBcGYBiewhi8hgkEQcgIE2EhOogRYo7YIs4IF5mOBCJhSDSSgKQg6YgUUSLFyHKkAqlCapFdSCPyLXIUOY1cQPqQ28ggMor8irxHMZSBslED1AJ1QLmoHxqKxqBz0XQ0D12AlqJr0Rq0Hj2AtqKn0UvodXQAfYqOY4DRMQ5mjNlhXIyHRWCJWBomxxZj5Vg1Vo81Yx1YN3YVG8CeYe8IJAKLgBPsCF6EEMJsgpCQR1hMWEOoJewjtBK6CFcJg4Qxwicik6hPtCV6EvnEeGI6sZBYRqwm7iEeIZ4lXicOE1+TSCQOyZLkTgohJZAySQtJa0jbSC2kU6Q+0hBpnEwm65Btyd7kCLKArCCXkbeQD5BPkvvJw+S3FDrFiOJMCaIkUqSUEko1ZT/lBKWfMkKZoKpRzame1AiqiDqfWkltoHZQL1OHqRM0dZolzZsWQ8ukLaPV0JppZ2n3aC/pdLoJ3YMeRZfQl9Jr6Afp5+mD9HcMDYYNg8dIYigZaxl7GacYtxkvmUymBdOXmchUMNcyG5lnmA+Yb1VYKvYqfBWRyhKVOpVWlX6V56pUVXNVP9V5qgtUq1UPq15WfaZGVbNQ46kJ1Bar1akdVbupNq7OUndSj1DPUV+jvl/9gvpjDbKGhUaghkijVGO3xhmNIRbGMmXxWELWclYD6yxrmE1iW7L57Ex2Bfsbdi97TFNDc6pmrGaRZp3mcc0BDsax4PA52ZxKziHODc57LQMtPy2x1mqtZq1+rTfaetq+2mLtcu0W7eva73VwnUCdLJ31Om0693UJuja6UbqFutt1z+o+02PreekJ9cr1Dund0Uf1bfSj9Rfq79bv0R83MDQINpAZbDE4Y/DMkGPoa5hpuNHwhOGoEctoupHEaKPRSaMnuCbuh2fjNXgXPmasbxxirDTeZdxrPGFiaTLbpMSkxeS+Kc2Ua5pmutG003TMzMgs3KzYrMnsjjnVnGueYb7ZvNv8jYWlRZzFSos2i8eW2pZ8ywWWTZb3rJhWPlZ5VvVW16xJ1lzrLOtt1ldsUBtXmwybOpvLtqitm63Edptt3xTiFI8p0in1U27aMez87ArsmuwG7Tn2YfYl9m32zx3MHBId1jt0O3xydHXMdmxwvOuk4TTDqcSpw+lXZxtnoXOd8zUXpkuQyxKXdpcXU22niqdun3rLleUa7rrStdP1o5u7m9yt2W3U3cw9xX2r+00umxvJXcM970H08PdY4nHM452nm6fC85DnL152Xlle+70eT7OcJp7WMG3I28Rb4L3Le2A6Pj1l+s7pAz7GPgKfep+Hvqa+It89viN+1n6Zfgf8nvs7+sv9j/i/4XnyFvFOBWABwQHlAb2BGoGzA2sDHwSZBKUHNQWNBbsGLww+FUIMCQ1ZH3KTb8AX8hv5YzPcZyya0RXKCJ0VWhv6MMwmTB7WEY6GzwjfEH5vpvlM6cy2CIjgR2yIuB9pGZkX+X0UKSoyqi7qUbRTdHF09yzWrORZ+2e9jvGPqYy5O9tqtnJ2Z6xqbFJsY+ybuIC4qriBeIf4RfGXEnQTJAntieTE2MQ9ieNzAudsmjOc5JpUlnRjruXcorkX5unOy553PFk1WZB8OIWYEpeyP+WDIEJQLxhP5aduTR0T8oSbhU9FvqKNolGxt7hKPJLmnVaV9jjdO31D+miGT0Z1xjMJT1IreZEZkrkj801WRNberM/ZcdktOZSclJyjUg1plrQr1zC3KLdPZisrkw3keeZtyhuTh8r35CP5c/PbFWyFTNGjtFKuUA4WTC+oK3hbGFt4uEi9SFrUM99m/ur5IwuCFny9kLBQuLCz2Lh4WfHgIr9FuxYji1MXdy4xXVK6ZHhp8NJ9y2jLspb9UOJYUlXyannc8o5Sg9KlpUMrglc0lamUycturvRauWMVYZVkVe9ql9VbVn8qF5VfrHCsqK74sEa45uJXTl/VfPV5bdra3kq3yu3rSOuk626s91m/r0q9akHV0IbwDa0b8Y3lG19tSt50oXpq9Y7NtM3KzQM1YTXtW8y2rNvyoTaj9nqdf13LVv2tq7e+2Sba1r/dd3vzDoMdFTve75TsvLUreFdrvUV99W7S7oLdjxpiG7q/5n7duEd3T8Wej3ulewf2Re/ranRvbNyvv7+yCW1SNo0eSDpw5ZuAb9qb7Zp3tXBaKg7CQeXBJ9+mfHvjUOihzsPcw83fmX+39QjrSHkr0jq/dawto22gPaG97+iMo50dXh1Hvrf/fu8x42N1xzWPV56gnSg98fnkgpPjp2Snnp1OPz3Umdx590z8mWtdUV29Z0PPnj8XdO5Mt1/3yfPe549d8Lxw9CL3Ytslt0utPa49R35w/eFIr1tv62X3y+1XPK509E3rO9Hv03/6asDVc9f41y5dn3m978bsG7duJt0cuCW69fh29u0XdwruTNxdeo94r/y+2v3qB/oP6n+0/rFlwG3g+GDAYM/DWQ/vDgmHnv6U/9OH4dJHzEfVI0YjjY+dHx8bDRq98mTOk+GnsqcTz8p+Vv9563Or59/94vtLz1j82PAL+YvPv655qfNy76uprzrHI8cfvM55PfGm/K3O233vuO+638e9H5ko/ED+UPPR+mPHp9BP9z7nfP78L/eE8/sl0p8zAAA+K2lUWHRYTUw6Y29tLmFkb2JlLnhtcAAAAAAAPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNS41LWMwMTQgNzkuMTUxNDgxLCAyMDEzLzAzLzEzLTEyOjA5OjE1ICAgICAgICAiPgogICA8cmRmOlJERiB4bWxuczpyZGY9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkvMDIvMjItcmRmLXN5bnRheC1ucyMiPgogICAgICA8cmRmOkRlc2NyaXB0aW9uIHJkZjphYm91dD0iIgogICAgICAgICAgICB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iCiAgICAgICAgICAgIHhtbG5zOnhtcE1NPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvbW0vIgogICAgICAgICAgICB4bWxuczpzdEV2dD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL3NUeXBlL1Jlc291cmNlRXZlbnQjIgogICAgICAgICAgICB4bWxuczpwaG90b3Nob3A9Imh0dHA6Ly9ucy5hZG9iZS5jb20vcGhvdG9zaG9wLzEuMC8iCiAgICAgICAgICAgIHhtbG5zOmRjPSJodHRwOi8vcHVybC5vcmcvZGMvZWxlbWVudHMvMS4xLyIKICAgICAgICAgICAgeG1sbnM6dGlmZj0iaHR0cDovL25zLmFkb2JlLmNvbS90aWZmLzEuMC8iCiAgICAgICAgICAgIHhtbG5zOmV4aWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20vZXhpZi8xLjAvIj4KICAgICAgICAgPHhtcDpDcmVhdG9yVG9vbD5BZG9iZSBQaG90b3Nob3AgQ0MgKFdpbmRvd3MpPC94bXA6Q3JlYXRvclRvb2w+CiAgICAgICAgIDx4bXA6Q3JlYXRlRGF0ZT4yMDE1LTA0LTI0VDA5OjMxOjA5KzA4OjAwPC94bXA6Q3JlYXRlRGF0ZT4KICAgICAgICAgPHhtcDpNZXRhZGF0YURhdGU+MjAxNS0wNC0yNFQwOTozMTowOSswODowMDwveG1wOk1ldGFkYXRhRGF0ZT4KICAgICAgICAgPHhtcDpNb2RpZnlEYXRlPjIwMTUtMDQtMjRUMDk6MzE6MDkrMDg6MDA8L3htcDpNb2RpZnlEYXRlPgogICAgICAgICA8eG1wTU06SW5zdGFuY2VJRD54bXAuaWlkOjIxYjc2YWQzLWNjZTEtMDI0My1hNjBlLWIzMDUwNWY0NTYxNTwveG1wTU06SW5zdGFuY2VJRD4KICAgICAgICAgPHhtcE1NOkRvY3VtZW50SUQ+eG1wLmRpZDozZDg3N2RhNC1iYTM1LTk4NDgtOWQxMC1kM2NkM2IwYTRiNjA8L3htcE1NOkRvY3VtZW50SUQ+CiAgICAgICAgIDx4bXBNTTpPcmlnaW5hbERvY3VtZW50SUQ+eG1wLmRpZDozZDg3N2RhNC1iYTM1LTk4NDgtOWQxMC1kM2NkM2IwYTRiNjA8L3htcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD4KICAgICAgICAgPHhtcE1NOkhpc3Rvcnk+CiAgICAgICAgICAgIDxyZGY6U2VxPgogICAgICAgICAgICAgICA8cmRmOmxpIHJkZjpwYXJzZVR5cGU9IlJlc291cmNlIj4KICAgICAgICAgICAgICAgICAgPHN0RXZ0OmFjdGlvbj5jcmVhdGVkPC9zdEV2dDphY3Rpb24+CiAgICAgICAgICAgICAgICAgIDxzdEV2dDppbnN0YW5jZUlEPnhtcC5paWQ6M2Q4NzdkYTQtYmEzNS05ODQ4LTlkMTAtZDNjZDNiMGE0YjYwPC9zdEV2dDppbnN0YW5jZUlEPgogICAgICAgICAgICAgICAgICA8c3RFdnQ6d2hlbj4yMDE1LTA0LTI0VDA5OjMxOjA5KzA4OjAwPC9zdEV2dDp3aGVuPgogICAgICAgICAgICAgICAgICA8c3RFdnQ6c29mdHdhcmVBZ2VudD5BZG9iZSBQaG90b3Nob3AgQ0MgKFdpbmRvd3MpPC9zdEV2dDpzb2Z0d2FyZUFnZW50PgogICAgICAgICAgICAgICA8L3JkZjpsaT4KICAgICAgICAgICAgICAgPHJkZjpsaSByZGY6cGFyc2VUeXBlPSJSZXNvdXJjZSI+CiAgICAgICAgICAgICAgICAgIDxzdEV2dDphY3Rpb24+c2F2ZWQ8L3N0RXZ0OmFjdGlvbj4KICAgICAgICAgICAgICAgICAgPHN0RXZ0Omluc3RhbmNlSUQ+eG1wLmlpZDoyMWI3NmFkMy1jY2UxLTAyNDMtYTYwZS1iMzA1MDVmNDU2MTU8L3N0RXZ0Omluc3RhbmNlSUQ+CiAgICAgICAgICAgICAgICAgIDxzdEV2dDp3aGVuPjIwMTUtMDQtMjRUMDk6MzE6MDkrMDg6MDA8L3N0RXZ0OndoZW4+CiAgICAgICAgICAgICAgICAgIDxzdEV2dDpzb2Z0d2FyZUFnZW50PkFkb2JlIFBob3Rvc2hvcCBDQyAoV2luZG93cyk8L3N0RXZ0OnNvZnR3YXJlQWdlbnQ+CiAgICAgICAgICAgICAgICAgIDxzdEV2dDpjaGFuZ2VkPi88L3N0RXZ0OmNoYW5nZWQ+CiAgICAgICAgICAgICAgIDwvcmRmOmxpPgogICAgICAgICAgICA8L3JkZjpTZXE+CiAgICAgICAgIDwveG1wTU06SGlzdG9yeT4KICAgICAgICAgPHBob3Rvc2hvcDpEb2N1bWVudEFuY2VzdG9ycz4KICAgICAgICAgICAgPHJkZjpCYWc+CiAgICAgICAgICAgICAgIDxyZGY6bGk+eG1wLmRpZDoyODNmODUwZi0wNTZlLTE3NGItYTNlNC0yMDRmOGUzMGI4MzM8L3JkZjpsaT4KICAgICAgICAgICAgICAgPHJkZjpsaT54bXAuZGlkOjQ5ZDVlOGExLTRlNGItMWM0My04ZWYzLThkYjkwMmMyNzI0MDwvcmRmOmxpPgogICAgICAgICAgICAgICA8cmRmOmxpPnhtcC5kaWQ6NTQxZDU5MWMtMGQ5Ny1lOTQwLWI4NzktN2Y1MjdlZDQ4ODRjPC9yZGY6bGk+CiAgICAgICAgICAgICAgIDxyZGY6bGk+eG1wLmRpZDo3MWU4OWMyYS1iNWY0LWJmNDctOWY0ZC02ZGE4NjM1YzU0ZWI8L3JkZjpsaT4KICAgICAgICAgICAgICAgPHJkZjpsaT54bXAuZGlkOjdkYmNlMGU0LTA1YTYtY2Q0NC1hYzEzLTljZmQzZDViNGFmZTwvcmRmOmxpPgogICAgICAgICAgICAgICA8cmRmOmxpPnhtcC5kaWQ6YTQ2YTFlZDMtY2Q0ZS0zODQ2LTlhMTUtYTQ5NDAxNjJjYzY0PC9yZGY6bGk+CiAgICAgICAgICAgICAgIDxyZGY6bGk+eG1wLmRpZDpiMDA1NjE3My05ZWQ1LTVlNGQtYWY4ZS03YzQ4M2EzZTJiMDU8L3JkZjpsaT4KICAgICAgICAgICAgICAgPHJkZjpsaT54bXAuZGlkOmIxYmZlMjlhLTgzYTItYTk0NS05ZmVjLTU3ODYyZDQzOGRkYjwvcmRmOmxpPgogICAgICAgICAgICAgICA8cmRmOmxpPnhtcC5kaWQ6Yjk5NDY1ZTQtZmU3My1jMDRhLWI4NzgtNDYzYTllYTU2MWEwPC9yZGY6bGk+CiAgICAgICAgICAgICAgIDxyZGY6bGk+eG1wLmRpZDpjM2VjMTY0NS1hMGYwLTMzNGEtYTQ5Ny1lNDM2MDY1NzFhZjQ8L3JkZjpsaT4KICAgICAgICAgICAgICAgPHJkZjpsaT54bXAuZGlkOmVkMTEzZmYzLWJlODMtOGU0NC1hMjU2LTUxMjM4Njk4OTZlNTwvcmRmOmxpPgogICAgICAgICAgICAgICA8cmRmOmxpPnhtcC5kaWQ6ZWZjOTQxMWMtMWFhYi0yZDQzLWEyMDktNTQ3YjI1ZDFhMjRlPC9yZGY6bGk+CiAgICAgICAgICAgIDwvcmRmOkJhZz4KICAgICAgICAgPC9waG90b3Nob3A6RG9jdW1lbnRBbmNlc3RvcnM+CiAgICAgICAgIDxwaG90b3Nob3A6Q29sb3JNb2RlPjM8L3Bob3Rvc2hvcDpDb2xvck1vZGU+CiAgICAgICAgIDxwaG90b3Nob3A6SUNDUHJvZmlsZT5zUkdCIElFQzYxOTY2LTIuMTwvcGhvdG9zaG9wOklDQ1Byb2ZpbGU+CiAgICAgICAgIDxkYzpmb3JtYXQ+aW1hZ2UvcG5nPC9kYzpmb3JtYXQ+CiAgICAgICAgIDx0aWZmOk9yaWVudGF0aW9uPjE8L3RpZmY6T3JpZW50YXRpb24+CiAgICAgICAgIDx0aWZmOlhSZXNvbHV0aW9uPjcyMDAwMC8xMDAwMDwvdGlmZjpYUmVzb2x1dGlvbj4KICAgICAgICAgPHRpZmY6WVJlc29sdXRpb24+NzIwMDAwLzEwMDAwPC90aWZmOllSZXNvbHV0aW9uPgogICAgICAgICA8dGlmZjpSZXNvbHV0aW9uVW5pdD4yPC90aWZmOlJlc29sdXRpb25Vbml0PgogICAgICAgICA8ZXhpZjpDb2xvclNwYWNlPjE8L2V4aWY6Q29sb3JTcGFjZT4KICAgICAgICAgPGV4aWY6UGl4ZWxYRGltZW5zaW9uPjY0PC9leGlmOlBpeGVsWERpbWVuc2lvbj4KICAgICAgICAgPGV4aWY6UGl4ZWxZRGltZW5zaW9uPjY0PC9leGlmOlBpeGVsWURpbWVuc2lvbj4KICAgICAgPC9yZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgCjw/eHBhY2tldCBlbmQ9InciPz4vJJCSAAAAIGNIUk0AAHolAACAgwAA+f8AAIDpAAB1MAAA6mAAADqYAAAXb5JfxUYAAAkZSURBVHja7JtLbBvlFsd/37zHie3YjvOQYvLQpVWlu3EKVaQKFSEEBEV0xd0gFbGoBHfbJbtKLBE7diwrqNg0sEGlKk2EqIQopQ8JFEW0oUAc2a1ju7YnM59n7gJmlLRp2iQ4rnv7LTOTxOf//c/jf86xCIKAzc6HH36Ioij/klJ+UKlUXpRSxoQQdMMJggBN0xrJZPKCpmnv+76/eOLEiU3f1R70RxRFGW82m9c9zzMnJycZHByk1Wo99sYLIVAUhZWVld5r1679R9f1o7ZtHwBubAsAz/M+9jzPfOONN8jn83TjGR8f54svvjA1TfsYmN4WANVq9cjBgwfJ5/N4nofrunSTCxiGQT6f5+bNm1y6dOnIA5n+oAdSSpHNZgG6yvjQDVzXBSCbzSKlFNsGQAjhhT7fTcavBwGg1WohhPC2DUBIpW4/D7NB4f/8PAXgKQCPSbDq1NE68k81DUVR8H2fIAhQFAUhBL7vI6V8MgH4uz5HVVXq9Tr1eh3XdfF9H1VVMQyDWCxGLBYjCAI8z9sTdmh7ZbxpmriuS6FQoFarIaVEUZQN76iqSk9PDwMDA9H7TwQApmnSaDT4/fffWVtbwzRNTNPcFKhKpUKj0SCXy2HbNp7ndW8QDIIAXddxHIfffvsNKSW2bT+Q2kIILMui1Wrxxx9/4Hkeqqp2LwBhoCsUCrRaLQzDiCqzIAhotVr3SexQyDiOQ7lc7m4ANE2jWq1Sr9cj48NoHwKiadqmIGiaRqPRQErZ1mDY9hhQr9fxfR/f9wHwfR8hBMPDw8TjcQCKxSLlchlN0zawR0qJ53kYhtG2ZkzbGCCEoNVq4ft+lP5UVSUIAtLpNP39/VHkT6fTqKoagbSeCe0WZFo7A2AQBGSzWcK+QnhUVaXZbBIEQZQONU27L+0JIdpeC7TdBXRdv8+I0CWEEBiGQaVSwXXdDXWB7/tRjGgnC9oOwL20Xu/jofHLy8sbdIEQAiklsVgMXdfbWhB1RAuEGaJUKlEoFFAUBV3Xo5t2HAfbtkmn023XBh1Rg7quU6vVWF5eRlXVDca7rott2+RyuU1T5BPDgGq1GjEhNF5KSTKZZHh4GEVR9qQZu+cArJe9YRaAv5qXpmnuqfEdY0CY/03TjEpdIQSxWCwKgHvVKNE6YXwQBAwPD29q5BPbELnXDTzPi2qB9T9vt/h5LGKAoiiUSiUqlQq6rkc3H4vFyOVye1ICdzwL3Fvq7kXZ+1i5QJgJQqOllB0Zv3cEAN/3sW07UophGrQsa8/HcR3LAuslcciKsEv0xDMgZMG9t92JYWxHg+DjMH1+Oht8CsBTALbO191+HmaD8jDF9rgEq50G2LATvW0ANE2jWCwCbJjodIvxhmEAf80c1s8bHjkNJhIJrl69ytjYGPl8PhIt3XQuX77M1atXSSQS2wdA13WklMzOznLjxo2uWZUNab+yssK1a9fQdX3Ly9MeVq/rus6PP/64p12af8IFNE0jmUyiadoDW/MPrQR930dRFFKpVNdmga2M71gdEAofx3Hu6wp1nRYIP3y9XqfRaEQGWZYVBZ8wg4QLD+FSVCKRiPoAnQJB+yduslQqMTo6yqFDh0ilUjQaDS5dusTPP/9MKpXCMAyazSZCCHRdp16v09fXx/Hjx/nyyy+5cuUKyWSyO0vhYrHI4cOHeffddxkbG+Pu3bukUimOHTvG66+/Trlc5s6dOwwMDHD8+HEMw6BcLkezwXCFxnGcDUxY7yaO40TLFeEmuOd5SClxHGdX7NkVA1ZXV9m/fz8zMzN8//33nD59miAI8H2fl19+mZmZGYrFIhcuXOCll14ik8mQSqVIJpNR+7tcLmNZFplMhmKxiOd5xONxarUaa2trjIyM0Gq1+PPPP+np6cEwDOLxOPV6HYD+/n6q1eqGyfKeABAEAa7rMj09jeM4fP755/T392NZFlJKvv76aw4dOsThw4e5ffs2U1NTABw9epTLly8zNzdHtVoln8/zyiuvMDQ0xNLSEqdPn6ZUKqHrOm+//Tajo6MIIbhy5QpnzpyhUqlw7Ngx4vE4uq5jmiaffPIJrutG1d+euECr1SKRSDA0NMTCwgJCCEzTjBYfTdNkcXGRwcFBCoUC586dA2B2dpZvvvmGWCyGaZo8++yzzM7OcurUKcbGxjhy5AjLy8u88847DAwMcPLkST766CMmJyd57bXXKJVKqKrKyMgIP/30E6dOnUJV1S3L3bYAEBYbYXRf74fh+mtYOTabTcrlMgC3b99mdXU1ur2zZ89y/fp1fvjhB+7cuUM6nWZ0dJSRkREWFhbYt28f2WyWtbU1Dh48iBAC27Ypl8t89dVXlEolpJQ7Hqjs2AVUVaVardJsNnnmmWeiYWcYwBzHify3Xq8Ti8UiYbWeqq7rkkql8H0f13VpNBpRRhgaGmJiYgJFUSgUCty6dYuenh6EEFSrVSzLIh6P72qQsmMAwi2u+fl5Xn31VSYnJ7l48SLJZJJarcaBAwcYHx9nbm6OZrOJZVnAX2PxarVKLpeLVGcY4cNFidXVVQC+++47zpw5QyaTwTAM+vv7IwDCemK3KnVXWSCdTjM3N0cul+Ott95i//79LC8vk81mmZqaYnFxkbNnzzI4OMjKygoAMzMzXLx4kUqlEomu0FUSiQRCCH799Vd++eUX3nzzTdLpNM1mk+eff575+XnOnz8f3fo/Ic52BYCmafT29vLpp5/ywgsv8NxzzzExMQHAuXPnmJ+fJxaLYds2t27d4vz580xOTjIxMcG3337L0tIS1Wo12hteWFjAcRwGBgb47LPPmJ6eZmpqCtd1uXnzJktLS6RSKRYXFwmCIGLVroq5Lb462wSsR3WFcNFR0zSklEgp6evri9ZffN+nUqlE71iWRa1Ww7btKCbcvXs3KpEbjUYEThhT+vr6ME0z2i7p7e19qNj5+zgnTpywt8uAR3KuUDFmMpkoGK0fdIYfUAhBX1/fBvET+nP4jmVZ0ehc13UymUz0rKenByBauH4UpfcotmyVBud2og1CobMVY8Ln97672e8qinJflbeDSfL8TgD4L7D2BHS+14D3dhIEbwD/Bj4AXgRiXWZ4A7gAvM8DvjkO8L8BAO94fxff8Sr/AAAAAElFTkSuQmCC"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/mobile/icon-doc-archive.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/mobile/icon-doc-audio.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/mobile/icon-doc-dir.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/mobile/icon-doc-excel.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/mobile/icon-doc-exe.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/mobile/icon-doc-file.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/mobile/icon-doc-image.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/mobile/icon-doc-pdf.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "../ShareWebCore/src/icons/assets/mobile/icon-doc-ppt.png":
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAACXBIWXMAAAsTAAALEwEAmpwYAAAKTWlDQ1BQaG90b3Nob3AgSUNDIHByb2ZpbGUAAHjanVN3WJP3Fj7f92UPVkLY8LGXbIEAIiOsCMgQWaIQkgBhhBASQMWFiApWFBURnEhVxILVCkidiOKgKLhnQYqIWotVXDjuH9yntX167+3t+9f7vOec5/zOec8PgBESJpHmomoAOVKFPDrYH49PSMTJvYACFUjgBCAQ5svCZwXFAADwA3l4fnSwP/wBr28AAgBw1S4kEsfh/4O6UCZXACCRAOAiEucLAZBSAMguVMgUAMgYALBTs2QKAJQAAGx5fEIiAKoNAOz0ST4FANipk9wXANiiHKkIAI0BAJkoRyQCQLsAYFWBUiwCwMIAoKxAIi4EwK4BgFm2MkcCgL0FAHaOWJAPQGAAgJlCLMwAIDgCAEMeE80DIEwDoDDSv+CpX3CFuEgBAMDLlc2XS9IzFLiV0Bp38vDg4iHiwmyxQmEXKRBmCeQinJebIxNI5wNMzgwAABr50cH+OD+Q5+bk4eZm52zv9MWi/mvwbyI+IfHf/ryMAgQAEE7P79pf5eXWA3DHAbB1v2upWwDaVgBo3/ldM9sJoFoK0Hr5i3k4/EAenqFQyDwdHAoLC+0lYqG9MOOLPv8z4W/gi372/EAe/tt68ABxmkCZrcCjg/1xYW52rlKO58sEQjFu9+cj/seFf/2OKdHiNLFcLBWK8ViJuFAiTcd5uVKRRCHJleIS6X8y8R+W/QmTdw0ArIZPwE62B7XLbMB+7gECiw5Y0nYAQH7zLYwaC5EAEGc0Mnn3AACTv/mPQCsBAM2XpOMAALzoGFyolBdMxggAAESggSqwQQcMwRSswA6cwR28wBcCYQZEQAwkwDwQQgbkgBwKoRiWQRlUwDrYBLWwAxqgEZrhELTBMTgN5+ASXIHrcBcGYBiewhi8hgkEQcgIE2EhOogRYo7YIs4IF5mOBCJhSDSSgKQg6YgUUSLFyHKkAqlCapFdSCPyLXIUOY1cQPqQ28ggMor8irxHMZSBslED1AJ1QLmoHxqKxqBz0XQ0D12AlqJr0Rq0Hj2AtqKn0UvodXQAfYqOY4DRMQ5mjNlhXIyHRWCJWBomxxZj5Vg1Vo81Yx1YN3YVG8CeYe8IJAKLgBPsCF6EEMJsgpCQR1hMWEOoJewjtBK6CFcJg4Qxwicik6hPtCV6EvnEeGI6sZBYRqwm7iEeIZ4lXicOE1+TSCQOyZLkTgohJZAySQtJa0jbSC2kU6Q+0hBpnEwm65Btyd7kCLKArCCXkbeQD5BPkvvJw+S3FDrFiOJMCaIkUqSUEko1ZT/lBKWfMkKZoKpRzame1AiqiDqfWkltoHZQL1OHqRM0dZolzZsWQ8ukLaPV0JppZ2n3aC/pdLoJ3YMeRZfQl9Jr6Afp5+mD9HcMDYYNg8dIYigZaxl7GacYtxkvmUymBdOXmchUMNcyG5lnmA+Yb1VYKvYqfBWRyhKVOpVWlX6V56pUVXNVP9V5qgtUq1UPq15WfaZGVbNQ46kJ1Bar1akdVbupNq7OUndSj1DPUV+jvl/9gvpjDbKGhUaghkijVGO3xhmNIRbGMmXxWELWclYD6yxrmE1iW7L57Ex2Bfsbdi97TFNDc6pmrGaRZp3mcc0BDsax4PA52ZxKziHODc57LQMtPy2x1mqtZq1+rTfaetq+2mLtcu0W7eva73VwnUCdLJ31Om0693UJuja6UbqFutt1z+o+02PreekJ9cr1Dund0Uf1bfSj9Rfq79bv0R83MDQINpAZbDE4Y/DMkGPoa5hpuNHwhOGoEctoupHEaKPRSaMnuCbuh2fjNXgXPmasbxxirDTeZdxrPGFiaTLbpMSkxeS+Kc2Ua5pmutG003TMzMgs3KzYrMnsjjnVnGueYb7ZvNv8jYWlRZzFSos2i8eW2pZ8ywWWTZb3rJhWPlZ5VvVW16xJ1lzrLOtt1ldsUBtXmwybOpvLtqitm63Edptt3xTiFI8p0in1U27aMez87ArsmuwG7Tn2YfYl9m32zx3MHBId1jt0O3xydHXMdmxwvOuk4TTDqcSpw+lXZxtnoXOd8zUXpkuQyxKXdpcXU22niqdun3rLleUa7rrStdP1o5u7m9yt2W3U3cw9xX2r+00umxvJXcM970H08PdY4nHM452nm6fC85DnL152Xlle+70eT7OcJp7WMG3I28Rb4L3Le2A6Pj1l+s7pAz7GPgKfep+Hvqa+It89viN+1n6Zfgf8nvs7+sv9j/i/4XnyFvFOBWABwQHlAb2BGoGzA2sDHwSZBKUHNQWNBbsGLww+FUIMCQ1ZH3KTb8AX8hv5YzPcZyya0RXKCJ0VWhv6MMwmTB7WEY6GzwjfEH5vpvlM6cy2CIjgR2yIuB9pGZkX+X0UKSoyqi7qUbRTdHF09yzWrORZ+2e9jvGPqYy5O9tqtnJ2Z6xqbFJsY+ybuIC4qriBeIf4RfGXEnQTJAntieTE2MQ9ieNzAudsmjOc5JpUlnRjruXcorkX5unOy553PFk1WZB8OIWYEpeyP+WDIEJQLxhP5aduTR0T8oSbhU9FvqKNolGxt7hKPJLmnVaV9jjdO31D+miGT0Z1xjMJT1IreZEZkrkj801WRNberM/ZcdktOZSclJyjUg1plrQr1zC3KLdPZisrkw3keeZtyhuTh8r35CP5c/PbFWyFTNGjtFKuUA4WTC+oK3hbGFt4uEi9SFrUM99m/ur5IwuCFny9kLBQuLCz2Lh4WfHgIr9FuxYji1MXdy4xXVK6ZHhp8NJ9y2jLspb9UOJYUlXyannc8o5Sg9KlpUMrglc0lamUycturvRauWMVYZVkVe9ql9VbVn8qF5VfrHCsqK74sEa45uJXTl/VfPV5bdra3kq3yu3rSOuk626s91m/r0q9akHV0IbwDa0b8Y3lG19tSt50oXpq9Y7NtM3KzQM1YTXtW8y2rNvyoTaj9nqdf13LVv2tq7e+2Sba1r/dd3vzDoMdFTve75TsvLUreFdrvUV99W7S7oLdjxpiG7q/5n7duEd3T8Wej3ulewf2Re/ranRvbNyvv7+yCW1SNo0eSDpw5ZuAb9qb7Zp3tXBaKg7CQeXBJ9+mfHvjUOihzsPcw83fmX+39QjrSHkr0jq/dawto22gPaG97+iMo50dXh1Hvrf/fu8x42N1xzWPV56gnSg98fnkgpPjp2Snnp1OPz3Umdx590z8mWtdUV29Z0PPnj8XdO5Mt1/3yfPe549d8Lxw9CL3Ytslt0utPa49R35w/eFIr1tv62X3y+1XPK509E3rO9Hv03/6asDVc9f41y5dn3m978bsG7duJt0cuCW69fh29u0XdwruTNxdeo94r/y+2v3qB/oP6n+0/rFlwG3g+GDAYM/DWQ/vDgmHnv6U/9OH4dJHzEfVI0YjjY+dHx8bDRq98mTOk+GnsqcTz8p+Vv9563Or59/94vtLz1j82PAL+YvPv655qfNy76uprzrHI8cfvM55PfGm/K3O233vuO+638e9H5ko/ED+UPPR+mPHp9BP9z7nfP78L/eE8/sl0p8zAAA+K2lUWHRYTUw6Y29tLmFkb2JlLnhtcAAAAAAAPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4KPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNS41LWMwMTQgNzkuMTUxNDgxLCAyMDEzLzAzLzEzLTEyOjA5OjE1ICAgICAgICAiPgogICA8cmRmOlJERiB4bWxuczpyZGY9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkvMDIvMjItcmRmLXN5bnRheC1ucyMiPgogICAgICA8cmRmOkRlc2NyaXB0aW9uIHJkZjphYm91dD0iIgogICAgICAgICAgICB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iCiAgICAgICAgICAgIHhtbG5zOnhtcE1NPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvbW0vIgogICAgICAgICAgICB4bWxuczpzdEV2dD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL3NUeXBlL1Jlc291cmNlRXZlbnQjIgogICAgICAgICAgICB4bWxuczpwaG90b3Nob3A9Imh0dHA6Ly9ucy5hZG9iZS5jb20vcGhvdG9zaG9wLzEuMC8iCiAgICAgICAgICAgIHhtbG5zOmRjPSJodHRwOi8vcHVybC5vcmcvZGMvZWxlbWVudHMvMS4xLyIKICAgICAgICAgICAgeG1sbnM6dGlmZj0iaHR0cDovL25zLmFkb2JlLmNvbS90aWZmLzEuMC8iCiAgICAgICAgICAgIHhtbG5zOmV4aWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20vZXhpZi8xLjAvIj4KICAgICAgICAgPHhtcDpDcmVhdG9yVG9vbD5BZG9iZSBQaG90b3Nob3AgQ0MgKFdpbmRvd3MpPC94bXA6Q3JlYXRvclRvb2w+CiAgICAgICAgIDx4bXA6Q3JlYXRlRGF0ZT4yMDE1LTA0LTI0VDA5OjMwOjUzKzA4OjAwPC94bXA6Q3JlYXRlRGF0ZT4KICAgICAgICAgPHhtcDpNZXRhZGF0YURhdGU+MjAxNS0wNC0yNFQwOTozMDo1MyswODowMDwveG1wOk1ldGFkYXRhRGF0ZT4KICAgICAgICAgPHhtcDpNb2RpZnlEYXRlPjIwMTUtMDQtMjRUMDk6MzA6NTMrMDg6MDA8L3htcDpNb2RpZnlEYXRlPgogICAgICAgICA8eG1wTU06SW5zdGFuY2VJRD54bXAuaWlkOjk3NjJhMDE5LTZlYmYtZTc0Yy04NWMyLThhZmI3NTdhNGJiOTwveG1wTU06SW5zdGFuY2VJRD4KICAgICAgICAgPHhtcE1NOkRvY3VtZW50SUQ+eG1wLmRpZDo3ZmY1YTZkMy1kYTY5LWQxNDQtYmQ0Yy04ZjFlNTg5NjBkYWU8L3htcE1NOkRvY3VtZW50SUQ+CiAgICAgICAgIDx4bXBNTTpPcmlnaW5hbERvY3VtZW50SUQ+eG1wLmRpZDo3ZmY1YTZkMy1kYTY5LWQxNDQtYmQ0Yy04ZjFlNTg5NjBkYWU8L3htcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD4KICAgICAgICAgPHhtcE1NOkhpc3Rvcnk+CiAgICAgICAgICAgIDxyZGY6U2VxPgogICAgICAgICAgICAgICA8cmRmOmxpIHJkZjpwYXJzZVR5cGU9IlJlc291cmNlIj4KICAgICAgICAgICAgICAgICAgPHN0RXZ0OmFjdGlvbj5jcmVhdGVkPC9zdEV2dDphY3Rpb24+CiAgICAgICAgICAgICAgICAgIDxzdEV2dDppbnN0YW5jZUlEPnhtcC5paWQ6N2ZmNWE2ZDMtZGE2OS1kMTQ0LWJkNGMtOGYxZTU4OTYwZGFlPC9zdEV2dDppbnN0YW5jZUlEPgogICAgICAgICAgICAgICAgICA8c3RFdnQ6d2hlbj4yMDE1LTA0LTI0VDA5OjMwOjUzKzA4OjAwPC9zdEV2dDp3aGVuPgogICAgICAgICAgICAgICAgICA8c3RFdnQ6c29mdHdhcmVBZ2VudD5BZG9iZSBQaG90b3Nob3AgQ0MgKFdpbmRvd3MpPC9zdEV2dDpzb2Z0d2FyZUFnZW50PgogICAgICAgICAgICAgICA8L3JkZjpsaT4KICAgICAgICAgICAgICAgPHJkZjpsaSByZGY6cGFyc2VUeXBlPSJSZXNvdXJjZSI+CiAgICAgICAgICAgICAgICAgIDxzdEV2dDphY3Rpb24+c2F2ZWQ8L3N0RXZ0OmFjdGlvbj4KICAgICAgICAgICAgICAgICAgPHN0RXZ0Omluc3RhbmNlSUQ+eG1wLmlpZDo5NzYyYTAxOS02ZWJmLWU3NGMtODVjMi04YWZiNzU3YTRiYjk8L3N0RXZ0Omluc3RhbmNlSUQ+CiAgICAgICAgICAgICAgICAgIDxzdEV2dDp3aGVuPjIwMTUtMDQtMjRUMDk6MzA6NTMrMDg6MDA8L3N0RXZ0OndoZW4+CiAgICAgICAgICAgICAgICAgIDxzdEV2dDpzb2Z0d2FyZUFnZW50PkFkb2JlIFBob3Rvc2hvcCBDQyAoV2luZG93cyk8L3N0RXZ0OnNvZnR3YXJlQWdlbnQ+CiAgICAgICAgICAgICAgICAgIDxzdEV2dDpjaGFuZ2VkPi88L3N0RXZ0OmNoYW5nZWQ+CiAgICAgICAgICAgICAgIDwvcmRmOmxpPgogICAgICAgICAgICA8L3JkZjpTZXE+CiAgICAgICAgIDwveG1wTU06SGlzdG9yeT4KICAgICAgICAgPHBob3Rvc2hvcDpEb2N1bWVudEFuY2VzdG9ycz4KICAgICAgICAgICAgPHJkZjpCYWc+CiAgICAgICAgICAgICAgIDxyZGY6bGk+eG1wLmRpZDoyODNmODUwZi0wNTZlLTE3NGItYTNlNC0yMDRmOGUzMGI4MzM8L3JkZjpsaT4KICAgICAgICAgICAgICAgPHJkZjpsaT54bXAuZGlkOjQ5ZDVlOGExLTRlNGItMWM0My04ZWYzLThkYjkwMmMyNzI0MDwvcmRmOmxpPgogICAgICAgICAgICAgICA8cmRmOmxpPnhtcC5kaWQ6NTQxZDU5MWMtMGQ5Ny1lOTQwLWI4NzktN2Y1MjdlZDQ4ODRjPC9yZGY6bGk+CiAgICAgICAgICAgICAgIDxyZGY6bGk+eG1wLmRpZDo3MWU4OWMyYS1iNWY0LWJmNDctOWY0ZC02ZGE4NjM1YzU0ZWI8L3JkZjpsaT4KICAgICAgICAgICAgICAgPHJkZjpsaT54bXAuZGlkOjdkYmNlMGU0LTA1YTYtY2Q0NC1hYzEzLTljZmQzZDViNGFmZTwvcmRmOmxpPgogICAgICAgICAgICAgICA8cmRmOmxpPnhtcC5kaWQ6YTQ2YTFlZDMtY2Q0ZS0zODQ2LTlhMTUtYTQ5NDAxNjJjYzY0PC9yZGY6bGk+CiAgICAgICAgICAgICAgIDxyZGY6bGk+eG1wLmRpZDpiMDA1NjE3My05ZWQ1LTVlNGQtYWY4ZS03YzQ4M2EzZTJiMDU8L3JkZjpsaT4KICAgICAgICAgICAgICAgPHJkZjpsaT54bXAuZGlkOmIxYmZlMjlhLTgzYTItYTk0NS05ZmVjLTU3ODYyZDQzOGRkYjwvcmRmOmxpPgogICAgICAgICAgICAgICA8cmRmOmxpPnhtcC5kaWQ6Yjk5NDY1ZTQtZmU3My1jMDRhLWI4NzgtNDYzYTllYTU2MWEwPC9yZGY6bGk+CiAgICAgICAgICAgICAgIDxyZGY6bGk+eG1wLmRpZDpjM2VjMTY0NS1hMGYwLTMzNGEtYTQ5Ny1lNDM2MDY1NzFhZjQ8L3JkZjpsaT4KICAgICAgICAgICAgICAgPHJkZjpsaT54bXAuZGlkOmVkMTEzZmYzLWJlODMtOGU0NC1hMjU2LTUxMjM4Njk4OTZlNTwvcmRmOmxpPgogICAgICAgICAgICAgICA8cmRmOmxpPnhtcC5kaWQ6ZWZjOTQxMWMtMWFhYi0yZDQzLWEyMDktNTQ3YjI1ZDFhMjRlPC9yZGY6bGk+CiAgICAgICAgICAgIDwvcmRmOkJhZz4KICAgICAgICAgPC9waG90b3Nob3A6RG9jdW1lbnRBbmNlc3RvcnM+CiAgICAgICAgIDxwaG90b3Nob3A6Q29sb3JNb2RlPjM8L3Bob3Rvc2hvcDpDb2xvck1vZGU+CiAgICAgICAgIDxwaG90b3Nob3A6SUNDUHJvZmlsZT5zUkdCIElFQzYxOTY2LTIuMTwvcGhvdG9zaG9wOklDQ1Byb2ZpbGU+CiAgICAgICAgIDxkYzpmb3JtYXQ+aW1hZ2UvcG5nPC9kYzpmb3JtYXQ+CiAgICAgICAgIDx0aWZmOk9yaWVudGF0aW9uPjE8L3RpZmY6T3JpZW50YXRpb24+CiAgICAgICAgIDx0aWZmOlhSZXNvbHV0aW9uPjcyMDAwMC8xMDAwMDwvdGlmZjpYUmVzb2x1dGlvbj4KICAgICAgICAgPHRpZmY6WVJlc29sdXRpb24+NzIwMDAwLzEwMDAwPC90aWZmOllSZXNvbHV0aW9uPgogICAgICAgICA8dGlmZjpSZXNvbHV0aW9uVW5pdD4yPC90aWZmOlJlc29sdXRpb25Vbml0PgogICAgICAgICA8ZXhpZjpDb2xvclNwYWNlPjE8L2V4aWY6Q29sb3JTcGFjZT4KICAgICAgICAgPGV4aWY6UGl4ZWxYRGltZW5zaW9uPjY0PC9leGlmOlBpeGVsWERpbWVuc2lvbj4KICAgICAgICAgPGV4aWY6UGl4ZWxZRGltZW5zaW9uPjY0PC9leGlmOlBpeGVsWURpbWVuc2lvbj4KICAgICAgPC9yZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIAogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAKICAgICAgI